/*
 * Decompiled with CFR 0.152.
 */
package ranger.entities;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import ranger.rpg.IRpgData;
import ranger.rpg.RpgData;
import ranger.util.RAWorldData;

public abstract class EntityRABase
extends EntityTameable {
    public static final int SHIELD_USE_RANDOM = 0;
    public static final int SHIELD_USE_BEFORE_ATTACK = 1;
    public static final int SHIELD_USE_AFTER_ATTACK = 2;
    public static final int SHIELD_USE_ALWAYS = 3;
    public int shieldUse = 0;
    public int shieldUseTime = 0;
    public int shieldCooldown = 0;
    public int prevAttackTime = 0;
    private static final DataParameter<Boolean> IS_CORPSE = EntityDataManager.func_187226_a(EntityRABase.class, (DataSerializer)DataSerializers.field_187198_h);
    boolean playHurtSound = true;

    public EntityRABase(World worldIn) {
        super(worldIn);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_184187_bx() != null && !this.field_70170_p.field_72995_K) {
            this.func_184187_bx().func_70106_y();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CORPSE, (Object)false);
    }

    public boolean isCorpse() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CORPSE);
    }

    public void setIsCorpse(boolean locked) {
        this.field_70180_af.func_187227_b(IS_CORPSE, (Object)locked);
    }

    public boolean func_70089_S() {
        return !this.isCorpse() && super.func_70089_S();
    }

    public double func_70033_W() {
        return this.func_184187_bx() != null ? -0.5 : 0.0;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_184581_c(DamageSource source) {
        if (this.playHurtSound) {
            super.func_184581_c(source);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70725_aQ > 0) {
            return false;
        }
        this.playHurtSound = true;
        return super.func_70097_a(source, amount);
    }

    public boolean func_175446_cd() {
        return this.field_70725_aQ > 0 || super.func_175446_cd();
    }

    public void func_70636_d() {
        if (this.func_70638_az() instanceof EntityPlayer || this.func_70638_az() instanceof EntityRABase) {
            IRpgData targetData = RpgData.getRpgData((Entity)this.func_70638_az());
            if (RAWorldData.get(this.field_70170_p).areNationsAllied(RpgData.getRpgData((Entity)this).getNation(), targetData.getNation())) {
                this.func_70624_b(null);
            }
        }
        if (this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            int lastAttacked = this.field_70173_aa - this.prevAttackTime;
            if (this.func_184592_cb().func_77973_b() instanceof ItemShield) {
                switch (this.shieldUse) {
                    case 1: {
                        if (lastAttacked <= 20) break;
                        this.shieldUseTime = 2;
                        break;
                    }
                    case 2: {
                        if (lastAttacked >= 2) break;
                        this.shieldUseTime = 20;
                        break;
                    }
                    case 3: {
                        this.shieldUseTime = 20;
                        break;
                    }
                    default: {
                        if (this.field_70146_Z.nextInt(50) != 0) break;
                        this.shieldUseTime = 20 + this.field_70146_Z.nextInt(20);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shieldUseTime > 0) {
                --this.shieldUseTime;
            }
            if (this.shieldCooldown > 0) {
                --this.shieldCooldown;
            }
            if (this.shieldUseTime > 0 && this.shieldCooldown <= 0) {
                this.func_184598_c(EnumHand.OFF_HAND);
            } else if (this.func_184600_cs() == EnumHand.OFF_HAND) {
                this.func_184602_cy();
            }
        }
        if (this.isCorpse()) {
            if (this.func_70051_ag()) {
                this.func_70031_b(false);
            }
            if (this.field_70131_O != 0.2f) {
                this.field_70130_N = 0.6f;
                this.field_70131_O = 0.2f;
                this.func_98055_j(1.0f);
                this.func_70105_a(0.6f, 0.2f);
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
            if (this.field_70173_aa > 3600) {
                this.func_70106_y();
            }
            if (!this.field_70122_E) {
                this.field_70181_x = -1.0;
            }
        } else if (this.field_70725_aQ > 0 && this.func_110143_aJ() > 0.0f) {
            this.func_70606_j(0.0f);
        }
        super.func_70636_d();
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.func_184585_cz()) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    protected void func_190629_c(EntityLivingBase attacker) {
        super.func_190629_c(attacker);
        this.playHurtSound = false;
        if (attacker.func_184614_ca().func_77973_b().canDisableShield(attacker.func_184614_ca(), this.func_184607_cu(), (EntityLivingBase)this, attacker)) {
            this.disableShield(100);
        } else if (this.shieldUse == 3 || this.shieldUse == 1) {
            this.disableShield(10 + this.field_70146_Z.nextInt(20));
        }
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
    }

    public void disableShield(int time) {
        this.shieldCooldown = time;
        this.func_184602_cy();
        if (time >= 30) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    protected void func_70609_aI() {
        if (this.isCorpse()) {
            this.field_70725_aQ = 0;
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.setIsCorpse(true);
            this.field_70725_aQ = 0;
            this.field_70173_aa = 0;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.prevAttackTime = this.field_70173_aa;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag && super.func_70652_k(entityIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.shieldUse = compound.func_74762_e("shieldUse");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("shieldUse", this.shieldUse);
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }
}

