/*
 * Decompiled with CFR 0.152.
 */
package ranger.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ranger.RASounds;
import ranger.Ranger;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityAINearestAttackableRATarget;
import ranger.entities.EntityCustomHorse;
import ranger.entities.EntityRABase;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityThrowingKnife;
import ranger.entities.EntityThrowingWeapon;
import ranger.entities.EntityWargal;
import ranger.entities.RAAIAttackMelee;
import ranger.entities.RAAIAttackRanged;
import ranger.entities.RAAIFollowOwner;
import ranger.entities.RAAIMoveTowardsPos;
import ranger.entities.RAAIOwnerHurtByTarget;
import ranger.entities.RAAIOwnerHurtTarget;
import ranger.entities.RAAIWanderAvoidWater;
import ranger.entities.RAAIWatchClosest;
import ranger.entities.RAEntityAIHurtByTarget;
import ranger.items.ItemThrowableWeapon;
import ranger.items.ItemWeapon;
import ranger.items.RAItemLoader;
import ranger.packet.PacketOpenRAGui;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;
import ranger.util.RAWorldData;

public class EntityRAHumanoid
extends EntityRABase
implements IRangedAttackMob {
    public boolean setCombatTask = true;
    public static final String[] squadNames = new String[]{"None", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
    public static final TextFormatting[] squadColors = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.AQUA, TextFormatting.BLUE, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.GRAY};
    public static final String[] squadColorsHex = new String[]{"ffffff", "55FFFF", "5555FF", "FFFF55", "55FF55", "AAAAAA"};
    public static final int ACTION_DEFEND = 0;
    public static final int ACTION_HOLD_POSITION = 1;
    public static final int ACTION_GUARD_PLAYER = 2;
    public static final int ACTION_FOLLOW_AND_ATTACK = 3;
    public static final int ACTION_WANDER = 4;
    public static final int ACTION_FLEE = 5;
    public ItemStack prevMainStack;
    public int maxThrowables = 1;
    private final RAAIAttackMelee aiAttackOnCollide = new RAAIAttackMelee((EntityCreature)this, 1.2, false){

        public void func_75251_c() {
            super.func_75251_c();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
        }
    };
    private final RAAIAttackRanged<EntityRAHumanoid> aiArrowAttack = new RAAIAttackRanged<EntityRAHumanoid>(this, 1.0, 20, 20.0f);
    public int attackTime = 0;
    public boolean createHorse = true;
    private static final DataParameter<Float> DEFEND_POS_X = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DEFEND_POS_Y = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DEFEND_POS_Z = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> LOCKED = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TEMPORARY = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEADER = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ACTION = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROWABLES = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AMMO = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SQUAD = EntityDataManager.func_187226_a(EntityRAHumanoid.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityRAHumanoid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.setCombatTask = true;
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RAAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new RAEntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableRATarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableRATarget((EntityCreature)this, EntityRABase.class, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RAAIFollowOwner(this, 1.0, 3.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new RAAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new RAAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new RAAIOwnerHurtTarget(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RAAIMoveTowardsPos(this, 1.1f));
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.prevMainStack = this.func_184614_ca();
        }
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask = true;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(70.0);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DEFEND_POS_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DEFEND_POS_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DEFEND_POS_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOCKED, (Object)true);
        this.field_70180_af.func_187214_a(TEMPORARY, (Object)false);
        this.field_70180_af.func_187214_a(LEADER, (Object)true);
        this.field_70180_af.func_187214_a(ACTION, (Object)0);
        this.field_70180_af.func_187214_a(THROWABLES, (Object)0);
        this.field_70180_af.func_187214_a(AMMO, (Object)16);
        this.field_70180_af.func_187214_a(SQUAD, (Object)0);
    }

    public Float getDefendPosX() {
        return (Float)this.field_70180_af.func_187225_a(DEFEND_POS_X);
    }

    public void setDefendPosX(Float x) {
        this.field_70180_af.func_187227_b(DEFEND_POS_X, (Object)x);
    }

    public Float getDefendPosY() {
        return (Float)this.field_70180_af.func_187225_a(DEFEND_POS_Y);
    }

    public void setDefendPosY(Float y) {
        this.field_70180_af.func_187227_b(DEFEND_POS_Y, (Object)y);
    }

    public Float getDefendPosZ() {
        return (Float)this.field_70180_af.func_187225_a(DEFEND_POS_Z);
    }

    public void setDefendPosZ(Float z) {
        this.field_70180_af.func_187227_b(DEFEND_POS_Z, (Object)z);
    }

    public boolean isLocked() {
        return (Boolean)this.field_70180_af.func_187225_a(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.field_70180_af.func_187227_b(LOCKED, (Object)locked);
    }

    public boolean isTemporary() {
        return (Boolean)this.field_70180_af.func_187225_a(TEMPORARY);
    }

    public void setTemporary(boolean locked) {
        this.field_70180_af.func_187227_b(TEMPORARY, (Object)locked);
    }

    public boolean isLeader() {
        return (Boolean)this.field_70180_af.func_187225_a(LEADER);
    }

    public void setLeader(boolean action) {
        this.field_70180_af.func_187227_b(LEADER, (Object)action);
    }

    public int getAction() {
        return (Integer)this.field_70180_af.func_187225_a(ACTION);
    }

    public void setAction(int action) {
        this.field_70180_af.func_187227_b(ACTION, (Object)action);
    }

    public int getThrowables() {
        return (Integer)this.field_70180_af.func_187225_a(THROWABLES);
    }

    public void setMaxThrowables(int amount) {
        this.maxThrowables = amount;
        this.setThrowables(amount);
    }

    public void setThrowables(int action) {
        this.field_70180_af.func_187227_b(THROWABLES, (Object)action);
    }

    public int getAmmo() {
        return (Integer)this.field_70180_af.func_187225_a(AMMO);
    }

    public void setAmmo(int action) {
        this.field_70180_af.func_187227_b(AMMO, (Object)action);
    }

    public int getSquad() {
        return (Integer)this.field_70180_af.func_187225_a(SQUAD);
    }

    public void setSquad(int action) {
        this.field_70180_af.func_187227_b(SQUAD, (Object)action);
    }

    public String func_70005_c_() {
        if (!this.func_145818_k_()) {
            IRpgData rpgData = RpgData.getRpgData((Entity)this);
            if (rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.MORGARATH.getId()) && rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId())) {
                return "Renegade Knight";
            }
            return RARpgManager.getRAClass(rpgData.getClassId()) != null ? RARpgManager.getRAClass((String)rpgData.getClassId()).name : super.func_70005_c_();
        }
        return super.func_70005_c_();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.func_70902_q() instanceof EntityPlayer) {
            IRpgData data = RpgData.getRpgData((Entity)this.func_70902_q());
            data.getHiredEntityUUIDs().remove(this.func_110124_au());
        }
        if (this.func_184187_bx() != null) {
            this.func_184187_bx().func_70097_a(cause, 100.0f);
            this.func_184210_p();
            this.field_70725_aQ = 19;
            this.func_70609_aI();
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        String playerNation;
        ItemStack heldItem = player.func_184586_b(hand);
        IRpgData rpgData = RpgData.getRpgData((Entity)this);
        IRpgData playerRpgData = RpgData.getRpgData((Entity)player);
        String nation = rpgData.getNation();
        if (!(nation.equalsIgnoreCase(playerNation = playerRpgData.getNation()) || RAWorldData.get(this.field_70170_p).areNationsAllied(nation, playerNation) || player.field_71075_bZ.field_75098_d)) {
            return super.func_184645_a(player, hand);
        }
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            if (!heldItem.func_190926_b()) {
                Item item = heldItem.func_77973_b();
                if (item == Items.field_151141_av && (this.func_70909_n() || player.field_71075_bZ.field_75098_d)) {
                    if (this.func_184187_bx() == null) {
                        this.createHorseMount();
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (item == Items.field_151043_k && this.isLeader()) {
                    Skill.SkillUpgrade laUpgrade;
                    Skill.SkillUpgrade lsUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.LEADERSHIP.getId()).getCurrentUpgrade(playerRpgData);
                    int maxHires = lsUpgrade != null ? (int)lsUpgrade.value : 0;
                    Skill.SkillUpgrade hsUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.HUMAN_SPEECH.getId()).getCurrentUpgrade(playerRpgData);
                    if (hsUpgrade != null) {
                        maxHires = (int)((float)maxHires + hsUpgrade.value);
                    }
                    if ((laUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.LEAD_ARCHER.getId()).getCurrentUpgrade(playerRpgData)) != null) {
                        maxHires = (int)((float)maxHires + laUpgrade.value);
                    }
                    if (playerRpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
                        if (!rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Rangers can only hire other rangers!"));
                            return true;
                        }
                        if (playerRpgData.getLevel() >= 25) {
                            maxHires = 1;
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "You must be a full Ranger to take an Apprentice"));
                            return true;
                        }
                    }
                    if (maxHires == 0) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "You can't hire any soldiers, level up your leadership skill!"));
                        return true;
                    }
                    if (playerRpgData.getHiredEntityUUIDs().size() >= maxHires) {
                        playerRpgData.getHiredEntityUUIDs().remove(0);
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "You have reached your hiring limit! One of your existing soldiers has been deleted."));
                    } else if (playerRpgData.getHiredEntityUUIDs().size() + 1 >= maxHires) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Warning: You have reached your limit of " + maxHires + " " + RARpgManager.getRAClass((String)rpgData.getClassId()).name + "s"));
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Hiring more will delete one of your existing soldiers!"));
                    }
                    EntityRAStandard raHumanoid = new EntityRAStandard(this.field_70170_p);
                    raHumanoid.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    IRpgData rpgDataNew = RpgData.getRpgData((Entity)raHumanoid);
                    rpgDataNew.setNation(rpgData.getNation());
                    rpgDataNew.setClassId(rpgData.getClassId());
                    raHumanoid.setLeader(false);
                    raHumanoid.func_193101_c(player);
                    raHumanoid.func_110163_bv();
                    raHumanoid.func_180482_a(this.field_70170_p.func_175649_E(raHumanoid.func_180425_c()), null);
                    raHumanoid.setAction(3);
                    this.field_70170_p.func_72838_d((Entity)raHumanoid);
                    raHumanoid.func_70024_g(this.field_70146_Z.nextFloat() * 2.0f - 2.0f, 0.0, this.field_70146_Z.nextFloat() * 2.0f - 2.0f);
                    if (raHumanoid.func_184187_bx() != null) {
                        raHumanoid.func_184187_bx().func_70024_g((double)(this.field_70146_Z.nextFloat() * 2.0f - 2.0f), 0.0, (double)(this.field_70146_Z.nextFloat() * 2.0f - 2.0f));
                    }
                    playerRpgData.getHiredEntityUUIDs().add(raHumanoid.func_110124_au());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                } else if (item instanceof ItemFood && !player.func_184587_cr()) {
                    ItemFood food = (ItemFood)item;
                    if (this.func_110143_aJ() < this.func_110138_aP()) {
                        this.func_70691_i(food.func_150905_g(heldItem));
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Healed to " + (int)this.func_110143_aJ() + " health!"));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Full health!"));
                    }
                } else if (!this.isLocked() || player.field_71075_bZ.field_75098_d && player.field_71075_bZ.field_75100_b) {
                    EntityEquipmentSlot slot = EntityRAHumanoid.func_184640_d((ItemStack)heldItem);
                    if (item == Items.field_190929_cY || item instanceof ItemShield) {
                        slot = EntityEquipmentSlot.OFFHAND;
                    }
                    if (!(this.func_184582_a(slot).func_190926_b() || player.func_184812_l_() && this.func_184582_a(slot).func_77969_a(heldItem))) {
                        this.func_70099_a(this.func_184582_a(slot), 1.0f);
                    }
                    this.field_184655_bs[slot.func_188454_b()] = 2.0f;
                    this.func_184201_a(slot, heldItem.func_77946_l());
                    if (slot == EntityEquipmentSlot.MAINHAND) {
                        this.prevMainStack = heldItem.func_77946_l();
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                }
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) || player.field_71075_bZ.field_75098_d) {
                Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketOpenRAGui(0, this.func_145782_y()), (EntityPlayerMP)player);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        if (this.func_70638_az() instanceof EntityPlayer || this.func_70638_az() instanceof EntityRABase) {
            IRpgData rpgData = RpgData.getRpgData((Entity)this);
            IRpgData targetData = RpgData.getRpgData((Entity)this.func_70638_az());
            if (!rpgData.getNation().equalsIgnoreCase(targetData.getNation())) {
                super.func_70604_c(livingBase);
            }
        } else {
            super.func_70604_c(livingBase);
        }
    }

    public void useCloseCombatWeapon() {
        IRpgData rpgData = RpgData.getRpgData((Entity)this);
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARRIDI_WARRIOR.getId()) || rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.BEDULLIN.getId()) || rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TUALAGHI.getId())) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("arridi_scimitar")));
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_WARRIOR.getId()) || rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_ARCHER.getId())) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("temujai_saber")));
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SENSHI.getId())) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("senshi_wakizashi")));
        } else {
            boolean isPike;
            boolean bl = isPike = this.func_184614_ca().func_77973_b() instanceof ItemWeapon && ((ItemWeapon)this.func_184614_ca().func_77973_b()).isPike;
            if (isPike && rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId())) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("broad_sword")));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("short_sword")));
            }
        }
    }

    @Override
    public void func_70636_d() {
        boolean prevPolearm;
        if (!this.func_70089_S()) {
            if (this.field_70173_aa > 3) {
                super.func_70636_d();
            }
            return;
        }
        if (this.getAction() == 1 && !this.field_70170_p.field_72995_K && (this.func_70638_az() == null || this.func_70032_d((Entity)this.func_70638_az()) > 3.0f)) {
            List nearby = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(20.0));
            for (EntityLivingBase entity : nearby) {
                if (RARpgManager.isAllied((Entity)this, (Entity)entity) || !(entity instanceof EntityRABase) && !(entity instanceof EntityPlayer) || entity instanceof EntityRABase && (((EntityRABase)entity).isCorpse() || !entity.func_70089_S() || entity.field_70128_L) || this.func_70638_az() != null && !(this.func_70032_d((Entity)entity) < this.func_70032_d((Entity)this.func_70638_az()))) continue;
                this.func_70624_b(entity);
            }
        }
        this.func_82168_bl();
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 100 == 0) {
            this.func_70691_i(0.5f);
        }
        if (!this.field_70170_p.field_72995_K && this.isTemporary() && this.field_70173_aa > 1200 && this.func_70638_az() == null) {
            this.func_70106_y();
        }
        IRpgData rpgData = RpgData.getRpgData((Entity)this);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 20) {
            if (rpgData.getClassId().isEmpty()) {
                this.func_70106_y();
            }
            if (this.field_70173_aa % 100 == 0 && this.func_70902_q() instanceof EntityPlayer) {
                IRpgData ownerRpgData = RpgData.getRpgData((Entity)this.func_70902_q());
                boolean found = false;
                for (UUID uuid : ownerRpgData.getHiredEntityUUIDs()) {
                    if (!uuid.equals(this.func_110124_au())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.func_70106_y();
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_82150_aj()) {
            this.func_70624_b(null);
            this.func_70604_c(null);
        }
        if (this.func_70638_az() instanceof EntityRABase && ((EntityRABase)this.func_70638_az()).isCorpse()) {
            this.func_70624_b(null);
            this.func_70604_c(null);
        }
        ItemStack heldStack = this.func_184586_b(EnumHand.MAIN_HAND);
        boolean curPolearm = this.prevMainStack != null && heldStack.func_77973_b() instanceof ItemWeapon && ((ItemWeapon)heldStack.func_77973_b()).polearm;
        boolean bl = prevPolearm = this.prevMainStack != null && this.prevMainStack.func_77973_b() instanceof ItemWeapon && ((ItemWeapon)this.prevMainStack.func_77973_b()).polearm;
        if (this.func_70638_az() != null && !this.field_70170_p.field_72995_K) {
            Skill.SkillUpgrade hupgrade;
            boolean prevPike;
            boolean useRanged = this.func_70032_d((Entity)this.func_70638_az()) > 3.0f;
            boolean mainlyThrowing = heldStack.func_77973_b() instanceof ItemThrowableWeapon && ((ItemThrowableWeapon)heldStack.func_77973_b()).isMainlyThrowing();
            boolean bl2 = prevPike = prevPolearm && ((ItemWeapon)this.prevMainStack.func_77973_b()).isPike;
            if (prevPolearm && (this.func_70032_d((Entity)this.func_70638_az()) >= 7.0f || prevPike && this.func_70638_az().func_184187_bx() != null) && (this.func_184187_bx() != null || ((ItemWeapon)this.prevMainStack.func_77973_b()).thrustDist <= 5.0f || prevPike)) {
                this.func_184611_a(EnumHand.MAIN_HAND, this.prevMainStack);
            }
            if (heldStack.func_77973_b() == RAItemLoader.getItem("skandian_throwing_axe")) {
                if (this.getThrowables() < 5 && this.field_70173_aa % 2400 == 0) {
                    this.setThrowables(this.getThrowables() + 1);
                }
                if (this.getThrowables() > 0 && this.attackTime <= 0 && this.field_70146_Z.nextInt(50) == 0 && useRanged) {
                    this.setThrowables(this.getThrowables() - 1);
                    this.attackTime = 20;
                    this.throwWeaponAt(this.func_70638_az());
                }
            } else if (heldStack.func_77973_b() instanceof ItemThrowableWeapon) {
                if (useRanged) {
                    if (this.getThrowables() > 0 && (this.field_70146_Z.nextInt(50) == 0 || mainlyThrowing) && this.attackTime <= 0) {
                        this.func_70625_a((Entity)this.func_70638_az(), 300.0f, 25.0f);
                        this.setThrowables(this.getThrowables() - 1);
                        this.throwWeaponAt(this.func_70638_az());
                        if (this.getThrowables() == 0) {
                            this.useCloseCombatWeapon();
                        }
                    }
                } else if (mainlyThrowing) {
                    this.useCloseCombatWeapon();
                }
            }
            this.useSkillConditionally(RARpgManager.SkillId.CHARGE.getId(), rpgData, 100, this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && !mainlyThrowing && this.getAction() != 1);
            this.useSkillConditionally(RARpgManager.SkillId.CLOSE_COMBAT.getId(), rpgData, 50, this.func_70032_d((Entity)this.func_70638_az()) < 4.0f);
            this.useSkill(RARpgManager.SkillId.VANISH.getId(), rpgData, 250);
            if (!rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) {
                this.useSkillConditionally(RARpgManager.SkillId.MISDIRECTION.getId(), rpgData, 20, this.func_70643_av() != null);
            }
            if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
                if (rpgData.getSkillLevel(RARpgManager.SkillId.ESCAPE.getId()) <= 0) {
                    if (this.getThrowables() > 0 && this.field_70146_Z.nextInt(50) == 0 && this.func_70032_d((Entity)this.func_70638_az()) < 7.0f) {
                        this.throwKnifeAt(this.func_70638_az());
                        this.setThrowables(this.getThrowables() - 1);
                    }
                } else if (this.useSkill(RARpgManager.SkillId.ESCAPE.getId(), rpgData, 50)) {
                    rpgData.setSkillCooldown(RARpgManager.SkillId.ESCAPE.getId(), (int)((float)rpgData.getSkillCooldown(RARpgManager.SkillId.ESCAPE.getId()) / 2.0f));
                    if (this.getThrowables() > 0) {
                        this.throwKnifeAt(this.func_70638_az());
                        this.setThrowables(this.getThrowables() - 1);
                    }
                }
            } else {
                this.useSkillConditionally(RARpgManager.SkillId.ESCAPE.getId(), rpgData, 150, this.func_70032_d((Entity)this.func_70638_az()) < 7.0f);
            }
            this.useSkillConditionally(RARpgManager.SkillId.AGILITY.getId(), rpgData, 200, !(this instanceof EntityWargal) && this.func_184187_bx() == null);
            this.useSkillConditionally(RARpgManager.SkillId.SHIELD_BASH.getId(), rpgData, 120, this.func_70032_d((Entity)this.func_70638_az()) < 3.0f && this.func_184592_cb().func_77973_b() instanceof ItemShield);
            this.useSkill(RARpgManager.SkillId.RAPID_FIRE.getId(), rpgData, 2);
            this.useSkillConditionally(RARpgManager.SkillId.GROUND_POUND.getId(), rpgData, 120, this.func_70032_d((Entity)this.func_70638_az()) < 3.0f);
            this.useSkill(RARpgManager.SkillId.BERSERKER.getId(), rpgData, 400);
            this.useSkill(RARpgManager.SkillId.BASH.getId(), rpgData, 1000);
            this.useSkillConditionally(RARpgManager.SkillId.SANDSTORM_SLASH.getId(), rpgData, 100, this.func_70032_d((Entity)this.func_70638_az()) < 4.0f);
            this.useSkill(RARpgManager.SkillId.UNBREAKABLE.getId(), rpgData, 400);
            this.useSkill(RARpgManager.SkillId.FURY_SLICE.getId(), rpgData, 200);
            this.useSkill(RARpgManager.SkillId.FATAL_SHOT.getId(), rpgData, 150);
            if (rpgData.getSkillLevel(RARpgManager.SkillId.HEAL.getId()) > 0 && rpgData.getSkillCooldown(RARpgManager.SkillId.HEAL.getId()) <= 0 && this.field_70146_Z.nextInt(200) == 0 && (hupgrade = RARpgManager.getSkill(RARpgManager.SkillId.HEAL.getId()).getNextUpgrade(rpgData)) != null) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, hupgrade.duration * 20, hupgrade.modifier));
                rpgData.setSkillCooldown(RARpgManager.SkillId.HEAL.getId(), hupgrade.cooldown / 2);
            }
        } else if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 60 == 0 && prevPolearm && !curPolearm && (this.func_184187_bx() != null || ((ItemWeapon)this.prevMainStack.func_77973_b()).thrustDist <= 5.0f || ((ItemWeapon)this.prevMainStack.func_77973_b()).isPike)) {
            this.func_184611_a(EnumHand.MAIN_HAND, this.prevMainStack);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 2400 == 0 && this.getThrowables() < this.maxThrowables) {
            this.setThrowables(this.getThrowables() + 1);
        }
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
            if (!this.field_70170_p.field_72995_K) {
                List nearbyKnives;
                if (this.getThrowables() < 3 && this.field_70173_aa % 2400 == 0) {
                    this.setThrowables(this.getThrowables() + 1);
                }
                if (this.field_70173_aa % 2400 == 0 && this.getAmmo() < 32) {
                    this.setAmmo(this.getAmmo() + 1);
                }
                if (this.field_70146_Z.nextInt(250) == 0 && this.attackTime <= 0 && !(nearbyKnives = this.field_70170_p.func_72872_a(EntityThrowingKnife.class, this.func_174813_aQ().func_186662_g(3.0))).isEmpty()) {
                    EntityThrowingKnife knife = (EntityThrowingKnife)((Object)nearbyKnives.get(0));
                    if (!(knife.field_70250_c instanceof EntityPlayer)) {
                        knife.func_70106_y();
                    }
                    this.setThrowables(this.getThrowables() + 1);
                }
                if (this.func_70638_az() != null && (this.func_70032_d((Entity)this.func_70638_az()) <= 5.0f || this.getAmmo() <= 0)) {
                    if (this.func_184614_ca().func_77973_b() != RAItemLoader.getItem("ranger_saxe")) {
                        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(RAItemLoader.getItem("ranger_saxe")));
                    }
                } else {
                    Item bow;
                    Item item = bow = this.isLeader() ? RAItemLoader.getItem("longbow") : RAItemLoader.getItem("recurve_bow");
                    if (this.func_184614_ca().func_77973_b() != bow) {
                        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(bow));
                    }
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            int maxAmmo;
            if (this.prevMainStack != null && this.prevMainStack.func_77973_b() instanceof ItemThrowableWeapon && !this.field_70170_p.field_72995_K && this.func_184614_ca() != this.prevMainStack && this.getThrowables() > 0 && (this.func_70638_az() == null ? this.field_70173_aa % 120 == 0 : this.func_70032_d((Entity)this.func_70638_az()) > 5.0f)) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.prevMainStack);
            }
            int n = maxAmmo = rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_ARCHER.getId()) ? 8 : 16;
            if (this.field_70173_aa % 2400 == 0 && this.getAmmo() < maxAmmo) {
                this.setAmmo(this.getAmmo() + 1);
            }
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                if (this.getAmmo() <= 0) {
                    this.useCloseCombatWeapon();
                }
            } else if (this.prevMainStack != null && this.prevMainStack.func_77973_b() instanceof ItemBow && !this.field_70170_p.field_72995_K && this.func_184614_ca() != this.prevMainStack && this.getAmmo() > 0 && (this.func_70638_az() == null ? this.field_70173_aa % 120 == 0 : this.func_70032_d((Entity)this.func_70638_az()) > 5.0f)) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.prevMainStack);
            }
        }
        if (this.field_70173_aa > 3) {
            super.func_70636_d();
        }
        if (this.setCombatTask) {
            this.setCombatTask();
            this.setCombatTask = false;
        }
    }

    public boolean useSkill(String skillId, IRpgData rpgData, int useChance) {
        return this.useSkillConditionally(skillId, rpgData, useChance, true);
    }

    public boolean useSkillConditionally(String skillId, IRpgData rpgData, int useChance, boolean condition) {
        if (rpgData.getSkillLevel(skillId) > 0 && rpgData.getSkillCooldown(skillId) <= 0 && this.field_70146_Z.nextInt(useChance) == 0 && condition) {
            RARpgManager.useSkillNew(rpgData, skillId);
            return true;
        }
        return false;
    }

    public boolean func_174833_aM() {
        return !this.isCorpse();
    }

    public boolean func_145818_k_() {
        return super.func_145818_k_();
    }

    public String func_95999_t() {
        return super.func_95999_t();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        List<String> armorItems;
        boolean isElite;
        IRpgData rpgData = RpgData.getRpgData((Entity)this);
        String classID = rpgData.getClassId();
        RAClass raClass = RARpgManager.getRAClass(classID);
        if (raClass == null) {
            this.func_70106_y();
            return null;
        }
        boolean bl = isElite = this.field_70146_Z.nextInt(10) == 0;
        if (!raClass.heldItems.isEmpty()) {
            Random random = new Random();
            String itemName = raClass.heldItems.get(random.nextInt(raClass.heldItems.size()));
            if (isElite && raClass.heldItemsElite != null && !raClass.heldItemsElite.isEmpty()) {
                itemName = raClass.heldItemsElite.get(random.nextInt(raClass.heldItemsElite.size()));
            }
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(RAItemLoader.getItem(itemName)));
        }
        List<String> list = armorItems = this.isLeader() ? raClass.armorItemsLeader : raClass.armorItems;
        if (armorItems != null) {
            armorItems = new ArrayList<String>(armorItems);
        }
        if (isElite && raClass.armorItemsElite != null && !raClass.armorItemsElite.isEmpty()) {
            List<List<String>> eliteArmors = this.isLeader() && raClass.armorItemsLeaderElite != null && !raClass.armorItemsLeaderElite.isEmpty() ? raClass.armorItemsLeaderElite : raClass.armorItemsElite;
            List<String> eliteArmorItems = eliteArmors.get(this.field_70146_Z.nextInt(eliteArmors.size()));
            for (int i = 0; i < eliteArmorItems.size(); ++i) {
                if (eliteArmorItems.get(i).isEmpty()) continue;
                armorItems.set(i, eliteArmorItems.get(i));
            }
        }
        if (rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.MORGARATH.getId()) && classID.equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId())) {
            armorItems = this.isLeader() ? RARpgManager.morgarathKnightArmorLeader : RARpgManager.morgarathKnightArmor;
        }
        ItemStack prevPants = this.func_184582_a(EntityEquipmentSlot.LEGS).func_77946_l();
        if (armorItems != null && !armorItems.isEmpty()) {
            for (int i = 0; i < armorItems.size(); ++i) {
                this.func_184201_a(EntityEquipmentSlot.values()[i + 2], new ItemStack(RAItemLoader.getItem(armorItems.get(i))));
            }
        }
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SCOTTI_WARRIOR.getId())) {
            if (!prevPants.func_190926_b()) {
                this.func_184201_a(EntityEquipmentSlot.LEGS, prevPants);
            } else {
                Item[] items = rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.SCOTTI.getId()) ? new Item[]{RAItemLoader.getItem("scotti_mcduig_pants"), RAItemLoader.getItem("scotti_mcforn_pants")} : new Item[]{RAItemLoader.getItem("scotti_pants_wrap"), RAItemLoader.getItem("scotti_macfrewin_pants"), RAItemLoader.getItem("scotti_mackentick_pants")};
                this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(items[this.field_70146_Z.nextInt(items.length)]));
            }
        }
        double distCheck = 200.0;
        double d0 = -1.0;
        int totalLevel = 0;
        int count = 0;
        for (int j2 = 0; j2 < this.field_70170_p.field_73010_i.size(); ++j2) {
            double d1;
            EntityPlayer entityplayer1 = (EntityPlayer)this.field_70170_p.field_73010_i.get(j2);
            if (!EntitySelectors.field_188444_d.apply((Object)entityplayer1) && !entityplayer1.func_184812_l_() || !((d1 = entityplayer1.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v)) < distCheck * distCheck) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            totalLevel += RpgData.getRpgData((Entity)entityplayer1).getLevel();
            ++count;
        }
        int avgPlayerLevels = (int)((float)totalLevel / (float)count);
        if (!this.isLeader()) {
            avgPlayerLevels -= 10;
        }
        int baseLevel = Math.max(avgPlayerLevels, 1);
        int level = Math.min(baseLevel + this.field_70146_Z.nextInt(20), 100);
        rpgData.setLevel(level);
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
            this.setMaxThrowables(3);
            this.setAmmo(32);
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_ARCHER.getId())) {
            this.setAmmo(16);
        }
        Item heldItem = this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
        if (heldItem == RAItemLoader.getItem("skandian_throwing_axe")) {
            this.setMaxThrowables(5);
        }
        if (heldItem == RAItemLoader.getItem("senshi_javelin")) {
            this.setMaxThrowables(8);
        }
        if (heldItem == RAItemLoader.getItem("arridi_jarid")) {
            this.setMaxThrowables(8);
        }
        if (heldItem == RAItemLoader.getItem("scotti_javelin")) {
            this.setMaxThrowables(8);
        }
        boolean useHorse = rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId());
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARRIDI_WARRIOR.getId()) && (heldItem == RAItemLoader.getItem("arridi_lance") || heldItem == RAItemLoader.getItem("arridi_jarid"))) {
            useHorse = true;
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("arridi_cavalry_pants")));
            if (this.isLeader()) {
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(RAItemLoader.getItem("arridi_cavalry_captain_chestplate")));
            } else {
                this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(RAItemLoader.getItem("arridi_cavalry_chestplate")));
            }
        }
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId()) && heldItem == RAItemLoader.getItem("araluen_lance")) {
            useHorse = true;
        }
        if (useHorse && this.createHorse) {
            this.createHorseMount();
        }
        this.shieldUse = this.field_70146_Z.nextInt(4);
        if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARRIDI_WARRIOR.getId())) {
            if (!(this.func_184614_ca().func_77973_b() instanceof ItemBow)) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(RAItemLoader.getItem("arridi_shield")));
            }
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId())) {
            if (this.field_70146_Z.nextInt(2) == 0 && heldItem != RAItemLoader.getItem("araluen_pike") && heldItem != RAItemLoader.getItem("long_sword") && heldItem != RAItemLoader.getItem("great_sword") && heldItem != RAItemLoader.getItem("war_hammer") && heldItem != RAItemLoader.getItem("halberd")) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(RAItemLoader.getItem("araluen_shield")));
            }
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId())) {
            if (this.field_70146_Z.nextInt(2) == 0 && heldItem != RAItemLoader.getItem("voulge") && heldItem != RAItemLoader.getItem("skandian_great_axe") && heldItem != RAItemLoader.getItem("ategir")) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(RAItemLoader.getItem("skandian_shield")));
            }
        } else if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SCOTTI_WARRIOR.getId()) && this.field_70146_Z.nextInt(2) == 0 && heldItem != RAItemLoader.getItem("scotti_claymore") && heldItem != RAItemLoader.getItem("jeddart_stave") && heldItem != RAItemLoader.getItem("lochaber_axe")) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(RAItemLoader.getItem("scotti_targe")));
        }
        this.applyLevelModifiers(rpgData);
        this.setCombatTask = true;
        return null;
    }

    public void createHorseMount() {
        EntityCustomHorse horse = new EntityCustomHorse(this.field_70170_p);
        horse.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        horse.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        horse.func_110234_j(true);
        horse.func_174820_d(400, new ItemStack(Items.field_151141_av));
        horse.func_174820_d(401, new ItemStack(Items.field_151138_bX));
        horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.22f);
        horse.func_70873_a(0);
        this.field_70170_p.func_72838_d((Entity)horse);
        this.func_184220_m((Entity)horse);
    }

    public void applyLevelModifiers(IRpgData rpgData) {
        int level = rpgData.getLevel();
        RAClass raClass = RARpgManager.getRAClass(rpgData.getClassId());
        if (raClass == null) {
            return;
        }
        int tries = 0;
        int skillPoints = rpgData.getAvailableSkillPoints();
        while (skillPoints > 0 && tries++ < 150) {
            Skill skill = RARpgManager.getSkill(raClass.skills.get(this.field_70146_Z.nextInt(raClass.skills.size())));
            int skillLevel = rpgData.getSkillLevel(skill.id);
            Skill.SkillUpgrade nextUpgrade = skill.getNextUpgrade(rpgData);
            if (skillLevel >= skill.upgrades.size() || skillPoints < nextUpgrade.cost) continue;
            rpgData.setSkillLevel(skill.id, skillLevel + 1);
            skillPoints -= nextUpgrade.cost;
        }
        float balancedMobHealth = (float)raClass.mobHealth * ((float)level / 100.0f);
        if (this.isLeader()) {
            balancedMobHealth += balancedMobHealth / 2.0f;
        } else if (this.func_70909_n()) {
            balancedMobHealth += 20.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f + balancedMobHealth));
        this.func_70606_j(this.func_110138_aP());
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.field_70146_Z.nextInt(2) == 0 ? RASounds.SKANDIAN_HURT : RASounds.SKANDIAN_HURT_TWO;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_184601_bQ(null);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDefendPosX(Float.valueOf(compound.func_74760_g("DefendPosX")));
        this.setDefendPosY(Float.valueOf(compound.func_74760_g("DefendPosY")));
        this.setDefendPosZ(Float.valueOf(compound.func_74760_g("DefendPosZ")));
        this.setLocked(compound.func_74767_n("Locked"));
        this.setTemporary(compound.func_74767_n("Temporary"));
        this.setLeader(compound.func_74767_n("Leader"));
        this.setAction(compound.func_74762_e("Action"));
        this.setThrowables(compound.func_74762_e("Throwables"));
        this.maxThrowables = compound.func_74762_e("MaxThrowables");
        this.setAmmo(compound.func_74762_e("Ammo"));
        this.setSquad(compound.func_74762_e("Squad"));
        this.setCombatTask = true;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("DefendPosX", this.getDefendPosX().floatValue());
        compound.func_74776_a("DefendPosY", this.getDefendPosY().floatValue());
        compound.func_74776_a("DefendPosZ", this.getDefendPosZ().floatValue());
        compound.func_74757_a("Locked", this.isLocked());
        compound.func_74757_a("Temporary", this.isTemporary());
        compound.func_74757_a("Leader", this.isLeader());
        compound.func_74768_a("Action", this.getAction());
        compound.func_74768_a("Throwables", this.getThrowables());
        compound.func_74768_a("MaxThrowables", this.maxThrowables);
        compound.func_74768_a("Ammo", this.getAmmo());
        compound.func_74768_a("Squad", this.getSquad());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            boolean mainlyThrowing;
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            boolean bl = mainlyThrowing = this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemThrowableWeapon && ((ItemThrowableWeapon)this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).isMainlyThrowing();
            if (itemstack.func_77973_b() instanceof ItemBow || mainlyThrowing) {
                Skill.SkillUpgrade qdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.POWER_DRAW.getId()).getCurrentUpgrade(RpgData.getRpgData((Entity)this));
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                    if (!mainlyThrowing && qdUpgrade != null) {
                        i = (int)((float)i * qdUpgrade.value / 2.0f);
                    }
                } else if (!mainlyThrowing && qdUpgrade != null) {
                    i = (int)((float)i * qdUpgrade.value);
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource != null && !(par1DamageSource.func_76346_g() instanceof EntityPlayer) && par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
            boolean isPike;
            EntityLivingBase attacker = (EntityLivingBase)par1DamageSource.func_76346_g();
            if (this.getAction() != 5) {
                this.func_70624_b((EntityLivingBase)par1DamageSource.func_76346_g());
            }
            boolean bl = isPike = attacker.func_184614_ca().func_77973_b() instanceof ItemWeapon && ((ItemWeapon)attacker.func_184614_ca().func_77973_b()).isPike;
            if (this.func_184187_bx() != null && (this.field_70146_Z.nextInt(2) == 0 || isPike)) {
                this.func_184187_bx().func_70097_a(par1DamageSource, par2);
                if (!isPike) {
                    return false;
                }
            }
        }
        super.func_70097_a(par1DamageSource, par2);
        return true;
    }

    public void throwKnifeAt(EntityLivingBase target) {
        EntityThrowingKnife entityarrow = new EntityThrowingKnife(this.field_70170_p, (EntityLivingBase)this);
        entityarrow.func_70239_b(entityarrow.func_70242_d() + 5.0 + 5.0);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.1, d2, 2.0f, 2.0f);
        this.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        this.attackTime = 40;
    }

    public void throwWeaponAt(EntityLivingBase target) {
        this.throwWeaponAt(target, this.func_184614_ca());
    }

    public void throwWeaponAt(EntityLivingBase target, ItemStack thrownItem) {
        EntityThrowingWeapon entityarrow = new EntityThrowingWeapon(this.field_70170_p, (EntityLivingBase)this, thrownItem);
        if (thrownItem.func_77973_b() instanceof ItemThrowableWeapon) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)((ItemThrowableWeapon)thrownItem.func_77973_b()).getAttackDamage());
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.1, d2, 1.5f, 5.0f);
        this.func_184185_a(SoundEvents.field_187797_fA, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        this.attackTime = 60;
        if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
            this.attackTime = 80;
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        Item bow;
        int k;
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        ItemStack stack = this.func_184614_ca();
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (j > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
            entityarrow.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            entityarrow.func_70015_d(100);
        }
        if ((bow = stack.func_77973_b()) == RAItemLoader.getItem("longbow") || bow == RAItemLoader.getItem("ranger_longbow")) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + 2.0);
        }
        if (RpgData.getRpgData((Entity)this).getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() * 2.0);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * 0.1, d2, 3.0f, 2.0f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
        if (this.getAmmo() > 0) {
            IRpgData rpgData = RpgData.getRpgData((Entity)this);
            if (!this.func_70644_a(EffectRegistry.RAPID_FIRE) || rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
                this.setAmmo(this.getAmmo() - 1);
            }
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }
}

