/*
 * Decompiled with CFR 0.152.
 */
package ranger.entities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import ranger.RASounds;
import ranger.entities.EntityCapedMob;
import ranger.entities.EntityCustomHorse;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class EntityTemujaiGeneral
extends EntityCapedMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public int spawnTime = 0;
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityTemujaiGeneral.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityTemujaiGeneral(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 2.2f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.bossInfo.func_186757_c().isEmpty()) {
            ArrayList players = new ArrayList(this.bossInfo.func_186757_c());
            for (EntityPlayerMP playerMP : players) {
                this.bossInfo.func_186761_b(playerMP);
            }
            this.bossInfo.func_186741_a(false);
            this.bossInfo.func_186758_d(false);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isCorpse()) {
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.getInvulTime() > 0) {
            IRpgData rpgData;
            List nearby;
            int j1 = this.getInvulTime() - 1;
            if (j1 == 350) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, false);
                this.spawnSoldier(5, false, RARpgManager.ClassId.TEMUJAI_WARRIOR.getId());
            }
            if (j1 == 100) {
                nearby = this.field_70170_p.func_72872_a(EntityRAHumanoid.class, this.func_174813_aQ().func_186662_g(40.0));
                for (EntityRAHumanoid humanoid : nearby) {
                    rpgData = RpgData.getRpgData((Entity)humanoid);
                    if (humanoid.func_70909_n() || !rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) continue;
                    this.pullBack(humanoid);
                }
            }
            if (j1 == 0) {
                nearby = this.field_70170_p.func_72872_a(EntityRAHumanoid.class, this.func_174813_aQ().func_186662_g(40.0));
                for (EntityRAHumanoid humanoid : nearby) {
                    rpgData = RpgData.getRpgData((Entity)humanoid);
                    if (humanoid.func_70909_n() || !rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) continue;
                    humanoid.setAction(4);
                    humanoid.func_70024_g(this.field_70146_Z.nextFloat() * 2.0f - 1.0f, 0.0, this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    if (humanoid.func_184187_bx() == null) continue;
                    humanoid.func_184187_bx().func_70024_g((double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f));
                }
                this.spawnSoldier(4, false, RARpgManager.ClassId.TEMUJAI_WARRIOR.getId());
                this.spawnSoldier(4, true, RARpgManager.ClassId.TEMUJAI_WARRIOR.getId());
                String classId = RARpgManager.ClassId.TEMUJAI_ARCHER.getId();
                this.spawnSoldier(5, true, classId);
            }
            this.setInvulTime(j1);
        }
    }

    private void pullBack(EntityRAHumanoid humanoid) {
        humanoid.setDefendPosX(Float.valueOf((float)this.field_70165_t));
        humanoid.setDefendPosY(Float.valueOf((float)this.field_70163_u));
        humanoid.setDefendPosZ(Float.valueOf((float)this.field_70161_v));
        humanoid.func_70624_b(null);
        humanoid.func_70604_c(null);
        humanoid.setAction(5);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getInvulTime() > 0) {
            return false;
        }
        if (source != null && !(source.func_76346_g() instanceof EntityPlayer) && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            if (this.func_184187_bx() != null && this.field_70146_Z.nextInt(2) == 0) {
                this.func_184187_bx().func_70097_a(source, amount);
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70104_M() {
        return this.getInvulTime() <= 0;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (!this.isCorpse()) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public void ignite() {
        this.setInvulTime(400);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isCorpse()) {
            return;
        }
        if (this.getInvulTime() > 0 && !this.field_70170_p.field_72995_K) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 6.0f - 3.0f), 4, 0.5, 0.1, 0.5, 0.01, new int[0]);
        }
        if (this.getInvulTime() <= 0 && !this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 300 == 0 && this.spawnTime <= 0) {
                List nearby2 = this.field_70170_p.func_72872_a(EntityRAHumanoid.class, this.func_174813_aQ().func_186662_g(20.0));
                int count = 0;
                for (EntityRAHumanoid raHumanoid : nearby2) {
                    if (raHumanoid.isCorpse()) continue;
                    IRpgData rpgData = RpgData.getRpgData((Entity)raHumanoid);
                    if (raHumanoid.func_70909_n() || !rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) continue;
                    ++count;
                }
                if (count < 20) {
                    this.spawnTime = 300;
                }
            }
            if (this.spawnTime > 0) {
                IRpgData rpgData;
                List nearby;
                --this.spawnTime;
                if (this.spawnTime == 100) {
                    nearby = this.field_70170_p.func_72872_a(EntityRAHumanoid.class, this.func_174813_aQ().func_186662_g(40.0));
                    for (EntityRAHumanoid humanoid : nearby) {
                        rpgData = RpgData.getRpgData((Entity)humanoid);
                        if (humanoid.func_70909_n() || !rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) continue;
                        this.pullBack(humanoid);
                    }
                }
                if (this.spawnTime == 0) {
                    nearby = this.field_70170_p.func_72872_a(EntityRAHumanoid.class, this.func_174813_aQ().func_186662_g(40.0));
                    for (EntityRAHumanoid humanoid : nearby) {
                        rpgData = RpgData.getRpgData((Entity)humanoid);
                        if (humanoid.func_70909_n() || !rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) continue;
                        humanoid.setAction(4);
                        humanoid.func_70024_g(this.field_70146_Z.nextFloat() * 2.0f - 1.0f, 0.0, this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                        if (humanoid.func_184187_bx() == null) continue;
                        humanoid.func_184187_bx().func_70024_g((double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f));
                    }
                    String classId = RARpgManager.ClassId.TEMUJAI_WARRIOR.getId();
                    EntityPlayer nearestPlayer = this.field_70170_p.func_184142_a((Entity)this, 20.0, 10.0);
                    classId = nearestPlayer != null && nearestPlayer.func_70032_d((Entity)this) < 5.0f ? RARpgManager.ClassId.TEMUJAI_WARRIOR.getId() : (this.field_70146_Z.nextInt(2) == 0 ? RARpgManager.ClassId.TEMUJAI_WARRIOR.getId() : RARpgManager.ClassId.TEMUJAI_ARCHER.getId());
                    this.spawnSoldier(4, false, classId);
                    this.spawnSoldier(1, true, classId);
                }
            }
        }
    }

    public void spawnSoldier(int amount, boolean leader, String classId) {
        for (int i = 0; i < amount; ++i) {
            EntityRAStandard raHumanoid = new EntityRAStandard(this.field_70170_p);
            raHumanoid.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            IRpgData rpgData = RpgData.getRpgData((Entity)raHumanoid);
            rpgData.setNation(RARpgManager.NationId.TEMUJAI.getId());
            rpgData.setClassId(classId);
            raHumanoid.setLeader(leader);
            raHumanoid.func_180482_a(this.field_70170_p.func_175649_E(raHumanoid.func_180425_c()), null);
            raHumanoid.func_110163_bv();
            this.field_70170_p.func_72838_d((Entity)raHumanoid);
            raHumanoid.func_70024_g(this.field_70146_Z.nextFloat() * 2.0f - 1.0f, 0.0, this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
            if (raHumanoid.func_184187_bx() == null) continue;
            raHumanoid.func_184187_bx().func_70024_g((double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f));
            if (this.getInvulTime() <= 100 || !(raHumanoid.func_184187_bx() instanceof EntityCustomHorse)) continue;
            EntityCustomHorse horse = (EntityCustomHorse)raHumanoid.func_184187_bx();
            horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            horse.func_70691_i(100.0f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.getInvulTime());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInvulTime(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.field_70146_Z.nextInt(2) == 0 ? RASounds.SKANDIAN_HURT : RASounds.SKANDIAN_HURT_TWO;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_184601_bQ(null);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Override
    public double func_70033_W() {
        return super.func_70033_W() - 0.05;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            double d0;
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            switch (entityequipmentslot.func_188453_a()) {
                case HAND: {
                    d0 = 5.0;
                    break;
                }
                case ARMOR: {
                    if (entityequipmentslot.func_188454_b() == 3) {
                        d0 = 5.0;
                        break;
                    }
                    d0 = this.field_184655_bs[entityequipmentslot.func_188454_b()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            boolean bl = flag = d0 > 1.0;
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack) || !wasRecentlyHit && !flag || !((double)(this.field_70146_Z.nextFloat() - (float)lootingModifier * 0.01f) < d0)) continue;
            if (!flag && itemstack.func_77984_f()) {
                itemstack.func_77964_b(itemstack.func_77958_k() - this.field_70146_Z.nextInt(1 + this.field_70146_Z.nextInt(Math.max(itemstack.func_77958_k() - 3, 1))));
            }
            this.func_70099_a(itemstack, 0.0f);
        }
        this.func_70099_a(new ItemStack(Items.field_151043_k, 3 + this.field_70146_Z.nextInt(8)), 0.0f);
        this.func_70099_a(new ItemStack(RAItemLoader.getItem("hardened_steel"), 2 + this.field_70146_Z.nextInt(5)), 0.0f);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (this.func_184187_bx() != null) {
            this.func_184187_bx().func_70097_a(par1DamageSource, 100.0f);
            this.func_184210_p();
            this.field_70725_aQ = 19;
            this.func_70609_aI();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Temujai Shan has been slain by " + par1DamageSource.func_76346_g().func_70005_c_()));
            } else {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Temujai Shan has been slain!"));
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        RpgData.getRpgData((Entity)this).setNation(RARpgManager.NationId.TEMUJAI.getId());
        RpgData.getRpgData((Entity)this).setLevel(100);
        RpgData.getRpgData((Entity)this).setSkillLevel(RARpgManager.SkillId.RIDING.getId(), 10);
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(RAItemLoader.getItem("temujai_general_boots")));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("temujai_general_pants")));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(RAItemLoader.getItem("temujai_general_tunic")));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RAItemLoader.getItem("temujai_general_helm")));
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RAItemLoader.getItem("temujai_saber")));
        EntityCustomHorse horse = new EntityCustomHorse(this.field_70170_p);
        horse.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        horse.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        horse.func_110234_j(true);
        horse.func_174820_d(400, new ItemStack(Items.field_151141_av));
        horse.func_174820_d(401, new ItemStack(Items.field_151138_bX));
        horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.22f);
        horse.func_70873_a(0);
        this.field_70170_p.func_72838_d((Entity)horse);
        this.func_184220_m((Entity)horse);
        return super.func_180482_a(difficulty, livingdata);
    }
}

