/*
 * Decompiled with CFR 0.152.
 */
package ranger.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import ranger.Ranger;
import ranger.entities.EntityRAHumanoid;
import ranger.packet.PacketUpdateHired;

public class GuiHiredSoldier
extends GuiScreen {
    private final EntityRAHumanoid defender;
    private final int entityId;
    private GuiTextField nameField;
    private GuiButton setPositionButton;
    private GuiButton lockItemsButton;
    private GuiButton changeSquadButton;
    private GuiButton[] actionButtons = new GuiButton[5];
    private static final ResourceLocation DEMO_BACKGROUND_LOCATION = new ResourceLocation("textures/gui/demo_background.png");

    public GuiHiredSoldier(EntityRAHumanoid defender) {
        this.defender = defender;
        this.entityId = defender.func_145782_y();
    }

    public void func_73866_w_() {
        int x = (this.field_146294_l - 248) / 2;
        int y = (this.field_146295_m - 166) / 2;
        int curAction = this.defender.getAction();
        Keyboard.enableRepeatEvents((boolean)true);
        this.nameField = new GuiTextField(0, this.field_146289_q, x + 4, y + 4, 240, 20);
        this.nameField.func_146180_a(this.defender.func_95999_t());
        this.setPositionButton = new GuiButton(1, x + 145, y + 45, 100, 20, "Set Position");
        this.setPositionButton.field_146124_l = curAction == 0 || curAction == 1;
        this.field_146292_n.add(this.setPositionButton);
        this.lockItemsButton = new GuiButton(2, x + 145, y + 125, 100, 20, this.defender.isLocked() ? "Unlock Items" : "Lock Items");
        this.field_146292_n.add(this.lockItemsButton);
        this.changeSquadButton = new GuiButton(2, x + 145, y + 90, 100, 20, "Change Squad");
        this.field_146292_n.add(this.changeSquadButton);
        String[] actions = new String[]{"Defend", "Hold Position", "Guard Player", "Follow & Attack", "Wander"};
        for (int i = 0; i < actions.length; ++i) {
            this.actionButtons[i] = new GuiButton(3 + i, x + 4, y + 45 + i * 20, 100, 20, actions[i]);
            if (i == curAction) {
                this.actionButtons[i].field_146124_l = false;
            }
            this.field_146292_n.add(this.actionButtons[i]);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.setPositionButton) {
            BlockPos pos = this.field_146297_k.field_71439_g.func_180425_c();
            this.defender.setDefendPosX(Float.valueOf(pos.func_177958_n()));
            this.defender.setDefendPosY(Float.valueOf(pos.func_177956_o()));
            this.defender.setDefendPosZ(Float.valueOf(pos.func_177952_p()));
        } else if (button == this.lockItemsButton) {
            this.defender.setLocked(!this.defender.isLocked());
            this.lockItemsButton.field_146126_j = this.defender.isLocked() ? "Unlock Items" : "Lock Items";
        } else if (button == this.changeSquadButton) {
            int nextSquad = this.defender.getSquad() + 1;
            if (nextSquad > 5) {
                nextSquad = 0;
            }
            this.defender.setSquad(nextSquad);
        } else {
            int curAction;
            for (int i = 0; i < this.actionButtons.length; ++i) {
                if (button != this.actionButtons[i]) continue;
                this.defender.setAction(i);
                for (GuiButton actionButton : this.actionButtons) {
                    actionButton.field_146124_l = true;
                }
                button.field_146124_l = false;
                break;
            }
            this.setPositionButton.field_146124_l = (curAction = this.defender.getAction()) == 0 || curAction == 1;
        }
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        if ((this.defender.getAction() == 1 || this.defender.getAction() == 0) && this.defender.getDefendPosX().floatValue() == 0.0f && this.defender.getDefendPosY().floatValue() == 0.0f && this.defender.getDefendPosZ().floatValue() == 0.0f) {
            this.defender.setDefendPosX(Float.valueOf((float)this.defender.field_70165_t));
            this.defender.setDefendPosY(Float.valueOf((float)this.defender.field_70163_u));
            this.defender.setDefendPosZ(Float.valueOf((float)this.defender.field_70161_v));
        }
        PacketUpdateHired packet = new PacketUpdateHired(this.entityId, this.nameField.func_146179_b(), this.defender.getDefendPosX().floatValue(), this.defender.getDefendPosY().floatValue(), this.defender.getDefendPosZ().floatValue(), this.defender.getAction(), this.defender.isLocked(), this.defender.getSquad());
        Ranger.RANGER_CHANNEL.sendToServer((IMessage)packet);
    }

    private String getCharForNumber(int i) {
        return i >= 0 && i < 26 ? String.valueOf((char)(i + 65)) : null;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(DEMO_BACKGROUND_LOCATION);
        int x = (this.field_146294_l - 248) / 2;
        int y = (this.field_146295_m - 166) / 2;
        this.func_73729_b(x, y, 0, 0, 248, 166);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.nameField.func_146194_f();
        TextFormatting color = TextFormatting.GREEN;
        if (this.defender.func_110143_aJ() < 5.0f) {
            color = TextFormatting.DARK_RED;
        } else if (this.defender.func_110143_aJ() < 10.0f) {
            color = TextFormatting.RED;
        } else if (this.defender.func_110143_aJ() < 15.0f) {
            color = TextFormatting.YELLOW;
        }
        String healthText = "Health: ";
        this.field_146289_q.func_78276_b(healthText, x + 150, y + 30, 0x4F4F4F);
        this.field_146289_q.func_175063_a("" + color + (int)this.defender.func_110143_aJ(), (float)(x + 150 + this.field_146289_q.func_78256_a(healthText)), (float)(y + 30), 0x4F4F4F);
        this.field_146289_q.func_78276_b("Defend Position: ", x + 150, y + 45 + 24, 0x4F4F4F);
        this.field_146289_q.func_78276_b(this.defender.getDefendPosX() + ", " + this.defender.getDefendPosY() + ", " + this.defender.getDefendPosZ(), x + 150, y + 55 + 24, 0x4F4F4F);
        if (this.defender.isLocked()) {
            this.field_146289_q.func_78276_b(TextFormatting.DARK_RED + "Items Locked", x + 150, y + 150, 0x4F4F4F);
        }
        String squadText = "Squad: ";
        this.field_146289_q.func_78276_b(squadText, x + 150, y + 115, 0x4F4F4F);
        this.field_146289_q.func_175063_a(EntityRAHumanoid.squadColors[this.defender.getSquad()] + EntityRAHumanoid.squadNames[this.defender.getSquad()], (float)(x + 150 + this.field_146289_q.func_78256_a(squadText)), (float)(y + 115), 0x4F4F4F);
        this.field_146289_q.func_78276_b("Select an action:", x + 6, y + 30, 0x4F4F4F);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        this.nameField.func_146178_a();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.nameField.func_146201_a(typedChar, keyCode);
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
        } else {
            this.sendUpdatePacket();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

