/*
 * Decompiled with CFR 0.152.
 */
package ranger.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import ranger.RASounds;
import ranger.Ranger;
import ranger.packet.PacketUseSkillPoint;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;

public class GuiNewSkillMenu
extends GuiScreen {
    private static final ResourceLocation skillTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillsgui.png");
    private static final ResourceLocation iconTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillicon.png");
    private static final ResourceLocation iconButtonTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillicon_button.png");
    private static final ResourceLocation popupTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillpopup.png");
    private int selectedSkill = -1;
    private RenderItem itemRender;
    private static String[] levelText = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
    private final List<String> categories = new ArrayList<String>();
    private final List<String> skillIds = new ArrayList<String>();
    private GuiButton level;
    private int availableSkillPoints = 0;
    IRpgData rpgData;
    private GuiButton reset;
    protected int achievementsPaneWidth = 256;
    protected int achievementsPaneHeight = 202;
    public int guiWidth = 0;
    public int guiHeight = 0;

    public GuiNewSkillMenu(IRpgData rpgData) {
        this(rpgData, -1);
    }

    public GuiNewSkillMenu(IRpgData rpgData, int selectedSkill) {
        this.rpgData = rpgData;
        this.selectedSkill = selectedSkill;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.guiWidth = width;
        this.guiHeight = height;
    }

    public void func_73866_w_() {
        int i1 = (this.field_146294_l - this.achievementsPaneWidth) / 2;
        int j1 = (this.field_146295_m - this.achievementsPaneHeight) / 2;
        i1 -= 30;
        RAClass raClass = RARpgManager.getRAClass(this.rpgData.getClassId());
        LinkedHashMap<String, ArrayList> skillMap = new LinkedHashMap<String, ArrayList>();
        for (String skillId : raClass.skills) {
            Skill skill = RARpgManager.getSkill(skillId);
            String category = skill.categoryOverrides.getOrDefault(this.rpgData.getClassId(), skill.category);
            skillMap.computeIfAbsent(category, k -> new ArrayList()).add(skill);
        }
        int skillind = 0;
        int yInd = 0;
        this.categories.clear();
        this.skillIds.clear();
        for (String category : skillMap.keySet()) {
            this.categories.add(category);
            int xInd = 0;
            for (Skill skill : (ArrayList)skillMap.get(category)) {
                String text;
                int skillLevel = this.rpgData.getSkillLevel(skill.id);
                String string = text = skillLevel >= 10 || skillLevel <= 0 ? "" : levelText[skillLevel - 1];
                if (skillLevel >= skill.upgrades.size()) {
                    text = TextFormatting.GOLD + text;
                }
                this.field_146292_n.add(new GuiItemButton(skillind, i1 + 20 + xInd * 30, j1 + 30 + yInd * 32, "", text, skill));
                ++xInd;
                ++skillind;
                this.skillIds.add(skill.id);
            }
            ++yInd;
        }
        this.availableSkillPoints = RpgData.getRpgData((Entity)this.field_146297_k.field_71439_g).getAvailableSkillPoints();
        this.itemRender = this.field_146297_k.func_175599_af();
        this.level = new GuiButton(100, i1 + 265, j1 + 175, 115, 20, "Unlock");
        this.field_146292_n.add(this.level);
        this.reset = new GuiButton(101, i1 + this.guiWidth / 2 + 60, 0, 120, 20, "Reset Skill Levels");
        this.field_146292_n.add(this.reset);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int i1 = (this.field_146294_l - this.achievementsPaneWidth) / 2;
        int j1 = (this.field_146295_m - this.achievementsPaneHeight) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(skillTexture);
        this.func_73729_b(i1 -= 30, j1, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.field_146297_k.field_71466_p.func_78276_b("Skill Points: " + this.availableSkillPoints, i1 + 90, j1 + 5, 0xFFFFFF);
        for (int i = 0; i < this.categories.size(); ++i) {
            String categoryName = this.categories.get(i).equalsIgnoreCase("cavalry") && (this.rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId()) || this.rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_ARCHER.getId())) ? "Equestrian" : WordUtils.capitalize((String)this.categories.get(i).replace("_", " ")).replace("And", "&");
            this.field_146297_k.field_71466_p.func_78276_b(categoryName, i1 + 20, j1 + 20 + i * 32, 0xFFFFFF);
        }
        boolean bl = this.level.field_146125_m = this.selectedSkill > -1;
        if (this.selectedSkill > -1) {
            Skill skill = RARpgManager.getSkill(this.skillIds.get(this.selectedSkill));
            int skillLevel = this.rpgData.getSkillLevel(skill.id);
            this.field_146297_k.func_110434_K().func_110577_a(popupTexture);
            this.func_73729_b(i1 + 250, j1, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("ranger:textures/gui/skillicons/" + skill.id + ".png"));
            this.func_73729_b(i1 + 272, j1 + 23, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
            String name = WordUtils.capitalize((String)skill.id.replace("_", " "));
            this.field_146297_k.field_71466_p.func_78276_b(name, i1 + 255, j1 + 5, 0xFFFFFF);
            String lvlString = skillLevel + "/" + skill.upgrades.size();
            this.field_146297_k.field_71466_p.func_78276_b(lvlString, i1 + 390 - this.field_146289_q.func_78256_a(lvlString), j1 + 5, 0xFFFFFF);
            this.field_146297_k.field_71466_p.func_78279_b(skill.description, i1 + 275, j1 + 128, 100, -256);
            if (skillLevel < skill.upgrades.size()) {
                int cost = skill.upgrades.get((int)skillLevel).cost;
                this.level.field_146124_l = cost <= this.availableSkillPoints;
                TextFormatting color = this.level.field_146124_l ? TextFormatting.GREEN : TextFormatting.RED;
                String text = skillLevel == 0 ? "Unlock" : "Upgrade";
                this.level.field_146126_j = text + " (" + color + cost + TextFormatting.RESET + ")";
            } else {
                this.level.field_146124_l = false;
                this.level.field_146126_j = "Fully Upgraded";
            }
            boolean bl2 = false;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(par1, par2, par3);
        for (GuiButton button : this.field_146292_n) {
            button.func_146111_b(par1, par2);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.reset.field_146127_k) {
            Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketUseSkillPoint("reset"));
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Reset skill levels!"));
        }
        if (button.field_146127_k == this.level.field_146127_k) {
            int cost;
            String skillId = this.skillIds.get(this.selectedSkill);
            Skill skill = RARpgManager.getSkill(skillId);
            int level = this.rpgData.getSkillLevel(skillId);
            if (level - 1 < skill.upgrades.size() && this.availableSkillPoints >= (cost = skill.upgrades.get((int)level).cost)) {
                Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketUseSkillPoint(skillId));
                this.rpgData.setSkillLevel(skillId, this.rpgData.getSkillLevel(skillId) + 1);
                this.availableSkillPoints = this.rpgData.getAvailableSkillPoints();
                this.field_146297_k.field_71439_g.func_184185_a(RASounds.LEVEL_UP_SKILL, 1.0f, 1.0f);
            }
            this.field_146297_k.func_147108_a((GuiScreen)new GuiNewSkillMenu(this.rpgData, this.selectedSkill));
        } else {
            this.selectedSkill = button.field_146127_k;
        }
        super.func_146284_a(button);
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiItemButton
    extends GuiButton {
        private ItemStack itemStack;
        private String cornerText;
        private Skill skill;

        public GuiItemButton(int buttonId, int x, int y, String buttonText, String cornerText, Skill skill) {
            super(buttonId, x, y, 20, 20, buttonText);
            this.cornerText = cornerText;
            this.skill = skill;
            String itemId = skill.itemOverrides.getOrDefault(GuiNewSkillMenu.this.rpgData.getClassId(), skill.item);
            Item item = Item.func_111206_d((String)itemId);
            if (item == null) {
                item = Items.field_190931_a;
            }
            this.itemStack = new ItemStack(item, 1, skill.meta);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.field_73735_i = 0.0f;
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(iconButtonTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, this.field_146120_f, this.field_146121_g);
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
                GlStateManager.func_179123_a();
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179109_b((float)1.5f, (float)2.0f, (float)0.0f);
                GuiNewSkillMenu.this.itemRender.func_175042_a(this.itemStack, this.field_146128_h, this.field_146129_i);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179099_b();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
                this.func_73732_a(fontrenderer, this.cornerText, this.field_146128_h + this.field_146120_f - 4, this.field_146129_i + this.field_146121_g - 9, 0xA0A0A0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179123_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179121_F();
                GlStateManager.func_179099_b();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        public void func_146111_b(int mouseX, int mouseY) {
            super.func_146111_b(mouseX, mouseY);
            if (this.field_146123_n) {
                int diff;
                FontRenderer fontrenderer = GuiNewSkillMenu.this.field_146297_k.field_71466_p;
                int level = GuiNewSkillMenu.this.rpgData.getSkillLevel(this.skill.id);
                Skill.SkillUpgrade firstUpgrade = this.skill.upgrades.get(0);
                Skill.SkillUpgrade nextUpgrade = this.skill.getNextUpgrade(GuiNewSkillMenu.this.rpgData);
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(WordUtils.capitalize((String)this.skill.id.replace("_", " ")) + " " + this.cornerText);
                if (level < this.skill.upgrades.size() && (level > 0 || nextUpgrade.tooltip != null)) {
                    lines.add(TextFormatting.GRAY + "Next Upgrade:");
                }
                if (nextUpgrade.tooltip != null) {
                    lines.addAll(Arrays.asList(nextUpgrade.tooltip.split("\n")));
                }
                if (level > 0 && firstUpgrade.range > 0 && firstUpgrade.range != nextUpgrade.range) {
                    diff = nextUpgrade.range - firstUpgrade.range;
                    lines.add("+" + diff + " Range");
                }
                if (level > 0 && firstUpgrade.duration > 0) {
                    float diff2 = (float)nextUpgrade.duration / (float)firstUpgrade.duration;
                    float rounded = (float)Math.round(diff2 * 10.0f) / 10.0f;
                    String display = rounded == (float)((int)rounded) ? String.format("%d", (int)rounded) : String.format("%.1f", Float.valueOf(rounded));
                    lines.add("x" + display + " Duration");
                }
                if (this.skill.usable && level > 0 && firstUpgrade.cooldown > 0 && (diff = (int)(100.0f - (float)nextUpgrade.cooldown / (float)firstUpgrade.cooldown * 100.0f)) != 0) {
                    lines.add("-" + diff + "% Cooldown");
                }
                GuiUtils.drawHoveringText(lines, (int)mouseX, (int)mouseY, (int)GuiNewSkillMenu.this.guiWidth, (int)GuiNewSkillMenu.this.guiHeight, (int)300, (FontRenderer)fontrenderer);
            }
        }
    }
}

