/*
 * Decompiled with CFR 0.152.
 */
package ranger.gui;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import ranger.Ranger;
import ranger.items.RAItemLoader;
import ranger.packet.PacketUseSkillPoint;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class GuiSkillMenu
extends GuiScreen {
    private static final ResourceLocation skillTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillsgui.png");
    private static final ResourceLocation iconTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillicon.png");
    private static final ResourceLocation popupTexture = new ResourceLocation("ranger:textures/gui/skillicons/skillpopup.png");
    private int selectedSkill = -1;
    private RenderItem itemRender;
    private Item[] items;
    private String[] names;
    private String[][] descriptions;
    private int cid;
    private int race;
    private GuiButton level;
    private int availableSkillPoints = 0;
    protected int achievementsPaneWidth = 256;
    protected int achievementsPaneHeight = 202;

    public GuiSkillMenu(String classID) {
        RAClass raClass = RARpgManager.getRAClass(classID);
        this.names = new String[raClass.skills.size()];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = WordUtils.capitalize((String)raClass.skills.get(i).replaceAll("_", " "));
        }
        if (classID.equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
            this.race = 1;
            this.cid = 0;
            this.items = new Item[]{Items.field_151008_G, RAItemLoader.getItem("ranger_boots"), RAItemLoader.getItem("longbow"), RAItemLoader.getItem("ranger_hood"), Items.field_151032_g, RAItemLoader.getItem("throwing_knife"), RAItemLoader.getItem("recurve_bow"), Items.field_151172_bF, RAItemLoader.getItem("saxe"), Item.func_150898_a((Block)Blocks.field_150468_ap)};
            this.descriptions = new String[][]{{"Jump backwards", "", ""}, {"Faster speed and", "attack while active", ""}, {"Hold down right click", "to fire very rapid", "while active"}, {"Chance to remain", "undected in stealth", "while attacking"}, {"Arrows are", "stronger", ""}, {"Knives are", "stronger", ""}, {"Bow is pulled back", "quicker", ""}, {"Faster riding", "horses", ""}, {"Deals heavy damage", "from behind", ""}, {"Allows climbing up", "blocks", ""}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.ARALUEN_KNIGHT.getId())) {
            this.race = 1;
            this.cid = 1;
            this.items = new Item[]{RAItemLoader.getItem("araluen_shield"), RAItemLoader.getItem("short_sword"), RAItemLoader.getItem("long_sword"), RAItemLoader.getItem("broad_sword"), RAItemLoader.getItem("flag_of_command"), RAItemLoader.getItem("araluen_spear"), Items.field_151030_Z, Items.field_185159_cQ, Items.field_151056_x, Items.field_151153_ao};
            this.descriptions = new String[][]{{"Hit the enemy with", "your shield, doing", "damage & knockback"}, {"Charge Forward", "", ""}, {"Spin around with", "your sword, damaging", "nearby enemies"}, {"More damage", "", ""}, {"You can lead", "more troops", ""}, {"Spears", "do more damage", ""}, {"Take less damage", "", ""}, {"Strength + take less", "damage and knockback", "while active"}, {"Kills most", "enemies in", "one hit"}, {"Survive killing", "blow with temp", "boost in stats"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId())) {
            this.race = 2;
            this.cid = 0;
            this.items = new Item[]{RAItemLoader.getItem("skandian_shield"), RAItemLoader.getItem("skandian_axe"), Items.field_151013_M, RAItemLoader.getItem("saxe"), RAItemLoader.getItem("flag_of_command"), RAItemLoader.getItem("skandian_throwing_axe"), Items.field_151030_Z, Items.field_151153_ao, Items.field_151040_l, Items.field_151056_x};
            this.descriptions = new String[][]{{"Hit the enemy with", "your shield, doing", "damage "}, {"Strength increases", "and no damage", "while active"}, {"Every enemy", "nearby flies into", "the air"}, {"More damage", "", ""}, {"You can lead", "more troops", ""}, {"Throwing axes", "do more damage", ""}, {"You have a", "chance to lose", "less health"}, {"You have a", "chance to survive", "a killing blow"}, {"Charge forward", "", ""}, {"You have a", "chance to kill", "in one hit"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_ARCHER.getId())) {
            this.race = 3;
            this.cid = 0;
            this.items = new Item[]{Items.field_151008_G, RAItemLoader.getItem("temujai_saber"), RAItemLoader.getItem("longbow"), Items.field_151068_bn, Items.field_151032_g, RAItemLoader.getItem("tLance"), RAItemLoader.getItem("recurve_bow"), Items.field_151172_bF, RAItemLoader.getItem("temujai_archer_boots"), Items.field_151059_bz};
            this.descriptions = new String[][]{{"Jump backwards", "", ""}, {"Charge forward", "", ""}, {"One shot most", "enemies with bow", "while active"}, {"Extra Health", "", ""}, {"Arrows are", "stronger", ""}, {"Lance attacks faster", " and does more", "damage"}, {"Bow is pulled back", "quicker", ""}, {"Faster riding", "horses", ""}, {"Faster speed and", "attack while active", ""}, {"Arrows have chance to", "set fire to and explode", "hit enemies"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_WARRIOR.getId())) {
            this.race = 3;
            this.cid = 1;
            this.items = new Item[]{RAItemLoader.getItem("araluen_shield"), RAItemLoader.getItem("temujai_saber"), RAItemLoader.getItem("short_sword"), RAItemLoader.getItem("flag_of_command"), Items.field_151032_g, RAItemLoader.getItem("temujai_lance"), Items.field_151153_ao, Items.field_151172_bF, RAItemLoader.getItem("temujai_warrior_boots"), Items.field_151068_bn};
            this.descriptions = new String[][]{{"Hit the enemy with", "your shield, doing", "damage and knockback"}, {"Charge forward", "", ""}, {"Spin around with", "your sword, damaging", "nearby enemies"}, {"You can lead", "more troops", ""}, {"Spears", "do more damage", ""}, {"Lance attacks faster", " and does more", "damage"}, {"You have a", "chance to survive", "a killing blow"}, {"Faster riding", "horses", ""}, {"Faster speed and", "attack while active", ""}, {"Heal some health", "", ""}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId())) {
            this.race = 4;
            this.cid = 0;
            this.items = new Item[]{Items.field_151040_l, RAItemLoader.getItem("wargal_axe"), RAItemLoader.getItem("short_sword"), Items.field_151030_Z, RAItemLoader.getItem("wargal_spear"), Items.field_151068_bn, Items.field_151048_u, Items.field_151153_ao, Items.field_151081_bc, Items.field_151008_G};
            this.descriptions = new String[][]{{"Charge forward", "", ""}, {"Extra damage with", "hands while active", ""}, {"Call more wargals", "to your aid", ""}, {"You have a", "chance to lose", "less health"}, {"Spears are", "stronger", ""}, {"Extra Health", "", ""}, {"More Damage", "", ""}, {"You have a", "chance to survive", "a killing blow"}, {"Nearby enemies", "don't move for", "a short time"}, {"Faster speed", "and attack", "while active"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.SCOTTI_WARRIOR.getId())) {
            this.race = 5;
            this.cid = 0;
            this.items = new Item[]{Items.field_151008_G, RAItemLoader.getItem("scotti_boots"), Items.field_185157_bK, Items.field_151030_Z, Items.field_151153_ao, RAItemLoader.getItem("scotti_dirk"), RAItemLoader.getItem("scotti_sword"), RAItemLoader.getItem("flag_of_command"), Items.field_190929_cY, Items.field_151056_x};
            this.descriptions = new String[][]{{"Jump backwards", "", ""}, {"Faster speed and", "attack while active", ""}, {"Heals some health", "", ""}, {"You have a", "chance to lose", "less health"}, {"You have a", "chance to survive", "a killing blow"}, {"You charge forward", "", ""}, {"More Damage", "", ""}, {"You can lead", "more troops", ""}, {"More health", "", ""}, {"You have a", "chance to kill", "in one hit"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.SENSHI.getId())) {
            this.race = 6;
            this.cid = 0;
            this.items = new Item[]{Item.func_150898_a((Block)Blocks.field_150357_h), RAItemLoader.getItem("short_sword"), RAItemLoader.getItem("long_sword"), RAItemLoader.getItem("broad_sword"), RAItemLoader.getItem("flag_of_command"), RAItemLoader.getItem("araluen_spear"), Items.field_151030_Z, Items.field_151153_ao, RAItemLoader.getItem("senshi_katana"), Items.field_151056_x};
            this.descriptions = new String[][]{{"Hold your ground", "with heavy resistance", "effect"}, {"Charge Forward", "", ""}, {"Spin around with", "your sword, damaging", "nearby enemies"}, {"More damage", "", ""}, {"You can lead", "more troops", ""}, {"Spears", "do more damage", ""}, {"You have a", "chance to lose", "less health"}, {"You have a", "chance to survive", "a killing blow"}, {"Lightning attack", "speed", ""}, {"You have a", "chance to kill", "in one hit"}};
        } else if (classID.equalsIgnoreCase(RARpgManager.ClassId.CELTIC_MINER.getId())) {
            this.race = 7;
            this.cid = 0;
            this.items = new Item[]{RAItemLoader.getItem("celtic_iron_pickaxe"), Items.field_151005_D, Item.func_150898_a((Block)Blocks.field_150335_W), Items.field_151021_T, Items.field_151008_G, Item.func_150898_a((Block)Blocks.field_150339_S), Item.func_150898_a((Block)Blocks.field_150349_c), RAItemLoader.getItem("celtic_stone_pickaxe"), RAItemLoader.getItem("skandian_axe"), Item.func_150898_a((Block)Blocks.field_150468_ap)};
            this.descriptions = new String[][]{{"BROTHERS OF THE", "MINE REJOICE!", "Ally Haste&Resist"}, {"Dig very fast", "for a short time!", ""}, {"Blast a large", "area of rock!", ""}, {"Speed!", "", ""}, {"Jump back", "", ""}, {"Skin made of iron,", "steel in our bones", ""}, {"Less fall damage", "and knockback", ""}, {"Ores drop more!", "We can never", "dig too deep"}, {"Every enemy", "nearby flies into", "the air"}, {"Allows climbing up", "blocks", ""}};
        }
    }

    public void func_73866_w_() {
        this.availableSkillPoints = RpgData.getRpgData((Entity)this.field_146297_k.field_71439_g).getAvailableSkillPoints();
        this.itemRender = this.field_146297_k.func_175599_af();
        int i1 = (this.field_146294_l - this.achievementsPaneWidth) / 2;
        int j1 = (this.field_146295_m - this.achievementsPaneHeight) / 2;
        this.level = new GuiButton(0, i1 + 265, j1 + 175, 115, 20, "Level Up");
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i1 = (this.field_146294_l - this.achievementsPaneWidth) / 2;
        int j1 = (this.field_146295_m - this.achievementsPaneHeight) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(skillTexture);
        this.func_73729_b(i1, j1, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.field_146297_k.func_110434_K().func_110577_a(iconTexture);
        this.func_73729_b(i1 + 50, j1 + 30, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 110, j1 + 30, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 170, j1 + 30, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 29, j1 + 78, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 84, j1 + 78, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 139, j1 + 78, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 194, j1 + 78, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 50, j1 + 125, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 110, j1 + 125, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        this.func_73729_b(i1 + 170, j1 + 125, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        IRpgData rpgData = RpgData.getRpgData((Entity)this.field_146297_k.field_71439_g);
        this.field_146297_k.field_71466_p.func_78276_b("Skill Points: " + this.availableSkillPoints, i1 + 90, j1 + 180, 0xFFFFFF);
        if (this.selectedSkill > -1) {
            this.field_146297_k.func_110434_K().func_110577_a(popupTexture);
            this.func_73729_b(i1 + 250, j1, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("ranger:textures/gui/skillicons/skill_" + this.race + "/" + (this.cid + 1) + "/" + (this.selectedSkill + 1) + ".png"));
            this.func_73729_b(i1 + 272, j1 + 23, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
            String name = this.names[this.selectedSkill];
            String machine_name = name.toLowerCase().replace(" ", "_");
            this.field_146297_k.field_71466_p.func_78276_b(name, i1 + 255, j1 + 5, 0xFFFFFF);
            String lvlString = "Lv." + rpgData.getSkillLevel(machine_name);
            this.field_146297_k.field_71466_p.func_78276_b(lvlString, i1 + 390 - this.field_146289_q.func_78256_a(lvlString), j1 + 5, 0xFFFFFF);
            this.field_146292_n.clear();
            this.field_146292_n.add(this.level);
        } else if (!this.field_146292_n.isEmpty()) {
            this.field_146292_n.clear();
        }
        super.func_73863_a(par1, par2, par3);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            this.items[i] = Items.field_151127_ba;
        }
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        this.itemRender.func_180450_b(new ItemStack(this.items[0]), i1 + 58, j1 + 38);
        this.itemRender.func_180450_b(new ItemStack(this.items[1]), i1 + 118, j1 + 38);
        if (this.items[2] == Items.field_151013_M) {
            this.itemRender.func_180450_b(new ItemStack(Blocks.field_150346_d), i1 + 178, j1 + 38);
        } else {
            this.itemRender.func_180450_b(new ItemStack(this.items[2], 1, this.items[2] == Items.field_151068_bn ? 8197 : 0), i1 + 178, j1 + 38);
        }
        this.itemRender.func_180450_b(new ItemStack(this.items[3]), i1 + 37, j1 + 86);
        this.itemRender.func_180450_b(new ItemStack(this.items[4]), i1 + 92, j1 + 86);
        this.itemRender.func_180450_b(new ItemStack(this.items[5]), i1 + 147, j1 + 86);
        this.itemRender.func_180450_b(new ItemStack(this.items[6]), i1 + 202, j1 + 86);
        this.itemRender.func_180450_b(new ItemStack(this.items[7]), i1 + 58, j1 + 133);
        this.itemRender.func_180450_b(new ItemStack(this.items[8], 1, this.items[2] == Items.field_151068_bn ? 8193 : 0), i1 + 118, j1 + 133);
        this.itemRender.func_180450_b(new ItemStack(this.items[9]), i1 + 178, j1 + 133);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        if (this.selectedSkill > -1) {
            this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.BLUE + this.descriptions[this.selectedSkill][0], i1 + 275, j1 + 125, -256);
            this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.BLUE + this.descriptions[this.selectedSkill][1], i1 + 275, j1 + 135, -256);
            this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.BLUE + this.descriptions[this.selectedSkill][2], i1 + 275, j1 + 145, -256);
        }
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        IRpgData rpgData = RpgData.getRpgData((Entity)this.field_146297_k.field_71439_g);
        int i1 = (this.field_146294_l - this.achievementsPaneWidth) / 2;
        int j1 = (this.field_146295_m - this.achievementsPaneHeight) / 2;
        int x = i - i1;
        int y = j - j1;
        if (k == 0 || k == 1) {
            if (x > 50 && x < 81 && y > 30 && y < 61) {
                this.selectedSkill = 0;
            } else if (x > 110 && x < 141 && y > 30 && y < 61) {
                this.selectedSkill = 1;
            } else if (x > 170 && x < 201 && y > 30 && y < 61) {
                this.selectedSkill = 2;
            } else if (x > 29 && x < 60 && y > 78 && y < 109) {
                this.selectedSkill = 3;
            } else if (x > 84 && x < 115 && y > 78 && y < 109) {
                this.selectedSkill = 4;
            } else if (x > 139 && x < 170 && y > 78 && y < 109) {
                this.selectedSkill = 5;
            } else if (x > 194 && x < 225 && y > 78 && y < 109) {
                this.selectedSkill = 6;
            } else if (x > 50 && x < 81 && y > 125 && y < 156) {
                this.selectedSkill = 7;
            } else if (x > 110 && x < 141 && y > 125 && y < 156) {
                this.selectedSkill = 8;
            } else if (x > 170 && x < 201 && y > 125 && y < 156) {
                this.selectedSkill = 9;
            } else if (x > 263 && x < 380 && y > 175 && y < 195 && this.selectedSkill > -1) {
                if (this.level.field_146124_l && this.availableSkillPoints > 0) {
                    RAClass raClass = RARpgManager.getRAClass(rpgData.getClassId());
                    String skill = raClass.skills.get(this.selectedSkill);
                    if (rpgData.getSkillLevel(skill) < 10) {
                        Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketUseSkillPoint(skill));
                        rpgData.setSkillLevel(skill, rpgData.getSkillLevel(skill) + 1);
                        this.availableSkillPoints = rpgData.getAvailableSkillPoints();
                    }
                }
            } else {
                this.selectedSkill = -1;
            }
        }
    }
}

