/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ranger.items.IRAClassItem;
import ranger.items.RAItemLoader;
import ranger.render.ModelArridiHelm;
import ranger.render.ModelKilt;
import ranger.render.ModelRAHumanoid;
import ranger.render.ModelSkandianHelm;
import ranger.render.ModelTemujaiHelm;
import ranger.render.ModelWargal;
import ranger.rpg.RARpgManager;

public class ItemRAArmor
extends ItemArmor
implements IRAClassItem {
    String texture;
    boolean renderTight = true;
    boolean isSkin = false;
    boolean plotArmor = false;
    EnumRarity rarity = EnumRarity.COMMON;
    boolean isCaped = false;
    RARpgManager.ClassId[] raClassList = new RARpgManager.ClassId[0];
    @SideOnly(value=Side.CLIENT)
    public static ModelRAHumanoid armorModel = new ModelRAHumanoid(0.01f);
    @SideOnly(value=Side.CLIENT)
    public static ModelWargal wargalModel = new ModelWargal(0.0f);
    @SideOnly(value=Side.CLIENT)
    public static ModelSkandianHelm skandianHelm = new ModelSkandianHelm(0.01f);
    @SideOnly(value=Side.CLIENT)
    public static ModelArridiHelm arridiHelm = new ModelArridiHelm(1.0f);
    @SideOnly(value=Side.CLIENT)
    public static ModelTemujaiHelm temujaiHelm = new ModelTemujaiHelm(0.5f);
    @SideOnly(value=Side.CLIENT)
    public static ModelKilt kilt = new ModelKilt(0.01f);
    @SideOnly(value=Side.CLIENT)
    public static ModelBiped caped = new ModelBiped(0.1f);

    public ItemRAArmor(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn, String texture) {
        super(materialIn, 2, equipmentSlotIn);
        this.texture = texture;
        this.func_77637_a(RAItemLoader.RANGER_TAB);
        if (equipmentSlotIn == EntityEquipmentSlot.HEAD) {
            this.renderTight = false;
        }
    }

    public ItemRAArmor setIsSkin() {
        this.isSkin = true;
        return this;
    }

    public ItemRAArmor setClasses(RARpgManager.ClassId ... classes) {
        this.raClassList = classes;
        return this;
    }

    public ItemRAArmor setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    @Override
    public RARpgManager.ClassId[] getRAClassList() {
        return this.raClassList;
    }

    public ItemRAArmor setCaped() {
        this.isCaped = true;
        return this;
    }

    public boolean isCaped() {
        return this.isCaped;
    }

    public boolean isRightClass(ItemStack stack) {
        if (!stack.func_77942_o() || this.raClassList.length <= 0) {
            return true;
        }
        String raClass = stack.func_77978_p().func_74779_i("class");
        return this.isRightClass(stack, raClass);
    }

    public boolean isRightClass(ItemStack stack, String raClass) {
        for (int i = 0; i < this.raClassList.length; ++i) {
            if (!this.raClassList[i].getId().equals(raClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hardSteel() {
        return false;
    }

    public ItemRAArmor setRenderTight() {
        this.renderTight = true;
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "ranger:textures/model/armor/" + this.texture + ".png";
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (this.isSkin && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack s = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (s.func_77973_b() != this) continue;
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelRAHumanoid armorModel;
        if (this.isSkin) {
            ItemRAArmor.wargalModel.field_78116_c.field_78806_j = true;
            ItemRAArmor.wargalModel.field_178720_f.field_78806_j = true;
            ItemRAArmor.wargalModel.field_78115_e.field_78806_j = true;
            ItemRAArmor.wargalModel.field_178723_h.field_78806_j = true;
            ItemRAArmor.wargalModel.field_178724_i.field_78806_j = true;
            ItemRAArmor.wargalModel.field_178721_j.field_78806_j = true;
            ItemRAArmor.wargalModel.field_178722_k.field_78806_j = true;
            return wargalModel;
        }
        if (!this.renderTight) {
            if (this == RAItemLoader.getItem("arridi_helmet")) {
                return arridiHelm;
            }
            if (this == RAItemLoader.getItem("temujai_warrior_helm") || this == RAItemLoader.getItem("temujai_captain_helm")) {
                return temujaiHelm;
            }
            return _default;
        }
        boolean scotti = this.getRegistryName().func_110623_a().contains("scotti");
        ModelRAHumanoid modelRAHumanoid = this == RAItemLoader.getItem("skandian_helm") ? skandianHelm : (armorModel = this.isCaped && !scotti ? caped : ItemRAArmor.armorModel);
        if (scotti && this.getRegistryName().func_110623_a().contains("pants")) {
            armorModel = kilt;
        }
        armorModel.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
        armorModel.field_178720_f.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
        armorModel.field_78115_e.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.LEGS;
        armorModel.field_178723_h.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.LEGS;
        armorModel.field_178724_i.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.LEGS;
        armorModel.field_178721_j.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
        armorModel.field_178722_k.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
        armorModel.field_78117_n = entityLiving.func_70093_af();
        armorModel.field_78093_q = entityLiving.func_184218_aH();
        armorModel.field_78091_s = entityLiving.func_70631_g_();
        return armorModel;
    }

    public ItemRAArmor setPlotArmor() {
        this.plotArmor = true;
        return this;
    }

    public boolean isPlotArmor() {
        return this.plotArmor;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77948_v() ? EnumRarity.RARE : this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.plotArmor) {
            tooltip.add(TextFormatting.GOLD + "Plot Armor");
        }
    }
}

