/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityRABase;
import ranger.items.ItemFlamingArrow;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;

public class ItemRABow
extends ItemBow {
    float draw_speed = 1.0f;
    float velocity_multiplier = 1.0f;
    RARpgManager.ClassId[] raClassList = new RARpgManager.ClassId[0];

    public ItemRABow(float draw_speed, float velocity_multiplier) {
        this.func_77637_a(RAItemLoader.RANGER_TAB);
        this.draw_speed = draw_speed;
        this.velocity_multiplier = velocity_multiplier;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("drawSpeed")) {
                    float multiplier = stack.func_77978_p().func_74760_g("drawSpeed");
                    if ((float)(stack.func_77988_m() - entityIn.func_184605_cv()) >= 40.0f * multiplier && entityIn instanceof EntityPlayer) {
                        IRpgData rpgData = RpgData.getRpgData((Entity)entityIn);
                        Skill.SkillUpgrade msUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.MULTI_SHOT.getId()).getCurrentUpgrade(rpgData);
                        if (msUpgrade != null) {
                            return 100.0f;
                        }
                    }
                    return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (20.0f * multiplier);
                }
                return 0.0f;
            }
        });
    }

    public ItemRABow setClasses(RARpgManager.ClassId ... classes) {
        this.raClassList = classes;
        return this;
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int time = this.func_77626_a(stack) - timeLeft;
            if ((time = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)time, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                float f = ItemRABow.getArrowVelocity(stack, time);
                if ((double)(f *= this.velocity_multiplier) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        Skill.SkillUpgrade vUpgrade;
                        this.shootArrow(worldIn, stack, itemstack, entityplayer, f, flag1, 1.0f);
                        IRpgData rpgData = RpgData.getRpgData((Entity)entityplayer);
                        Skill.SkillUpgrade msUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.MULTI_SHOT.getId()).getCurrentUpgrade(rpgData);
                        float multiplier = stack.func_77978_p().func_74760_g("drawSpeed");
                        if (msUpgrade != null && (float)time >= 40.0f * multiplier) {
                            int i2 = 0;
                            while ((float)i2 < msUpgrade.value) {
                                this.shootArrow(worldIn, stack, itemstack, entityplayer, f, true, 5.0f);
                                ++i2;
                            }
                        }
                        if (entityplayer.func_70644_a(EffectRegistry.ARROW_STORM)) {
                            int count = (entityplayer.func_70660_b(EffectRegistry.ARROW_STORM).func_76458_c() + 2) * 2;
                            for (int i2 = 0; i2 < count; ++i2) {
                                this.shootArrow(worldIn, stack, itemstack, entityplayer, f, true, 5.0f);
                            }
                        }
                        NBTTagCompound compound = stack.func_77978_p();
                        if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d && stack.func_77978_p().func_74762_e("volley") <= 0) {
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                entityplayer.field_71071_by.func_184437_d(itemstack);
                            }
                        }
                        if (compound.func_74762_e("volley") > 0) {
                            compound.func_74768_a("volley", compound.func_74762_e("volley") - 1);
                            compound.func_74768_a("delay", 3);
                        } else if (entityplayer.func_70644_a(EffectRegistry.VOLLEY) && (vUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.VOLLEY.getId()).getCurrentUpgrade(rpgData)) != null) {
                            compound.func_74768_a("volley", (int)vUpgrade.value);
                            compound.func_74768_a("delay", 3);
                        }
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    private void shootArrow(World worldIn, ItemStack stack, ItemStack ammoStack, EntityPlayer entityplayer, float f, boolean flag1, float inaccuracy) {
        IRpgData rpgData = RpgData.getRpgData((Entity)entityplayer);
        ItemArrow itemarrow = (ItemArrow)(ammoStack.func_77973_b() instanceof ItemArrow ? ammoStack.func_77973_b() : Items.field_151032_g);
        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, ammoStack, (EntityLivingBase)entityplayer);
        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, inaccuracy);
        if (f >= 1.0f) {
            entityarrow.func_70243_d(true);
        }
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this == RAItemLoader.getItem("longbow") || this == RAItemLoader.getItem("ranger_longbow")) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + 2.0);
        }
        Skill.SkillUpgrade pdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.POWER_DRAW.getId()).getCurrentUpgrade(rpgData);
        double damage = entityarrow.func_70242_d();
        if (pdUpgrade != null) {
            damage += (double)pdUpgrade.value;
        }
        entityarrow.func_70239_b(damage);
        if (entityplayer.func_70644_a(EffectRegistry.FATAL_SHOT)) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() * 5.0);
        }
        int flameSkillLevel = rpgData.getSkillLevel(RARpgManager.SkillId.FLAMING_ARROWS.getId());
        if (itemarrow instanceof ItemFlamingArrow || flameSkillLevel > 0 && field_77697_d.nextInt(11 - flameSkillLevel) == 0) {
            entityarrow.func_70015_d(100);
        }
        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
        if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        worldIn.func_72838_d((Entity)entityarrow);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70644_a(EffectRegistry.RAPID_FIRE)) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            if (!worldIn.field_72995_K) {
                this.func_77615_a(itemstack, worldIn, (EntityLivingBase)playerIn, 0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static float getArrowVelocity(ItemStack stack, int charge) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("drawSpeed")) {
            return 0.0f;
        }
        float multiplier = stack.func_77978_p().func_74760_g("drawSpeed");
        float f = (float)charge / (20.0f * multiplier);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && (entityIn instanceof EntityPlayer || entityIn instanceof EntityRABase)) {
            Skill.SkillUpgrade qdUpgrade;
            float drawSpeed;
            NBTTagCompound compound;
            if (!stack.func_77942_o()) {
                compound = new NBTTagCompound();
                compound.func_74778_a("class", "");
                compound.func_74776_a("drawSpeed", 1.0f);
                compound.func_74768_a("volley", 0);
                stack.func_77982_d(compound);
            } else {
                compound = stack.func_77978_p();
            }
            IRpgData data = RpgData.getRpgData(entityIn);
            if (!compound.func_74779_i("class").equals(data.getClassId())) {
                compound.func_74778_a("class", data.getClassId());
            }
            float f = drawSpeed = (qdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.QUICK_DRAW.getId()).getCurrentUpgrade(data)) != null ? qdUpgrade.value : 1.0f;
            if (compound.func_74760_g("drawSpeed") != drawSpeed) {
                compound.func_74776_a("drawSpeed", drawSpeed);
            }
            if (!worldIn.field_72995_K) {
                if (compound.func_74762_e("volley") > 0 && compound.func_74762_e("delay") <= 0) {
                    this.func_77615_a(stack, worldIn, (EntityLivingBase)entityIn, 0);
                }
                if (compound.func_74762_e("delay") > 0) {
                    stack.func_77978_p().func_74768_a("delay", stack.func_77978_p().func_74762_e("delay") - 1);
                }
            }
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("volley") > 0) {
            stack.func_77978_p().func_74768_a("volley", 0);
        }
    }

    public int func_77626_a(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77626_a(stack);
        }
        float multiplier = stack.func_77978_p().func_74760_g("drawSpeed");
        return (int)(72000.0f * multiplier);
    }
}

