/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityRABase;
import ranger.items.ItemFlamingArrow;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class ItemRACrossbow
extends Item {
    float draw_speed = 1.0f;
    float velocity_multiplier = 1.0f;
    RARpgManager.ClassId[] raClassList = new RARpgManager.ClassId[0];

    public ItemRACrossbow(float draw_speed, float velocity_multiplier) {
        this.field_77777_bU = 1;
        this.func_77656_e(384);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_185043_a(new ResourceLocation("charged"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("charged") ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_77637_a(RAItemLoader.RANGER_TAB);
        this.draw_speed = draw_speed;
        this.velocity_multiplier = velocity_multiplier;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("drawLevel")) {
                    float multiplier = 1.0f - 0.05f * (float)stack.func_77978_p().func_74762_e("drawLevel");
                    return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (20.0f * multiplier);
                }
                return 0.0f;
            }
        });
    }

    public ItemRACrossbow setClasses(RARpgManager.ClassId ... classes) {
        this.raClassList = classes;
        return this;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        stack.func_77978_p().func_74757_a("pulling", false);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void shoot(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(entityplayer);
            int i = this.func_77626_a(stack);
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                float f = ItemRACrossbow.getArrowVelocity(stack, i);
                if ((double)(f *= this.velocity_multiplier) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (f >= 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        if (this == RAItemLoader.getItem("longbow")) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + 2.0);
                        }
                        IRpgData rpgData = RpgData.getRpgData((Entity)entityplayer);
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)rpgData.getSkillLevel(RARpgManager.SkillId.POWER_DRAW.getId()));
                        int flameSkillLevel = rpgData.getSkillLevel(RARpgManager.SkillId.FLAMING_ARROWS.getId());
                        if (itemarrow instanceof ItemFlamingArrow || flameSkillLevel > 0 && field_77697_d.nextInt(11 - flameSkillLevel) == 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                        if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            entityplayer.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean pulling = itemstack.func_77978_p().func_74767_n("pulling");
        if (pulling && this.isCharged(itemstack)) {
            playerIn.func_184598_c(handIn);
            itemstack.func_77978_p().func_74757_a("pulling", true);
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (playerIn.func_70644_a(EffectRegistry.RAPID_FIRE) || this.isCharged(itemstack)) {
            itemstack.func_77978_p().func_74757_a("charged", false);
            if (!worldIn.field_72995_K) {
                this.shoot(itemstack, worldIn, (EntityLivingBase)playerIn, 0);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (this.isCharged(itemstack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        boolean flag = !this.findAmmo(playerIn).func_190926_b();
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        itemstack.func_77978_p().func_74757_a("pulling", true);
        if (pulling) {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean isCharged(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("charged");
    }

    public static float getArrowVelocity(ItemStack stack, int charge) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("drawLevel")) {
            return 0.0f;
        }
        float multiplier = 1.0f - 0.05f * (float)stack.func_77978_p().func_74762_e("drawLevel");
        float f = (float)charge / (20.0f * multiplier);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && (entityIn instanceof EntityPlayer || entityIn instanceof EntityRABase)) {
            NBTTagCompound compound;
            EntityLivingBase living = (EntityLivingBase)entityIn;
            if (!stack.func_77942_o()) {
                compound = new NBTTagCompound();
                compound.func_74778_a("class", "");
                compound.func_74768_a("drawLevel", 0);
                compound.func_74757_a("charged", false);
                compound.func_74757_a("pulling", false);
                stack.func_77982_d(compound);
            } else {
                compound = stack.func_77978_p();
            }
            IRpgData data = RpgData.getRpgData(entityIn);
            if (!compound.func_74779_i("class").equals(data.getClassId())) {
                compound.func_74778_a("class", data.getClassId());
            }
            int drawLevel = stack.func_77978_p().func_74762_e("drawLevel");
            if (living.func_184605_cv() > 0 && stack.func_77988_m() - living.func_184605_cv() > 25 - drawLevel) {
                stack.func_77978_p().func_74757_a("charged", true);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77626_a(stack);
        }
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.isCharged(stack) && stack.func_77978_p().func_74767_n("pulling")) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }
}

