/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ranger.entities.EntityRABase;
import ranger.items.IRAClassItem;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class ItemRASword
extends ItemSword
implements IRAClassItem {
    public int craftStickCount = 1;
    public int craftIronCount = 3;
    RARpgManager.ClassId[] raClassList = new RARpgManager.ClassId[0];
    float field_150934_a;
    float attackSpeed;
    boolean hardSteel = false;
    public int extraReach = 0;
    EnumRarity rarity = EnumRarity.COMMON;

    public ItemRASword(Item.ToolMaterial material, float damage, float attackSpeed) {
        super(material);
        this.attackSpeed = attackSpeed;
        this.field_150934_a = damage;
        this.func_77637_a(RAItemLoader.RANGER_TAB);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemRASword setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemRASword setCraftStickCount(int count) {
        this.craftStickCount = count;
        return this;
    }

    public ItemRASword setCraftIronCount(int count) {
        this.craftIronCount = count;
        return this;
    }

    public ItemRASword setHardSteel() {
        this.hardSteel = true;
        return this;
    }

    public ItemRASword setExtraReach(int count) {
        this.extraReach = count;
        return this;
    }

    @Override
    public RARpgManager.ClassId[] getRAClassList() {
        return this.raClassList;
    }

    @Override
    public boolean hardSteel() {
        return this.hardSteel;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77948_v() ? EnumRarity.RARE : this.rarity;
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (this.func_77658_a().contains("morgarath")) {
            return TextFormatting.DARK_RED + name;
        }
        return name;
    }

    public ItemRASword setClasses(RARpgManager.ClassId ... classes) {
        this.raClassList = classes;
        return this;
    }

    public int getProgression(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return Math.min(stack.func_77978_p().func_74764_b("progression") ? stack.func_77978_p().func_74762_e("progression") : 0, 1000);
    }

    public float func_150931_i() {
        return this.field_150934_a;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_184592_cb().func_190926_b()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        float progress = playerIn.func_184825_o(0.5f);
        if (progress < 1.0f) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && (entityIn instanceof EntityPlayer || entityIn instanceof EntityRABase)) {
            NBTTagCompound compound;
            if (!stack.func_77942_o()) {
                compound = new NBTTagCompound();
                compound.func_74778_a("class", "");
                compound.func_74768_a("progression", 0);
                stack.func_77982_d(compound);
            } else {
                compound = stack.func_77978_p();
            }
            IRpgData data = RpgData.getRpgData(entityIn);
            int progression = data.getWeaponProgression(this.getRegistryName().func_110623_a());
            if (!compound.func_74779_i("class").equals(data.getClassId())) {
                compound.func_74778_a("class", data.getClassId());
            }
            if (!compound.func_74764_b("progression") || compound.func_74762_e("progression") != progression) {
                compound.func_74768_a("progression", progression);
            }
        }
    }

    public boolean isRightClass(ItemStack stack) {
        if (!stack.func_77942_o() || this.raClassList.length <= 0) {
            return true;
        }
        String raClass = stack.func_77978_p().func_74779_i("class");
        for (int i = 0; i < this.raClassList.length; ++i) {
            if (!this.raClassList[i].getId().equals(raClass)) continue;
            return true;
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            float attackSpeed = this.attackSpeed;
            if (!this.isRightClass(stack)) {
                attackSpeed -= 1.0f;
            }
            if (attackSpeed <= -4.0f) {
                attackSpeed = -3.9f;
            }
            if (!this.isRightClass(stack)) {
                int progression = this.getProgression(stack);
                float progMod = (float)progression / 1000.0f;
                attackSpeed += progMod;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(this.field_150934_a - 1.0f), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeed, 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null || stack.func_77978_p() == null) {
            return;
        }
        if (this.raClassList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.raClassList.length; ++i) {
                sb.append(RARpgManager.classMap.get((Object)this.raClassList[i].getId()).name);
                if (i + 1 >= this.raClassList.length) continue;
                sb.append(", ");
            }
            tooltip.add("For: " + sb.toString());
        }
        if (!this.isRightClass(stack)) {
            int progression = this.getProgression(stack);
            float progMod = (float)progression / 1000.0f;
            tooltip.add(TextFormatting.RED + "Wrong class penalty! -" + Math.ceil((1.0f - progMod) * 10.0f) / 10.0 + " Attack Speed");
        }
        if (this.extraReach > 0) {
            tooltip.add("+" + this.extraReach + " Reach");
        }
    }
}

