/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityWargal;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataProvider;

public class ItemSpawnClass
extends ItemMonsterPlacer {
    public String nationID;
    public String classID;
    public boolean leader;

    public ItemSpawnClass(String nationID, String classID) {
        this(nationID, classID, false);
    }

    public ItemSpawnClass(String nationID, String classID, boolean leader) {
        this.func_77637_a(RAItemLoader.RANGER_TAB);
        this.nationID = nationID;
        this.classID = classID;
        this.leader = leader;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150474_ac && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            EntityRAHumanoid dummy;
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_98270_a(new NBTTagCompound());
            tileentity.func_70296_d();
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            NBTTagCompound spawnData = new NBTTagCompound();
            if (this.classID.equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId())) {
                dummy = new EntityWargal(worldIn);
                spawnData.func_74778_a("id", "ranger:wargal");
            } else {
                dummy = new EntityRAStandard(worldIn);
                spawnData.func_74778_a("id", "ranger:ra_humanoid");
            }
            dummy.setLeader(false);
            IRpgData rpgData = RpgData.getRpgData((Entity)dummy);
            rpgData.setNation(this.nationID);
            rpgData.setClassId(this.classID);
            dummy.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)dummy)), null);
            dummy.func_70014_b(spawnData);
            NBTTagCompound capData = new NBTTagCompound();
            capData.func_74782_a("ranger:rpg_data", RpgDataProvider.RPG_DATA.writeNBT((Object)rpgData, null));
            spawnData.func_74782_a("ForgeCaps", (NBTBase)capData);
            mobspawnerbaselogic.func_184993_a(new WeightedSpawnerEntity(1, spawnData));
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.func_190909_a(worldIn, blockpos);
        Entity entity = this.spawnCreature(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                entity.func_96094_a(itemstack.func_82833_r());
            }
            ItemSpawnClass.func_185079_a((World)worldIn, (EntityPlayer)player, (ItemStack)itemstack, (Entity)entity);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public Entity spawnCreature(World worldIn, double x, double y, double z) {
        EntityRAHumanoid entity = this.classID.equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId()) ? new EntityWargal(worldIn) : new EntityRAStandard(worldIn);
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_110163_bv();
        IRpgData rpgData = RpgData.getRpgData((Entity)entity);
        rpgData.setNation(this.nationID);
        rpgData.setClassId(this.classID);
        entity.setLeader(this.leader);
        entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        worldIn.func_72838_d((Entity)entity);
        entity.func_70642_aH();
        return entity;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
        }
    }
}

