/*
 * Decompiled with CFR 0.152.
 */
package ranger.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ranger.entities.EntityRABase;
import ranger.items.IRAClassItem;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class ItemWeapon
extends ItemTool
implements IRAClassItem {
    public int craftStickCount = 1;
    public int craftIronCount = 3;
    public float extraReach = 0.0f;
    RARpgManager.ClassId[] raClassList = new RARpgManager.ClassId[0];
    float field_77865_bY;
    float field_185065_c;
    boolean hardSteel = false;
    EnumRarity rarity = EnumRarity.COMMON;
    public boolean isAxe = false;
    public boolean polearm = false;
    public boolean isPike = false;
    public boolean pullOffHorse = false;
    public float thrustDist = 5.0f;
    protected static final UUID REACH_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA4");

    public ItemWeapon(Item.ToolMaterial material, float damage, float attackSpeed) {
        super(material, new HashSet());
        this.field_185065_c = attackSpeed;
        this.field_77865_bY = damage;
        this.func_77637_a(RAItemLoader.RANGER_TAB);
    }

    public ItemWeapon setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemWeapon setCraftStickCount(int count) {
        this.craftStickCount = count;
        return this;
    }

    public ItemWeapon setCraftIronCount(int count) {
        this.craftIronCount = count;
        return this;
    }

    public ItemWeapon setAxe() {
        this.isAxe = true;
        return this;
    }

    public ItemWeapon setHardSteel() {
        this.hardSteel = true;
        return this;
    }

    public ItemWeapon setExtraReach(float extraReach) {
        this.extraReach = extraReach;
        return this;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this.isAxe;
    }

    @Override
    public RARpgManager.ClassId[] getRAClassList() {
        return this.raClassList;
    }

    @Override
    public boolean hardSteel() {
        return this.hardSteel;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77948_v() ? EnumRarity.RARE : this.rarity;
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (this.func_77658_a().contains("morgarath")) {
            return TextFormatting.DARK_RED + name;
        }
        return name;
    }

    public float getAttackDamage() {
        return this.field_77865_bY;
    }

    public ItemWeapon setClasses(RARpgManager.ClassId ... classes) {
        this.raClassList = classes;
        return this;
    }

    public ItemWeapon setPolearm(float distance) {
        return this.setPolearm(distance, false);
    }

    public ItemWeapon setPolearm(float distance, boolean isPike) {
        this.polearm = true;
        this.thrustDist = distance;
        this.isPike = isPike;
        return this;
    }

    public ItemWeapon setPullsOffHorse() {
        this.pullOffHorse = true;
        return this;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && target.func_184187_bx() instanceof EntityHorse && this.pullOffHorse) {
            target.func_184187_bx().func_184226_ay();
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && (entityIn instanceof EntityPlayer || entityIn instanceof EntityRABase)) {
            NBTTagCompound compound;
            if (!stack.func_77942_o()) {
                compound = new NBTTagCompound();
                compound.func_74778_a("class", "");
                compound.func_74768_a("progression", 0);
                stack.func_77982_d(compound);
            } else {
                compound = stack.func_77978_p();
            }
            IRpgData data = RpgData.getRpgData(entityIn);
            int progression = data.getWeaponProgression(this.getRegistryName().func_110623_a());
            if (compound.func_74764_b("class") && !compound.func_74779_i("class").equals(data.getClassId())) {
                compound.func_74778_a("class", data.getClassId());
            }
            if (!compound.func_74764_b("progression") || compound.func_74762_e("progression") != progression) {
                compound.func_74768_a("progression", progression);
            }
        }
    }

    public boolean isRightClass(ItemStack stack) {
        if (!stack.func_77942_o() || this.raClassList.length <= 0) {
            return true;
        }
        String raClass = stack.func_77978_p().func_74779_i("class");
        for (int i = 0; i < this.raClassList.length; ++i) {
            if (!this.raClassList[i].getId().equals(raClass)) continue;
            return true;
        }
        return false;
    }

    public int getProgression(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return Math.min(stack.func_77978_p().func_74764_b("progression") ? stack.func_77978_p().func_74762_e("progression") : 0, 1000);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            float damage = this.field_77865_bY - 1.0f;
            float attackSpeed = this.field_185065_c;
            if (!this.isRightClass(stack)) {
                attackSpeed -= 1.0f;
            }
            if (attackSpeed <= -4.0f) {
                attackSpeed = -3.9f;
            }
            if (!this.isRightClass(stack)) {
                int progression = this.getProgression(stack);
                float progMod = (float)progression / 1000.0f;
                attackSpeed += progMod;
            }
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeed, 0));
            if (this.polearm && !this.isAxe && this.thrustDist <= 5.0f) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(damage / 2.0f), 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)damage, 0));
            }
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null || stack.func_77978_p() == null) {
            return;
        }
        if (this.raClassList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.raClassList.length; ++i) {
                sb.append(RARpgManager.classMap.get((Object)this.raClassList[i].getId()).name);
                if (i + 1 >= this.raClassList.length) continue;
                sb.append(", ");
            }
            tooltip.add("For: " + sb.toString());
        }
        if (!this.isRightClass(stack)) {
            int progression = this.getProgression(stack);
            float progMod = (float)progression / 1000.0f;
            tooltip.add(TextFormatting.RED + "Wrong class penalty! -" + Math.ceil((1.0f - progMod) * 10.0f) / 10.0 + " Attack Speed");
        }
        if (this.isPike) {
            tooltip.add(TextFormatting.YELLOW + "x5 Damage against Cavalry");
        } else if (!this.isAxe && this.polearm && this.thrustDist > 5.0f) {
            tooltip.add(TextFormatting.YELLOW + "Must be used on horseback");
        }
        if (this.extraReach > 0.0f) {
            tooltip.add("+" + this.extraReach + " Reach");
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!this.polearm || playerIn.func_184592_cb().func_77973_b() instanceof ItemShield) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.polearm ? EnumAction.NONE : super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return super.func_77626_a(stack);
    }
}

