/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class PacketAction
implements IMessage {
    public static final int PACKET_USE_SKILL = 0;
    int type;

    public PacketAction() {
    }

    public PacketAction(int type) {
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
    }

    public static class Handler
    implements IMessageHandler<PacketAction, IMessage> {
        public IMessage onMessage(PacketAction message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.readMessage(message, player));
            return null;
        }

        private static void readMessage(PacketAction message, EntityPlayerMP player) {
            IRpgData data = RpgData.getRpgData((Entity)player);
            switch (message.type) {
                case 0: {
                    RAClass raClass = RARpgManager.getRAClass(data.getClassId());
                    String skill = raClass.skills.get(data.getSelectedSkill());
                    if (data.getSkillCooldown(skill) > 5) break;
                    RARpgManager.useSkillNew(data, skill);
                    break;
                }
            }
        }
    }
}

