/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.entities.EntityRAHumanoid;
import ranger.items.ItemCommandFlag;
import ranger.items.RAItemLoader;

public class PacketCommandHired
implements IMessage {
    private int squad;
    private int action;
    private float posX;
    private float posY;
    private float posZ;

    public PacketCommandHired() {
    }

    public PacketCommandHired(int squad, int action, float posX, float posY, float posZ) {
        this.squad = squad;
        this.action = action;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.squad);
        buf.writeInt(this.action);
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.squad = buf.readInt();
        this.action = buf.readInt();
        this.posX = buf.readFloat();
        this.posY = buf.readFloat();
        this.posZ = buf.readFloat();
    }

    public static class Handler
    implements IMessageHandler<PacketCommandHired, IMessage> {
        public IMessage onMessage(PacketCommandHired message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.lambda$onMessage$0((EntityPlayer)player, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, PacketCommandHired message) {
            if (player.func_184592_cb().func_77973_b() == RAItemLoader.getItem("flag_of_command")) {
                ((ItemCommandFlag)player.func_184592_cb().func_77973_b()).setSquad(player.func_184592_cb(), message.squad);
            } else if (player.func_184614_ca().func_77973_b() == RAItemLoader.getItem("flag_of_command")) {
                ((ItemCommandFlag)player.func_184614_ca().func_77973_b()).setSquad(player.func_184614_ca(), message.squad);
            }
            if (message.action < 0) {
                return;
            }
            List entityList = player.field_70170_p.func_72910_y();
            try {
                ArrayList<EntityRAHumanoid> entitiesToCommand = new ArrayList<EntityRAHumanoid>();
                for (Entity entity : entityList) {
                    EntityRAHumanoid defender;
                    if (!(entity instanceof EntityRAHumanoid) || (defender = (EntityRAHumanoid)entity).isCorpse() || message.squad != 0 && defender.getSquad() != message.squad || !defender.func_152114_e((EntityLivingBase)player)) continue;
                    entitiesToCommand.add((EntityRAHumanoid)entity);
                }
                BlockPos blockPos = new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ);
                EnumFacing facing = EnumFacing.func_176733_a((double)player.field_70177_z).func_176746_e();
                blockPos = blockPos.func_177967_a(facing.func_176734_d(), entitiesToCommand.size() / 2);
                for (EntityRAHumanoid defender : entitiesToCommand) {
                    if (message.squad != 0 && defender.getSquad() != message.squad || !defender.func_152114_e((EntityLivingBase)player)) continue;
                    defender.setAction(message.action);
                    if (defender.getAction() == 3 || defender.getAction() == 2) continue;
                    if (defender.func_70011_f(message.posX, message.posY, message.posZ) > 50.0) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "That position is too far for " + defender.func_70005_c_()));
                        continue;
                    }
                    blockPos = blockPos.func_177967_a(facing, 1);
                    defender.setDefendPosX(Float.valueOf(blockPos.func_177958_n()));
                    defender.setDefendPosY(Float.valueOf(blockPos.func_177956_o()));
                    defender.setDefendPosZ(Float.valueOf(blockPos.func_177952_p()));
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }
}

