/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.util.RACrafting;
import ranger.util.RARecipe;

public class PacketCraft
implements IMessage {
    private int recipeIndex;
    private String classId;

    public PacketCraft() {
    }

    public PacketCraft(int recipeIndex, String classId) {
        this.recipeIndex = recipeIndex;
        this.classId = classId;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipeIndex = buf.readInt();
        this.classId = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipeIndex);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.classId);
    }

    public static class Handler
    implements IMessageHandler<PacketCraft, IMessage> {
        public IMessage onMessage(PacketCraft message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.readMessage(message, player));
            return null;
        }

        private static void readMessage(PacketCraft message, EntityPlayerMP player) {
            if (message.recipeIndex < 0 || message.recipeIndex >= RACrafting.getRecipesFor(message.classId).size()) {
                return;
            }
            RARecipe recipe = RACrafting.getRecipesFor(message.classId).get(message.recipeIndex);
            if (!player.field_70170_p.field_72995_K) {
                if (!player.field_71071_by.func_70441_a(recipe.getCrafted().func_77946_l())) {
                    player.func_70099_a(recipe.getCrafted().func_77946_l(), 0.0f);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    for (int i = 0; i < recipe.getRequirements().length; ++i) {
                        for (int a = 0; a < recipe.getRequirements()[i].func_190916_E(); ++a) {
                            ItemStack stack;
                            player.field_71071_by.func_174925_a(recipe.getRequirements()[i].func_77973_b(), -1, 1, null);
                            if (recipe.getRequirements()[i].func_77973_b() != Items.field_151117_aB || player.field_71071_by.func_70441_a(stack = new ItemStack(Items.field_151133_ar))) continue;
                            player.func_70099_a(stack, 0.0f);
                        }
                    }
                }
            }
        }
    }
}

