/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.items.ItemRASword;
import ranger.items.ItemWeapon;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataProvider;
import ranger.rpg.Skill;

public class PacketSetInt
implements IMessage {
    public static final int PACKET_SKILL = 0;
    public static final int PACKET_SPIN_ATTACK = 1;
    int type;
    int value;

    public PacketSetInt() {
    }

    public PacketSetInt(int type, int value) {
        this.type = type;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.value);
    }

    public static class Handler
    implements IMessageHandler<PacketSetInt, IMessage> {
        public IMessage onMessage(PacketSetInt message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.readMessage(message, player));
            return null;
        }

        private static void readMessage(PacketSetInt message, EntityPlayerMP player) {
            IRpgData data = RpgData.getRpgData((Entity)player);
            switch (message.type) {
                case 0: {
                    data.setSelectedSkill(message.value);
                    break;
                }
                case 1: {
                    player.field_70177_z = message.value;
                    float radius = 4.0f;
                    if (player.func_184614_ca().func_77973_b() instanceof ItemWeapon) {
                        radius += ((ItemWeapon)player.func_184614_ca().func_77973_b()).extraReach;
                    } else if (player.func_184614_ca().func_77973_b() instanceof ItemRASword) {
                        radius += (float)((ItemRASword)player.func_184614_ca().func_77973_b()).extraReach;
                    }
                    List nearby = player.field_70170_p.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g((double)radius), e -> e != player && !e.field_70128_L && e.func_70104_M() && (!e.hasCapability(RpgDataProvider.RPG_DATA, null) || !RpgData.getRpgData((Entity)e).getNation().equalsIgnoreCase(data.getNation())));
                    for (EntityLivingBase targetEntity : nearby) {
                        Skill skill = RARpgManager.getSkill(RARpgManager.SkillId.SPIN_ATTACK.getId());
                        int level = Math.min(RpgData.getRpgData((Entity)player).getSkillLevel(skill.id), skill.upgrades.size() - 1);
                        Skill.SkillUpgrade upgrade = skill.upgrades.get(level - 1);
                        targetEntity.func_70653_a((Entity)player, upgrade.horizontalKnockback, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        double baseDamage = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), (float)(baseDamage + (double)upgrade.damage));
                    }
                    break;
                }
            }
        }
    }
}

