/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.Ranger;
import ranger.blocks.RABlockLoader;
import ranger.packet.PacketSyncRpgData;
import ranger.rpg.IRpgData;
import ranger.rpg.RpgData;

public class PacketSetValue
implements IMessage {
    public static final int PACKET_NATION = 0;
    public static final int PACKET_CLASS = 1;
    public static final int PACKET_GIVE_ITEM = 2;
    int type;
    String value;

    public PacketSetValue() {
    }

    public PacketSetValue(int type, String value) {
        this.type = type;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        this.value = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.value);
    }

    public static class Handler
    implements IMessageHandler<PacketSetValue, IMessage> {
        public IMessage onMessage(PacketSetValue message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.readMessage(message, player));
            return null;
        }

        private static void readMessage(PacketSetValue message, EntityPlayerMP player) {
            IRpgData data = RpgData.getRpgData((Entity)player);
            switch (message.type) {
                case 0: {
                    data.setNation(message.value);
                    Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)player, data));
                    break;
                }
                case 1: {
                    String prevClass = data.getClassId();
                    data.setClassId(message.value);
                    if (data.getLevel() <= 0) {
                        data.setLevel(1);
                    }
                    if (!prevClass.equalsIgnoreCase(data.getClassId())) {
                        player.field_71071_by.func_70441_a(new ItemStack(RABlockLoader.getBlock(RABlockLoader.craftingTableMap.get(data.getClassId()))));
                    }
                    Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)player, data));
                    break;
                }
            }
        }
    }
}

