/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.RASounds;
import ranger.rpg.IRpgData;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataProvider;

public class PacketSyncRpgData
implements IMessage {
    private int entityId;
    private String nation;
    private String classId;
    private int level;
    private int xp;
    private Map<String, Integer> classSkillLevels;
    private Map<String, Integer> weaponProgression;
    private int stealthAttacks;
    public boolean levelUpSound = false;

    public PacketSyncRpgData() {
    }

    public PacketSyncRpgData(Entity entity, IRpgData data) {
        this.entityId = entity.func_145782_y();
        this.nation = data.getNation();
        this.classId = data.getClassId();
        this.level = data.getLevel();
        this.xp = data.getXP();
        this.classSkillLevels = data.getSkillLevelsForClass(this.classId);
        this.weaponProgression = data.getWeaponProgressionForClass(this.classId);
        this.stealthAttacks = data.getStealthAttacks();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.nation);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.classId);
        buf.writeInt(this.level);
        buf.writeInt(this.xp);
        buf.writeInt(this.classSkillLevels.size());
        for (Map.Entry<String, Integer> entry : this.classSkillLevels.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
        buf.writeInt(this.weaponProgression.size());
        for (Map.Entry<String, Integer> entry : this.weaponProgression.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
        buf.writeInt(this.stealthAttacks);
        buf.writeBoolean(this.levelUpSound);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.nation = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.classId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.level = buf.readInt();
        this.xp = buf.readInt();
        int size = buf.readInt();
        this.classSkillLevels = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            String skillId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int level = buf.readInt();
            this.classSkillLevels.put(skillId, level);
        }
        int size2 = buf.readInt();
        this.weaponProgression = new HashMap<String, Integer>();
        for (int i = 0; i < size2; ++i) {
            String skillId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int level = buf.readInt();
            this.weaponProgression.put(skillId, level);
        }
        this.stealthAttacks = buf.readInt();
        this.levelUpSound = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketSyncRpgData, IMessage> {
        public IMessage onMessage(PacketSyncRpgData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                IRpgData data;
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                if (entity != null && entity.hasCapability(RpgDataProvider.RPG_DATA, null) && (data = RpgData.getRpgData(entity)) != null) {
                    data.setNation(message.nation);
                    data.setClassId(message.classId);
                    int prevLevel = data.getLevel();
                    data.setLevel(message.level);
                    if (message.levelUpSound && data.getLevel() > prevLevel && entity == Minecraft.func_71410_x().field_71439_g) {
                        if (data.getLevel() % 5 == 0) {
                            entity.func_184185_a(RASounds.LEVEL_UP_5, 1.0f, 1.0f);
                        } else {
                            entity.func_184185_a(RASounds.LEVEL_UP, 1.0f, 1.0f);
                        }
                        entity.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Level up!"));
                    }
                    data.setXP(message.xp);
                    data.setSkillLevelsForClass(message.classId, message.classSkillLevels);
                    for (String we : message.weaponProgression.keySet()) {
                        data.setWeaponProgression(we, (Integer)message.weaponProgression.get(we));
                    }
                    data.setStealthAttacks(message.stealthAttacks);
                }
            });
            return null;
        }
    }
}

