/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.Ranger;
import ranger.packet.PacketResetCooldown;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;

public class PacketUseLookSkill
implements IMessage {
    int entityId;
    String skillId;

    public PacketUseLookSkill() {
    }

    public PacketUseLookSkill(int entityID, String skillId) {
        this.entityId = entityID;
        this.skillId = skillId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.skillId = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skillId);
    }

    public static class Handler
    implements IMessageHandler<PacketUseLookSkill, IMessage> {
        public IMessage onMessage(PacketUseLookSkill message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.lambda$onMessage$1((EntityPlayer)player, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$1(EntityPlayer player, PacketUseLookSkill message) {
            World world = player.field_70170_p;
            Entity entity = world.func_73045_a(message.entityId);
            if (entity != null && entity instanceof EntityLivingBase) {
                Skill skill;
                EntityLivingBase target = (EntityLivingBase)entity;
                if (message.skillId != null && !message.skillId.isEmpty() && (skill = RARpgManager.getSkill(message.skillId)) != null) {
                    IRpgData rpgData = RpgData.getRpgData((Entity)player);
                    Skill.SkillUpgrade upgrade = skill.getCurrentUpgrade(rpgData);
                    for (Skill.SkillEffect effect : skill.skillEffects) {
                        effect.performActions((EntityLivingBase)player, target, skill, upgrade);
                        effect.applyPotionEffects(target, upgrade);
                        if (!effect.spread) continue;
                        List nearby = world.func_175647_a(EntityLivingBase.class, target.func_174813_aQ().func_186662_g((double)upgrade.range), e -> e != target && e != player && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches((EntityLivingBase)player, e, effect.effectTarget));
                        for (EntityLivingBase entityLivingBase : nearby) {
                            effect.performActions((EntityLivingBase)player, entityLivingBase, skill, upgrade);
                            effect.applyPotionEffects(entityLivingBase, upgrade);
                        }
                    }
                    rpgData.setSkillCooldown(skill.id, RARpgManager.getCooldownForSkill(rpgData, skill));
                }
                Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketResetCooldown(), (EntityPlayerMP)player);
                player.func_184821_cY();
                player.func_184597_cx();
                if (message.skillId.equalsIgnoreCase(RARpgManager.SkillId.STEALTH_KILL.getId())) {
                    RpgData.getRpgData((Entity)player).setSkillCooldown(RARpgManager.SkillId.CAMOUFLAGE.getId(), 0);
                    if (!player.field_70170_p.field_72995_K && entity.func_70093_af()) {
                        entity.func_82142_c(true);
                    }
                }
            }
        }
    }
}

