/*
 * Decompiled with CFR 0.152.
 */
package ranger.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ranger.Ranger;
import ranger.packet.PacketSyncRpgData;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;

public class PacketUseSkillPoint
implements IMessage {
    String skill;

    public PacketUseSkillPoint() {
    }

    public PacketUseSkillPoint(String skill) {
        this.skill = skill;
    }

    public void fromBytes(ByteBuf buf) {
        this.skill = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skill);
    }

    public static class Handler
    implements IMessageHandler<PacketUseSkillPoint, IMessage> {
        public IMessage onMessage(PacketUseSkillPoint message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> Handler.readMessage(message, player));
            return null;
        }

        private static void readMessage(PacketUseSkillPoint message, EntityPlayerMP player) {
            IRpgData rpgData = RpgData.getRpgData((Entity)player);
            if (message.skill.equalsIgnoreCase("reset")) {
                rpgData.getAllSkillLevels().clear();
                Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)player, rpgData));
                return;
            }
            Skill skill = RARpgManager.getSkill(message.skill);
            if (skill == null) {
                return;
            }
            int level = rpgData.getSkillLevel(skill.id);
            if (level - 1 < skill.upgrades.size()) {
                int cost = skill.upgrades.get((int)level).cost;
                if (rpgData.getAvailableSkillPoints() >= cost) {
                    rpgData.setSkillLevel(skill.id, level + 1);
                }
            }
        }
    }
}

