/*
 * Decompiled with CFR 0.152.
 */
package ranger.render;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import ranger.Ranger;
import ranger.blocks.RABlockLoader;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityKalkara;
import ranger.items.ItemNigiri;
import ranger.items.ItemRASword;
import ranger.items.ItemTreaty;
import ranger.items.ItemWeapon;
import ranger.items.RAItemLoader;
import ranger.packet.PacketAttackEntity;
import ranger.render.RAItemModel;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.Skill;
import ranger.util.RayTraceHelper;

@Mod.EventBusSubscriber(modid="ranger", value={Side.CLIENT})
public class RenderEvents {
    private static final Map<String, ResourceLocation> classOverlayMap = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation RA_GUI_TEXTURE = new ResourceLocation("ranger", "textures/gui/class/all.png");
    private static final ResourceLocation BERSERK_TEXTURE = new ResourceLocation("ranger", "textures/gui/class/berserk.png");
    public static boolean usingPolearm = false;
    public static boolean prevUsingPolearm = false;
    public static float usingPolearmCount = 0.0f;
    public static int stabTime = 0;
    public static boolean big = false;
    public static float prevSensitivity = 0.0f;
    public static final ResourceLocation WARGAL_TEXTURE = new ResourceLocation("ranger", "textures/entity/wargal/player.png");
    public static int zLevel = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null) {
            EntityPlayerSP player;
            ItemStack stack;
            if (prevSensitivity != 0.0f) {
                mc.field_71474_y.field_74341_c = prevSensitivity;
            }
            if ((stack = (player = mc.field_71439_g).func_184614_ca()).func_77973_b() instanceof ItemWeapon) {
                ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
                if (weapon.polearm) {
                    big = weapon.thrustDist > 5.0f;
                    float progress = player.func_184825_o(0.5f);
                    if (mc.field_71474_y.field_74313_G.func_151470_d() && stabTime <= 0 && progress >= 1.0f && (!big || player.func_184187_bx() != null || weapon.isPike || weapon.isAxe)) {
                        if (!prevUsingPolearm) {
                            usingPolearm = true;
                            prevUsingPolearm = true;
                            stabTime = 0;
                        }
                    } else {
                        if (stabTime == 0 && usingPolearmCount >= 110.0f) {
                            RenderEvents.usePolearm((EntityPlayer)player, stack, false);
                        }
                        if (stabTime > 0) {
                            --stabTime;
                        }
                        if (stabTime == 0) {
                            usingPolearm = false;
                            if (!mc.field_71474_y.field_74313_G.func_151470_d()) {
                                prevUsingPolearm = false;
                            }
                        }
                    }
                } else {
                    usingPolearm = false;
                    prevUsingPolearm = false;
                }
            }
            if (usingPolearm) {
                float chargingSpeed;
                if (usingPolearmCount < 110.0f) {
                    usingPolearmCount += 22.0f;
                } else if (stack.func_77973_b() instanceof ItemWeapon && stabTime <= 0 && ((chargingSpeed = RenderEvents.getChargingSpeed((EntityPlayer)player)) > 0.1f || ((ItemWeapon)stack.func_77973_b()).isPike)) {
                    RenderEvents.usePolearm((EntityPlayer)player, stack, true);
                }
            } else {
                if (usingPolearmCount > 0.0f) {
                    usingPolearmCount -= 44.0f;
                }
                if (usingPolearmCount < 0.0f) {
                    usingPolearmCount = 0.0f;
                }
            }
            if (player.func_70644_a(EffectRegistry.PARALYSIS)) {
                mc.field_71474_y.field_74341_c *= 0.1f;
                if (Minecraft.func_71410_x().field_71460_t.func_147706_e() == null) {
                    try {
                        Minecraft.func_71410_x().field_71460_t.func_175069_a(new ResourceLocation("minecraft", "shaders/post/phosphor.json"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                float radius = 30.0f;
                List mobs = player.field_70170_p.func_175647_a(EntityKalkara.class, player.func_174813_aQ().func_186662_g((double)radius), arg_0 -> RenderEvents.lambda$onClientTick$0((EntityPlayer)player, arg_0));
                EntityKalkara kalkara = mobs.stream().min(Comparator.comparingDouble(arg_0 -> RenderEvents.lambda$onClientTick$1((EntityPlayer)player, arg_0))).orElse(null);
                if (kalkara != null) {
                    double dx = kalkara.field_70165_t - player.field_70165_t;
                    double dy = kalkara.field_70163_u + (double)kalkara.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e());
                    double dz = kalkara.field_70161_v - player.field_70161_v;
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                    float targetPitch = (float)(-(Math.atan2(dy, distance) * 57.29577951308232));
                    float yaw = RenderEvents.smoothAngle(player.field_70177_z, targetYaw, 3.0f);
                    float pitch = RenderEvents.smoothAngle(player.field_70125_A, targetPitch, 2.0f);
                    player.field_70177_z = yaw;
                    player.field_70759_as = yaw;
                    player.field_70125_A = pitch;
                    player.field_70761_aq = yaw;
                    player.field_70759_as = yaw;
                }
            } else {
                prevSensitivity = mc.field_71474_y.field_74341_c;
                if (Minecraft.func_71410_x().field_71460_t.func_147706_e() != null) {
                    Minecraft.func_71410_x().field_71460_t.func_181022_b();
                }
            }
        }
    }

    private static float smoothAngle(float current, float target, float maxChange) {
        float diff = MathHelper.func_76142_g((float)(target - current));
        if (diff > maxChange) {
            diff = maxChange;
        }
        if (diff < -maxChange) {
            diff = -maxChange;
        }
        return current + diff;
    }

    private static void usePolearm(EntityPlayer player, ItemStack stack, boolean couched) {
        boolean riding;
        ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
        float damage = weapon.getAttackDamage();
        boolean bl = riding = player.func_184187_bx() != null;
        if (riding && couched) {
            damage *= 2.0f;
        } else if (!riding && !couched) {
            damage *= 0.5f;
        }
        RayTraceResult res = RayTraceHelper.getLookTarget((EntityLivingBase)player, weapon.thrustDist, true);
        if (res != null && res.field_72308_g != null) {
            if (weapon.isPike && couched && !riding && res.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)res.field_72308_g;
                double motion = Math.abs(entity.field_70165_t - entity.field_70142_S) + Math.abs(entity.field_70161_v - entity.field_70136_U);
                if (motion < 0.05 && !player.func_70051_ag()) {
                    return;
                }
                if (res.field_72308_g instanceof EntityHorse) {
                    damage *= 6.0f;
                } else if (res.field_72308_g.func_184218_aH()) {
                    damage *= 5.0f;
                }
            }
            stabTime = 5;
            Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketAttackEntity(res.field_72308_g.func_145782_y(), damage));
        }
        if (!couched) {
            stabTime = 5;
        }
    }

    private static float getChargingSpeed(EntityPlayer player) {
        float movement = player.field_191988_bg;
        if (player.func_184607_cu().func_77973_b() instanceof ItemShield && player.func_184187_bx() == null) {
            return 0.0f;
        }
        return movement;
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : RAItemLoader.items.values()) {
            int i;
            if (item instanceof ItemNigiri) {
                for (i = 0; i < ItemNigiri.nigiriTypes; ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + ((ItemNigiri)item).getName(i), "inventory"));
                }
                continue;
            }
            if (item instanceof ItemTreaty) {
                for (i = 0; i < RARpgManager.nationMap.size(); ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : RABlockLoader.blocks.values()) {
            Item item = ItemBlock.func_150898_a((Block)block);
            if (item == Items.field_190931_a) continue;
            ResourceLocation loc = item.getRegistryName();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "normal"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc.func_110624_b() + ":itemblock/" + loc.func_110623_a(), "inventory"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderHand(RenderSpecificHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        IRpgData data = RpgData.getRpgData((Entity)player);
        ItemStack stack = player.func_184586_b(event.getHand());
        if (data.getClassId().equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId()) && stack.func_190926_b()) {
            boolean flag;
            boolean bl = flag = event.getHand() == EnumHand.MAIN_HAND;
            if (flag) {
                EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                mc.field_71446_o.func_110577_a(WARGAL_TEXTURE);
                GlStateManager.func_179094_E();
                RenderEvents.renderArmFirstPerson(event.getEquipProgress(), event.getSwingProgress(), enumhandside);
                GlStateManager.func_179121_F();
                event.setCanceled(true);
            }
        }
        if (stack.func_77973_b() instanceof ItemWeapon) {
            ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
            if (weapon.polearm) {
                float am;
                float multiplier = 0.5f;
                float f = am = !(player.func_184607_cu().func_77973_b() instanceof ItemWeapon) ? 0.0f : (float)(stack.func_77988_m() - player.func_184605_cv()) / (20.0f * multiplier);
                if (am > 1.0f) {
                    am = 1.0f;
                }
            }
        }
    }

    private static void renderArmFirstPerson(float p_187456_1_, float p_187456_2_, EnumHandSide p_187456_3_) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean flag = p_187456_3_ != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)p_187456_2_);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(p_187456_2_ * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + p_187456_1_ * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(p_187456_2_ * p_187456_2_ * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        EntityPlayerSP abstractclientplayer = mc.field_71439_g;
        mc.func_110434_K().func_110577_a(WARGAL_TEXTURE);
        GlStateManager.func_179109_b((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        RenderPlayer renderplayer = (RenderPlayer)mc.func_175598_ae().func_78713_a((Entity)abstractclientplayer);
        GlStateManager.func_179129_p();
        if (flag) {
            renderplayer.func_177138_b((AbstractClientPlayer)abstractclientplayer);
        } else {
            renderplayer.func_177139_c((AbstractClientPlayer)abstractclientplayer);
        }
        GlStateManager.func_179089_o();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void renderPlayerPre(RenderLivingEvent.Pre event) {
        EntityLivingBase entityLivingBase = event.getEntity();
        if (entityLivingBase.func_82150_aj() && entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == RAItemLoader.getItem("ranger_hood")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRender(RenderGameOverlayEvent event) {
        if (event instanceof RenderGameOverlayEvent.Post && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            int i;
            Skill.SkillUpgrade upgrade;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null) {
                return;
            }
            EntityPlayerSP player = mc.field_71439_g;
            IRpgData data = RpgData.getRpgData((Entity)player);
            String nation = data.getNation();
            if (nation == null || nation.isEmpty()) {
                return;
            }
            RAClass raClass = RARpgManager.getRAClass(data.getClassId());
            if (raClass == null) {
                return;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            if (!classOverlayMap.containsKey(nation)) {
                classOverlayMap.put(nation, new ResourceLocation("ranger", "textures/gui/class/" + nation + ".png"));
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179108_z();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71446_o.func_110577_a(RA_GUI_TEXTURE);
            if (player.func_82150_aj()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            }
            RenderEvents.drawTexturedModalRect(0, 0, 0, 0, 200, 48);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FontRenderer fontRenderer = mc.field_71466_p;
            if (data.getClassId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId()) && data.getLevel() < 25) {
                fontRenderer.func_175063_a(raClass.name + " Apprentice", 5.0f, 5.0f, 0xE0E0E0);
            } else {
                fontRenderer.func_175063_a(raClass.name, 5.0f, 5.0f, 0xE0E0E0);
            }
            String lvlStr = "Lv." + data.getLevel();
            fontRenderer.func_78276_b(lvlStr, 164 - fontRenderer.func_78256_a(lvlStr), 5, 0xE0E0E0);
            if (player.func_82150_aj() && (upgrade = RARpgManager.getSkill(RARpgManager.SkillId.CAMOUFLAGE.getId()).getCurrentUpgrade(data)) != null) {
                TextFormatting formatting = data.getStealthAttacks() <= 0 ? TextFormatting.RED : TextFormatting.YELLOW;
                String sString = "(" + formatting + data.getStealthAttacks() + TextFormatting.RESET + ")";
                fontRenderer.func_78276_b(sString, 164 - fontRenderer.func_78256_a(sString), 14, 0xE0E0E0);
            }
            int curXP = data.getXP();
            int nextXP = data.getXPToNextLevel();
            if (data.getLevel() == 100) {
                curXP = nextXP = RpgData.getXPForLevel(100);
            }
            fontRenderer.func_78276_b("XP: " + curXP + "/" + nextXP, 5, 15, 0xE0E0E0);
            Skill.SkillUpgrade cdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.CLIMBING.getId()).getCurrentUpgrade(data);
            int maxClimbStamina = cdUpgrade != null ? (int)cdUpgrade.value : 0;
            int climbStamina = ((RpgData)data).climbStamina;
            if (climbStamina < maxClimbStamina) {
                int y = 50;
                mc.func_110434_K().func_110577_a(new ResourceLocation("ranger", "textures/gui/class/bar.png"));
                RenderEvents.drawTexturedModalRect(2, y, 0, 0, 102, 8);
                int width2 = (int)(102.0f * ((float)climbStamina / (float)maxClimbStamina));
                RenderEvents.drawTexturedModalRect(2, y + 2, 0, 8, width2, 4);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(RA_GUI_TEXTURE);
            int lockedSkills = 0;
            int index = 0;
            for (i = 0; i < raClass.skills.size(); ++i) {
                Skill skill = RARpgManager.getSkill(raClass.skills.get(i));
                if (skill == null || !skill.usable) continue;
                if (data.getSkillLevel(skill.id) > 0) {
                    int x = 5 + index * 20;
                    int y = 28;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179147_l();
                    RenderEvents.drawTexturedModalRect(x, y, 0, 48, 18, 18);
                    String itemId = skill.itemOverrides.getOrDefault(data.getClassId(), skill.item);
                    Item item = Item.func_111206_d((String)itemId);
                    if (data.getSkillLevel(skill.id) > 0) {
                        GlStateManager.func_179123_a();
                        RenderHelper.func_74520_c();
                        GlStateManager.func_179091_B();
                        GlStateManager.func_179147_l();
                        if (item == RAItemLoader.getItem("araluen_shield") && nation.equalsIgnoreCase(RARpgManager.NationId.SKANDIA.getId())) {
                            item = RAItemLoader.getItem("skandian_shield");
                        }
                        mc.func_175599_af().func_175042_a(new ItemStack(item), x + 1, y + 1);
                        RenderHelper.func_74518_a();
                        GlStateManager.func_179101_C();
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179099_b();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        mc.func_110434_K().func_110577_a(RA_GUI_TEXTURE);
                        GlStateManager.func_179147_l();
                    } else {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        RenderEvents.drawTexturedModalRect(x, y, 36, 48, 18, 18);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderEvents.drawTexturedModalRect(x, y, 54, 48, 18, 18);
                    }
                    int skillCooldown = data.getSkillCooldown(skill.id);
                    if (skillCooldown > 0) {
                        int size = (int)(18.0f * ((float)(skillCooldown + 100) / (float)RARpgManager.getCooldownForSkill(data, skill)));
                        size = Math.min(size, 18);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        RenderEvents.drawTexturedModalRect(x, y + (18 - size), 36, 48, 18, size);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (data.getSelectedSkill() == i) {
                        RenderEvents.drawTexturedModalRect(x, y, 18, 48, 18, 18);
                    }
                    ++index;
                    continue;
                }
                ++lockedSkills;
            }
            if (index < 8) {
                for (i = 0; i < lockedSkills; ++i) {
                    int x = 5 + index * 20;
                    int y = 28;
                    RenderEvents.drawTexturedModalRect(x, y, 0, 48, 18, 18);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    RenderEvents.drawTexturedModalRect(x, y, 36, 48, 18, 18);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderEvents.drawTexturedModalRect(x, y, 54, 48, 18, 18);
                    if (++index > 7) break;
                }
            }
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int width = scaledresolution.func_78326_a();
            int height = scaledresolution.func_78328_b();
            if (player.func_70644_a(EffectRegistry.BERSERK)) {
                mc.field_71446_o.func_110577_a(BERSERK_TEXTURE);
                RenderEvents.renderOverlay(width, height);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
        }
    }

    private static void renderOverlay(int par1, int par2) {
        GL11.glEnable((int)2977);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)((float)par1 / 2.0f - (float)(2 * par2)), (double)par2, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)par1 / 2.0f + (float)(2 * par2)), (double)par2, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)par1 / 2.0f + (float)(2 * par2)), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)par1 / 2.0f - (float)(2 * par2)), 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)2977);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        for (Item item : RAItemLoader.items.values()) {
            if (!(item instanceof ItemWeapon) || !((ItemWeapon)item).polearm) continue;
            ModelResourceLocation modelLocation = new ModelResourceLocation("ranger:" + item.getRegistryName().func_110623_a(), "inventory");
            IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelLocation);
            if (original == null) continue;
            RAItemModel rotatingModel = new RAItemModel(original);
            event.getModelRegistry().func_82595_a((Object)modelLocation, (Object)rotatingModel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onEvent(MouseEvent event) {
        if (event.getButton() == 0 && event.isButtonstate()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP thePlayer = mc.field_71439_g;
            if (thePlayer != null) {
                RayTraceResult mov;
                ItemStack itemstack = thePlayer.func_184614_ca();
                float reach = 0.0f;
                if (itemstack.func_77973_b() instanceof ItemRASword) {
                    reach = ((ItemRASword)itemstack.func_77973_b()).extraReach;
                } else if (itemstack.func_77973_b() instanceof ItemWeapon) {
                    reach = ((ItemWeapon)itemstack.func_77973_b()).extraReach;
                }
                if (thePlayer.func_70644_a(EffectRegistry.FEND_OFF)) {
                    reach += (float)(thePlayer.func_70660_b(EffectRegistry.FEND_OFF).func_76458_c() + 1);
                }
                if (reach > 0.0f && (mov = RayTraceHelper.getLookTarget((EntityLivingBase)thePlayer, 4.0f + reach, false)) != null && mov.field_72308_g != null && mov.field_72308_g.field_70172_ad == 0 && mov.field_72308_g != thePlayer && mov.field_72308_g != mc.field_147125_j) {
                    Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketAttackEntity(mov.field_72308_g.func_145782_y(), -1.0f, "ra_sword"));
                }
            }
        }
    }

    private static /* synthetic */ double lambda$onClientTick$1(EntityPlayer player, EntityKalkara m) {
        return m.func_70068_e((Entity)player);
    }

    private static /* synthetic */ boolean lambda$onClientTick$0(EntityPlayer player, EntityKalkara e) {
        return e.func_70685_l((Entity)player);
    }
}

