/*
 * Decompiled with CFR 0.152.
 */
package ranger.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import ranger.entities.EntityRAHumanoid;
import ranger.render.LayerRACape;
import ranger.render.ModelRAHumanoid;
import ranger.render.RenderRABase;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class RenderRAHumanoid
extends RenderRABase<EntityRAHumanoid> {
    public static final ResourceLocation CLOAK_TEXTURE = new ResourceLocation("ranger", "textures/model/armor/araluen_hero_cape.png");

    public RenderRAHumanoid(RenderManager renderManagerIn) {
        this(renderManagerIn, new ModelRAHumanoid());
    }

    public RenderRAHumanoid(RenderManager renderManagerIn, ModelBiped modelBiped) {
        super(renderManagerIn, modelBiped, 0.5f);
        this.func_177094_a(new LayerRACape((RenderLivingBase)this, CLOAK_TEXTURE));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelBiped(0.5f);
                this.field_177186_d = new ModelBiped(1.0f);
            }
        });
    }

    protected void preRenderCallback(EntityRAHumanoid entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
    }

    protected void renderLivingLabel(EntityRAHumanoid entityIn, String str, double x, double y, double z, int maxDistance) {
        double d0;
        IRpgData rpgData = RpgData.getRpgData((Entity)entityIn);
        String lvlString = "Lv." + rpgData.getLevel();
        str = !entityIn.func_145818_k_() || str.isEmpty() ? lvlString : str + " " + lvlString;
        if (entityIn.func_70902_q() == Minecraft.func_71410_x().field_71439_g && entityIn.getSquad() > 0 && entityIn.getSquad() < EntityRAHumanoid.squadColors.length) {
            str = EntityRAHumanoid.squadColors[entityIn.getSquad()] + str;
        }
        if ((d0 = entityIn.func_70068_e(this.field_76990_c.field_78734_h)) <= (double)(maxDistance * maxDistance)) {
            int i;
            boolean flag = entityIn.func_70093_af();
            float f = this.field_76990_c.field_78735_i;
            float f1 = this.field_76990_c.field_78732_j;
            boolean flag1 = this.field_76990_c.field_78733_k.field_74320_O == 2;
            float f2 = entityIn.field_70131_O + 0.5f - (flag ? 0.25f : 0.0f);
            int n = i = "deadmau5".equals(str) ? -10 : 0;
            if (rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.ARRIDA.getId()) || rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.TEMUJAI.getId())) {
                f2 += 0.3f;
            }
            EntityRenderer.func_189692_a((FontRenderer)this.func_76983_a(), (String)str, (float)((float)x), (float)((float)y + f2), (float)((float)z), (int)i, (float)f, (float)f1, (boolean)flag1, (boolean)flag);
        }
    }

    protected ResourceLocation getEntityTexture(EntityRAHumanoid entity) {
        IRpgData rpgData = RpgData.getRpgData((Entity)entity);
        RAClass raClass = RARpgManager.getRAClass(rpgData.getClassId());
        if (raClass == null) {
            return null;
        }
        return new ResourceLocation("ranger", "textures/entity/" + raClass.id + "/" + entity.func_145782_y() % raClass.skins + ".png");
    }
}

