/*
 * Decompiled with CFR 0.152.
 */
package ranger.rpg;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ranger.RASounds;
import ranger.Ranger;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityRABase;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityWargal;
import ranger.packet.PacketAttackEntity;
import ranger.packet.PacketUseLookSkill;
import ranger.rpg.IRpgData;
import ranger.rpg.Nation;
import ranger.rpg.RAClass;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataProvider;
import ranger.rpg.Skill;
import ranger.util.RAWorldData;
import ranger.util.RayTraceHelper;

public class RARpgManager {
    public static final Map<String, RAClass> classMap = new LinkedHashMap<String, RAClass>();
    public static final Map<String, Nation> nationMap = new LinkedHashMap<String, Nation>();
    public static final Map<String, Skill> skillMap = new LinkedHashMap<String, Skill>();
    public static final List<String> morgarathKnightArmor = new ArrayList<String>();
    public static final List<String> morgarathKnightArmorLeader = new ArrayList<String>();

    private static InputStream getLocalStream(String path) {
        return RARpgManager.class.getClassLoader().getResourceAsStream(path);
    }

    public static void init() {
        Type nationListType2;
        InputStreamReader nationReader;
        Throwable throwable;
        System.out.println("Loading Ranger's Apprentice RPG Data");
        Gson gson = new Gson();
        try {
            throwable = null;
            try (InputStreamReader classReader = new InputStreamReader(RARpgManager.getLocalStream("assets/ranger/rpg/classes.json"));){
                Type classListType = new TypeToken<List<RAClass>>(){}.getType();
                List classes = (List)gson.fromJson((Reader)classReader, classListType);
                for (RAClass cls : classes) {
                    classMap.put(cls.id, cls);
                }
                System.out.println("Loaded " + classMap.size() + " classes.");
            }
            catch (Throwable classListType) {
                throwable = classListType;
                throw classListType;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            nationReader = new InputStreamReader(RARpgManager.getLocalStream("assets/ranger/rpg/nations.json"));
            throwable = null;
            try {
                nationListType2 = new TypeToken<List<Nation>>(){}.getType();
                List nations = (List)gson.fromJson((Reader)nationReader, nationListType2);
                for (Nation nation : nations) {
                    nationMap.put(nation.id, nation);
                }
                System.out.println("Loaded " + nationMap.size() + " nations.");
            }
            catch (Throwable nationListType2) {
                throwable = nationListType2;
                throw nationListType2;
            }
            finally {
                if (nationReader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)nationReader).close();
                        }
                        catch (Throwable nationListType2) {
                            throwable.addSuppressed(nationListType2);
                        }
                    } else {
                        ((Reader)nationReader).close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            nationReader = new InputStreamReader(RARpgManager.getLocalStream("assets/ranger/rpg/skills.json"));
            throwable = null;
            try {
                nationListType2 = new TypeToken<List<Skill>>(){}.getType();
                List skills = (List)gson.fromJson((Reader)nationReader, nationListType2);
                for (Skill skill : skills) {
                    skillMap.put(skill.id, skill);
                }
                System.out.println("Loaded " + skillMap.size() + " skills.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nationReader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)nationReader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)nationReader).close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        morgarathKnightArmor.add("renegade_knight_boots");
        morgarathKnightArmor.add("renegade_knight_pants");
        morgarathKnightArmor.add("renegade_knight_tunic");
        morgarathKnightArmor.add("renegade_knight_helm");
        morgarathKnightArmorLeader.add("renegade_knight_boots");
        morgarathKnightArmorLeader.add("renegade_knight_pants");
        morgarathKnightArmorLeader.add("renegade_knight_tunic");
        morgarathKnightArmorLeader.add("renegade_general_helm");
    }

    public static Nation getNation(String nation) {
        return nationMap.getOrDefault(nation, null);
    }

    public static Nation getNation(NationId nation) {
        return nationMap.get(nation.getId());
    }

    public static boolean isAllied(Entity e1, Entity e2) {
        if (!e1.hasCapability(RpgDataProvider.RPG_DATA, null) || !e2.hasCapability(RpgDataProvider.RPG_DATA, null)) {
            return false;
        }
        String nation1 = RpgData.getRpgData(e1).getNation();
        String nation2 = RpgData.getRpgData(e2).getNation();
        return RAWorldData.get(e1.field_70170_p).areNationsAllied(nation1, nation2);
    }

    public static boolean isSameNation(Entity e1, Entity e2) {
        if (!e1.hasCapability(RpgDataProvider.RPG_DATA, null) || !e2.hasCapability(RpgDataProvider.RPG_DATA, null)) {
            return false;
        }
        return RpgData.getRpgData(e1).getNation().equalsIgnoreCase(RpgData.getRpgData(e2).getNation());
    }

    public static boolean isSameClass(Entity e1, Entity e2) {
        if (!e1.hasCapability(RpgDataProvider.RPG_DATA, null) || !e2.hasCapability(RpgDataProvider.RPG_DATA, null)) {
            return false;
        }
        return RpgData.getRpgData(e1).getClassId().equalsIgnoreCase(RpgData.getRpgData(e2).getClassId());
    }

    public static RAClass getRAClass(String clas) {
        return classMap.getOrDefault(clas, null);
    }

    public static RAClass getRAClass(ClassId clas) {
        return classMap.get(clas.getId());
    }

    public static Skill getSkill(String skill) {
        return skillMap.getOrDefault(skill, null);
    }

    public static Skill getSkill(SkillId skill) {
        return skillMap.get(skill.getId());
    }

    public static boolean targetMatches(EntityLivingBase source, EntityLivingBase target, String effectTarget) {
        switch (effectTarget) {
            case "attackers": {
                return target.func_70643_av() == source || target instanceof EntityLiving && ((EntityLiving)target).func_70638_az() == source;
            }
            case "enemy": {
                return !RARpgManager.isAllied((Entity)target, (Entity)source) && (!(target instanceof EntityAnimal) || target instanceof EntityRABase);
            }
            case "not_allies": {
                return !RARpgManager.isAllied((Entity)target, (Entity)source);
            }
            case "allies": {
                return RARpgManager.isAllied((Entity)target, (Entity)source);
            }
            case "allies_same_nation": {
                return RARpgManager.isSameNation((Entity)target, (Entity)source);
            }
            case "allies_same_class": {
                return RARpgManager.isSameNation((Entity)target, (Entity)source) && RARpgManager.isSameClass((Entity)target, (Entity)source);
            }
            case "allies_include_mount": {
                return RARpgManager.targetMatches(source, target, "allies") || !target.func_184188_bt().isEmpty() && target.func_184188_bt().get(0) instanceof EntityLivingBase && RARpgManager.targetMatches(source, (EntityLivingBase)target.func_184188_bt().get(0), "allies");
            }
            case "hired": {
                return target instanceof EntityTameable && ((EntityTameable)target).func_70902_q() == source;
            }
            case "hired_include_mount": {
                return RARpgManager.targetMatches(source, target, "hired") || !target.func_184188_bt().isEmpty() && target.func_184188_bt().get(0) instanceof EntityLivingBase && RARpgManager.targetMatches(source, (EntityLivingBase)target.func_184188_bt().get(0), "hired");
            }
        }
        return false;
    }

    public static int getCooldownForSkill(IRpgData data, SkillId skill) {
        return (skill.getCooldown() - data.getSkillLevel(skill.getId()) * 10) * 20;
    }

    public static int getCooldownForSkill(IRpgData data, Skill skill) {
        int level = Math.min(data.getSkillLevel(skill.id) - 1, skill.upgrades.size() - 1);
        return skill.upgrades.get((int)Math.max((int)level, (int)0)).cooldown * 20;
    }

    public static void useSkillNew(IRpgData rpgData, String skillId) {
        Skill skill = RARpgManager.getSkill(skillId);
        if (!skill.usable) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)rpgData.getEntity();
        World world = entity.field_70170_p;
        if (skill.playerOnly && !(entity instanceof EntityPlayer)) {
            return;
        }
        Skill.SkillUpgrade upgrade = skill.getCurrentUpgrade(rpgData);
        block13: for (Skill.SkillEffect effect : skill.skillEffects) {
            switch (effect.effectType) {
                case "play_sound": {
                    world.func_184133_a(null, entity.func_180425_c(), RASounds.getSound(effect.effectTarget), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case "look": 
                case "look_far": {
                    double dist;
                    double d = dist = effect.effectType.equalsIgnoreCase("look_far") ? 100.0 : 4.0;
                    if (effect.effectTarget.equalsIgnoreCase("block")) {
                        RayTraceResult res = RayTraceHelper.getLookTarget(entity, dist, true);
                        if (res == null || res.field_72313_a != RayTraceResult.Type.BLOCK) continue block13;
                        effect.performActionsOnBlock(entity, res.func_178782_a(), skill, upgrade);
                        break;
                    }
                    if (!(entity instanceof EntityPlayer)) {
                        if (!(entity instanceof EntityLiving) || ((EntityLiving)entity).func_70638_az() == null) continue block13;
                        EntityLivingBase targetEntity = ((EntityLiving)entity).func_70638_az();
                        effect.performActions(entity, targetEntity, skill, upgrade);
                        effect.applyPotionEffects(targetEntity, upgrade);
                        entity.func_184609_a(EnumHand.MAIN_HAND);
                        break;
                    }
                    if (world.field_72995_K) {
                        RayTraceResult res2x = RayTraceHelper.getLookTarget(entity, dist, true);
                        if (res2x == null || res2x.field_72313_a != RayTraceResult.Type.ENTITY || !(res2x.field_72308_g instanceof EntityLivingBase)) {
                            return;
                        }
                        EntityLivingBase targetEntity = (EntityLivingBase)res2x.field_72308_g;
                        if (!RARpgManager.targetMatches(entity, targetEntity, effect.effectTarget)) {
                            return;
                        }
                        Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketUseLookSkill(targetEntity.func_145782_y(), skillId));
                        entity.func_184609_a(EnumHand.MAIN_HAND);
                        break;
                    }
                    return;
                }
                case "aura": 
                case "aura_include_player": {
                    boolean includePlayer = effect.effectType.equals("aura_include_player");
                    List nearby = world.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g((double)upgrade.range), e -> (e != entity || includePlayer) && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(entity, e, effect.effectTarget));
                    for (EntityLivingBase entityLivingBase : nearby) {
                        effect.performActions(entity, entityLivingBase, skill, upgrade);
                        effect.applyPotionEffects(entityLivingBase, upgrade);
                    }
                    continue block13;
                }
                default: {
                    if (effect.effectTarget != null && effect.effectTarget.equalsIgnoreCase("mount")) {
                        if (!(entity.func_184187_bx() instanceof EntityLivingBase)) continue block13;
                        effect.performActions(entity, (EntityLivingBase)entity.func_184187_bx(), skill, upgrade);
                        effect.applyPotionEffects((EntityLivingBase)entity.func_184187_bx(), upgrade);
                        break;
                    }
                    effect.performActions(entity, entity, skill, upgrade);
                    effect.applyPotionEffects(entity, upgrade);
                }
            }
        }
        if (!(entity instanceof EntityPlayer)) {
            rpgData.setSkillCooldown(skill.id, RARpgManager.getCooldownForSkill(rpgData, skill) / 2);
        } else if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            rpgData.setSkillCooldown(skill.id, RARpgManager.getCooldownForSkill(rpgData, skill));
        }
    }

    public static void useSkill(IRpgData data, SkillId skill) {
        int level = data.getSkillLevel(skill.getId());
        if (level <= 0 || !skill.isUsable()) {
            return;
        }
        level = Math.min(Math.max(level, 1), 10);
        EntityLivingBase entity = (EntityLivingBase)data.getEntity();
        World world = entity.field_70170_p;
        Random random = new Random();
        Vec3d lookVec = entity.func_70040_Z();
        switch (skill) {
            case ESCAPE: {
                Vec3d backward = new Vec3d(-lookVec.field_72450_a, 0.0, -lookVec.field_72449_c).func_72432_b().func_186678_a(1.0 + 0.1 * (double)level);
                entity.func_70024_g(backward.field_72450_a, 0.5 + 0.0125 * (double)level, backward.field_72449_c);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case AGILITY: {
                if (!entity.field_70170_p.field_72995_K) {
                    int strength = level / 4;
                    if (entity instanceof EntityRABase) {
                        strength = level / 10;
                    }
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20 * (10 + level * 2), strength, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case RAPID_FIRE: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(EffectRegistry.RAPID_FIRE, 20 * (5 + level / 2), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case CHARGE: {
                double chargeRot = Math.toRadians(entity.field_70177_z);
                double xMultiplier = -Math.sin(chargeRot);
                double zMultiplier = Math.cos(chargeRot);
                int chargeAmount = (int)((7.0f + (float)level * 0.75f) * (entity instanceof EntityRABase ? 0.5f : 1.0f));
                data.startCharge(chargeAmount, xMultiplier, zMultiplier, false);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case FATAL_SHOT: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(EffectRegistry.FATAL_SHOT, 20 * (5 + level / 2), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case BERSERKER: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(EffectRegistry.BERSERK, 20 * (5 + level), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case GROUND_POUND: {
                if (!entity.field_70170_p.field_72995_K) {
                    double radius = 3.0 + (double)level * 0.3;
                    Vec3d center = entity.func_174791_d().func_178787_e(new Vec3d(0.0, 0.1, 0.0));
                    for (int i = 0; i < 10; ++i) {
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, center.field_72450_a + (double)(random.nextFloat() * 6.0f - 3.0f), center.field_72448_b + (double)0.2f, center.field_72449_c + (double)(random.nextFloat() * 6.0f - 3.0f), 4, 0.5, 0.1, 0.5, 0.01, new int[0]);
                    }
                    List nearby = world.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(radius), e -> e != entity && !e.field_70128_L && e.func_70104_M() && !RARpgManager.isAllied((Entity)entity, (Entity)e));
                    for (EntityLivingBase e2 : nearby) {
                        e2.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity), (float)level);
                        Vec3d dir = e2.func_174791_d().func_178788_d(center).func_72432_b();
                        double knockbackStrength = 0.2 + (double)level * 0.15;
                        e2.func_70024_g(dir.field_72450_a * knockbackStrength, 0.2 + 0.03 * (double)level, dir.field_72449_c * knockbackStrength);
                        e2.field_70133_I = true;
                    }
                    BlockPos below = entity.func_180425_c().func_177977_b();
                    IBlockState state = entity.field_70170_p.func_180495_p(below);
                    Block block = state.func_177230_c();
                    if (block != Blocks.field_150350_a) {
                        world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
                entity.func_184609_a(EnumHand.MAIN_HAND);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case SPIN_ATTACK: {
                data.setSpinCount(360);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case REINFORCEMENTS: {
                if (!world.field_72995_K) {
                    for (int i = 0; i < 2 + level / 2; ++i) {
                        EntityRAHumanoid raHumanoid = data.getClassId().equalsIgnoreCase(ClassId.WARGAL.getId()) ? new EntityWargal(world) : new EntityRAStandard(world);
                        raHumanoid.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        raHumanoid.setTemporary(true);
                        IRpgData rpgDataNew = RpgData.getRpgData((Entity)raHumanoid);
                        rpgDataNew.setNation(data.getNation());
                        rpgDataNew.setClassId(data.getClassId());
                        raHumanoid.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                        world.func_72838_d((Entity)raHumanoid);
                        raHumanoid.func_70024_g(random.nextFloat() / 2.0f, 0.0, random.nextFloat() / 2.0f);
                    }
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case GROWL: {
                if (!world.field_72995_K) {
                    double radius = 7.0 + (double)level * 0.8;
                    List nearby = world.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(radius), e -> e != entity && !e.field_70128_L && e.func_70104_M());
                    for (EntityLivingBase e3 : nearby) {
                        boolean ally;
                        boolean bl = ally = e3.hasCapability(RpgDataProvider.RPG_DATA, null) && RpgData.getRpgData((Entity)e3).getNation().equalsIgnoreCase(data.getNation());
                        if (ally) {
                            e3.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20 * (10 + level), 0, false, true));
                            continue;
                        }
                        e3.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 * (5 + level / 2), level / 3, false, true));
                    }
                    world.func_184133_a(null, entity.func_180425_c(), RASounds.WARGAL_GROWL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case TEAR: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(EffectRegistry.TEAR, 20 * (10 + level), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case HEAL: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70691_i(5.0f + (float)level / 2.0f);
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case SHIELD_BASH: {
                RayTraceResult result = RayTraceHelper.getLookTarget(entity, 4.0, true);
                if (entity instanceof EntityRABase && ((EntityRABase)entity).func_70638_az() != null) {
                    result = new RayTraceResult((Entity)((EntityRABase)entity).func_70638_az());
                }
                if (result == null || result.field_72313_a != RayTraceResult.Type.ENTITY || !(result.field_72308_g instanceof EntityLivingBase) || RARpgManager.isAllied((Entity)entity, result.field_72308_g)) break;
                float extraKnock = (float)level / 5.0f;
                float yKnock = 0.2f + 0.02f * (float)level;
                if (!(entity instanceof EntityPlayer)) {
                    extraKnock *= 0.5f;
                    yKnock *= 0.5f;
                }
                int slownessLevel = entity instanceof EntityRABase ? level / 10 : level / 4;
                EntityLivingBase targetEntity = (EntityLivingBase)result.field_72308_g;
                targetEntity.func_70653_a((Entity)entity, 0.6f + extraKnock, (double)MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180)))));
                targetEntity.func_70024_g(0.0, (double)yKnock, 0.0);
                targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity), (float)(5 + level * 2));
                targetEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 + level * 6, slownessLevel));
                for (EntityLivingBase entitylivingbase : world.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(5.0, 1.0, 5.0))) {
                    if (entitylivingbase == entity || entitylivingbase == targetEntity || entity.func_184191_r((Entity)entitylivingbase) || RARpgManager.isAllied((Entity)entity, (Entity)entitylivingbase) || !((double)entity.func_70032_d((Entity)entitylivingbase) < 9.0)) continue;
                    entitylivingbase.func_70653_a((Entity)entity, 0.4f + extraKnock, (double)MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180)))));
                    entitylivingbase.func_70024_g(0.0, 0.2 + 0.02 * (double)level, 0.0);
                    if (!(entitylivingbase instanceof EntityCreature) || entitylivingbase instanceof EntityRABase) {
                        entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity), (float)(5 + level));
                    }
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 + level * 6, slownessLevel));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case STEALTH_KILL: {
                RayTraceResult res2 = RayTraceHelper.getLookTarget(entity, 4.0, true);
                if (res2 == null || res2.field_72313_a != RayTraceResult.Type.ENTITY || !(res2.field_72308_g instanceof EntityLivingBase)) break;
                EntityLivingBase targetEntity = (EntityLivingBase)res2.field_72308_g;
                if (!world.field_72995_K) break;
                Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketAttackEntity(targetEntity.func_145782_y(), 40 + level * 6, SkillId.CAMOUFLAGE.getId()));
                data.setSkillCooldown(SkillId.CAMOUFLAGE.getId(), 0);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case EXECUTE: {
                RayTraceResult res2x = RayTraceHelper.getLookTarget(entity, 4.0, true);
                if (!world.field_72995_K || res2x == null || res2x.field_72313_a != RayTraceResult.Type.ENTITY || !(res2x.field_72308_g instanceof EntityLivingBase)) break;
                EntityLivingBase targetEntity = (EntityLivingBase)res2x.field_72308_g;
                Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketAttackEntity(targetEntity.func_145782_y(), 40 + level * 6));
                entity.func_184609_a(EnumHand.MAIN_HAND);
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case UNBREAKABLE: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20 * (7 + level / 2), 3, false, true));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20 * (7 + level / 2), level / 3, false, true));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20 * (7 + level / 2), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case HOLD_THE_LINE: {
                if (!entity.field_70170_p.field_72995_K) {
                    int duration = (int)(10.0f + (float)level * 1.5f) * 20;
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration, 1, false, true));
                    entity.func_70690_d(new PotionEffect(EffectRegistry.HOLD, duration, 0, false, true));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, duration, level / 4, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case FURY_SLICE: {
                if (!entity.field_70170_p.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(EffectRegistry.FURY_SLICE, 20 * (5 + level / 2), 0, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case BROTHERS_OF_THE_MINE: {
                if (!world.field_72995_K) {
                    double radius = 7.0 + (double)level * 0.8;
                    List nearby = world.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(radius), e -> e != entity && !e.field_70128_L && e.func_70104_M());
                    for (EntityLivingBase e4 : nearby) {
                        boolean ally = e4.hasCapability(RpgDataProvider.RPG_DATA, null) && RpgData.getRpgData((Entity)e4).getNation().equalsIgnoreCase(data.getNation());
                        if (!ally) continue;
                        e4.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20 * (10 + level * 2), level / 3, false, true));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20 * (10 + level * 2), level / 3));
                        entity.func_70690_d(new PotionEffect(EffectRegistry.DIGGY_DIGGY_HOLE, 20 * (10 + level * 2), 0));
                    }
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20 * (10 + level * 2)));
                    entity.func_70690_d(new PotionEffect(EffectRegistry.DIGGY_DIGGY_HOLE, 20 * (10 + level * 2), 0));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 20 * (10 + level), level / 5, false, true));
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case DIGGY_DIGGY_HOLE: {
                int digDur = 20 * (20 + level * 2);
                entity.func_70690_d(new PotionEffect(EffectRegistry.DIGGY_DIGGY_HOLE, digDur, level));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, digDur, level / 3));
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
                break;
            }
            case BLAST_MINE: {
                int yDir;
                RayTraceResult res_mine = RayTraceHelper.getLookTarget(entity, 4.0, true);
                if (res_mine == null || res_mine.field_72313_a != RayTraceResult.Type.BLOCK) break;
                EnumFacing facing = entity.func_174811_aO();
                BlockPos pos = res_mine.func_178782_a();
                int depth = 2 + level;
                int size = 1 + level / 3;
                int n = entity.field_70125_A > 35.0f ? -1 : (yDir = entity.field_70125_A < -35.0f ? 1 : 0);
                if (yDir != 0) {
                    facing = yDir > 0 ? EnumFacing.UP : EnumFacing.DOWN;
                    for (int d = 0; d < depth; ++d) {
                        for (int w = -size; w < size + 1; ++w) {
                            for (int h = -size; h < size + 1; ++h) {
                                BlockPos breakPos = pos.func_177982_a(h, 0, w);
                                if (world.func_180495_p(breakPos).func_185904_a() != Material.field_151576_e || world.func_180495_p(breakPos).func_177230_c() == Blocks.field_150357_h) continue;
                                world.func_175655_b(breakPos, true);
                            }
                        }
                        pos = pos.func_177972_a(facing);
                    }
                } else {
                    for (int d = 0; d < depth; ++d) {
                        for (int w = -size; w < size + 1; ++w) {
                            for (int h = -1; h < size * 2; ++h) {
                                BlockPos breakPos;
                                BlockPos blockPos = breakPos = facing.func_176740_k() == EnumFacing.Axis.X ? pos.func_177982_a(0, h, w) : pos.func_177982_a(w, h, 0);
                                if (world.func_180495_p(breakPos).func_185904_a() != Material.field_151576_e) continue;
                                world.func_175655_b(breakPos, true);
                            }
                        }
                        pos = pos.func_177972_a(facing);
                    }
                }
                data.setSkillCooldown(skill.getId(), RARpgManager.getCooldownForSkill(data, skill));
            }
        }
        if (entity instanceof EntityRABase) {
            data.setSkillCooldown(skill.getId(), data.getSkillCooldown(skill.getId()) / 2);
        }
    }

    public static Vec3d normalize2D(Vec3d vec) {
        double length = Math.sqrt(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c);
        return length == 0.0 ? new Vec3d(0.0, 0.0, 0.0) : new Vec3d(vec.field_72450_a / length, 0.0, vec.field_72449_c / length);
    }

    public static boolean isValidClass(String clas) {
        for (ClassId c : ClassId.values()) {
            if (!c.name().equals(clas)) continue;
            return true;
        }
        return false;
    }

    public static enum SkillId {
        ESCAPE(true, "minecraft:feather", 120),
        AGILITY(true, "ranger_boots", 150),
        RAPID_FIRE(true, "recurve_bow", 160),
        STEALTH_KILL(true, "saxe", 110),
        STEALTH,
        CAMOUFLAGE,
        POWER_DRAW,
        POWER_THROW,
        QUICK_DRAW,
        RIDING,
        FLAMING_ARROWS,
        SHIELD_BASH(true, "araluen_shield", 110),
        CHARGE(true, "short_sword", 120),
        SPIN_ATTACK(true, "broad_sword", 130),
        STRENGTH,
        LEADERSHIP,
        RESISTANCE,
        VITALITY,
        FATALITY,
        FIRST_STRIKE,
        BERSERKER(true, "skandian_axe", 180),
        GROUND_POUND(true, "minecraft:dirt", 140),
        FATAL_SHOT(true, "longbow", 150),
        HEALTH,
        LANCE_MASTERY,
        HEAL(true, "minecraft:potion", 130),
        TEAR(true, "wargal_axe", 140),
        REINFORCEMENTS(true, "minecraft:spawn_egg", 180),
        GROWL(true, "minecraft:melon_seeds", 150),
        CLIMBING,
        UNBREAKABLE(true, "minecraft:bedrock", 180),
        FURY_SLICE(true, "senshi_katana", 160),
        DIGGY_DIGGY_HOLE(true, "minecraft:golden_pickaxe", 120),
        IRONFLESH,
        STABLE_FOOTING,
        BROTHERS_OF_THE_MINE(true, "celtic_iron_pickaxe", 140),
        MASTER_MINER,
        BLAST_MINE(true, "minecraft:tnt", 140),
        HOLD_THE_LINE(true, "minecraft:shield", 180),
        EXECUTE(true, "minecraft:diamond_axe", 120),
        BASH,
        FINAL_STAND,
        DEFENDER,
        TACTICS,
        CAVALRY_CHARGE,
        ARMORER,
        VOLLEY,
        CAVE_DWELLER,
        KIND_MASTER,
        UNBREAKABLE_BOND,
        MULTI_SHOT,
        HORSE_WHISPERER,
        BYPASS_DEFENSE,
        COUNTER,
        WILDERNESS_DWELLER,
        TOUGH_HIDE,
        HUMAN_SPEECH,
        PACK_LOYALTY,
        WILD_BEAST,
        SHARED_THOUGHT,
        SEAFARER,
        RAGE,
        FEAST,
        SHIELD_BREAKER,
        BROTHERBAND,
        VALLASVOW,
        PICK_OFF,
        VULTURE,
        CAREFUL_RIDER,
        LEAD_ARCHER,
        SUN_HARDENED,
        BLITZ,
        SANDSTORM_SLASH,
        DISCIPLINE,
        PARRY,
        FINESSE,
        HONOR,
        MERCILESS,
        CLOSE_COMBAT,
        VANISH,
        MISDIRECTION,
        HIGHLAND_AMBUSH,
        TENACIOUS_FIGHTER,
        PRIMITIVE_TAILOR;

        public final boolean usable;
        public final String item;
        public final int cooldown;

        private SkillId() {
            this(false, "", 0);
        }

        private SkillId(boolean usable, String item, int cooldown) {
            this.usable = usable;
            this.item = item;
            this.cooldown = cooldown;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public String getId() {
            return this.name().toLowerCase();
        }
    }

    public static enum ClassId {
        RANGER,
        ARALUEN_KNIGHT,
        SKANDIAN_WARRIOR,
        TEMUJAI_WARRIOR,
        TEMUJAI_ARCHER,
        SCOTTI_WARRIOR,
        ARRIDI_WARRIOR,
        BEDULLIN,
        TUALAGHI,
        SENSHI,
        WARGAL,
        KALKARA,
        BANDIT,
        CELTIC_MINER;


        public String getId() {
            return this.name().toLowerCase();
        }
    }

    public static enum NationId {
        ARALUEN,
        SKANDIA,
        TEMUJAI,
        SCOTTI,
        ARRIDA,
        BEDULLIN,
        TUALAGHI,
        NIHON_JA,
        MORGARATH,
        MACHADDISH_ALLIANCE;


        public String getId() {
            return this.name().toLowerCase();
        }
    }
}

