/*
 * Decompiled with CFR 0.152.
 */
package ranger.rpg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ranger.Ranger;
import ranger.entities.EntityRABase;
import ranger.packet.PacketClimb;
import ranger.packet.PacketSetInt;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgDataProvider;
import ranger.rpg.Skill;

public class RpgData
implements IRpgData {
    private String nation = "";
    private String classId = "";
    private int selectedSkill = 0;
    private float woundDamage = 0.0f;
    private final Map<String, Integer> classLevels = new HashMap<String, Integer>();
    private final Map<String, Integer> classXP = new HashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> classSkillLevels = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Integer> skillCooldown = new HashMap<String, Integer>();
    protected Entity entity;
    private final List<UUID> hiredEntityUUIDs = new ArrayList<UUID>();
    public int spinCount = 0;
    public int climbStamina = 0;
    public int slashCount = 0;
    public int chargeCount = 0;
    public double chargeMultiplierX;
    public double chargeMultiplierZ;
    public boolean cavalryCharge = false;
    public int stealthAttacks = 0;
    public int prevFoodLevel = 0;
    public int timeSinceLastAttack = 0;
    public float foodCheck = 0.0f;
    private final Map<String, Map<String, Integer>> weaponProgression = new HashMap<String, Map<String, Integer>>();
    private final Map<Integer, Float> damageToEntities = new HashMap<Integer, Float>();
    private final Set<String> killedNations = new HashSet<String>();
    private ItemStack prevHeldItem;

    public RpgData() {
    }

    public RpgData(Entity entity) {
        this.entity = entity;
    }

    @Override
    public String getNation() {
        return this.nation;
    }

    @Override
    public void setNation(String nation) {
        this.nation = nation;
    }

    @Override
    public String getClassId() {
        return this.classId;
    }

    @Override
    public void setClassId(String classId) {
        this.classId = classId;
    }

    @Override
    public int getLevel() {
        return this.classLevels.computeIfAbsent(this.getClassId(), k -> 0);
    }

    @Override
    public void setLevel(int level) {
        this.classLevels.put(this.getClassId(), level);
    }

    @Override
    public Map<String, Integer> getAllLevels() {
        return this.classLevels;
    }

    @Override
    public int getXP() {
        return this.classXP.computeIfAbsent(this.getClassId(), k -> 0);
    }

    public static int getXPForLevel(int level) {
        int scale = 25;
        return scale * level * level;
    }

    @Override
    public int getXPToNextLevel() {
        return RpgData.getXPForLevel(this.getLevel());
    }

    @Override
    public void addXP(int xp) {
        this.classXP.put(this.getClassId(), this.getXP() + xp);
        if (this.getXP() >= this.getXPToNextLevel() && this.getLevel() < 100) {
            this.setLevel(this.getLevel() + 1);
        }
    }

    @Override
    public void setXP(int xp) {
        this.classXP.put(this.getClassId(), xp);
    }

    @Override
    public Map<String, Integer> getAllXP() {
        return this.classXP;
    }

    @Override
    public int getSelectedSkill() {
        return this.selectedSkill;
    }

    @Override
    public void setSelectedSkill(int id) {
        this.selectedSkill = id;
    }

    @Override
    public int getSkillCooldown(String skillId) {
        return this.skillCooldown.computeIfAbsent(skillId, k -> 0);
    }

    @Override
    public void setSkillCooldown(String skillId, int cooldown) {
        this.skillCooldown.put(skillId, cooldown);
    }

    @Override
    public Map<String, Map<String, Integer>> getAllSkillLevels() {
        return this.classSkillLevels;
    }

    @Override
    public Map<String, Integer> getSkillLevelsForClass(String classId) {
        return this.classSkillLevels.computeIfAbsent(classId, k -> new HashMap());
    }

    @Override
    public void setSkillLevelsForClass(String classId, Map<String, Integer> classSkillLevels) {
        this.classSkillLevels.put(classId, classSkillLevels);
    }

    @Override
    public void setSkillLevel(String skillId, int level) {
        this.classSkillLevels.computeIfAbsent(this.getClassId(), k -> new HashMap()).put(skillId, level);
    }

    @Override
    public int getSkillLevel(String skillId) {
        Map<String, Integer> skillMap = this.classSkillLevels.get(this.getClassId());
        return skillMap != null ? skillMap.getOrDefault(skillId, 0) : 0;
    }

    @Override
    public void setSkillLevel(String classId, String skillId, int level) {
        this.classSkillLevels.computeIfAbsent(classId, k -> new HashMap()).put(skillId, level);
    }

    @Override
    public int getSkillLevel(String classId, String skillId) {
        Map<String, Integer> skillMap = this.classSkillLevels.get(classId);
        return skillMap != null ? skillMap.getOrDefault(skillId, 0) : 0;
    }

    @Override
    public int getAvailableSkillPoints() {
        int skillPoints = this.getLevel();
        RAClass raClass = RARpgManager.classMap.get(this.getClassId());
        if (raClass != null) {
            for (int i = 0; i < raClass.skills.size(); ++i) {
                Skill skill = RARpgManager.getSkill(raClass.skills.get(i));
                int level = this.getSkillLevel(skill.id);
                for (int i2 = 0; i2 < Math.min(level, skill.upgrades.size()); ++i2) {
                    skillPoints -= skill.upgrades.get((int)i2).cost;
                }
            }
        }
        return skillPoints;
    }

    @Override
    public void setWeaponProgression(String item, int amount) {
        this.weaponProgression.computeIfAbsent(this.getClassId(), k -> new HashMap()).put(item, amount);
    }

    @Override
    public int getWeaponProgression(String item) {
        return this.weaponProgression.computeIfAbsent(this.getClassId(), k -> new HashMap()).getOrDefault(item, 0);
    }

    @Override
    public Map<String, Integer> getWeaponProgressionForClass(String classId) {
        return this.weaponProgression.computeIfAbsent(this.getClassId(), k -> new HashMap());
    }

    @Override
    public Map<String, Map<String, Integer>> getAllWeaponProgression() {
        return this.weaponProgression;
    }

    @Override
    public float getWoundDamage() {
        return this.woundDamage;
    }

    @Override
    public void setWoundDamage(float damage) {
        this.woundDamage = damage;
    }

    @Override
    public List<UUID> getHiredEntityUUIDs() {
        return this.hiredEntityUUIDs;
    }

    @Override
    public void setSpinCount(int count) {
        this.spinCount = count;
    }

    @Override
    public void setSlashCount(int count) {
        this.slashCount = count;
    }

    @Override
    public void startCharge(int length, double multX, double multZ, boolean cavalry) {
        this.chargeCount = length;
        this.chargeMultiplierX = multX;
        this.chargeMultiplierZ = multZ;
        this.cavalryCharge = cavalry;
    }

    @Override
    public int getStealthAttacks() {
        return this.stealthAttacks;
    }

    @Override
    public void setStealthAttacks(int value) {
        this.stealthAttacks = value;
    }

    @Override
    public Map<Integer, Float> getDamageToEntities() {
        return this.damageToEntities;
    }

    @Override
    public Set<String> getKilledNations() {
        return this.killedNations;
    }

    @Override
    public int getTimeSinceLastAttack() {
        return this.timeSinceLastAttack;
    }

    @Override
    public void setTimeSinceLastAttack(int time) {
        this.timeSinceLastAttack = time;
    }

    @Override
    public void update() {
        Skill.SkillUpgrade upgrade;
        ++this.timeSinceLastAttack;
        for (Map.Entry<String, Integer> entry : this.skillCooldown.entrySet()) {
            if (entry.getValue() <= 0) continue;
            entry.setValue(entry.getValue() - 1);
        }
        if (this.spinCount > 0) {
            int rate = 15;
            this.spinCount -= rate;
            this.getEntity().field_70177_z += (float)rate;
            if (this.getEntity() instanceof EntityPlayer && this.getEntity().field_70170_p.field_72995_K) {
                Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketSetInt(1, (int)this.getEntity().field_70177_z));
                ((EntityPlayer)this.getEntity()).func_184609_a(EnumHand.MAIN_HAND);
            }
        }
        if (this.slashCount > 0 && this.entity instanceof EntityLivingBase) {
            --this.slashCount;
            EntityLivingBase elb = (EntityLivingBase)this.entity;
            Skill.SkillUpgrade ssUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.SANDSTORM_SLASH.getId()).getCurrentUpgrade(this);
            World world = elb.field_70170_p;
            if (world instanceof WorldServer) {
                double d0 = (double)(-MathHelper.func_76126_a((float)(this.entity.field_70177_z * ((float)Math.PI / 180)))) * 2.0;
                double d1 = (double)MathHelper.func_76134_b((float)(this.entity.field_70177_z * ((float)Math.PI / 180))) * 2.0;
                Random rand = new Random();
                float yOff = rand.nextFloat() * 2.0f;
                List nearby = world.func_175647_a(EntityLivingBase.class, this.entity.func_174813_aQ().func_72317_d(d0 += (double)(rand.nextFloat() * 2.0f - 1.0f), (double)yOff, d1 += (double)(rand.nextFloat() * 2.0f - 1.0f)).func_186662_g(5.0), e -> e != this.entity && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(elb, e, "enemy"));
                for (EntityLivingBase entityLivingBase : nearby) {
                    if (this.entity instanceof EntityPlayer) {
                        entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.entity)), ssUpgrade.damage);
                    } else {
                        entityLivingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)elb), ssUpgrade.damage);
                    }
                    entityLivingBase.field_70172_ad = 11;
                    entityLivingBase.field_70179_y = 0.0;
                    entityLivingBase.field_70181_x = 0.0;
                    entityLivingBase.field_70159_w = 0.0;
                }
                this.entity.field_70170_p.func_184148_a(null, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, SoundEvents.field_187730_dW, this.entity.func_184176_by(), 1.0f, 1.0f);
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, this.entity.field_70165_t + d0, this.entity.field_70163_u + (double)this.entity.field_70131_O * 0.5 + (double)yOff, this.entity.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
            }
            elb.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (this.chargeCount > 0) {
            Entity target = this.cavalryCharge ? this.getEntity().func_184187_bx() : this.getEntity();
            --this.chargeCount;
            if (target.field_70122_E) {
                target.func_70024_g(0.75 * this.chargeMultiplierX, 0.0, 0.75 * this.chargeMultiplierZ);
            }
            if (this.getEntity() instanceof EntityPlayer && target instanceof EntityLivingBase) {
                EntityPlayer player = (EntityPlayer)this.getEntity();
                player.func_184609_a(EnumHand.MAIN_HAND);
                Skill skill = RARpgManager.getSkill(this.cavalryCharge ? RARpgManager.SkillId.CAVALRY_CHARGE.getId() : RARpgManager.SkillId.CHARGE.getId());
                Skill.SkillUpgrade upgrade2 = skill.getCurrentUpgrade(this);
                if (!player.field_70170_p.field_72995_K && upgrade2 != null) {
                    double radius = 3.0;
                    List nearby = player.field_70170_p.func_175647_a(EntityLivingBase.class, target.func_174813_aQ().func_186662_g(radius), e -> e != this.entity && !e.field_70128_L && e.func_70104_M() && !RARpgManager.isAllied(this.entity, (Entity)e) && e.field_70172_ad <= 5 && (!(e instanceof EntityAnimal) || e instanceof EntityRABase));
                    Vec3d chargeDir = new Vec3d(this.chargeMultiplierX, 0.0, this.chargeMultiplierZ).func_72432_b();
                    for (EntityLivingBase e2 : nearby) {
                        if (e2 instanceof EntityRABase) {
                            ((EntityRABase)e2).func_70624_b(null);
                            e2.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 10, 5));
                        }
                        double baseDamage = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                        e2.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), (float)(baseDamage + (double)upgrade2.damage));
                        e2.field_70179_y = 0.0;
                        e2.field_70181_x = 0.0;
                        e2.field_70159_w = 0.0;
                        Vec3d toEntity = new Vec3d(e2.field_70165_t - target.field_70165_t, 0.0, e2.field_70161_v - target.field_70161_v).func_72432_b();
                        double cross = chargeDir.field_72450_a * toEntity.field_72449_c - chargeDir.field_72449_c * toEntity.field_72450_a;
                        Vec3d knockbackDir = cross > 0.0 ? new Vec3d(-chargeDir.field_72449_c, 0.0, chargeDir.field_72450_a) : new Vec3d(chargeDir.field_72449_c, 0.0, -chargeDir.field_72450_a);
                        double knockbackStrength = upgrade2.horizontalKnockback;
                        e2.func_70024_g(knockbackDir.field_72450_a * knockbackStrength, (double)upgrade2.verticalKnockback, knockbackDir.field_72449_c * knockbackStrength);
                        e2.field_70133_I = true;
                    }
                }
            }
        }
        if (this.entity instanceof EntityPlayer) {
            int foodLevel;
            int climbValue;
            EntityPlayer player = (EntityPlayer)this.entity;
            if (this.prevHeldItem != player.func_184614_ca()) {
                this.timeSinceLastAttack = 0;
            }
            this.prevHeldItem = player.func_184614_ca();
            Skill.SkillUpgrade cdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.CLIMBING.getId()).getCurrentUpgrade(this);
            int n = climbValue = cdUpgrade != null ? (int)cdUpgrade.value : 0;
            if (player.field_70123_F && player.field_191988_bg > 0.0f && !player.field_70122_E) {
                if (this.climbStamina > 0) {
                    Ranger.RANGER_CHANNEL.sendToServer((IMessage)new PacketClimb());
                    player.field_70181_x = player.func_70093_af() ? 0.0 : 0.2;
                    player.field_70143_R = 0.0f;
                    player.field_70133_I = true;
                    if (!(player.func_70617_f_() || player.func_70093_af() && player.field_70173_aa % 3 != 0)) {
                        --this.climbStamina;
                    }
                }
            } else if (this.climbStamina < climbValue) {
                ++this.climbStamina;
            }
            Skill.SkillUpgrade wdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.WILDERNESS_DWELLER.getId()).getCurrentUpgrade(this);
            Skill.SkillUpgrade shUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.SUN_HARDENED.getId()).getCurrentUpgrade(this);
            float foodVal = 0.0f;
            if (wdUpgrade != null) {
                foodVal += wdUpgrade.value;
            }
            if (shUpgrade != null) {
                foodVal += shUpgrade.value;
            }
            if (foodVal > 0.0f && this.prevFoodLevel > (foodLevel = player.func_71024_bL().func_75116_a())) {
                this.foodCheck += foodVal;
                if (this.foodCheck >= 1.0f) {
                    this.foodCheck -= 1.0f;
                    player.func_71024_bL().func_75114_a(this.prevFoodLevel);
                }
            }
            this.prevFoodLevel = player.func_71024_bL().func_75116_a();
        }
        if ((upgrade = RARpgManager.getSkill(RARpgManager.SkillId.CAMOUFLAGE.getId()).getCurrentUpgrade(this)) != null && (float)this.stealthAttacks < upgrade.value && this.entity.field_70173_aa % (upgrade.cooldown * 20) == 0) {
            ++this.stealthAttacks;
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public static IRpgData getRpgData(Entity entity) {
        return (IRpgData)entity.getCapability(RpgDataProvider.RPG_DATA, null);
    }
}

