/*
 * Decompiled with CFR 0.152.
 */
package ranger.rpg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import ranger.rpg.IRpgData;

public class RpgDataStorage
implements Capability.IStorage<IRpgData> {
    public static final int EDITION = 1;

    public NBTBase writeNBT(Capability<IRpgData> capability, IRpgData instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("edition", 1);
        tag.func_74778_a("Nation", instance.getNation());
        tag.func_74778_a("ClassId", instance.getClassId());
        NBTTagCompound levelTag = new NBTTagCompound();
        for (Map.Entry<String, Integer> entry : instance.getAllLevels().entrySet()) {
            levelTag.func_74768_a(entry.getKey(), entry.getValue().intValue());
        }
        tag.func_74782_a("Levels", (NBTBase)levelTag);
        NBTTagCompound xpTag = new NBTTagCompound();
        for (Map.Entry<String, Integer> entry : instance.getAllXP().entrySet()) {
            xpTag.func_74768_a(entry.getKey(), entry.getValue().intValue());
        }
        tag.func_74782_a("XP", (NBTBase)xpTag);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        for (Map.Entry<String, Map<String, Integer>> entry : instance.getAllSkillLevels().entrySet()) {
            NBTTagCompound skillMapTag = new NBTTagCompound();
            for (Map.Entry<String, Integer> skillEntry : entry.getValue().entrySet()) {
                skillMapTag.func_74768_a(skillEntry.getKey(), skillEntry.getValue().intValue());
            }
            nBTTagCompound2.func_74782_a(entry.getKey(), (NBTBase)skillMapTag);
        }
        tag.func_74782_a("SkillLevels", (NBTBase)nBTTagCompound2);
        tag.func_74782_a("Skills", (NBTBase)nBTTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (UUID uuid : instance.getHiredEntityUUIDs()) {
            tagList.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        tag.func_74782_a("HiredUUIDs", (NBTBase)tagList);
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        for (Map.Entry<String, Map<String, Integer>> classEntry : instance.getAllWeaponProgression().entrySet()) {
            NBTTagCompound weaponDataTag = new NBTTagCompound();
            for (Map.Entry<String, Integer> we : classEntry.getValue().entrySet()) {
                weaponDataTag.func_74768_a(we.getKey(), we.getValue().intValue());
            }
            nBTTagCompound3.func_74782_a(classEntry.getKey(), (NBTBase)weaponDataTag);
        }
        tag.func_74782_a("WeaponProgression", (NBTBase)nBTTagCompound3);
        tag.func_74768_a("StealthAttacks", instance.getStealthAttacks());
        return tag;
    }

    public void readNBT(Capability<IRpgData> capability, IRpgData instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        int edition = tag.func_74762_e("edition");
        try {
            instance.setNation(tag.func_74779_i("Nation"));
            instance.setClassId(tag.func_74779_i("ClassId"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        NBTTagCompound levelTag = tag.func_74775_l("Levels");
        HashMap<String, Integer> allLevels = new HashMap<String, Integer>();
        for (String classId : levelTag.func_150296_c()) {
            allLevels.put(classId, levelTag.func_74762_e(classId));
        }
        instance.getAllLevels().clear();
        instance.getAllLevels().putAll(allLevels);
        NBTTagCompound xpTag = tag.func_74775_l("XP");
        HashMap<String, Integer> allXP = new HashMap<String, Integer>();
        for (String classId : xpTag.func_150296_c()) {
            allXP.put(classId, xpTag.func_74762_e(classId));
        }
        instance.getAllXP().clear();
        instance.getAllXP().putAll(allXP);
        NBTTagCompound skillData = tag.func_74775_l("SkillLevels");
        HashMap allSkills = new HashMap();
        for (String classId : skillData.func_150296_c()) {
            NBTTagCompound skillMapTag = skillData.func_74775_l(classId);
            HashMap<String, Integer> skillMap = new HashMap<String, Integer>();
            for (String skillId : skillMapTag.func_150296_c()) {
                skillMap.put(skillId, skillMapTag.func_74762_e(skillId));
            }
            allSkills.put(classId, skillMap);
        }
        instance.getAllSkillLevels().clear();
        instance.getAllSkillLevels().putAll(allSkills);
        ArrayList<UUID> uuidSet = new ArrayList<UUID>();
        if (((NBTTagCompound)nbt).func_150297_b("HiredUUIDs", 9)) {
            NBTTagList tagList = ((NBTTagCompound)nbt).func_150295_c("HiredUUIDs", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String uuidStr = tagList.func_150307_f(i);
                try {
                    uuidSet.add(UUID.fromString(uuidStr));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        instance.getHiredEntityUUIDs().clear();
        instance.getHiredEntityUUIDs().addAll(uuidSet);
        NBTTagCompound weaponProgressionTag = tag.func_74775_l("WeaponProgression");
        HashMap allProgression = new HashMap();
        for (String classId : weaponProgressionTag.func_150296_c()) {
            NBTTagCompound progTag = weaponProgressionTag.func_74775_l(classId);
            HashMap<String, Integer> progMap = new HashMap<String, Integer>();
            for (String we : progTag.func_150296_c()) {
                progMap.put(we, progTag.func_74762_e(we));
            }
            allProgression.put(classId, progMap);
        }
        instance.getAllWeaponProgression().clear();
        instance.getAllWeaponProgression().putAll(allProgression);
        instance.setStealthAttacks(tag.func_74762_e("StealthAttacks"));
        if (edition != 1) {
            instance.getAllSkillLevels().clear();
        }
    }
}

