/*
 * Decompiled with CFR 0.152.
 */
package ranger.rpg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import ranger.entities.EntityRABase;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityWargal;
import ranger.items.ItemKnife;
import ranger.items.ItemThrowableWeapon;
import ranger.items.RAItemLoader;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class Skill {
    public String id;
    public String description;
    public String category;
    public String item;
    public boolean usable;
    public boolean playerOnly;
    public int meta;
    public List<SkillEffect> skillEffects = new ArrayList<SkillEffect>();
    public List<SkillUpgrade> upgrades = new ArrayList<SkillUpgrade>();
    public Map<String, String> itemOverrides = new HashMap<String, String>();
    public Map<String, String> categoryOverrides = new HashMap<String, String>();
    public List<String> requirements = new ArrayList<String>();
    public boolean alwaysRun;
    boolean requireAny = false;

    public boolean checkRequirements(EntityLivingBase entity, SkillUpgrade upgrade) {
        for (String requirement : this.requirements) {
            boolean pass = false;
            int requiredCount = 0;
            if (requirement.contains(":")) {
                String[] split = requirement.split(":");
                requirement = split[0];
                requiredCount = Integer.parseInt(split[1]);
            }
            switch (requirement) {
                case "in_dry": {
                    pass = BiomeDictionary.hasType((Biome)entity.field_70170_p.func_180494_b(entity.func_180425_c()), (BiomeDictionary.Type)BiomeDictionary.Type.DRY);
                    break;
                }
                case "in_sunlight": {
                    pass = entity.field_70170_p.func_72935_r() && entity.field_70170_p.func_175678_i(entity.func_180425_c());
                    break;
                }
                case "in_dark": {
                    pass = !entity.field_70170_p.func_72935_r() || entity.field_70170_p.func_175699_k(entity.func_180425_c()) < 7;
                    break;
                }
                case "is_sneaking": {
                    pass = entity.func_70093_af();
                    break;
                }
                case "holding_knife": {
                    pass = entity.func_184614_ca().func_77973_b() instanceof ItemKnife || entity.func_184614_ca().func_77973_b() == RAItemLoader.getItem("throwing_knife");
                    break;
                }
                case "always_run": {
                    pass = true;
                    break;
                }
                case "low_health": {
                    pass = entity.func_110143_aJ() <= entity.func_110138_aP() / 2.0f;
                    break;
                }
                case "allies": 
                case "allies_same_nation": 
                case "allies_same_class": {
                    if (upgrade == null) break;
                    String finalRequirement = requirement;
                    List nearby = entity.field_70170_p.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g((double)upgrade.range), e -> e != entity && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(entity, e, finalRequirement));
                    pass = nearby != null && nearby.size() >= requiredCount;
                    break;
                }
            }
            if (this.requireAny && pass) {
                return true;
            }
            if (pass || this.requireAny) continue;
            return false;
        }
        return !this.requireAny;
    }

    public SkillUpgrade getCurrentUpgrade(IRpgData rpgData) {
        int level = Math.min(rpgData.getSkillLevel(this.id), this.upgrades.size());
        return level > 0 ? this.upgrades.get(level - 1) : null;
    }

    public SkillUpgrade getNextUpgrade(IRpgData rpgData) {
        return this.upgrades.get(Math.min(rpgData.getSkillLevel(this.id), this.upgrades.size() - 1));
    }

    public void applyEffects(EntityLivingBase source, EntityLivingBase entity, Skill skill, SkillUpgrade upgrade) {
        for (SkillEffect effect : this.skillEffects) {
            effect.performActions(source, entity, skill, upgrade);
            effect.applyPotionEffects(entity, upgrade);
        }
    }

    public class SkillUpgrade {
        public int cooldown;
        public int cost;
        public int modifier;
        public int duration;
        public float damage;
        public int range;
        public float horizontalKnockback;
        public float verticalKnockback;
        public String tooltip;
        public float value;
    }

    public class SkillEffect {
        public String effectType = "self";
        public String effectTarget = "user";
        public List<String> potionEffects;
        public List<String> actions;
        public boolean spread;

        public void applyPotionEffects(EntityLivingBase entity, SkillUpgrade upgrade) {
            if (this.potionEffects == null || upgrade.duration <= 0) {
                return;
            }
            for (String potion : this.potionEffects) {
                if (entity.field_70170_p.field_72995_K) continue;
                int level = upgrade.modifier;
                String[] split = potion.split(";");
                if (split.length > 1) {
                    level = Integer.parseInt(split[1]);
                }
                String effect = split[0];
                Potion p = Potion.func_180142_b((String)effect);
                boolean lightParticles = !effect.equalsIgnoreCase("ranger:berserk") && !effect.equalsIgnoreCase("ranger:fatal_shot") && !effect.equalsIgnoreCase("minecraft:regeneration");
                boolean particles = !effect.equalsIgnoreCase("ranger:counter");
                entity.func_70690_d(new PotionEffect(p, upgrade.duration * 20, level, lightParticles, particles));
            }
        }

        public void performActionsOnBlock(EntityLivingBase source, BlockPos pos, Skill skill, SkillUpgrade upgrade) {
            World world = source.field_70170_p;
            EnumFacing facing = source.func_174811_aO();
            Iterator<String> iterator = this.actions.iterator();
            block6: while (iterator.hasNext()) {
                String action;
                switch (action = iterator.next()) {
                    case "blast_mine": {
                        BlockPos breakPos;
                        int h;
                        int w;
                        int d;
                        int yDir;
                        int depth = (int)upgrade.value;
                        int size = (int)(upgrade.value / 3.0f);
                        int n = source.field_70125_A > 35.0f ? -1 : (yDir = source.field_70125_A < -35.0f ? 1 : 0);
                        if (yDir != 0) {
                            facing = yDir > 0 ? EnumFacing.UP : EnumFacing.DOWN;
                            for (d = 0; d < depth; ++d) {
                                for (w = -size; w < size + 1; ++w) {
                                    for (h = -size; h < size + 1; ++h) {
                                        breakPos = pos.func_177982_a(h, 0, w);
                                        if (world.func_180495_p(breakPos).func_185904_a() != Material.field_151576_e || world.func_180495_p(breakPos).func_177230_c() == Blocks.field_150357_h) continue;
                                        world.func_175655_b(breakPos, true);
                                    }
                                }
                                pos = pos.func_177972_a(facing);
                            }
                            continue block6;
                        }
                        for (d = 0; d < depth; ++d) {
                            for (w = -size; w < size + 1; ++w) {
                                for (h = -1; h < size * 2; ++h) {
                                    BlockPos blockPos = breakPos = facing.func_176740_k() == EnumFacing.Axis.X ? pos.func_177982_a(0, h, w) : pos.func_177982_a(w, h, 0);
                                    if (world.func_180495_p(breakPos).func_185904_a() != Material.field_151576_e || world.func_180495_p(breakPos).func_177230_c() == Blocks.field_150357_h) continue;
                                    world.func_175655_b(breakPos, true);
                                }
                            }
                            pos = pos.func_177972_a(facing);
                        }
                        continue block6;
                    }
                }
            }
        }

        public void performActions(EntityLivingBase source, EntityLivingBase entity, Skill skill, SkillUpgrade upgrade) {
            if (this.actions == null) {
                return;
            }
            World world = entity.field_70170_p;
            Random random = new Random();
            double rot = Math.toRadians(entity.field_70177_z);
            double xMultiplier = -Math.sin(rot);
            double zMultiplier = Math.cos(rot);
            Iterator<String> iterator = this.actions.iterator();
            block37: while (iterator.hasNext()) {
                String action;
                switch (action = iterator.next()) {
                    case "saber_sweep": {
                        if (world instanceof WorldServer) {
                            double d0 = (double)(-MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180)))) * 4.0;
                            double d1 = (double)MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * 4.0;
                            List nearby = world.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_72317_d(d0, 0.0, d1).func_186662_g(5.0), e -> e != entity && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(entity, e, "enemy"));
                            for (EntityLivingBase entityLivingBase : nearby) {
                                if (source instanceof EntityPlayer) {
                                    entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)source)), upgrade.damage);
                                    continue;
                                }
                                entityLivingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)source), upgrade.damage);
                            }
                            boolean yOff = source.func_184187_bx() == null;
                            ((WorldServer)world).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, entity.field_70165_t + d0, entity.field_70163_u + (double)entity.field_70131_O * 0.5 + (double)yOff, entity.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
                        }
                        source.func_184609_a(EnumHand.MAIN_HAND);
                        break;
                    }
                    case "refill_arrows": {
                        if (!(entity instanceof EntityRAHumanoid)) break;
                        EntityRAHumanoid humanoid = (EntityRAHumanoid)entity;
                        if (humanoid.getAmmo() >= 8) continue block37;
                        humanoid.setAmmo(8);
                        break;
                    }
                    case "pull_back": {
                        if (!(entity instanceof EntityRAHumanoid)) break;
                        EntityRAHumanoid humanoid = (EntityRAHumanoid)entity;
                        humanoid.setDefendPosX(Float.valueOf((float)source.field_70165_t));
                        humanoid.setDefendPosY(Float.valueOf((float)source.field_70163_u));
                        humanoid.setDefendPosZ(Float.valueOf((float)source.field_70161_v));
                        humanoid.func_70624_b(null);
                        humanoid.func_70604_c(null);
                        humanoid.setAction(5);
                        break;
                    }
                    case "retarget": {
                        if (world.field_72995_K || !(entity instanceof EntityLiving)) break;
                        EntityLiving living = (EntityLiving)entity;
                        living.func_70624_b(source);
                        living.func_70604_c(null);
                        break;
                    }
                    case "remove_target": {
                        if (world.field_72995_K || !(entity instanceof EntityLiving)) break;
                        EntityLiving living = (EntityLiving)entity;
                        living.func_70624_b(null);
                        living.func_70604_c(null);
                        break;
                    }
                    case "heal": {
                        if (world.field_72995_K) break;
                        entity.func_70691_i(upgrade.value);
                        break;
                    }
                    case "damage": {
                        if (world.field_72995_K) break;
                        if (source instanceof EntityPlayer) {
                            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)source)), upgrade.damage);
                            break;
                        }
                        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)source), upgrade.damage);
                        break;
                    }
                    case "explosion_particles": {
                        if (world.field_72995_K) break;
                        Vec3d center = entity.func_174791_d().func_178787_e(new Vec3d(0.0, 0.1, 0.0));
                        for (int i = 0; i < 10; ++i) {
                            ((WorldServer)world).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, center.field_72450_a + (double)(random.nextFloat() * 6.0f - 3.0f), center.field_72448_b + (double)0.2f, center.field_72449_c + (double)(random.nextFloat() * 6.0f - 3.0f), 4, 0.5, 0.1, 0.5, 0.01, new int[0]);
                        }
                        continue block37;
                    }
                    case "knockback_center": {
                        Vec3d dir = entity.func_174791_d().func_178788_d(source.func_174791_d().func_178787_e(new Vec3d(0.0, 0.1, 0.0))).func_72432_b();
                        double knockbackStrength = upgrade.horizontalKnockback;
                        entity.func_70024_g(dir.field_72450_a * knockbackStrength, (double)upgrade.verticalKnockback, dir.field_72449_c * knockbackStrength);
                        break;
                    }
                    case "knockback": {
                        entity.func_70653_a((Entity)source, upgrade.horizontalKnockback, (double)MathHelper.func_76126_a((float)(source.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(source.field_70177_z * ((float)Math.PI / 180)))));
                        entity.func_70024_g(0.0, (double)upgrade.verticalKnockback, 0.0);
                        break;
                    }
                    case "slash": {
                        RpgData.getRpgData((Entity)entity).setSlashCount((int)upgrade.value);
                        break;
                    }
                    case "charge": 
                    case "cavalry_charge": {
                        int chargeAmount = (int)((7.0f + upgrade.value) * (entity instanceof EntityRABase ? 0.5f : 1.0f));
                        RpgData.getRpgData((Entity)entity).startCharge(chargeAmount, xMultiplier, zMultiplier, action.equalsIgnoreCase("cavalry_charge"));
                        break;
                    }
                    case "leap": {
                        float am = 1.25f;
                        entity.func_70024_g(xMultiplier * (double)am, 0.5, zMultiplier * (double)am);
                        break;
                    }
                    case "reinforcements": {
                        if (entity.field_70170_p.field_72995_K) break;
                        IRpgData rpgData = RpgData.getRpgData((Entity)entity);
                        int i = 0;
                        while ((float)i < upgrade.value) {
                            EntityRAHumanoid raHumanoid = rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId()) ? new EntityWargal(world) : new EntityRAStandard(world);
                            raHumanoid.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                            raHumanoid.setTemporary(true);
                            raHumanoid.setLeader(false);
                            IRpgData rpgDataNew = RpgData.getRpgData((Entity)raHumanoid);
                            rpgDataNew.setNation(rpgData.getNation());
                            rpgDataNew.setClassId(rpgData.getClassId());
                            raHumanoid.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                            world.func_72838_d((Entity)raHumanoid);
                            raHumanoid.func_70024_g(random.nextFloat() / 2.0f, 0.0, random.nextFloat() / 2.0f);
                            ++i;
                        }
                        continue block37;
                    }
                    case "javelins": {
                        if (entity.field_70170_p.field_72995_K) break;
                        ItemThrowableWeapon throwableWeapon = (ItemThrowableWeapon)RAItemLoader.getItem("scotti_javelin");
                        int count = (int)upgrade.value;
                        count = 9;
                        int rows = (int)Math.ceil(Math.sqrt(count));
                        int cols = (int)Math.ceil((double)count / (double)rows);
                        float startPitch = entity.field_70125_A - 4.0f * ((float)cols / 2.0f);
                        entity.field_70177_z -= 4.0f * ((float)rows / 2.0f);
                        for (int i = 0; i < rows; ++i) {
                            entity.field_70177_z += 4.0f;
                            entity.field_70125_A = startPitch;
                            for (int y = 0; y < cols; ++y) {
                                entity.field_70125_A += 4.0f;
                                if (entity instanceof EntityRAHumanoid) {
                                    ((EntityRAHumanoid)entity).throwWeaponAt(((EntityRAHumanoid)entity).func_70638_az(), new ItemStack(RAItemLoader.getItem("scotti_javelin")));
                                    continue;
                                }
                                throwableWeapon.throwWeapon(entity.field_70170_p, (EntityPlayer)entity, 1.0f, false, 1.1f);
                            }
                        }
                        continue block37;
                    }
                    case "spin_attack": {
                        RpgData.getRpgData((Entity)entity).setSpinCount(360);
                    }
                }
            }
        }
    }
}

