/*
 * Decompiled with CFR 0.152.
 */
package ranger.structures;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ranger.Ranger;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.items.RAItemLoader;
import ranger.packet.PacketSyncRpgData;
import ranger.rpg.IRpgData;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;

public class RAStructure {
    String name;
    ResourceLocation lootTable;
    public Rotation rotation = Rotation.NONE;
    public String scottiClan = null;

    public RAStructure(String name, ResourceLocation lootTable) {
        this.name = name;
        this.lootTable = lootTable;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void generate(WorldServer world, BlockPos pos, Random random, boolean renderUpdate) {
        this.generate(world, pos, random, renderUpdate, this.name);
    }

    public void generate(WorldServer world, BlockPos pos, Random random, boolean renderUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("ranger", name);
        TemplateManager templatemanager = world.func_184163_y();
        templatemanager.func_186237_a(null, loc);
        Template template = templatemanager.func_189942_b(null, loc);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(this.rotation).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(false);
        BlockPos endPos = pos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)template.func_186259_a()));
        template.func_189962_a((World)world, pos, placementsettings, renderUpdate ? 3 : 2);
        AxisAlignedBB box = new AxisAlignedBB(pos, endPos);
        List entities = world.func_72872_a(EntityLiving.class, box);
        for (EntityLiving entity : entities) {
            IRpgData rpgData;
            EntityRAHumanoid raHumanoid;
            entity.func_110163_bv();
            if (entity instanceof EntityRAHumanoid) {
                raHumanoid = (EntityRAHumanoid)entity;
                raHumanoid.createHorse = false;
                world.func_73046_m().func_152344_a(() -> raHumanoid.func_180482_a(world.func_175649_E(raHumanoid.func_180425_c()), null));
                rpgData = RpgData.getRpgData((Entity)entity);
                if (this.scottiClan != null) {
                    if (this.scottiClan.equalsIgnoreCase("machaddish")) {
                        if (random.nextInt(2) == 0) {
                            raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("scotti_pants_wrap")));
                        } else {
                            raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("scotti_pants")));
                        }
                    } else {
                        raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("scotti_" + this.scottiClan + "_pants")));
                    }
                    if (!this.scottiClan.equalsIgnoreCase("mcduig") && !this.scottiClan.equalsIgnoreCase("mcforn")) {
                        rpgData.setNation(RARpgManager.NationId.MACHADDISH_ALLIANCE.getId());
                    }
                }
                rpgData.setLevel(Math.min(100, random.nextInt(100) + 1 + (raHumanoid.isLeader() ? 20 : 0)));
                raHumanoid.applyLevelModifiers(rpgData);
                Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)raHumanoid, rpgData));
            }
            if (!(entity instanceof EntityIllusionIllager) && !(entity instanceof EntityVindicator)) continue;
            raHumanoid = new EntityRAStandard((World)world);
            raHumanoid.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            raHumanoid.setLeader(false);
            rpgData = RpgData.getRpgData((Entity)raHumanoid);
            rpgData.setNation(RARpgManager.NationId.TEMUJAI.getId());
            rpgData.setClassId(entity instanceof EntityIllusionIllager ? RARpgManager.ClassId.TEMUJAI_WARRIOR.getId() : RARpgManager.ClassId.TEMUJAI_ARCHER.getId());
            raHumanoid.func_180482_a(world.func_175649_E(raHumanoid.func_180425_c()), null);
            rpgData.setLevel(Math.min(100, random.nextInt(100) + 1 + (raHumanoid.isLeader() ? 20 : 0)));
            raHumanoid.applyLevelModifiers(rpgData);
            world.func_72838_d((Entity)raHumanoid);
            entity.func_70106_y();
        }
        BlockPos.func_177975_b((BlockPos)pos, (BlockPos)endPos).forEach(p -> {
            IBlockState state = world.func_180495_p((BlockPos)p);
            if (renderUpdate) {
                world.markAndNotifyBlock((BlockPos)p, world.func_175726_f((BlockPos)p), state, state, 3);
            }
            if (state.func_177230_c() == Blocks.field_185779_df) {
                TileEntityStructure tileEntityStructure = (TileEntityStructure)world.func_175625_s((BlockPos)p);
                this.generate(world, p.func_177971_a((Vec3i)tileEntityStructure.func_189711_e()), random, renderUpdate, tileEntityStructure.func_189715_d());
                world.func_175655_b((BlockPos)p, false);
            }
            if (state.func_177230_c() == Blocks.field_150486_ae) {
                TileEntityChest tileEntityChest = (TileEntityChest)world.func_175625_s((BlockPos)p);
                tileEntityChest.func_174888_l();
                tileEntityChest.func_189404_a(this.lootTable, random.nextLong());
                tileEntityChest.func_184281_d(null);
            }
        });
        if (!renderUpdate) {
            int y = Math.min(pos.func_177956_o(), endPos.func_177956_o());
            BlockPos fillStart = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            BlockPos fillEnd = new BlockPos(endPos.func_177958_n() - 1, y, endPos.func_177952_p() - 1);
            IBlockState fillerBlock = world.func_180494_b((BlockPos)fillStart).field_76753_B;
            BlockPos.func_177975_b((BlockPos)fillStart, (BlockPos)fillEnd).forEach(p -> {
                BlockPos.MutableBlockPos fp = p;
                int count = 0;
                while (count++ < 50 && (world.func_175623_d((BlockPos)(fp = fp.func_177977_b())) || !world.func_175665_u((BlockPos)fp) || world.func_180495_p((BlockPos)fp).func_185904_a().func_76224_d())) {
                    world.func_180501_a((BlockPos)fp, fillerBlock, renderUpdate ? 3 : 2);
                }
            });
        }
        if (name.equals(this.name)) {
            this.setRotation(Rotation.NONE);
        }
    }
}

