/*
 * Decompiled with CFR 0.152.
 */
package ranger.structures;

import java.util.Random;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import ranger.structures.Structures;

public class RAWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            EnumFacing facing;
            int z;
            int y;
            int x = chunkX * 16 + random.nextInt(16) + 8;
            BlockPos pos = new BlockPos(x, y = world.func_189649_b(x, z = chunkZ * 16 + random.nextInt(16) + 8), z).func_177977_b();
            Biome biome = world.func_180494_b(pos);
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(300) == 0) {
                Structures.SKANDIAN_WOLFSHIP.generate((WorldServer)world, pos.func_177977_b(), random, false);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                int randomizer = random.nextInt(1000);
                if (randomizer == 0) {
                    Structures.RUINS_OF_GORLAN.generate((WorldServer)world, pos, random, false);
                } else if (randomizer == 1) {
                    Structures.RENEGADE_OUTPOST.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                } else if (randomizer == 2) {
                    Structures.ARALUEN_FORT.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                }
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && (y = random.nextInt(256)) == world.func_175672_r(pos = new BlockPos(x, y, z)).func_177956_o()) {
                if (random.nextInt(3) == 0) {
                    Structures.TEMUJAI_HORSE_PEN.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                    for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
                        EnumFacing rotDir;
                        if (random.nextInt(2) != 0) continue;
                        facing = EnumFacing.field_176754_o[i];
                        BlockPos gPos = pos.func_177967_a(facing, 30);
                        gPos = world.func_175672_r(gPos);
                        Structures.TEMUJAI_GER.generate((WorldServer)world, gPos.func_177977_b().func_177977_b(), random, false);
                        EnumFacing watchTowerDir = EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)];
                        if (watchTowerDir == facing.func_176734_d()) continue;
                        BlockPos wtPos = gPos.func_177967_a(watchTowerDir, 30);
                        int dir = random.nextInt(3);
                        if (dir == 1) {
                            rotDir = watchTowerDir.func_176746_e();
                            if (rotDir != facing.func_176734_d() && rotDir != watchTowerDir.func_176734_d()) {
                                wtPos = wtPos.func_177967_a(rotDir, 30);
                            }
                        } else if (dir == 2 && (rotDir = watchTowerDir.func_176735_f()) != facing.func_176734_d() && rotDir != watchTowerDir.func_176734_d()) {
                            wtPos = wtPos.func_177967_a(rotDir, 30);
                        }
                        wtPos = world.func_175672_r(wtPos);
                        if (random.nextInt(3) == 0) {
                            Structures.TEMUJAI_DOUBLE_WATCHTOWER.generate((WorldServer)world, wtPos.func_177977_b().func_177977_b(), random, false);
                            continue;
                        }
                        Structures.TEMUJAI_WATCHTOWER.generate((WorldServer)world, wtPos.func_177977_b().func_177977_b(), random, false);
                    }
                } else if (random.nextInt(3) == 0) {
                    Structures.TEMUJAI_DOUBLE_WATCHTOWER.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                } else {
                    Structures.TEMUJAI_WATCHTOWER.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                }
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && (y = random.nextInt(256)) == world.func_175672_r(pos = new BlockPos(x, y, z)).func_177956_o()) {
                Structures.RANGER_CABIN.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                y = random.nextInt(256);
                pos = new BlockPos(x, y, z);
                int structure = random.nextInt(3);
                if (y == world.func_175672_r(pos).func_177956_o() && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151595_p) {
                    if (structure == 0) {
                        if (random.nextInt(2) == 0) {
                            Structures.ARRIDI_BATH_HOUSE.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                        }
                        int villageSize = 1 + random.nextInt(3);
                        for (int vx = -villageSize; vx < villageSize; ++vx) {
                            for (int vz = -villageSize; vz < villageSize; ++vz) {
                                if (random.nextInt(2) == 0 || vx == 0 && vz == 0) continue;
                                BlockPos vp = pos.func_177982_a(30 * vx, 0, 30 * vz);
                                if (world.func_180495_p((vp = world.func_175672_r(vp)).func_177977_b()).func_185904_a() != Material.field_151595_p) continue;
                                Structures.ARRIDI_HOUSES[random.nextInt(Structures.ARRIDI_HOUSES.length)].generate((WorldServer)world, vp.func_177977_b().func_177977_b(), random, false);
                            }
                        }
                    } else if (structure == 1) {
                        Structures.TUALAGHI_LARGE_TENT.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                        facing = EnumFacing.NORTH;
                        for (int i = 0; i < 6; ++i) {
                            int faceOffset = i > 2 ? 20 * (i - 2) - 12 : 20 * (i + 1);
                            BlockPos gPos = pos.func_177967_a(facing, faceOffset).func_177967_a(i > 2 ? EnumFacing.WEST : EnumFacing.EAST, i > 2 ? -11 : 30);
                            if (i > 2) {
                                Structures.TUALAGHI_TENT.setRotation(Rotation.CLOCKWISE_180);
                            }
                            if (world.func_180495_p(gPos = world.func_175672_r(gPos)).func_185904_a().func_76224_d() || world.func_180495_p(gPos.func_177977_b()).func_185904_a() != Material.field_151595_p) continue;
                            Structures.TUALAGHI_TENT.generate((WorldServer)world, gPos.func_177977_b().func_177977_b(), random, false);
                        }
                    }
                }
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                if (random.nextInt(1000) == 0) {
                    int villageSize = 2 + random.nextInt(5);
                    for (int vx = -villageSize; vx < villageSize; ++vx) {
                        for (int vz = -villageSize; vz < villageSize; ++vz) {
                            if (random.nextInt(2) == 0) continue;
                            BlockPos vp = pos.func_177982_a(30 * vx, 0, 30 * vz);
                            if (world.func_180495_p(vp = world.func_175645_m(vp)).func_177230_c() != Blocks.field_150431_aC && world.func_180495_p(vp).func_177230_c() != Blocks.field_150433_aE || world.func_180495_p(vp.func_177977_b()).func_177230_c() instanceof BlockLeaves || world.func_180495_p(vp.func_177977_b()).func_177230_c() instanceof BlockIce) continue;
                            Structures.SKANDIAN_HOUSES[random.nextInt(Structures.SKANDIAN_HOUSES.length)].generate((WorldServer)world, vp.func_177977_b(), random, false);
                        }
                    }
                } else if (random.nextInt(500) == 0 && world.func_180495_p(pos).func_177230_c() == Blocks.field_150431_aC && world.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE) {
                    Structures.SKANDIAN_WATCHTOWER.generate((WorldServer)world, pos.func_177977_b(), random, false);
                }
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && (y = random.nextInt(256)) == world.func_175672_r(pos = new BlockPos(x, y, z)).func_177956_o()) {
                String[] clans;
                if (random.nextInt(2) == 0) {
                    clans = new String[]{"machaddish", "macfrewin", "mackentick"};
                    Structures.SCOTTI_BROCH.scottiClan = clans[random.nextInt(clans.length)];
                    Structures.SCOTTI_HUT.scottiClan = clans[random.nextInt(clans.length)];
                    Structures.SCOTTI_HUT.lootTable = Structures.SCOTTI_MACHADDISH_LOOT_TABLE;
                    Structures.SCOTTI_BROCH.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                } else {
                    clans = new String[]{"mcduig", "mcforn", "machaddish", "macfrewin", "mackentick"};
                    Structures.SCOTTI_HUT.scottiClan = clans[random.nextInt(clans.length)];
                    Structures.SCOTTI_HUT.lootTable = Structures.SCOTTI_LOOT_TABLE;
                    Structures.SCOTTI_HUT.generate((WorldServer)world, pos.func_177977_b().func_177977_b(), random, false);
                }
                for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
                    if (random.nextInt(2) != 0) continue;
                    EnumFacing facing2 = EnumFacing.field_176754_o[i];
                    BlockPos gPos = pos.func_177967_a(facing2, 30);
                    gPos = world.func_175672_r(gPos);
                    Structures.SCOTTI_HUT.generate((WorldServer)world, gPos.func_177977_b().func_177977_b(), random, false);
                }
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) && (y = random.nextInt(256)) == world.func_175672_r(pos = new BlockPos(x, y, z)).func_177956_o()) {
                if (random.nextInt(5) == 0) {
                    Structures.NIHONJA_CASTLE_SMALL.generate((WorldServer)world, pos.func_177982_a(0, -2, 0), random, false);
                } else {
                    Structures.NIHONJA_SENSHI_HOUSE.generate((WorldServer)world, pos.func_177982_a(0, -2, 0), random, false);
                }
            }
        }
    }
}

