/*
 * Decompiled with CFR 0.152.
 */
package ranger.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ranger.Ranger;
import ranger.effects.EffectRegistry;
import ranger.entities.EntityNightWarrior;
import ranger.entities.EntityRABase;
import ranger.entities.EntityRAHumanoid;
import ranger.entities.EntityRAStandard;
import ranger.entities.EntityWargal;
import ranger.items.IRAClassItem;
import ranger.items.ItemKnife;
import ranger.items.ItemRAArmor;
import ranger.items.ItemRAShield;
import ranger.items.ItemRASword;
import ranger.items.ItemWeapon;
import ranger.items.RAItemLoader;
import ranger.packet.PacketResetCooldown;
import ranger.packet.PacketSyncRpgData;
import ranger.rpg.IRpgData;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.rpg.RpgDataProvider;
import ranger.rpg.Skill;
import ranger.util.RAWorldData;

@Mod.EventBusSubscriber(modid="ranger")
public class CapabilityEvents {
    private static Field ticksSinceLastSwingField;
    private static boolean cancelNextKnockback;
    public static Random random;
    protected static final UUID ATTACK_SPEED_UUID;
    private static final Map<String, UUID> attributeMap;
    private static final Item[] RAW_MEAT_LIST;

    public static void setTicksSinceLastSwing(EntityLivingBase entity, int value) {
        try {
            if (ticksSinceLastSwingField != null) {
                ticksSinceLastSwingField.setInt(entity, value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer) && !(event.getObject() instanceof EntityRABase)) {
            return;
        }
        event.addCapability(RpgDataProvider.ID, (ICapabilityProvider)new RpgDataProvider((Entity)event.getObject()));
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IRpgData rpgData;
        if (event.getEntity() instanceof EntityPlayer && (rpgData = RpgData.getRpgData(event.getEntity())) != null && event.getEntity() != null && !event.getEntity().field_70170_p.field_72995_K) {
            Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData(event.getEntity(), rpgData));
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack classStack = new ItemStack(RAItemLoader.getItem("class_selection_book"));
            if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70431_c(classStack)) {
                player.field_71071_by.func_70441_a(classStack);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IRpgData rpgData = RpgData.getRpgData((Entity)event.player);
        if (rpgData != null) {
            Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)event.player, rpgData));
        }
    }

    @SubscribeEvent
    public static void onTrackEntity(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer || event.getTarget() instanceof EntityRABase) {
            IRpgData data = RpgData.getRpgData(event.getTarget());
            Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketSyncRpgData(event.getTarget(), data), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        IRpgData rpgData;
        EntityTameable tameable;
        IRpgData rpgData2;
        EntityLivingBase source;
        EntityLivingBase hurtEntity = event.getEntityLiving();
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            Item heldItem;
            source = (EntityLivingBase)event.getSource().func_76346_g();
            ItemStack stack = source.func_184614_ca();
            if (source.func_70644_a(EffectRegistry.WEAK)) {
                float am = (float)(source.func_70660_b(EffectRegistry.WEAK).func_76458_c() + 1) * 0.1f;
                event.setAmount(event.getAmount() * (1.0f - Math.min(am, 1.0f)));
            }
            if (source.func_70644_a(EffectRegistry.CLOSE_COMBAT) && ((heldItem = source.func_184614_ca().func_77973_b()) instanceof ItemKnife || heldItem == RAItemLoader.getItem("striker") || heldItem == RAItemLoader.getItem("double_striker"))) {
                hurtEntity.field_70172_ad = 0;
            }
            if (source.func_70644_a(EffectRegistry.FURY_SWIPES)) {
                hurtEntity.field_70172_ad = 0;
                cancelNextKnockback = true;
            }
            if (source.hasCapability(RpgDataProvider.RPG_DATA, null)) {
                Skill.SkillUpgrade bdUpgrade;
                Skill.SkillUpgrade vtUpgrade;
                List nearby;
                Skill.SkillUpgrade poUpgrade;
                EntityLivingBase owner;
                IRpgData hurtData;
                Skill.SkillUpgrade vvUpgrade;
                Skill.SkillUpgrade rgUpgrade;
                Skill.SkillUpgrade mcUpgrade;
                Skill.SkillUpgrade bzUpgrade;
                Skill.SkillUpgrade cmUpgrade;
                IRpgData rpgData3 = RpgData.getRpgData((Entity)source);
                if (source.func_82150_aj() && (cmUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.CAMOUFLAGE.getId()).getCurrentUpgrade(rpgData3)) != null) {
                    event.setAmount(event.getAmount() * cmUpgrade.damage);
                }
                if ((bzUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.BLITZ.getId()).getCurrentUpgrade(rpgData3)) != null) {
                    hurtEntity.field_70172_ad = (int)((float)hurtEntity.field_70172_ad * bzUpgrade.value);
                }
                if ((mcUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.MERCILESS.getId()).getCurrentUpgrade(rpgData3)) != null) {
                    hurtEntity.field_70172_ad = (int)((float)hurtEntity.field_70172_ad * mcUpgrade.value);
                }
                if (source.func_70644_a(EffectRegistry.COUNTER)) {
                    event.setAmount(event.getAmount() * (float)(source.func_70660_b(EffectRegistry.COUNTER).func_76458_c() + 2));
                    source.func_184589_d(EffectRegistry.COUNTER);
                }
                if (source.func_70644_a(EffectRegistry.BERSERK) && !event.getSource().func_76352_a()) {
                    event.setAmount(event.getAmount() * (float)(source.func_70660_b(EffectRegistry.BERSERK).func_76458_c() + 2));
                }
                if (source.func_70644_a(EffectRegistry.TEAR) && source.func_184614_ca().func_190926_b() && !event.getSource().func_76352_a()) {
                    int amount = source.func_70660_b(EffectRegistry.TEAR).func_76458_c();
                    event.setAmount(event.getAmount() + 5.0f + (float)(5 * amount));
                    event.getSource().func_76348_h();
                }
                if (source.func_70644_a(EffectRegistry.BASH)) {
                    event.getSource().func_76348_h();
                }
                if ((rgUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.RAGE.getId()).getCurrentUpgrade(rpgData3)) != null && source.func_189748_bU() != null && source.func_189748_bU().func_76346_g() instanceof EntityLivingBase && hurtEntity == source.func_189748_bU().func_76346_g()) {
                    event.setAmount(event.getAmount() * rgUpgrade.value);
                }
                if ((vvUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.VALLASVOW.getId()).getCurrentUpgrade(rpgData3)) != null && hurtEntity.hasCapability(RpgDataProvider.RPG_DATA, null) && (hurtData = RpgData.getRpgData((Entity)hurtEntity)).getKilledNations().contains(rpgData3.getNation())) {
                    event.setAmount(event.getAmount() * vvUpgrade.value);
                }
                Skill.SkillUpgrade defUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.DEFENDER.getId()).getCurrentUpgrade(rpgData3);
                Skill.SkillUpgrade plUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.PACK_LOYALTY.getId()).getCurrentUpgrade(rpgData3);
                if (source instanceof EntityTameable && (owner = ((EntityTameable)source).func_70902_q()) != null) {
                    plUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.PACK_LOYALTY.getId()).getCurrentUpgrade(RpgData.getRpgData((Entity)owner));
                }
                float protectFriendlyBonus = 0.0f;
                if (defUpgrade != null) {
                    protectFriendlyBonus = defUpgrade.value;
                }
                if (plUpgrade != null) {
                    protectFriendlyBonus += plUpgrade.value;
                }
                if (protectFriendlyBonus > 0.0f) {
                    EntityLivingBase target = hurtEntity.func_110144_aD();
                    if (hurtEntity instanceof EntityLiving && ((EntityLiving)hurtEntity).func_70638_az() != null) {
                        target = ((EntityLiving)hurtEntity).func_70638_az();
                    }
                    if (target != null && target != source && RARpgManager.isAllied((Entity)source, (Entity)target)) {
                        event.setAmount(event.getAmount() * protectFriendlyBonus);
                    }
                }
                if ((poUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.PICK_OFF.getId()).getCurrentUpgrade(rpgData3)) != null && event.getSource().func_76352_a() && hurtEntity.hasCapability(RpgDataProvider.RPG_DATA, null) && (nearby = hurtEntity.field_70170_p.func_175647_a(EntityLivingBase.class, hurtEntity.func_174813_aQ().func_186662_g((double)poUpgrade.range), e -> e != hurtEntity && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(hurtEntity, e, "allies"))).isEmpty()) {
                    event.setAmount(event.getAmount() * poUpgrade.value);
                }
                if ((vtUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.VULTURE.getId()).getCurrentUpgrade(rpgData3)) != null && hurtEntity.func_110143_aJ() < hurtEntity.func_110138_aP() / 2.0f) {
                    float mult = (1.0f - hurtEntity.func_110143_aJ() / hurtEntity.func_110138_aP()) * vtUpgrade.value;
                    event.setAmount(event.getAmount() * mult);
                }
                if ((bdUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.BYPASS_DEFENSE.getId()).getCurrentUpgrade(rpgData3)) != null && !event.getSource().func_76363_c()) {
                    float damage = event.getAmount();
                    damage = CombatRules.func_189427_a((float)damage, (float)hurtEntity.func_70658_aO(), (float)((float)hurtEntity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                    float diff = event.getAmount() - damage;
                    event.setAmount(event.getAmount() - diff * (1.0f - bdUpgrade.value));
                    event.getSource().func_76348_h();
                }
                if (hurtEntity.hasCapability(RpgDataProvider.RPG_DATA, null)) {
                    rpgData3.getDamageToEntities().put(hurtEntity.func_145782_y(), Float.valueOf(rpgData3.getDamageToEntities().getOrDefault(hurtEntity.func_145782_y(), Float.valueOf(0.0f)).floatValue() + event.getAmount()));
                }
            }
            if (source instanceof EntityPlayer) {
                float timeDiff;
                Skill.SkillUpgrade fnUpgrade;
                int fatalityLevel;
                EntityPlayer player = (EntityPlayer)source;
                IRpgData rpgData4 = RpgData.getRpgData((Entity)source);
                Skill fs = RARpgManager.getSkill(RARpgManager.SkillId.FIRST_STRIKE.getId());
                Skill.SkillUpgrade fsUpgrade = fs.getCurrentUpgrade(rpgData4);
                if (fsUpgrade != null && rpgData4.getSkillCooldown(fs.id) <= 0 && !event.getSource().func_76352_a()) {
                    event.setAmount(event.getAmount() * fsUpgrade.value);
                    rpgData4.setSkillCooldown(fs.id, RARpgManager.getCooldownForSkill(rpgData4, fs));
                    source.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "First Strike Bonus!"));
                }
                if ((fatalityLevel = rpgData4.getSkillLevel(RARpgManager.SkillId.FATALITY.getId())) > 0 && event.getAmount() >= 4.0f && random.nextInt(14 - fatalityLevel) == 0) {
                    if (hurtEntity.func_110138_aP() < 100.0f) {
                        event.setAmount(hurtEntity.func_110143_aJ() * 2.0f);
                    } else {
                        event.setAmount(100.0f);
                    }
                }
                if ((fnUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.FINESSE.getId()).getCurrentUpgrade(rpgData4)) != null && (timeDiff = (float)rpgData4.getTimeSinceLastAttack() - player.func_184818_cX()) >= 0.0f && timeDiff < 50.0f) {
                    event.setAmount(event.getAmount() * 1.5f);
                    player.func_71009_b((Entity)hurtEntity);
                    CapabilityEvents.setTicksSinceLastSwing((EntityLivingBase)player, 100);
                    Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketResetCooldown(1), (EntityPlayerMP)player);
                    if (fnUpgrade.value == 1.0f) {
                        hurtEntity.field_70172_ad = 0;
                        cancelNextKnockback = true;
                    }
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                }
                rpgData4.setTimeSinceLastAttack(0);
            }
            if (source instanceof EntityRABase && stack.func_77973_b() instanceof ItemWeapon) {
                ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
                if (weapon.polearm) {
                    if (hurtEntity.func_184585_cz()) {
                        ItemStack copyBeforeUse = source.func_184614_ca().func_77946_l();
                        source.func_184614_ca().func_77972_a(50, source);
                        if (source.func_184614_ca().func_190926_b()) {
                            if (source instanceof EntityPlayer) {
                                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)hurtEntity), (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                            }
                            source.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                            source.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                        }
                    } else {
                        float mountMult;
                        float f = mountMult = source.func_184187_bx() != null && !(hurtEntity instanceof EntityPlayer) ? 1.5f : 1.0f;
                        if (weapon.isPike && source.func_184187_bx() == null && hurtEntity instanceof EntityHorse) {
                            if (!hurtEntity.func_184188_bt().isEmpty() && !(hurtEntity.func_184188_bt().get(0) instanceof EntityPlayer)) {
                                mountMult = 6.0f;
                            } else if (hurtEntity.field_191988_bg > 0.0f) {
                                mountMult = 5.0f;
                            }
                        }
                        if (weapon.thrustDist > 5.0f) {
                            event.setAmount(event.getAmount() + weapon.getAttackDamage() * mountMult);
                        } else {
                            event.setAmount(event.getAmount() * mountMult);
                        }
                    }
                }
            }
        }
        if (hurtEntity.func_70644_a(EffectRegistry.MARKED)) {
            event.setAmount(event.getAmount() * (float)(hurtEntity.func_70660_b(EffectRegistry.MARKED).func_76458_c() + 2));
        }
        if (hurtEntity.func_70644_a(EffectRegistry.HOLD)) {
            event.setAmount(event.getAmount() / 2.0f);
        }
        if (hurtEntity.func_70644_a(EffectRegistry.BERSERK)) {
            if (hurtEntity instanceof EntityRABase || hurtEntity instanceof EntityPlayer) {
                rpgData2 = RpgData.getRpgData((Entity)hurtEntity);
                float div = hurtEntity.func_70660_b(EffectRegistry.BERSERK).func_76458_c() + 1;
                rpgData2.setWoundDamage(rpgData2.getWoundDamage() + event.getAmount() / div);
            }
            event.setAmount(0.0f);
        }
        if (hurtEntity instanceof EntityTameable && (tameable = (EntityTameable)hurtEntity).func_70902_q() instanceof EntityPlayer) {
            rpgData = RpgData.getRpgData((Entity)tameable.func_70902_q());
            Skill.SkillUpgrade rsUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.TACTICS.getId()).getCurrentUpgrade(rpgData);
            if (rsUpgrade != null) {
                event.setAmount(event.getAmount() * rsUpgrade.value);
            }
        }
        if (hurtEntity.hasCapability(RpgDataProvider.RPG_DATA, null)) {
            Skill.SkillUpgrade shUpgrade;
            rpgData2 = RpgData.getRpgData((Entity)hurtEntity);
            if (event.getSource().func_76347_k() && (shUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.SUN_HARDENED.getId()).getCurrentUpgrade(rpgData2)) != null) {
                event.setAmount(event.getAmount() * shUpgrade.damage);
            }
        }
        if (hurtEntity instanceof EntityPlayer) {
            Skill.SkillUpgrade sfUpgrade;
            Skill fs;
            Skill.SkillUpgrade fsUpgrade;
            int vitalityLevel;
            Skill.SkillUpgrade ifUpgrade;
            Skill.SkillUpgrade ubUpgrade;
            Skill.SkillUpgrade thUpgrade;
            Skill.SkillUpgrade rsUpgrade;
            rpgData2 = RpgData.getRpgData((Entity)hurtEntity);
            if (hurtEntity.func_82150_aj()) {
                Skill camouflage = RARpgManager.getSkill(RARpgManager.SkillId.CAMOUFLAGE.getId());
                rpgData2.setSkillCooldown(RARpgManager.SkillId.CAMOUFLAGE.getId(), RARpgManager.getCooldownForSkill(rpgData2, camouflage));
                hurtEntity.func_82142_c(false);
            }
            if ((rsUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.RESISTANCE.getId()).getCurrentUpgrade(rpgData2)) != null) {
                event.setAmount(event.getAmount() * rsUpgrade.value);
            }
            if ((thUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.TOUGH_HIDE.getId()).getCurrentUpgrade(rpgData2)) != null) {
                event.setAmount(event.getAmount() * thUpgrade.value);
            }
            if ((ubUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.UNBREAKABLE_BOND.getId()).getCurrentUpgrade(rpgData2)) != null && hurtEntity.func_184187_bx() instanceof EntityLivingBase && event.getSource() != DamageSource.field_76377_j) {
                event.setAmount(event.getAmount() * ubUpgrade.value);
                float amount = event.getAmount() / 2.0f;
                event.setAmount(amount);
                hurtEntity.func_184187_bx().func_70097_a(DamageSource.field_76377_j, amount);
            }
            if ((ifUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.IRONFLESH.getId()).getCurrentUpgrade(rpgData2)) != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                event.setAmount(event.getAmount() * ifUpgrade.value);
            }
            if ((vitalityLevel = rpgData2.getSkillLevel(RARpgManager.SkillId.VITALITY.getId())) > 0 && event.getAmount() > hurtEntity.func_110143_aJ()) {
                int chance;
                int n = chance = hurtEntity.func_110143_aJ() > 2.0f ? 9 : 7;
                if (random.nextInt(vitalityLevel - chance / 2) == 0) {
                    hurtEntity.func_70606_j(1.0f);
                    event.setAmount(0.0f);
                }
            }
            if ((fsUpgrade = (fs = RARpgManager.getSkill(RARpgManager.SkillId.FINAL_STAND.getId())).getCurrentUpgrade(rpgData2)) != null && event.getAmount() > hurtEntity.func_110143_aJ() && rpgData2.getSkillCooldown(RARpgManager.SkillId.FINAL_STAND.getId()) <= 0 && event.getSource() != DamageSource.field_76380_i) {
                hurtEntity.func_70606_j(1.0f);
                event.setAmount(0.0f);
                hurtEntity.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Survived a killing blow!"));
                fs.applyEffects(hurtEntity, hurtEntity, fs, fsUpgrade);
                hurtEntity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, (20 - fsUpgrade.duration) * 20, 2));
                rpgData2.setSkillCooldown(RARpgManager.SkillId.FINAL_STAND.getId(), RARpgManager.getCooldownForSkill(rpgData2, fs));
            }
            if ((sfUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.STABLE_FOOTING.getId()).getCurrentUpgrade(rpgData2)) != null && event.getSource() == DamageSource.field_76379_h) {
                event.setAmount(Math.max(event.getAmount() + sfUpgrade.damage, 0.0f));
            }
        }
        if (hurtEntity.func_184585_cz() && hurtEntity.func_184607_cu().func_77973_b() instanceof ItemShield && event.getSource().func_76346_g() != null && event.getSource().func_76346_g().hasCapability(RpgDataProvider.RPG_DATA, null)) {
            source = (EntityLivingBase)event.getSource().func_76346_g();
            Skill.SkillUpgrade sbUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.SHIELD_BREAKER.getId()).getCurrentUpgrade(RpgData.getRpgData((Entity)source));
            if (sbUpgrade != null) {
                ItemStack activeItemStack = hurtEntity.func_184607_cu();
                ItemStack copyBeforeUse = activeItemStack.func_77946_l();
                activeItemStack.func_77972_a((int)sbUpgrade.value, hurtEntity);
                if (activeItemStack.func_190926_b()) {
                    if (hurtEntity instanceof EntityPlayer) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)hurtEntity), (ItemStack)copyBeforeUse, (EnumHand)hurtEntity.func_184600_cs());
                    }
                    hurtEntity.func_184201_a(hurtEntity.func_184600_cs() == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    hurtEntity.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
        if (hurtEntity instanceof EntityHorse && !hurtEntity.func_184188_bt().isEmpty()) {
            if (hurtEntity.func_184188_bt().get(0) instanceof EntityPlayer && event.getSource() != DamageSource.field_76377_j) {
                EntityLivingBase source2;
                Skill.SkillUpgrade crUpgrade;
                EntityPlayer rider = (EntityPlayer)hurtEntity.func_184188_bt().get(0);
                rpgData = RpgData.getRpgData((Entity)rider);
                Skill.SkillUpgrade ubUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.UNBREAKABLE_BOND.getId()).getCurrentUpgrade(rpgData);
                if (ubUpgrade != null) {
                    event.setAmount(event.getAmount() * ubUpgrade.value);
                    float amount = event.getAmount() / 2.0f;
                    event.setAmount(amount);
                    rider.func_70097_a(DamageSource.field_76377_j, amount);
                }
                if ((crUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.CAREFUL_RIDER.getId()).getCurrentUpgrade(rpgData)) != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (source2 = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof ItemWeapon) {
                    ItemWeapon weapon = (ItemWeapon)source2.func_184614_ca().func_77973_b();
                    if (weapon.polearm) {
                        event.setAmount(event.getAmount() * crUpgrade.value);
                    }
                }
            }
            if (hurtEntity.func_184188_bt().get(0) instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityRABase) {
                event.setAmount(event.getAmount() / 2.0f);
            }
        }
        if (event.getAmount() < 0.0f) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        IRpgData rpgData;
        EntityPlayer player;
        Vec3d vec3d;
        EntityLivingBase hurtEntity = event.getEntityLiving();
        Entity sourceEntity = event.getSource().func_76346_g();
        if (hurtEntity.func_184587_cr() && !(hurtEntity.func_184607_cu().func_77973_b() instanceof ItemShield) && hurtEntity.func_184607_cu().func_77975_n() == EnumAction.BLOCK && !event.getSource().func_76363_c() && (vec3d = event.getSource().func_188404_v()) != null) {
            Vec3d vec3d1 = hurtEntity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(hurtEntity.field_70165_t, hurtEntity.field_70163_u, hurtEntity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                Entity entity;
                ItemStack copyBeforeUse;
                EntityLivingBase source;
                hurtEntity.field_70170_p.func_184148_a(null, hurtEntity.field_70165_t, hurtEntity.field_70163_u, hurtEntity.field_70161_v, SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                boolean hurtHardSteel = hurtEntity.func_184614_ca().func_77973_b() instanceof IRAClassItem && ((IRAClassItem)hurtEntity.func_184614_ca().func_77973_b()).hardSteel();
                boolean sourceHardSteel = false;
                if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    source = (EntityLivingBase)event.getSource().func_76346_g();
                    boolean bl = sourceHardSteel = source.func_184614_ca().func_77973_b() instanceof IRAClassItem && ((IRAClassItem)source.func_184614_ca().func_77973_b()).hardSteel();
                }
                if (hurtEntity instanceof EntityPlayer) {
                    IRpgData rpgData2 = RpgData.getRpgData((Entity)hurtEntity);
                    Skill paSkill = RARpgManager.getSkill(RARpgManager.SkillId.PARRY.getId());
                    Skill.SkillUpgrade paUpgrade = paSkill.getCurrentUpgrade(rpgData2);
                    if (paUpgrade == null) {
                        if (!hurtEntity.field_70170_p.field_72995_K) {
                            Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketResetCooldown(), (EntityPlayerMP)hurtEntity);
                        }
                        ((EntityPlayer)hurtEntity).func_184821_cY();
                        hurtEntity.func_184597_cx();
                    }
                }
                if (hurtEntity.func_184614_ca().func_77973_b() instanceof ItemRASword || hurtEntity.func_184614_ca().func_77973_b() instanceof ItemKnife) {
                    ItemStack activeItemStack = hurtEntity.func_184614_ca();
                    copyBeforeUse = activeItemStack.func_77946_l();
                    if (sourceHardSteel && !hurtHardSteel) {
                        activeItemStack.func_77972_a(2 + random.nextInt(50), hurtEntity);
                    } else {
                        activeItemStack.func_77972_a(1, hurtEntity);
                    }
                    if (activeItemStack.func_190926_b()) {
                        if (hurtEntity instanceof EntityPlayer) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)hurtEntity), (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                        }
                        hurtEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                        hurtEntity.field_70170_p.func_184148_a(null, hurtEntity.field_70165_t, hurtEntity.field_70163_u, hurtEntity.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    }
                }
                if (hurtEntity.func_184614_ca().func_77973_b() instanceof ItemKnife && !(hurtEntity.func_184592_cb().func_77973_b() instanceof ItemKnife) && hurtEntity instanceof EntityPlayer && !hurtEntity.field_70170_p.field_72995_K) {
                    ((EntityPlayerMP)hurtEntity).func_184811_cZ().func_185145_a(hurtEntity.func_184614_ca().func_77973_b(), 50);
                }
                if (hurtHardSteel && !sourceHardSteel && (source = (EntityLivingBase)event.getSource().func_76346_g()) != null && !source.func_184614_ca().func_190926_b()) {
                    copyBeforeUse = source.func_184614_ca().func_77946_l();
                    source.func_184614_ca().func_77972_a(random.nextInt(100), source);
                    if (source.func_184614_ca().func_190926_b()) {
                        if (source instanceof EntityPlayer) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)source), (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                        }
                        source.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                        source.func_184602_cy();
                        source.field_70170_p.func_184148_a(null, source.field_70165_t, source.field_70163_u, source.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 0.8f + source.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    }
                }
                if (!event.getSource().func_76352_a() && (entity = event.getSource().func_76364_f()) instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70653_a((Entity)hurtEntity, 0.5f, hurtEntity.field_70165_t - entity.field_70165_t, hurtEntity.field_70161_v - entity.field_70161_v);
                }
                event.setCanceled(true);
                return;
            }
        }
        if (event.getSource() == DamageSource.field_76379_h && hurtEntity.func_70644_a(EffectRegistry.FALL_RESISTANCE)) {
            event.setCanceled(true);
            return;
        }
        if (sourceEntity instanceof EntityLivingBase && sourceEntity.hasCapability(RpgDataProvider.RPG_DATA, null) && (!(sourceEntity instanceof EntityPlayer) || !((EntityPlayer)sourceEntity).func_184812_l_())) {
            String nationId = "";
            String sourceNationId = RpgData.getRpgData(sourceEntity).getNation();
            if (hurtEntity.hasCapability(RpgDataProvider.RPG_DATA, null)) {
                nationId = RpgData.getRpgData((Entity)hurtEntity).getNation();
            }
            if (!hurtEntity.func_184188_bt().isEmpty() && ((Entity)hurtEntity.func_184188_bt().get(0)).hasCapability(RpgDataProvider.RPG_DATA, null)) {
                nationId = RpgData.getRpgData((Entity)hurtEntity.func_184188_bt().get(0)).getNation();
            }
            if (RAWorldData.get(hurtEntity.func_130014_f_()).areNationsAllied(nationId, sourceNationId)) {
                event.setCanceled(true);
            }
        }
        if (hurtEntity instanceof EntityPlayer) {
            player = (EntityPlayer)hurtEntity;
            rpgData = RpgData.getRpgData((Entity)player);
            Skill ctSkill = RARpgManager.getSkill(RARpgManager.SkillId.COUNTER.getId());
            Skill.SkillUpgrade ctUpgrade = ctSkill.getCurrentUpgrade(rpgData);
            Skill paSkill = RARpgManager.getSkill(RARpgManager.SkillId.PARRY.getId());
            Skill.SkillUpgrade paUpgrade = paSkill.getCurrentUpgrade(rpgData);
            if (player.func_184585_cz() && player.func_184607_cu().func_77988_m() - player.func_184605_cv() < 10) {
                if (ctUpgrade != null) {
                    ctSkill.applyEffects((EntityLivingBase)player, (EntityLivingBase)player, ctSkill, ctUpgrade);
                }
                if (paUpgrade != null) {
                    paSkill.applyEffects((EntityLivingBase)player, (EntityLivingBase)player, paSkill, paUpgrade);
                }
            }
            if (player.func_184585_cz() && player.func_184607_cu().func_77973_b() instanceof ItemRASword && !player.field_70170_p.field_72995_K) {
                EnumHand hand = player.func_184600_cs();
                ItemStack copyBeforeUse = player.func_184586_b(hand).func_77946_l();
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                if (player.func_184586_b(hand).func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)EnumHand.MAIN_HAND);
                    player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    player.func_184602_cy();
                    hurtEntity.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
            if (player.func_184585_cz() && player.func_184607_cu().func_77973_b() instanceof ItemRAShield) {
                ItemStack stack;
                if (!player.field_70170_p.field_72995_K) {
                    player.func_184607_cu().func_77972_a(1, (EntityLivingBase)player);
                }
                if (sourceEntity instanceof EntityRABase && (stack = ((EntityRABase)sourceEntity).func_184614_ca()).func_77973_b() instanceof ItemWeapon) {
                    ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
                    if (weapon.polearm && !player.field_70170_p.field_72995_K) {
                        ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
                        player.func_184607_cu().func_77972_a(10, (EntityLivingBase)player);
                        if (player.func_184607_cu().func_190926_b()) {
                            EnumHand enumhand = player.func_184600_cs();
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)player.func_184600_cs());
                            player.func_184201_a(enumhand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                            player.func_184602_cy();
                            event.setCanceled(true);
                            player.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + hurtEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                        }
                    }
                }
            }
        }
        if (sourceEntity instanceof EntityPlayer) {
            player = (EntityPlayer)sourceEntity;
            rpgData = RpgData.getRpgData((Entity)player);
            if (player.func_82150_aj() && !(event.getEntity() instanceof EntityHorse)) {
                Skill camouflage = RARpgManager.getSkill(RARpgManager.SkillId.CAMOUFLAGE.getId());
                Skill.SkillUpgrade upgrade = camouflage.getCurrentUpgrade(rpgData);
                if (rpgData.getStealthAttacks() > 0) {
                    rpgData.setStealthAttacks(rpgData.getStealthAttacks() - 1);
                    if (!player.field_70170_p.field_72995_K) {
                        Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketSyncRpgData((Entity)player, rpgData), (EntityPlayerMP)player);
                    }
                } else {
                    rpgData.setSkillCooldown(RARpgManager.SkillId.CAMOUFLAGE.getId(), RARpgManager.getCooldownForSkill(rpgData, camouflage));
                    if (upgrade != null) {
                        rpgData.setStealthAttacks((int)upgrade.value);
                        if (!player.field_70170_p.field_72995_K) {
                            Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketSyncRpgData((Entity)player, rpgData), (EntityPlayerMP)player);
                        }
                    }
                    hurtEntity.func_82142_c(false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void checkCanSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getWorld().func_175659_aa() == EnumDifficulty.PEACEFUL) {
            // empty if block
        }
        if (event.getEntity() instanceof EntityWargal) {
            EntityWargal wargal = (EntityWargal)event.getEntity();
            if (event.getWorld().func_175659_aa() == EnumDifficulty.PEACEFUL && !wargal.func_104002_bU()) {
                event.setResult(Event.Result.DENY);
                return;
            }
            IRpgData rpgData = RpgData.getRpgData((Entity)wargal);
            BlockPos pos = new BlockPos(wargal.field_70165_t, wargal.field_70163_u, wargal.field_70161_v);
            if (random.nextInt(1000) == 0 && !event.getWorld().func_72935_r() && event.getWorld().func_175710_j(pos) && !BiomeDictionary.hasType((Biome)event.getWorld().func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                EntityNightWarrior nightWarrior = new EntityNightWarrior(event.getWorld());
                nightWarrior.func_70012_b(wargal.field_70165_t, wargal.field_70163_u, wargal.field_70161_v, MathHelper.func_76142_g((float)(event.getWorld().field_73012_v.nextFloat() * 360.0f)), 0.0f);
                nightWarrior.setClone(true);
                nightWarrior.func_180482_a(event.getWorld().func_175649_E(nightWarrior.func_180425_c()), null);
                event.getWorld().func_72838_d((Entity)nightWarrior);
                wargal.func_70106_y();
                event.setResult(Event.Result.DENY);
                return;
            }
            if (event.isSpawner() && wargal.func_70058_J()) {
                wargal.setLocked(true);
                wargal.func_180482_a(wargal.field_70170_p.func_175649_E(new BlockPos((Vec3i)wargal.func_180425_c())), null);
                event.setResult(Event.Result.ALLOW);
            }
            rpgData.setNation(RARpgManager.NationId.MORGARATH.getId());
            rpgData.setClassId(RARpgManager.ClassId.WARGAL.getId());
            return;
        }
        if (event.getEntity() instanceof EntityRAHumanoid) {
            EntityRAHumanoid raHumanoid = (EntityRAHumanoid)event.getEntity();
            if (event.getWorld().func_175659_aa() == EnumDifficulty.PEACEFUL && !raHumanoid.func_104002_bU()) {
                event.setResult(Event.Result.DENY);
                return;
            }
            IRpgData rpgData = RpgData.getRpgData((Entity)raHumanoid);
            if (event.isSpawner()) {
                raHumanoid.setLocked(true);
                raHumanoid.func_180482_a(raHumanoid.field_70170_p.func_175649_E(new BlockPos((Vec3i)raHumanoid.func_180425_c())), null);
                return;
            }
            Biome biome = event.getWorld().func_180494_b(raHumanoid.func_180425_c());
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                rpgData.setNation(RARpgManager.NationId.NIHON_JA.getId());
                rpgData.setClassId(RARpgManager.ClassId.SENSHI.getId());
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                rpgData.setNation(RARpgManager.NationId.SKANDIA.getId());
                rpgData.setClassId(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId());
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                rpgData.setNation(RARpgManager.NationId.TEMUJAI.getId());
                rpgData.setClassId(RARpgManager.ClassId.TEMUJAI_WARRIOR.getId());
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                rpgData.setNation(RARpgManager.NationId.ARALUEN.getId());
                rpgData.setClassId(RARpgManager.ClassId.ARALUEN_KNIGHT.getId());
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && random.nextInt(6) == 0) {
                rpgData.setNation(RARpgManager.NationId.ARALUEN.getId());
                rpgData.setClassId(RARpgManager.ClassId.RANGER.getId());
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                if (random.nextInt(2) == 0) {
                    rpgData.setNation(RARpgManager.NationId.SCOTTI.getId());
                } else {
                    rpgData.setNation(RARpgManager.NationId.MACHADDISH_ALLIANCE.getId());
                }
                rpgData.setClassId(RARpgManager.ClassId.SCOTTI_WARRIOR.getId());
                if (rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SCOTTI_WARRIOR.getId())) {
                    Item[] items = rpgData.getNation().equalsIgnoreCase(RARpgManager.NationId.SCOTTI.getId()) ? new Item[]{RAItemLoader.getItem("scotti_mcduig_pants"), RAItemLoader.getItem("scotti_mcforn_pants")} : new Item[]{RAItemLoader.getItem("scotti_pants_wrap"), RAItemLoader.getItem("scotti_macfrewin_pants"), RAItemLoader.getItem("scotti_mackentick_pants")};
                    raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(items[random.nextInt(items.length)]));
                }
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                int faction = random.nextInt(5);
                if (faction <= 1) {
                    rpgData.setNation(RARpgManager.NationId.ARRIDA.getId());
                    rpgData.setClassId(RARpgManager.ClassId.ARRIDI_WARRIOR.getId());
                } else if (faction <= 3) {
                    rpgData.setNation(RARpgManager.NationId.TUALAGHI.getId());
                    rpgData.setClassId(RARpgManager.ClassId.TUALAGHI.getId());
                } else {
                    rpgData.setNation(RARpgManager.NationId.BEDULLIN.getId());
                    rpgData.setClassId(RARpgManager.ClassId.BEDULLIN.getId());
                }
            } else {
                event.setResult(Event.Result.DENY);
                return;
            }
            int i = MathHelper.func_76128_c((double)raHumanoid.field_70165_t);
            int j = MathHelper.func_76128_c((double)raHumanoid.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)raHumanoid.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            if (!raHumanoid.func_104002_bU()) {
                boolean stopSpawn;
                boolean bl = stopSpawn = random.nextInt(180) == 0;
                if (!stopSpawn && event.getWorld().func_175699_k(blockpos) <= 8 && event.getWorld().func_175710_j(blockpos)) {
                    stopSpawn = true;
                }
                if (stopSpawn) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void specialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityRAHumanoid) {
            int spawnAmount;
            EntityRAHumanoid entity = (EntityRAHumanoid)event.getEntity();
            World world = event.getWorld();
            IRpgData rpgData = RpgData.getRpgData((Entity)entity);
            RAClass raClass = RARpgManager.getRAClass(rpgData.getClassId());
            int chance = 3;
            if (raClass.id.equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId()) || random.nextInt(chance) != 0) {
                entity.setLeader(false);
            }
            if ((spawnAmount = random.nextInt(raClass.maxSpawnTroops + 1)) > 0) {
                for (int i = 0; i < spawnAmount; ++i) {
                    EntityRAHumanoid raHumanoid = entity instanceof EntityWargal ? new EntityWargal(world) : new EntityRAStandard(world);
                    raHumanoid.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    IRpgData rpgDataNew = RpgData.getRpgData((Entity)raHumanoid);
                    rpgDataNew.setNation(rpgData.getNation());
                    rpgDataNew.setClassId(rpgData.getClassId());
                    if (entity.func_104002_bU()) {
                        raHumanoid.func_110163_bv();
                    }
                    if (rpgDataNew.getClassId().equalsIgnoreCase(RARpgManager.ClassId.TEMUJAI_WARRIOR.getId()) && new Random().nextInt(2) == 0) {
                        rpgDataNew.setClassId(RARpgManager.ClassId.TEMUJAI_ARCHER.getId());
                    }
                    raHumanoid.setLeader(false);
                    raHumanoid.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                    if (rpgDataNew.getClassId().equalsIgnoreCase(RARpgManager.ClassId.SCOTTI_WARRIOR.getId())) {
                        if (entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == RAItemLoader.getItem("scotti_pants_wrap") && random.nextInt(2) == 0) {
                            raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(RAItemLoader.getItem("scotti_pants")));
                        } else {
                            raHumanoid.func_184201_a(EntityEquipmentSlot.LEGS, entity.func_184582_a(EntityEquipmentSlot.LEGS));
                        }
                    }
                    world.func_72838_d((Entity)raHumanoid);
                    raHumanoid.func_70024_g(random.nextFloat() * 2.0f - 1.0f, 0.0, random.nextFloat() * 2.0f - 1.0f);
                }
            }
        }
    }

    private static void applyModifier(EntityLivingBase entityLivingBase, String attributeName, double value) {
        String customId = "ranger:" + attributeName;
        UUID uuid = attributeMap.computeIfAbsent(attributeName, k -> UUID.nameUUIDFromBytes(customId.getBytes()));
        IAttributeInstance attributeInstance = entityLivingBase.func_110140_aT().func_111152_a(attributeName);
        if (attributeInstance == null) {
            return;
        }
        AttributeModifier modifier = attributeInstance.func_111127_a(uuid);
        if (value > 0.0) {
            if (modifier == null || !attributeInstance.func_180374_a(modifier) || modifier.func_111164_d() != value) {
                attributeInstance.func_188479_b(uuid);
                attributeInstance.func_111121_a(new AttributeModifier(uuid, customId, value, 0));
            }
        } else if (modifier != null && attributeInstance.func_180374_a(modifier)) {
            attributeInstance.func_188479_b(uuid);
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        IRpgData rpgData;
        if (event.getEntityLiving().func_70644_a(EffectRegistry.PARALYSIS)) {
            event.getEntityLiving().field_70159_w = 0.0;
            if (event.getEntityLiving().field_70181_x > 0.0) {
                event.getEntityLiving().field_70181_x = 0.0;
            }
            event.getEntityLiving().field_70179_y = 0.0;
        }
        if (event.getEntityLiving().hasCapability(RpgDataProvider.RPG_DATA, null)) {
            Skill.SkillUpgrade sfUpgrade;
            Skill.SkillUpgrade krUpgrade;
            Skill.SkillUpgrade arUpgrade;
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            rpgData = RpgData.getRpgData((Entity)entityLivingBase);
            RAClass raClass = RARpgManager.getRAClass(rpgData.getClassId());
            if (!entityLivingBase.field_70170_p.field_72995_K && raClass != null) {
                HashMap<String, Double> attributeValues = new HashMap<String, Double>();
                HashMap<String, Double> mountAttributeValues = new HashMap<String, Double>();
                if (entityLivingBase.func_70644_a(EffectRegistry.BARRAGE)) {
                    attributeValues.put("generic.attackSpeed", (double)(entityLivingBase.func_70660_b(EffectRegistry.BARRAGE).func_76458_c() + 1) * 0.5);
                }
                for (String string : raClass.skills) {
                    Skill skill = RARpgManager.getSkill(string);
                    if (skill.usable || skill.playerOnly && !(entityLivingBase instanceof EntityPlayer)) continue;
                    Skill.SkillUpgrade upgrade = skill.getCurrentUpgrade(rpgData);
                    boolean meetsRequirements = skill.checkRequirements(entityLivingBase, upgrade);
                    if (!skill.alwaysRun) continue;
                    for (Skill.SkillEffect effect : skill.skillEffects) {
                        if (effect.effectType.startsWith("stat")) {
                            double value;
                            String stat = effect.effectType.split(":")[1];
                            double d = value = upgrade != null && meetsRequirements ? (double)upgrade.value : 0.0;
                            if (meetsRequirements && skill.requirements.contains("low_health")) {
                                value *= (double)(1.0f - entityLivingBase.func_110143_aJ() / (entityLivingBase.func_110138_aP() / 2.0f));
                            }
                            if (effect.effectTarget.equalsIgnoreCase("mount")) {
                                mountAttributeValues.put(stat, value + mountAttributeValues.getOrDefault(stat, value));
                                continue;
                            }
                            attributeValues.put(stat, value + attributeValues.getOrDefault(stat, value));
                            continue;
                        }
                        if (!meetsRequirements || rpgData.getSkillLevel(skill.id) <= 0 || rpgData.getSkillCooldown(skill.id) > 0) continue;
                        RARpgManager.useSkillNew(rpgData, skill.id);
                    }
                }
                for (Map.Entry entry : attributeValues.entrySet()) {
                    CapabilityEvents.applyModifier(entityLivingBase, (String)entry.getKey(), (Double)entry.getValue());
                }
                if (entityLivingBase.func_184187_bx() instanceof EntityLivingBase) {
                    for (Map.Entry entry : mountAttributeValues.entrySet()) {
                        CapabilityEvents.applyModifier((EntityLivingBase)entityLivingBase.func_184187_bx(), (String)entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if ((arUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.ARMORER.getId()).getCurrentUpgrade(rpgData)) != null && event.getEntity().field_70173_aa % (arUpgrade.duration * 20) == 0) {
                EntityEquipmentSlot slot = EntityEquipmentSlot.values()[random.nextInt(EntityEquipmentSlot.values().length)];
                ItemStack stack = event.getEntityLiving().func_184582_a(slot);
                if (!stack.func_190926_b() && stack.func_77984_f() && stack.func_77952_i() > 0) {
                    stack.func_77964_b((int)((float)stack.func_77952_i() - arUpgrade.value));
                }
            }
            if ((krUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.KIND_MASTER.getId()).getCurrentUpgrade(rpgData)) != null && event.getEntity().func_184187_bx() instanceof EntityLivingBase && event.getEntity().field_70173_aa % (krUpgrade.duration * 20) == 0) {
                ((EntityLivingBase)event.getEntity().func_184187_bx()).func_70691_i(krUpgrade.value);
            }
            if (entityLivingBase.func_184187_bx() instanceof EntityBoat && (sfUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.SEAFARER.getId()).getCurrentUpgrade(rpgData)) != null && entityLivingBase.field_191988_bg > 0.0f) {
                EntityBoat entityBoat = (EntityBoat)entityLivingBase.func_184187_bx();
                float f = 0.08f;
                entityBoat.field_70159_w += (double)(MathHelper.func_76126_a((float)(-entityBoat.field_70177_z * ((float)Math.PI / 180))) * f);
                entityBoat.field_70179_y += (double)(MathHelper.func_76134_b((float)(entityBoat.field_70177_z * ((float)Math.PI / 180))) * f);
            }
            if (!entityLivingBase.field_70170_p.field_72995_K) {
                Skill.SkillUpgrade dpUpgrade;
                Skill.SkillUpgrade wbUpgrade;
                Skill cdSkill = RARpgManager.getSkill(RARpgManager.SkillId.CAVE_DWELLER.getId());
                Skill.SkillUpgrade skillUpgrade = cdSkill.getCurrentUpgrade(rpgData);
                if (skillUpgrade != null) {
                    boolean active = entityLivingBase.func_70644_a(MobEffects.field_76439_r);
                    if (cdSkill.checkRequirements(entityLivingBase, skillUpgrade)) {
                        if (!active) {
                            cdSkill.applyEffects(entityLivingBase, entityLivingBase, cdSkill, skillUpgrade);
                        }
                    } else if (active) {
                        entityLivingBase.func_184589_d(MobEffects.field_76439_r);
                    }
                }
                if (entityLivingBase.func_70644_a(MobEffects.field_76438_s) && (wbUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.WILD_BEAST.getId()).getCurrentUpgrade(rpgData)) != null) {
                    entityLivingBase.func_184589_d(MobEffects.field_76438_s);
                }
                if ((dpUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.DISCIPLINE.getId()).getCurrentUpgrade(rpgData)) != null) {
                    if (entityLivingBase.func_70644_a(MobEffects.field_76437_t)) {
                        entityLivingBase.func_184589_d(MobEffects.field_76437_t);
                    }
                    if (entityLivingBase.func_70644_a(EffectRegistry.WEAK)) {
                        entityLivingBase.func_184589_d(EffectRegistry.WEAK);
                    }
                }
            }
        }
        if (event.getEntity() instanceof EntityPlayer || event.getEntity() instanceof EntityRAHumanoid) {
            EntityLivingBase entity = event.getEntityLiving();
            rpgData = RpgData.getRpgData((Entity)entity);
            rpgData.update();
            if (!entity.field_70170_p.field_72995_K) {
                if (entity.func_70644_a(EffectRegistry.STEALTH)) {
                    entity.func_82142_c(true);
                } else if (entity.func_70093_af() && rpgData.getSkillCooldown(RARpgManager.SkillId.CAMOUFLAGE.getId()) <= 0) {
                    if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == RAItemLoader.getItem("ranger_hood") && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().func_77658_a().contains("ranger_tunic") && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == RAItemLoader.getItem("ranger_pants")) {
                        entity.func_82142_c(true);
                    }
                } else if (!entity.func_70644_a(MobEffects.field_76441_p)) {
                    entity.func_82142_c(false);
                }
            }
            if (event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                IAttributeInstance attackSpeed = player.func_110148_a(SharedMonsterAttributes.field_188790_f);
                AttributeModifier attackSpeedMod = player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111127_a(ATTACK_SPEED_UUID);
                int attackValue = 0;
                if (player.func_70644_a(EffectRegistry.FURY_SLICE)) {
                    attackValue = 20;
                }
                if (attackValue > 0) {
                    if (attackSpeedMod == null || !attackSpeed.func_180374_a(attackSpeedMod)) {
                        attackSpeed.func_188479_b(ATTACK_SPEED_UUID);
                        attackSpeed.func_111121_a(new AttributeModifier(ATTACK_SPEED_UUID, "ra_attack_speed", (double)attackValue, 0));
                    }
                } else if (attackSpeedMod != null && attackSpeed.func_180374_a(attackSpeedMod)) {
                    attackSpeed.func_188479_b(ATTACK_SPEED_UUID);
                }
                if (!player.field_70170_p.field_72995_K && rpgData.getClassId().equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId())) {
                    CapabilityEvents.checkRemoveArmor(player, EntityEquipmentSlot.HEAD);
                    CapabilityEvents.checkRemoveArmor(player, EntityEquipmentSlot.CHEST);
                    CapabilityEvents.checkRemoveArmor(player, EntityEquipmentSlot.LEGS);
                    CapabilityEvents.checkRemoveArmor(player, EntityEquipmentSlot.FEET);
                    if (player.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                        player.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(RAItemLoader.getItem("wargal_skin")));
                    }
                }
            }
        }
        if (event.getEntity() instanceof EntityMob) {
            EntityMob mob = (EntityMob)event.getEntity();
            if (mob.func_70638_az() instanceof EntityPlayer && mob.func_70638_az().func_82150_aj()) {
                mob.func_70624_b(null);
                mob.func_70604_c(null);
                if (mob instanceof EntityCreeper) {
                    ((EntityCreeper)mob).func_70829_a(-1);
                }
            }
            if (mob.func_70638_az() != null && mob.func_70644_a(MobEffects.field_76440_q) && mob.func_70643_av() != mob.func_70638_az()) {
                mob.func_70624_b(null);
                mob.func_70604_c(null);
                if (mob instanceof EntityCreeper) {
                    ((EntityCreeper)mob).func_70829_a(-1);
                }
            }
        }
    }

    private static void checkRemoveArmor(EntityPlayer player, EntityEquipmentSlot slot) {
        ItemStack stack = player.func_184582_a(slot);
        if (!(stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemRAArmor) || ((ItemRAArmor)stack.func_77973_b()).getRAClassList().length != 0 && ((ItemRAArmor)stack.func_77973_b()).isRightClass(stack, RARpgManager.ClassId.WARGAL.getId()))) {
            player.func_71019_a(stack, false);
            player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Wargals can't wear normal armor!"));
        }
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        if (cancelNextKnockback) {
            cancelNextKnockback = false;
            event.setCanceled(true);
            return;
        }
        if (event.getAttacker() instanceof EntityLivingBase && ((EntityLivingBase)event.getAttacker()).func_70644_a(EffectRegistry.CLOSE_COMBAT)) {
            event.setCanceled(true);
            return;
        }
        if ((event.getEntityLiving().func_70644_a(MobEffects.field_76421_d) || event.getEntityLiving().func_70644_a(EffectRegistry.HOLD)) && !event.getEntityLiving().func_70644_a(EffectRegistry.DRUNK)) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            Skill.SkillUpgrade sfUpgrade;
            IRpgData rpgData = RpgData.getRpgData(event.getEntity());
            Skill.SkillUpgrade dpUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.DISCIPLINE.getId()).getCurrentUpgrade(rpgData);
            if (dpUpgrade != null) {
                event.setStrength(event.getStrength() * dpUpgrade.value);
            }
            if ((sfUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.STABLE_FOOTING.getId()).getCurrentUpgrade(rpgData)) != null) {
                event.setStrength(event.getStrength() * sfUpgrade.value);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        IRpgData rpgData;
        Entity sourceEntity = null;
        if (event.getSource().func_76346_g() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof EntityRAHumanoid) {
            sourceEntity = event.getSource().func_76346_g();
        } else if (event.getEntityLiving().func_110144_aD() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof EntityRAHumanoid) {
            sourceEntity = event.getEntityLiving().func_110144_aD();
        }
        if (sourceEntity != null && (rpgData = RpgData.getRpgData(sourceEntity)).getClassId() != null && !rpgData.getClassId().isEmpty()) {
            int xpAmount;
            int level = rpgData.getLevel();
            if (event.getEntity() instanceof EntityRABase) {
                EntityRABase raHumanoid = (EntityRABase)event.getEntity();
                xpAmount = (int)(raHumanoid.func_110138_aP() + (float)RpgData.getRpgData((Entity)raHumanoid).getLevel());
            } else {
                xpAmount = (int)event.getEntityLiving().func_110138_aP();
            }
            rpgData.addXP(xpAmount);
            if (sourceEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sourceEntity;
                if (player.func_184614_ca().func_77973_b() instanceof IRAClassItem) {
                    IRAClassItem weapon = (IRAClassItem)player.func_184614_ca().func_77973_b();
                    boolean rightClass = false;
                    for (int i = 0; i < weapon.getRAClassList().length; ++i) {
                        if (!weapon.getRAClassList()[i].getId().equalsIgnoreCase(rpgData.getClassId())) continue;
                        rightClass = true;
                        break;
                    }
                    if (!rightClass && weapon.getRAClassList().length > 0) {
                        String weaponName = player.func_184614_ca().func_77973_b().getRegistryName().func_110623_a();
                        int curProgression = rpgData.getWeaponProgression(weaponName);
                        int addProgression = 1;
                        addProgression = curProgression < 100 ? 35 : (curProgression < 200 ? 20 : (curProgression < 500 ? 10 : 5));
                        if (Math.floor((double)curProgression / 100.0) < Math.floor((double)(curProgression + addProgression) / 100.0)) {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Increased weapon mastery of " + player.func_184614_ca().func_77973_b().func_77653_i(player.func_184614_ca()) + "! Attack penalty reduced by 0.1!"));
                        }
                        rpgData.setWeaponProgression(weaponName, curProgression + addProgression);
                    }
                }
                PacketSyncRpgData packetSyncRpgData = new PacketSyncRpgData((Entity)player, rpgData);
                packetSyncRpgData.levelUpSound = true;
                Ranger.RANGER_CHANNEL.sendTo((IMessage)packetSyncRpgData, (EntityPlayerMP)player);
            } else {
                rpgData.addXP(xpAmount);
                if (rpgData.getLevel() != level) {
                    Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData(sourceEntity, rpgData));
                }
                if (sourceEntity instanceof EntityRAHumanoid) {
                    EntityRAHumanoid raSource = (EntityRAHumanoid)sourceEntity;
                    raSource.applyLevelModifiers(rpgData);
                    if (raSource.func_70902_q() instanceof EntityPlayerMP) {
                        EntityPlayerMP owner = (EntityPlayerMP)raSource.func_70902_q();
                        IRpgData ownerData = RpgData.getRpgData((Entity)owner);
                        Skill.SkillUpgrade bbUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.BROTHERBAND.getId()).getCurrentUpgrade(ownerData);
                        ownerData.addXP(xpAmount / 2);
                        if (bbUpgrade != null) {
                            int shareAmount = (int)((float)xpAmount * bbUpgrade.value);
                            ownerData.addXP(shareAmount);
                            List nearby = raSource.field_70170_p.func_175647_a(EntityRABase.class, owner.func_174813_aQ().func_186662_g((double)bbUpgrade.range), e -> e != raSource && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches((EntityLivingBase)owner, (EntityLivingBase)e, "hired"));
                            for (EntityRABase entityRABase : nearby) {
                                IRpgData hiredData = RpgData.getRpgData((Entity)entityRABase);
                                int hl = hiredData.getLevel();
                                hiredData.addXP(shareAmount);
                                if (hl == hiredData.getLevel()) continue;
                                Ranger.RANGER_CHANNEL.sendToAll((IMessage)new PacketSyncRpgData((Entity)entityRABase, hiredData));
                            }
                        }
                        Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketSyncRpgData((Entity)raSource.func_70902_q(), ownerData), (EntityPlayerMP)raSource.func_70902_q());
                    }
                }
            }
        }
        if (event.getEntity().hasCapability(RpgDataProvider.RPG_DATA, null) && event.getSource().func_76346_g() != null && event.getSource().func_76346_g().hasCapability(RpgDataProvider.RPG_DATA, null)) {
            Skill hnSkill;
            Skill.SkillUpgrade hnUpgrade;
            sourceEntity = event.getSource().func_76346_g();
            IRpgData hurtData = RpgData.getRpgData(event.getEntity());
            IRpgData rpgData2 = RpgData.getRpgData(event.getSource().func_76346_g());
            rpgData2.getKilledNations().add(hurtData.getNation());
            Skill.SkillUpgrade vvUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.VALLASVOW.getId()).getCurrentUpgrade(rpgData2);
            if (vvUpgrade != null && hurtData.getKilledNations().contains(rpgData2.getNation())) {
                event.getSource().func_76346_g().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Vallasvow fulfilled!"));
            }
            if ((hnUpgrade = (hnSkill = RARpgManager.getSkill(RARpgManager.SkillId.HONOR.getId())).getCurrentUpgrade(rpgData2)) != null) {
                float damageToAllies = 0.0f;
                for (Map.Entry<Integer, Float> entry : hurtData.getDamageToEntities().entrySet()) {
                    Entity entity = sourceEntity.field_70170_p.func_73045_a(entry.getKey().intValue());
                    if (entity == null || entity == sourceEntity || !RARpgManager.isAllied(entity, sourceEntity)) continue;
                    damageToAllies += entry.getValue().floatValue();
                }
                if (damageToAllies >= 15.0f) {
                    hnSkill.applyEffects((EntityLivingBase)sourceEntity, (EntityLivingBase)sourceEntity, hnSkill, hnUpgrade);
                    sourceEntity.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Honor Kill!"));
                }
            }
        }
        if (event.getEntity() instanceof EntityWargal || event.getEntity() instanceof EntityPlayer && RpgData.getRpgData(event.getEntity()).getClassId().equalsIgnoreCase(RARpgManager.ClassId.WARGAL.getId())) {
            int range = 20;
            EntityLivingBase entity = event.getEntityLiving();
            List nearby = entity.field_70170_p.func_175647_a(EntityPlayer.class, entity.func_174813_aQ().func_186662_g((double)range), e -> e != entity && !e.field_70128_L && e.func_70104_M() && RARpgManager.targetMatches(entity, (EntityLivingBase)e, "allies_same_class"));
            Skill stSkill = RARpgManager.getSkill(RARpgManager.SkillId.SHARED_THOUGHT.getId());
            for (EntityPlayer player : nearby) {
                Skill.SkillUpgrade stUpgrade = stSkill.getCurrentUpgrade(RpgData.getRpgData((Entity)player));
                if (stUpgrade == null) continue;
                stSkill.applyEffects(entity, (EntityLivingBase)player, stSkill, stUpgrade);
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer().func_70644_a(EffectRegistry.DIGGY_DIGGY_HOLE)) {
            float f = event.getOriginalSpeed();
            event.setNewSpeed(f *= 1.0f + (float)(event.getEntityPlayer().func_70660_b(EffectRegistry.DIGGY_DIGGY_HOLE).func_76458_c() + 1) * 0.25f);
        }
    }

    @SubscribeEvent
    public static void breakBlockEvent(BlockEvent.BreakEvent event) {
        EntityPlayer player;
        IRpgData rpgData;
        if (event.getPlayer() != null && (rpgData = RpgData.getRpgData((Entity)(player = event.getPlayer()))).getClassId().equalsIgnoreCase(RARpgManager.ClassId.CELTIC_MINER.getId())) {
            Skill.SkillUpgrade mUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.MASTER_MINER.getId()).getCurrentUpgrade(rpgData);
            Item dropped = Items.field_190931_a;
            if (event.getState().func_177230_c() instanceof BlockOre) {
                BlockOre oreBlock = (BlockOre)event.getState().func_177230_c();
                dropped = oreBlock.func_180660_a(event.getState(), random, 0);
            } else if (event.getState().func_177230_c() instanceof BlockRedstoneOre) {
                dropped = Items.field_151137_ax;
            }
            if (dropped != Items.field_190931_a) {
                if (dropped == Items.field_151045_i) {
                    rpgData.addXP(100);
                } else if (dropped == Items.field_151166_bC) {
                    rpgData.addXP(200);
                } else if (dropped == Items.field_151137_ax) {
                    rpgData.addXP(75);
                } else if (event.getState().func_177230_c() instanceof BlockOre) {
                    if (dropped == Items.field_151100_aR) {
                        rpgData.addXP(50);
                    } else if (event.getState().func_177230_c() == Blocks.field_150352_o) {
                        rpgData.addXP(25);
                    } else if (event.getState().func_177230_c() == Blocks.field_150366_p) {
                        rpgData.addXP(10);
                    } else {
                        rpgData.addXP(5);
                    }
                }
            }
            if (event.getState().func_177230_c() instanceof BlockOre) {
                rpgData.addXP(1);
            }
            Ranger.RANGER_CHANNEL.sendTo((IMessage)new PacketSyncRpgData((Entity)player, rpgData), (EntityPlayerMP)player);
            if (mUpgrade != null && !(dropped instanceof ItemBlock) && dropped != Items.field_190931_a) {
                BlockPos pos = event.getPos();
                World worldIn = player.func_130014_f_();
                ItemStack stack = new ItemStack(dropped, (int)mUpgrade.value);
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                worldIn.func_72838_d((Entity)entityitem);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void interactEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof EntityHorse) {
            Skill.SkillUpgrade hwUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.HORSE_WHISPERER.getId()).getCurrentUpgrade(RpgData.getRpgData((Entity)event.getEntityPlayer()));
            EntityHorse horse = (EntityHorse)event.getTarget();
            if (!horse.func_110248_bS() && hwUpgrade != null) {
                horse.func_110263_g(event.getEntityPlayer());
                horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(horse.func_110138_aP() * 2.0f));
                horse.func_70691_i(horse.func_110138_aP());
            }
        }
    }

    @SubscribeEvent
    public static void itemUseFinishEvent(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().func_77973_b() instanceof ItemFood && event.getEntityLiving() instanceof EntityPlayer) {
            ItemFood food = (ItemFood)event.getItem().func_77973_b();
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRpgData rpgData = RpgData.getRpgData((Entity)player);
            Skill.SkillUpgrade fsUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.FEAST.getId()).getCurrentUpgrade(rpgData);
            Skill.SkillUpgrade wbUpgrade = RARpgManager.getSkill(RARpgManager.SkillId.WILD_BEAST.getId()).getCurrentUpgrade(rpgData);
            if (fsUpgrade != null && (food.func_77845_h() || food == Items.field_151115_aP)) {
                player.func_71024_bL().func_75122_a((int)((float)food.func_150905_g(event.getItem()) * wbUpgrade.value), food.func_150906_h(event.getItem()) * wbUpgrade.value);
            }
            if (wbUpgrade != null && Arrays.asList(RAW_MEAT_LIST).contains(food)) {
                player.func_71024_bL().func_75122_a((int)((float)food.func_150905_g(event.getItem()) * wbUpgrade.value), food.func_150906_h(event.getItem()) * wbUpgrade.value);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IRpgData data = RpgData.getRpgData((Entity)player);
        IRpgData oldData = RpgData.getRpgData((Entity)event.getOriginal());
        RpgDataProvider.RPG_DATA.readNBT((Object)data, null, RpgDataProvider.RPG_DATA.writeNBT((Object)oldData, null));
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110624_b().equalsIgnoreCase("ranger")) continue;
            if (mapping.key.func_110623_a().equalsIgnoreCase("iron_spear")) {
                mapping.remap((IForgeRegistryEntry)RAItemLoader.getItem("javelin"));
            }
            if (mapping.key.func_110623_a().equalsIgnoreCase("temujai_kaijin_headband")) {
                mapping.remap((IForgeRegistryEntry)RAItemLoader.getItem("temujai_warrior_helm"));
            }
            if (mapping.key.func_110623_a().equalsIgnoreCase("morgarath_boots")) {
                mapping.remap((IForgeRegistryEntry)RAItemLoader.getItem("morgaraths_boots"));
            }
            if (mapping.key.func_110623_a().equalsIgnoreCase("morgarath_pants")) {
                mapping.remap((IForgeRegistryEntry)RAItemLoader.getItem("morgaraths_pants"));
            }
            if (!mapping.key.func_110623_a().equalsIgnoreCase("morgarath_tunic")) continue;
            mapping.remap((IForgeRegistryEntry)RAItemLoader.getItem("morgaraths_tunic"));
        }
    }

    static {
        cancelNextKnockback = false;
        ticksSinceLastSwingField = ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"ticksSinceLastSwing", "field_184617_aD"});
        ticksSinceLastSwingField.setAccessible(true);
        random = new Random();
        ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA5");
        attributeMap = new HashMap<String, UUID>();
        RAW_MEAT_LIST = new Item[]{Items.field_151147_al, Items.field_151076_bf, Items.field_151082_bd, Items.field_179561_bm, Items.field_151078_bh, Items.field_151115_aP, Items.field_179558_bo};
    }
}

