/*
 * Decompiled with CFR 0.152.
 */
package ranger.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ranger.blocks.RABlockLoader;
import ranger.items.IRAClassItem;
import ranger.items.ItemRAArmor;
import ranger.items.ItemRASword;
import ranger.items.ItemWeapon;
import ranger.items.RAItemLoader;
import ranger.rpg.RAClass;
import ranger.rpg.RARpgManager;
import ranger.rpg.RpgData;
import ranger.util.RARecipe;

public class RACrafting {
    private static final HashMap<String, ArrayList<RARecipe>> recipesForClass = new HashMap();

    public static ArrayList<RARecipe> getRecipesFor(String raClass) {
        return recipesForClass.computeIfAbsent(raClass, k -> recipesForClass.put(raClass, new ArrayList()));
    }

    public static void registerRecipes() {
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("bronze_oakleaf"), new ItemStack((Block)Blocks.field_150362_t, 1), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151074_bl));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("silver_oakleaf"), new ItemStack((Block)Blocks.field_150362_t, 1), new ItemStack(Items.field_151042_j));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("gold_oakleaf"), new ItemStack((Block)Blocks.field_150362_t, 1), new ItemStack(Items.field_151043_k));
        for (Item item : RAItemLoader.items.values()) {
            Object raArmor;
            int i;
            IRAClassItem weapon;
            if (item instanceof ItemWeapon) {
                weapon = (ItemWeapon)item;
                ItemStack mainItem = weapon == RAItemLoader.getItem("striker") ? new ItemStack(Items.field_151043_k, ((ItemWeapon)weapon).craftIronCount) : (weapon == RAItemLoader.getItem("wooden_mace") || weapon == RAItemLoader.getItem("wooden_club") ? new ItemStack(Blocks.field_150344_f, ((ItemWeapon)weapon).craftIronCount) : (((ItemWeapon)weapon).hardSteel() && weapon != RAItemLoader.getItem("arridi_lance") ? new ItemStack(RAItemLoader.getItem("hardened_steel"), ((ItemWeapon)weapon).craftIronCount) : new ItemStack(Items.field_151042_j, ((ItemWeapon)weapon).craftIronCount)));
                for (i = 0; i < ((ItemWeapon)weapon).getRAClassList().length; ++i) {
                    if (((ItemWeapon)weapon).craftIronCount < 0) continue;
                    if (weapon == RAItemLoader.getItem("ranger_saxe") && !((ItemWeapon)weapon).getRAClassList()[i].getId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) {
                        if (!((ItemWeapon)weapon).getRAClassList()[i].getId().equalsIgnoreCase(RARpgManager.ClassId.RANGER.getId())) continue;
                        RACrafting.addRecipeFor(((ItemWeapon)weapon).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151055_y, 1), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151042_j));
                        continue;
                    }
                    RACrafting.addRecipeFor(((ItemWeapon)weapon).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151055_y, ((ItemWeapon)weapon).craftStickCount), mainItem);
                }
                continue;
            }
            if (item instanceof ItemRASword) {
                weapon = (ItemRASword)item;
                ItemStack mainItem = ((ItemRASword)weapon).hardSteel() ? new ItemStack(RAItemLoader.getItem("hardened_steel"), ((ItemRASword)weapon).craftIronCount) : new ItemStack(Items.field_151042_j, ((ItemRASword)weapon).craftIronCount);
                for (i = 0; i < ((ItemRASword)weapon).getRAClassList().length; ++i) {
                    if (((ItemRASword)weapon).craftIronCount < 0) continue;
                    RACrafting.addRecipeFor(((ItemRASword)weapon).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151055_y, ((ItemRASword)weapon).craftStickCount), mainItem);
                }
                continue;
            }
            if (!(item instanceof ItemRAArmor) || Arrays.asList(((ItemRAArmor)(raArmor = (ItemRAArmor)item)).getRAClassList()).contains((Object)RARpgManager.ClassId.WARGAL)) continue;
            int count = 0;
            switch (raArmor.func_185083_B_()) {
                case FEET: {
                    count = 4;
                    break;
                }
                case LEGS: {
                    count = 7;
                    break;
                }
                case CHEST: {
                    count = 8;
                    break;
                }
                case HEAD: {
                    count = 5;
                }
            }
            if (raArmor.func_82812_d() == RAItemLoader.TOUGH_WOOL) {
                count /= 2;
            }
            for (i = 0; i < ((ItemRAArmor)raArmor).getRAClassList().length; ++i) {
                if (raArmor.func_82812_d() == RAItemLoader.RANGER_MATERIAL) {
                    if (raArmor == RAItemLoader.getItem("ranger_tunic_apprentice")) {
                        RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(RAItemLoader.getItem("bronze_oakleaf")), new ItemStack(Blocks.field_150325_L, 4), new ItemStack(Items.field_151116_aA, 4));
                        continue;
                    }
                    if (raArmor == RAItemLoader.getItem("ranger_tunic")) {
                        RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(RAItemLoader.getItem("silver_oakleaf")), new ItemStack(Blocks.field_150325_L, 4), new ItemStack(Items.field_151116_aA, 4));
                        continue;
                    }
                    if (raArmor == RAItemLoader.getItem("ranger_tunic_retired")) {
                        RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(RAItemLoader.getItem("gold_oakleaf")), new ItemStack(Blocks.field_150325_L, 4), new ItemStack(Items.field_151116_aA, 4));
                        continue;
                    }
                    RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Blocks.field_150325_L, count));
                    continue;
                }
                if (raArmor.func_82812_d() == RAItemLoader.TOUGH_WOOL) {
                    RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Blocks.field_150325_L, count));
                    continue;
                }
                if (raArmor.func_82812_d() == RAItemLoader.TOUGH_LEATHER || raArmor.func_82812_d() == RAItemLoader.TATTERED_LEATHER) {
                    if (raArmor.getRegistryName().func_110623_a().contains("paint")) {
                        RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151100_aR, 1, 11));
                        continue;
                    }
                    RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151116_aA, count));
                    continue;
                }
                if (raArmor == RAItemLoader.getItem("scotti_padded_tunic")) {
                    RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151116_aA, 4), new ItemStack(Items.field_151042_j, 4));
                    continue;
                }
                RACrafting.addRecipeFor(((ItemRAArmor)raArmor).getRAClassList()[i].getId(), item, new ItemStack(Items.field_151042_j, count));
            }
        }
        RACrafting.addRecipeFor(RARpgManager.ClassId.CELTIC_MINER.getId(), new ItemStack(RAItemLoader.getItem("celtic_stone_pickaxe")), new ItemStack(Items.field_151055_y, 2), new ItemStack(Blocks.field_150347_e, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.CELTIC_MINER.getId(), new ItemStack(RAItemLoader.getItem("celtic_iron_pickaxe")), new ItemStack(Items.field_151055_y, 2), new ItemStack(Items.field_151042_j, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("recurve_bow"), new ItemStack(Items.field_151055_y, 3), new ItemStack(Items.field_151007_F, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("ranger_longbow"), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151007_F, 4));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(Items.field_151032_g, 8), new ItemStack(Items.field_151055_y, 1), new ItemStack(Items.field_151008_G), new ItemStack(Blocks.field_150347_e));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("flaming_arrow"), 1), new ItemStack(Items.field_151032_g, 1), new ItemStack(Blocks.field_150478_aa));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), RAItemLoader.getItem("longbow"), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151007_F, 4));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("araluen_shield"), 1), new ItemStack(Items.field_151042_j, 1), new ItemStack(Blocks.field_150344_f, 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("skandian_shield"), 1), new ItemStack(Items.field_151042_j, 1), new ItemStack(Blocks.field_150344_f, 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("ale_empty"), 1), new ItemStack(Blocks.field_150344_f, 1), new ItemStack(Items.field_151055_y));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), new ItemStack(RABlockLoader.getBlock("ale_barrel"), 1), new ItemStack(Blocks.field_150344_f, 4), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151102_aT), new ItemStack((Block)Blocks.field_150328_O, 1, 4), new ItemStack((Block)Blocks.field_150338_P));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SCOTTI_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("scotti_targe"), 1), new ItemStack(Items.field_151042_j, 1), new ItemStack(Blocks.field_150344_f, 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), new ItemStack(RAItemLoader.getItem("nigiri"), 1, 0), new ItemStack(Items.field_151115_aP, 1), new ItemStack(Items.field_151014_N));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), new ItemStack(RAItemLoader.getItem("nigiri"), 1, 1), new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_151014_N));
        RACrafting.addRecipeFor(RARpgManager.ClassId.TEMUJAI_ARCHER.getId(), new ItemStack(Items.field_151032_g, 8), new ItemStack(Items.field_151055_y, 1), new ItemStack(Items.field_151008_G), new ItemStack(Blocks.field_150347_e));
        RACrafting.addRecipeFor(RARpgManager.ClassId.TEMUJAI_ARCHER.getId(), new ItemStack(RAItemLoader.getItem("flaming_arrow"), 1), new ItemStack(Items.field_151032_g, 1), new ItemStack(Blocks.field_150478_aa));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("coffee_grounds"), 1), new ItemStack(Items.field_151100_aR, 1, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("coffee_mug_empty"), 1), new ItemStack(Items.field_151119_aD, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("coffee_mug"), 1), new ItemStack(RAItemLoader.getItem("coffee_mug_empty")), new ItemStack(RAItemLoader.getItem("coffee_grounds")));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("coffee_grounds"), 1), new ItemStack(Items.field_151100_aR, 1, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("coffee_mug_empty"), 1), new ItemStack(Items.field_151119_aD, 3));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("coffee_mug"), 1), new ItemStack(RAItemLoader.getItem("coffee_mug_empty")), new ItemStack(RAItemLoader.getItem("coffee_grounds")));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("challenge_morgarath"), new ItemStack(Items.field_151040_l, 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), RAItemLoader.getItem("challenge_morgarath"), new ItemStack(Items.field_151040_l, 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SCOTTI_WARRIOR.getId(), RAItemLoader.getItem("challenge_morgarath"), new ItemStack(Items.field_151040_l, 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARRIDI_WARRIOR.getId(), RAItemLoader.getItem("challenge_morgarath"), new ItemStack(Items.field_151040_l, 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), RAItemLoader.getItem("challenge_morgarath"), new ItemStack(Items.field_151040_l, 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SCOTTI_WARRIOR.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARRIDI_WARRIOR.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), RAItemLoader.getItem("challenge_temujai"), new ItemStack(RAItemLoader.getItem("temujai_saber"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), RAItemLoader.getItem("challenge_yusal"), new ItemStack(RAItemLoader.getItem("arridi_scimitar"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), RAItemLoader.getItem("challenge_yusal"), new ItemStack(RAItemLoader.getItem("arridi_scimitar"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), RAItemLoader.getItem("challenge_yusal"), new ItemStack(RAItemLoader.getItem("arridi_scimitar"), 2));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), RAItemLoader.getItem("challenge_yusal"), new ItemStack(RAItemLoader.getItem("arridi_scimitar"), 2));
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        int i = 0;
        for (String nationId : RARpgManager.nationMap.keySet()) {
            indices.put(nationId, i);
            ++i;
        }
        RACrafting.addRecipeFor(RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("tattered_leather_pants"), 1), new ItemStack(Items.field_151116_aA, 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("tattered_leather_tunic"), 1), new ItemStack(Items.field_151116_aA, 1));
        Predicate tailorFilter = p -> RpgData.getRpgData((Entity)p).getSkillLevel(RARpgManager.SkillId.PRIMITIVE_TAILOR.getId()) > 0;
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("black_leather_pants"), 1), new ItemStack(Items.field_151116_aA, 7));
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("black_leather_tunic"), 1), new ItemStack(Items.field_151116_aA, 8));
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("wargal_hood"), 1), new ItemStack(Items.field_151116_aA, 5));
        Predicate tailorFilter2 = p -> RpgData.getRpgData((Entity)p).getSkillLevel(RARpgManager.SkillId.PRIMITIVE_TAILOR.getId()) > 1;
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter2, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("black_studded_leather_tunic"), 1), new ItemStack(Items.field_151116_aA, 8), new ItemStack(Items.field_151042_j, 4));
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter2, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("wargal_champion_pants"), 1), new ItemStack(RAItemLoader.getItem("araluen_hero_pants")), new ItemStack(RAItemLoader.getItem("hardened_steel"), 1));
        RACrafting.addRecipeFor((Predicate<EntityPlayer>)tailorFilter2, RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("wargal_champion_tunic"), 1), new ItemStack(RAItemLoader.getItem("araluen_hero_tunic")), new ItemStack(RAItemLoader.getItem("hardened_steel"), 2));
        int skandia = (Integer)indices.get(RARpgManager.NationId.SKANDIA.getId());
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SCOTTI_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARRIDI_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.WARGAL.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, skandia), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("temujai_general_helm"), 1));
        int arrida = (Integer)indices.get(RARpgManager.NationId.ARRIDA.getId());
        RACrafting.addRecipeFor(RARpgManager.ClassId.RANGER.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, arrida), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("tualaghi_leader_keffiyeh"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARALUEN_KNIGHT.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, arrida), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("tualaghi_leader_keffiyeh"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SKANDIAN_WARRIOR.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, arrida), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("tualaghi_leader_keffiyeh"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), new ItemStack(RAItemLoader.getItem("treaty"), 1, arrida), new ItemStack(Items.field_151121_aF, 1), new ItemStack(RAItemLoader.getItem("tualaghi_leader_keffiyeh"), 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.ARRIDI_WARRIOR.getId(), RAItemLoader.getItem("hardened_steel"), new ItemStack(Items.field_151042_j, 1), new ItemStack(Items.field_151045_i, 1));
        RACrafting.addRecipeFor(RARpgManager.ClassId.SENSHI.getId(), RAItemLoader.getItem("hardened_steel"), new ItemStack(Items.field_151042_j, 1), new ItemStack(Items.field_151045_i, 1));
        for (RAClass raClass : RARpgManager.classMap.values()) {
            RACrafting.addRecipeFor(raClass.id, new ItemStack(RABlockLoader.getBlock("rope"), 4), new ItemStack(Items.field_151007_F, 4));
            RACrafting.addRecipeFor(raClass.id, new ItemStack(RAItemLoader.getItem("flag_of_command"), 1), new ItemStack(Items.field_151055_y, 2), new ItemStack(Blocks.field_150325_L, 1));
        }
        GameRegistry.addSmelting((Item)RAItemLoader.getItem("ranger_saxe"), (ItemStack)new ItemStack(RAItemLoader.getItem("hardened_steel")), (float)1.0f);
        GameRegistry.addSmelting((Item)RAItemLoader.getItem("arridi_broadsword"), (ItemStack)new ItemStack(RAItemLoader.getItem("hardened_steel")), (float)1.0f);
        GameRegistry.addSmelting((Item)RAItemLoader.getItem("senshi_katana"), (ItemStack)new ItemStack(RAItemLoader.getItem("hardened_steel")), (float)1.0f);
        GameRegistry.addSmelting((Item)RAItemLoader.getItem("senshi_wakizashi"), (ItemStack)new ItemStack(RAItemLoader.getItem("hardened_steel")), (float)1.0f);
        GameRegistry.addSmelting((Item)RAItemLoader.getItem("senshi_nagamaki"), (ItemStack)new ItemStack(RAItemLoader.getItem("hardened_steel")), (float)2.0f);
    }

    public static void addRecipeFor(String raClass, ItemStack craft, ItemStack ... require) {
        RACrafting.addRecipeFor(null, raClass, craft, require);
    }

    public static void addRecipeFor(String raClass, Item craft, ItemStack ... require) {
        if (craft == null) {
            return;
        }
        for (int i = 0; i < require.length; ++i) {
            if (!require[i].func_190926_b()) continue;
            return;
        }
        RACrafting.addRecipeFor(raClass, new ItemStack(craft), require);
    }

    public static void addRecipeFor(@Nullable Predicate<EntityPlayer> filter, String raClass, ItemStack craft, ItemStack ... require) {
        if (craft.func_190926_b()) {
            return;
        }
        for (int i = 0; i < require.length; ++i) {
            if (!require[i].func_190926_b()) continue;
            return;
        }
        if (!recipesForClass.containsKey(raClass)) {
            recipesForClass.put(raClass, new ArrayList());
        }
        RARecipe recipe = new RARecipe(craft, require, filter);
        recipesForClass.get(raClass).add(recipe);
    }
}

