/*
 * Decompiled with CFR 0.152.
 */
package ranger.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class RAWorldData
extends WorldSavedData {
    private final Map<String, Set<String>> treatyMap = new HashMap<String, Set<String>>();

    public RAWorldData(String name) {
        super(name);
    }

    public void addTreaty(String nationA, String nationB) {
        this.treatyMap.computeIfAbsent(nationA, k -> new HashSet()).add(nationB);
        this.treatyMap.computeIfAbsent(nationB, k -> new HashSet()).add(nationA);
        this.func_76185_a();
    }

    public void removeTreaty(String nationA, String nationB) {
        ((Set)this.treatyMap.getOrDefault(nationA, new HashSet())).remove(nationB);
        ((Set)this.treatyMap.getOrDefault(nationB, new HashSet())).remove(nationA);
        this.func_76185_a();
    }

    public boolean areNationsAllied(String nationA, String nationB) {
        return nationA.equalsIgnoreCase(nationB) || this.treatyMap.getOrDefault(nationA, Collections.emptySet()).contains(nationB);
    }

    public Set<String> getAllies(String nation) {
        return Collections.unmodifiableSet(this.treatyMap.getOrDefault(nation, Collections.emptySet()));
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.treatyMap.clear();
        NBTTagList list = nbt.func_150295_c("Treaties", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            String nation = entry.func_74779_i("Nation");
            NBTTagList alliesList = entry.func_150295_c("Allies", 8);
            HashSet<String> allies = new HashSet<String>();
            for (int j = 0; j < alliesList.func_74745_c(); ++j) {
                allies.add(alliesList.func_150307_f(j));
            }
            this.treatyMap.put(nation, allies);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Set<String>> entry : this.treatyMap.entrySet()) {
            NBTTagCompound nationTag = new NBTTagCompound();
            nationTag.func_74778_a("Nation", entry.getKey());
            NBTTagList alliesList = new NBTTagList();
            for (String ally : entry.getValue()) {
                alliesList.func_74742_a((NBTBase)new NBTTagString(ally));
            }
            nationTag.func_74782_a("Allies", (NBTBase)alliesList);
            list.func_74742_a((NBTBase)nationTag);
        }
        compound.func_74782_a("Treaties", (NBTBase)list);
        return compound;
    }

    public static RAWorldData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        RAWorldData data = (RAWorldData)storage.func_75742_a(RAWorldData.class, "ranger");
        if (data == null) {
            data = new RAWorldData("ranger");
            storage.func_75745_a("ranger", (WorldSavedData)data);
        }
        return data;
    }
}

