/*
 * Decompiled with CFR 0.152.
 */
package ranger.util;

import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RayTraceHelper {
    public static RayTraceResult getLookTarget(EntityLivingBase owner, double reachDistance, boolean livingOnly) {
        return RayTraceHelper.getLookTarget(owner, reachDistance, livingOnly, false);
    }

    public static RayTraceResult getLookTarget(EntityLivingBase owner, double reachDistance, boolean livingOnly, boolean includeRiding) {
        Vec3d eyePos = owner.func_174824_e(1.0f);
        Vec3d lookVec = owner.field_70170_p.field_72995_K && owner instanceof EntityPlayerSP ? ((EntityPlayerSP)owner).func_70676_i(1.0f) : owner.func_70676_i(1.0f);
        Vec3d reachVec = eyePos.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        RayTraceResult blockResult = owner.field_70170_p.func_147447_a(eyePos, reachVec, false, false, true);
        Entity pointedEntity = null;
        double minDistance = reachDistance;
        Vec3d hitVec = null;
        List entities = owner.field_70170_p.func_72839_b((Entity)owner, owner.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance).func_72314_b(1.0, 1.0, 1.0));
        for (Entity entity1 : entities) {
            double dist;
            AxisAlignedBB aabb;
            RayTraceResult result;
            if (!entity1.func_70067_L() || !(entity1 instanceof EntityLivingBase) && livingOnly || !includeRiding && entity1 == owner.func_184187_bx() || (result = (aabb = entity1.func_174813_aQ().func_186662_g(0.3)).func_72327_a(eyePos, reachVec)) == null || !((dist = eyePos.func_72438_d(result.field_72307_f)) < minDistance)) continue;
            pointedEntity = entity1;
            hitVec = result.field_72307_f;
            minDistance = dist;
        }
        if (pointedEntity != null && (blockResult == null || minDistance < eyePos.func_72438_d(blockResult.field_72307_f))) {
            return new RayTraceResult(pointedEntity, hitVec);
        }
        return blockResult;
    }
}

