/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum;

import com.mojang.authlib.GameProfile;
import com.teamresourceful.resourcefulconfig.common.config.Configurator;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.api.spells.Pattern;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.common.blocks.MagicDoorBlock;
import dev.cammiescorner.arcanuscontinuum.common.blocks.entities.MagicDoorBlockEntity;
import dev.cammiescorner.arcanuscontinuum.common.enchantments.ManaPoolEnchantment;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.CastSpellPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.SaveBookDataPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.SetCastingPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.ShootOrbsPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.SyncPatternPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncConfigValuesPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncStatusEffectPacket;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlockEntities;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlocks;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusCommands;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusCriteriaTriggers;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEnchantments;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEntities;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusItems;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusMobEffects;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusParticles;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusPointsOfInterest;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusRecipes;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusScreenHandlers;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusStructureProcessorTypes;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.cammiescorner.arcanuscontinuum.common.util.supporters.HaloData;
import dev.cammiescorner.arcanuscontinuum.common.util.supporters.WizardData;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.api.SyncToken;
import dev.upcraft.sparkweave.api.registry.RegistryService;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Arcanus
implements ModInitializer {
    public static final Configurator configurator = new Configurator();
    public static final String MOD_ID = "arcanuscontinuum";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"arcanuscontinuum");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##,####.##");
    public static final class_5321<class_2378<SpellComponent>> SPELL_COMPONENTS_REGISTRY_KEY = class_5321.method_29180((class_2960)Arcanus.id("spell_components"));
    public static final class_7922<SpellComponent> SPELL_COMPONENTS = (class_7922)FabricRegistryBuilder.createDefaulted(SPELL_COMPONENTS_REGISTRY_KEY, (class_2960)Arcanus.id("empty")).buildAndRegister();
    public static final Color DEFAULT_MAGIC_COLOUR = Color.fromInt(6873599, Color.Ordering.RGB);
    public static final SyncToken<WizardData> WIZARD_DATA = DataSyncAPI.register(WizardData.class, (class_2960)WizardData.ID, WizardData.CODEC);
    public static final SyncToken<HaloData> HALO_DATA = DataSyncAPI.register(HaloData.class, (class_2960)HaloData.ID, HaloData.CODEC);
    public static final UUID SPELL_SPEED_MODIFIER_ID = UUID.fromString("e348efa3-7987-4912-b82a-03c5c75eccb1");

    public void onInitialize() {
        configurator.registerConfig(ArcanusConfig.class);
        RegistryService registryService = RegistryService.get();
        ArcanusEntityAttributes.registerAll();
        ArcanusEntities.ENTITY_TYPES.accept(registryService);
        ArcanusEnchantments.ENCHANTMENTS.accept(registryService);
        ArcanusBlocks.BLOCKS.accept(registryService);
        ArcanusItems.ITEM_GROUPS.accept(registryService);
        ArcanusItems.ITEMS.accept(registryService);
        ArcanusBlockEntities.BLOCK_ENTITY_TYPES.accept(registryService);
        ArcanusParticles.PARTICLE_TYPES.accept(registryService);
        ArcanusPointsOfInterest.register();
        ArcanusRecipes.RECIPE_SERIALIZERS.accept(registryService);
        ArcanusScreenHandlers.SCREEN_HANDLERS.accept(registryService);
        ArcanusSpellComponents.SPELL_COMPONENTS.accept(registryService);
        ArcanusMobEffects.MOB_EFFECTS.accept(registryService);
        ArcanusStructureProcessorTypes.STRUCTURE_PROCESSORS.accept(registryService);
        ArcanusCriteriaTriggers.register();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CastSpellPacket.ID, CastSpellPacket::handler);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SetCastingPacket.ID, SetCastingPacket::handler);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SaveBookDataPacket.ID, SaveBookDataPacket::handler);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SyncPatternPacket.ID, SyncPatternPacket::handler);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ShootOrbsPacket.ID, ShootOrbsPacket::handler);
        CommandRegistrationCallback.EVENT.register(ArcanusCommands::init);
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, attributeModifiers) -> {
            if (ArcanusConfig.Enchantments.ManaPool.maxLevel <= 0) {
                return;
            }
            int manaPoolLevel = class_1890.method_8225((class_1887)((class_1887)ArcanusEnchantments.MANA_POOL.get()), (class_1799)stack);
            if (slot.method_46643() && manaPoolLevel > 0) {
                class_1738 armorItem;
                class_1792 patt5927$temp = stack.method_7909();
                if (patt5927$temp instanceof class_1738 && (armorItem = (class_1738)patt5927$temp).method_7685() != slot) {
                    return;
                }
                class_1322 maxManaModifier = new class_1322(ManaPoolEnchantment.getUuidForSlot(slot), "Mana Pool Max Mana Modifier", ArcanusConfig.Enchantments.ManaPool.manaPerLevel * (double)manaPoolLevel, ArcanusConfig.Enchantments.ManaPool.manaModifierOperation);
                attributeModifiers.put((Object)((class_1320)ArcanusEntityAttributes.MAX_MANA.get()), (Object)maxManaModifier);
            }
        });
        EntityElytraEvents.CUSTOM.register((entity, tickElytra) -> entity.method_6059((class_1291)ArcanusMobEffects.MANA_WINGS.get()));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            GameProfile hostProfile = server.method_43824();
            if (hostProfile == null || !hostProfile.getId().equals(handler.field_14140.method_7334().getId())) {
                SyncConfigValuesPacket.send(handler.field_14140);
            }
            SyncStatusEffectPacket.sendToAll((class_1309)handler.field_14140, (class_1291)ArcanusMobEffects.ANONYMITY.get(), handler.field_14140.method_6059((class_1291)ArcanusMobEffects.ANONYMITY.get()));
        });
        EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> {
            if (trackedEntity instanceof class_3222) {
                class_3222 playerEntity = (class_3222)trackedEntity;
                SyncStatusEffectPacket.sendTo(player, (class_1309)playerEntity, (class_1291)ArcanusMobEffects.ANONYMITY.get(), playerEntity.method_6059((class_1291)ArcanusMobEffects.ANONYMITY.get()));
            }
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_1293 copperCurse;
            if (!entity.method_37908().method_8608() && entity.method_37908().method_8532() == 24000L && (copperCurse = entity.method_6112((class_1291)ArcanusMobEffects.COPPER_CURSE.get())) != null) {
                entity.method_6016((class_1291)ArcanusMobEffects.COPPER_CURSE.get());
                if (copperCurse.method_5584() > 24000) {
                    entity.method_6092(new class_1293((class_1291)ArcanusMobEffects.COPPER_CURSE.get(), copperCurse.method_5584() - 24000, 0, true, false));
                }
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            MagicDoorBlockEntity door;
            class_1799 stack = player.method_5998(hand);
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            if (!world.method_8608() && player.method_5715() && stack.method_31574(class_1802.field_8448) && stack.method_7938() && (door = MagicDoorBlock.getBlockEntity(world, state, pos)) != null && door.getOwner() == player) {
                door.setPassword(stack.method_7964().getString());
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (ArcanusComponents.isBlockWarded(world, pos) && !ArcanusComponents.isOwnerOfBlock(player, pos)) {
                class_1750 ctx = new class_1750(world, player, hand, stack, hitResult);
                class_1269 result = stack.method_7981((class_1838)ctx);
                if (!result.method_23665()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.arcanuscontinuum.block_is_warded").method_27692(class_124.field_1061), true);
                    player.method_6104(hand);
                    return class_1269.field_5814;
                }
                return result;
            }
            return class_1269.field_5811;
        });
    }

    public static class_2960 id(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static String format(double d) {
        return DECIMAL_FORMAT.format(d);
    }

    public static int getSpellIndex(List<Pattern> patternList) {
        String pattern;
        return switch (pattern = patternList.get(0).getLetter() + patternList.get(1).getLetter() + patternList.get(2).getLetter()) {
            case "LLL" -> 0;
            case "LLR" -> 1;
            case "LRL" -> 2;
            case "LRR" -> 3;
            case "RRR" -> 4;
            case "RRL" -> 5;
            case "RLR" -> 6;
            case "RLL" -> 7;
            default -> 0;
        };
    }

    public static List<Pattern> getSpellPattern(int index) {
        return switch (index) {
            case 1 -> List.of(Pattern.LEFT, Pattern.LEFT, Pattern.RIGHT);
            case 2 -> List.of(Pattern.LEFT, Pattern.RIGHT, Pattern.LEFT);
            case 3 -> List.of(Pattern.LEFT, Pattern.RIGHT, Pattern.RIGHT);
            case 4 -> List.of(Pattern.RIGHT, Pattern.RIGHT, Pattern.RIGHT);
            case 5 -> List.of(Pattern.RIGHT, Pattern.RIGHT, Pattern.LEFT);
            case 6 -> List.of(Pattern.RIGHT, Pattern.LEFT, Pattern.RIGHT);
            case 7 -> List.of(Pattern.RIGHT, Pattern.LEFT, Pattern.LEFT);
            default -> List.of(Pattern.LEFT, Pattern.LEFT, Pattern.LEFT);
        };
    }

    public static class_5250 getSpellPatternAsText(int index) {
        String string = switch (index) {
            case 0 -> Pattern.LEFT.getSymbol() + "-" + Pattern.LEFT.getSymbol() + "-" + Pattern.LEFT.getSymbol();
            case 1 -> Pattern.LEFT.getSymbol() + "-" + Pattern.LEFT.getSymbol() + "-" + Pattern.RIGHT.getSymbol();
            case 2 -> Pattern.LEFT.getSymbol() + "-" + Pattern.RIGHT.getSymbol() + "-" + Pattern.LEFT.getSymbol();
            case 3 -> Pattern.LEFT.getSymbol() + "-" + Pattern.RIGHT.getSymbol() + "-" + Pattern.RIGHT.getSymbol();
            case 4 -> Pattern.RIGHT.getSymbol() + "-" + Pattern.RIGHT.getSymbol() + "-" + Pattern.RIGHT.getSymbol();
            case 5 -> Pattern.RIGHT.getSymbol() + "-" + Pattern.RIGHT.getSymbol() + "-" + Pattern.LEFT.getSymbol();
            case 6 -> Pattern.RIGHT.getSymbol() + "-" + Pattern.LEFT.getSymbol() + "-" + Pattern.RIGHT.getSymbol();
            case 7 -> Pattern.RIGHT.getSymbol() + "-" + Pattern.LEFT.getSymbol() + "-" + Pattern.LEFT.getSymbol();
            default -> "ERROR";
        };
        return class_2561.method_43470((String)string).method_27694(style -> style.method_27704(Arcanus.id("magic_symbols")));
    }
}

