/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.api.spells;

import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.api.spells.Weight;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class Spell {
    private final List<SpellGroup> groups;
    private final String name;

    public Spell(List<SpellGroup> groups, String name) {
        this.groups = groups;
        this.name = name;
    }

    public Spell() {
        this(List.of(new SpellGroup(SpellShape.empty(), List.of(), List.of())), "Blank");
    }

    public static Spell fromNbt(class_2487 nbt) {
        ArrayList<SpellGroup> groups = new ArrayList<SpellGroup>();
        class_2499 nbtList = nbt.method_10554("ComponentGroups", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            SpellGroup group = SpellGroup.fromNbt(nbtList.method_10602(i));
            if (group.isEmpty()) {
                return new Spell();
            }
            groups.add(group);
        }
        return new Spell(groups, nbt.method_10558("Name"));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 nbtList = new class_2499();
        for (SpellGroup group : this.groups) {
            nbtList.add((Object)group.toNbt());
        }
        nbt.method_10566("ComponentGroups", (class_2520)nbtList);
        nbt.method_10582("Name", this.name != null ? this.name : "Empty");
        return nbt;
    }

    public List<SpellGroup> getComponentGroups() {
        return this.groups;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.groups.isEmpty() || this.groups.get(0).isEmpty();
    }

    public Weight getWeight() {
        int averageWeightIndex = 0;
        if (!this.groups.isEmpty()) {
            int i = 0;
            for (SpellGroup group : this.groups) {
                if (group.isEmpty()) continue;
                averageWeightIndex += group.getAverageWeight().ordinal();
                ++i;
            }
            averageWeightIndex = Math.round((float)averageWeightIndex / (float)i);
        }
        return Weight.values()[averageWeightIndex];
    }

    public double getManaCost() {
        double manaCost = 0.0;
        for (SpellGroup group : this.groups) {
            manaCost += group.getManaCost();
        }
        return manaCost * this.getManaMultiplier();
    }

    public double getManaMultiplier() {
        double manaMultiplier = 1.0;
        for (SpellGroup group : this.groups) {
            manaMultiplier += group.shape().getManaMultiplier();
        }
        return manaMultiplier;
    }

    public int getCoolDown() {
        int coolDown = 0;
        if (!this.groups.isEmpty()) {
            for (SpellGroup group : this.groups) {
                coolDown += group.getCoolDown();
            }
        }
        return coolDown;
    }

    public Stream<SpellComponent> components() {
        return this.groups.stream().flatMap(SpellGroup::getAllComponents);
    }

    public void cast(class_1309 caster, class_3218 world, class_1799 stack) {
        List<SpellGroup> groups = this.getComponentGroups();
        if (groups.isEmpty()) {
            return;
        }
        if (groups.stream().flatMap(SpellGroup::getAllComponents).anyMatch(Predicate.not(SpellComponent::isEnabled))) {
            caster.method_43496((class_2561)class_2561.method_43471((String)"text.arcanuscontinuum.disabled_component").method_27692(class_124.field_1061));
            return;
        }
        SpellGroup firstGroup = groups.get(0);
        firstGroup.shape().cast(caster, caster.method_19538(), null, world, stack, firstGroup.effects(), groups, 0, caster.method_26825((class_1320)ArcanusEntityAttributes.SPELL_POTENCY.get()));
    }
}

