/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.api.spells;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.api.spells.Weight;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.joml.Vector2i;

public record SpellGroup(SpellShape shape, List<SpellEffect> effects, List<Vector2i> positions) {
    public static SpellGroup fromNbt(class_2487 tag) {
        int i;
        SpellShape shape = (SpellShape)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(tag.method_10558("Shape")));
        ArrayList<SpellEffect> effects = new ArrayList<SpellEffect>();
        ArrayList<Vector2i> positions = new ArrayList<Vector2i>();
        class_2499 nbtEffects = tag.method_10554("Effects", 8);
        class_2499 nbtPoses = tag.method_10554("Positions", 10);
        for (i = 0; i < nbtEffects.size(); ++i) {
            String nbtId;
            class_2960 correctedId = switch (nbtId = nbtEffects.method_10608(i)) {
                case "arcanuscontinuum:projectile_shape" -> ArcanusSpellComponents.MISSILE.getId();
                case "arcanuscontinuum:lob_shape" -> ArcanusSpellComponents.LOB.getId();
                case "arcanuscontinuum:explosion_shape" -> ArcanusSpellComponents.BURST.getId();
                case "arcanuscontinuum:guardian_orb_shape" -> ArcanusSpellComponents.ENTANGLED_ORB.getId();
                case "arcanuscontinuum:aggressorb_shape" -> ArcanusSpellComponents.AGGRESSORB.getId();
                default -> new class_2960(nbtId);
            };
            Object object = Arcanus.SPELL_COMPONENTS.method_10223(correctedId);
            if (!(object instanceof SpellEffect)) continue;
            SpellEffect effect = (SpellEffect)object;
            effects.add(effect);
        }
        for (i = 0; i < nbtPoses.size(); ++i) {
            class_2487 nbt = nbtPoses.method_10602(i);
            positions.add(new Vector2i(nbt.method_10550("X"), nbt.method_10550("Y")));
        }
        if (positions.size() != effects.size() + 1) {
            return new SpellGroup((SpellShape)ArcanusSpellComponents.EMPTY.get(), List.of(), List.of());
        }
        return new SpellGroup(shape, effects, positions);
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 effectsList = new class_2499();
        class_2499 posesList = new class_2499();
        for (SpellEffect effect : this.effects) {
            effectsList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (Vector2i position : this.positions) {
            class_2487 nbt = new class_2487();
            nbt.method_10569("X", position.x());
            nbt.method_10569("Y", position.y());
            posesList.add((Object)nbt);
        }
        tag.method_10582("Shape", Arcanus.SPELL_COMPONENTS.method_10221((Object)this.shape).toString());
        tag.method_10566("Effects", (class_2520)effectsList);
        tag.method_10566("Positions", (class_2520)posesList);
        return tag;
    }

    public Weight getAverageWeight() {
        int cumulativeWeightIndex = this.shape.getWeight().ordinal();
        int effectCount = 0;
        for (int i = 0; i < this.effects.size(); ++i) {
            SpellEffect effect = this.effects().get(i);
            if (effect.getWeight() == Weight.NONE) continue;
            cumulativeWeightIndex += effect.getWeight().ordinal();
            ++effectCount;
        }
        return Weight.values()[Math.round((float)cumulativeWeightIndex / ((float)effectCount + 1.0f))];
    }

    public double getManaCost() {
        double cumulativeManaCost = this.shape().getManaCost();
        for (SpellEffect effect : this.effects) {
            cumulativeManaCost += effect.getManaCost();
        }
        return cumulativeManaCost;
    }

    public int getCoolDown() {
        int cumulativeCoolDown = this.shape().getCoolDown();
        for (SpellEffect effect : this.effects) {
            cumulativeCoolDown += effect.getCoolDown();
        }
        return cumulativeCoolDown;
    }

    public Stream<SpellComponent> getAllComponents() {
        return Stream.concat(Stream.of(this.shape), this.effects.stream());
    }

    public boolean isEmpty() {
        return ArcanusSpellComponents.EMPTY.is((Object)this.shape);
    }
}

