/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.api.spells;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.Weight;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class SpellShape
extends SpellComponent {
    private final double manaMultiplier;
    private final double potencyModifier;

    public static SpellShape empty() {
        return (SpellShape)ArcanusSpellComponents.EMPTY.get();
    }

    public SpellShape(boolean isEnabled, Weight weight, double manaCost, double manaMultiplier, int coolDown, int minLevel, double potencyModifier, boolean procsOnce) {
        super(isEnabled, weight, manaCost, coolDown, minLevel, procsOnce);
        this.manaMultiplier = manaMultiplier;
        this.potencyModifier = potencyModifier;
    }

    public double getPotencyModifier() {
        return this.potencyModifier;
    }

    public double getManaMultiplier() {
        return this.manaMultiplier - 1.0;
    }

    public String getPotencyModifierAsString() {
        return (this.getPotencyModifier() < 0.0 ? "" : "+") + Arcanus.format(this.getPotencyModifier() * 100.0) + "%";
    }

    public String getManaMultiplierAsString() {
        return (this.getManaMultiplier() < 0.0 ? "" : "+") + Arcanus.format(this.getManaMultiplier() * 100.0) + "%";
    }

    public abstract void cast(@Nullable class_1309 var1, class_243 var2, @Nullable class_1297 var3, class_3218 var4, class_1799 var5, List<SpellEffect> var6, List<SpellGroup> var7, int var8, double var9);

    public static void castNext(@Nullable class_1309 caster, class_243 castFrom, @Nullable class_1297 castSource, class_3218 level, class_1799 stack, List<SpellGroup> spellGroups, int groupIndex, double potency) {
        if (spellGroups.size() <= groupIndex + 1) {
            return;
        }
        SpellGroup group = spellGroups.get(groupIndex + 1);
        group.shape().cast(caster, castFrom, castSource, level, stack, group.effects(), spellGroups, groupIndex + 1, potency);
    }
}

