/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Pattern;
import dev.cammiescorner.arcanuscontinuum.client.gui.screens.ArcaneWorkbenchScreen;
import dev.cammiescorner.arcanuscontinuum.client.gui.screens.SpellBookScreen;
import dev.cammiescorner.arcanuscontinuum.client.gui.screens.SpellcraftScreen;
import dev.cammiescorner.arcanuscontinuum.client.models.armour.BattleMageArmourModel;
import dev.cammiescorner.arcanuscontinuum.client.models.armour.WizardArmourModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.living.OpossumModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.living.WizardModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.AggressorbModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.AreaOfEffectModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.EntangledOrbModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.MagicLobModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.MagicProjectileModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.MagicRuneModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.PocketDimensionPortalModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.SpatialRiftSigilModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.TemporalDilationFieldModel;
import dev.cammiescorner.arcanuscontinuum.client.models.feature.HaloModel;
import dev.cammiescorner.arcanuscontinuum.client.models.feature.SpellPatternModel;
import dev.cammiescorner.arcanuscontinuum.client.particles.CollapseParticle;
import dev.cammiescorner.arcanuscontinuum.client.renderer.armour.BattleMageArmourRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.armour.WizardArmourRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.block.MagicBlockEntityRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.block.SpatialRiftExitBlockEntityRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.living.OpossumRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.living.WizardRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.AggressorbRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.AreaOfEffectRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.BeamRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.EntangledOrbRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.GuidedShotRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.LobRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.MagicRuneRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.ManaShieldRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.MissileRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.PocketDimensionPortalRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.SmiteRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic.TemporalDilationFieldRenderer;
import dev.cammiescorner.arcanuscontinuum.client.renderer.item.StaffItemRenderer;
import dev.cammiescorner.arcanuscontinuum.common.compat.ArcanusCompat;
import dev.cammiescorner.arcanuscontinuum.common.compat.FirstPersonCompat;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusItemTags;
import dev.cammiescorner.arcanuscontinuum.common.items.BattleMageArmorItem;
import dev.cammiescorner.arcanuscontinuum.common.items.StaffItem;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncConfigValuesPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncExplosionParticlesPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncScalePacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncStaffTemplatePacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncStatusEffectPacket;
import dev.cammiescorner.arcanuscontinuum.common.packets.s2c.SyncWorkbenchModePacket;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlockEntities;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusBlocks;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusEntities;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusItems;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusParticles;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusScreenHandlers;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5272;
import net.minecraft.class_5431;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_5819;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_946;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ArcanusClient
implements ClientModInitializer {
    private static final class_2960 HUD_ELEMENTS = Arcanus.id("textures/gui/hud/mana_bar.png");
    private static final class_2960 STUN_OVERLAY = Arcanus.id("textures/gui/hud/stunned_vignette.png");
    private static final class_2960 MAGIC_CIRCLES = Arcanus.id("textures/entity/feature/magic_circles.png");
    public static final class_2960 WHITE = new class_2960("textures/misc/white.png");
    public static final class_1921 LAYER = ArcanusClient.getMagicCircles(Arcanus.id("textures/block/warded_block.png"));
    public static BooleanSupplier FIRST_PERSON_MODEL_ENABLED = () -> false;
    public static BooleanSupplier FIRST_PERSON_SHOW_HANDS = () -> true;
    public static boolean castingSpeedHasCoolDown;
    private final class_310 client = class_310.method_1551();
    private static int hudTimer;
    private static int hitTimer;

    public void onInitializeClient() {
        ArcanusCompat.FIRST_PERSON.ifEnabled(() -> FirstPersonCompat::init);
        class_3929.method_17542((class_3917)((class_3917)ArcanusScreenHandlers.SPELLCRAFT_SCREEN_HANDLER.get()), SpellcraftScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ArcanusScreenHandlers.SPELL_BOOK_SCREEN_HANDLER.get()), SpellBookScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ArcanusScreenHandlers.ARCANE_WORKBENCH_SCREEN_HANDLER.get()), ArcaneWorkbenchScreen::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WizardArmourModel.MODEL_LAYER, WizardArmourModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)BattleMageArmourModel.MODEL_LAYER, BattleMageArmourModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WizardModel.MODEL_LAYER, WizardModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)OpossumModel.MODEL_LAYER, OpossumModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)MagicLobModel.MODEL_LAYER, MagicLobModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)MagicProjectileModel.MODEL_LAYER, MagicProjectileModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)MagicRuneModel.MODEL_LAYER, MagicRuneModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)AreaOfEffectModel.MODEL_LAYER, AreaOfEffectModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SpellPatternModel.MODEL_LAYER, SpellPatternModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HaloModel.MODEL_LAYER, HaloModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)EntangledOrbModel.MODEL_LAYER, EntangledOrbModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)PocketDimensionPortalModel.MODEL_LAYER, PocketDimensionPortalModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SpatialRiftSigilModel.MODEL_LAYER, SpatialRiftSigilModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)AggressorbModel.MODEL_LAYER, AggressorbModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)TemporalDilationFieldModel.MODEL_LAYER, TemporalDilationFieldModel::getTexturedModelData);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.WIZARD.get()), WizardRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.OPOSSUM.get()), OpossumRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.NECRO_SKELETON.get()), class_946::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.MANA_SHIELD.get()), ManaShieldRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.MISSILE.get()), MissileRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.LOB.get()), LobRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.AOE.get()), AreaOfEffectRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.SMITE.get()), SmiteRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.MAGIC_RUNE.get()), MagicRuneRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.GUIDED_SHOT.get()), GuidedShotRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.BEAM.get()), BeamRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.ENTANGLED_ORB.get()), EntangledOrbRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.PORTAL.get()), PocketDimensionPortalRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.AGGRESSORB.get()), AggressorbRenderer::new);
        EntityRendererRegistry.register((class_1299)((class_1299)ArcanusEntities.TEMPORAL_DILATION_FIELD.get()), TemporalDilationFieldRenderer::new);
        ArmorRenderer.register((ArmorRenderer)new WizardArmourRenderer(), (class_1935[])new class_1935[]{(class_1935)ArcanusItems.WIZARD_HAT.get(), (class_1935)ArcanusItems.WIZARD_ROBES.get(), (class_1935)ArcanusItems.WIZARD_PANTS.get(), (class_1935)ArcanusItems.WIZARD_BOOTS.get()});
        ArmorRenderer.register((ArmorRenderer)new BattleMageArmourRenderer(), (class_1935[])new class_1935[]{(class_1935)ArcanusItems.BATTLE_MAGE_HELMET.get(), (class_1935)ArcanusItems.BATTLE_MAGE_CHESTPLATE.get(), (class_1935)ArcanusItems.BATTLE_MAGE_LEGGINGS.get(), (class_1935)ArcanusItems.BATTLE_MAGE_BOOTS.get()});
        ParticleFactoryRegistry.getInstance().register((class_2396)ArcanusParticles.COLLAPSE.get(), CollapseParticle.Factory::new);
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{(class_2248)ArcanusBlocks.MAGIC_DOOR.get(), (class_2248)ArcanusBlocks.ARCANE_WORKBENCH.get()});
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), new class_2248[]{(class_2248)ArcanusBlocks.SPATIAL_RIFT_EXIT_EDGE.get()});
        class_5616.method_32144((class_2591)((class_2591)ArcanusBlockEntities.MAGIC_BLOCK.get()), MagicBlockEntityRenderer.factory(ArcanusHelper::getMagicColor));
        class_5616.method_32144((class_2591)((class_2591)ArcanusBlockEntities.SPATIAL_RIFT_EXIT.get()), SpatialRiftExitBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ArcanusBlockEntities.SPATIAL_RIFT_WALL.get()), MagicBlockEntityRenderer.factory(ArcanusHelper::getPocketDimensionColor));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncStatusEffectPacket.ID, SyncStatusEffectPacket::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncWorkbenchModePacket.ID, SyncWorkbenchModePacket::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncStaffTemplatePacket.ID, SyncStaffTemplatePacket::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncConfigValuesPacket.ID, SyncConfigValuesPacket::handle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncExplosionParticlesPacket.ID, SyncExplosionParticlesPacket::handle);
        ArcanusCompat.PEHKUI.ifEnabled(() -> () -> ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncScalePacket.ID, SyncScalePacket::handle));
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> switch (tintIndex) {
            case 0 -> StaffItem.getPrimaryColorRGB(stack);
            case 1 -> StaffItem.getSecondaryColorRGB(stack);
            default -> -1;
        }, (Object[])new class_1935[]{(class_1935)ArcanusItems.WOODEN_STAFF.get(), (class_1935)ArcanusItems.CRYSTAL_STAFF.get(), (class_1935)ArcanusItems.DIVINATION_STAFF.get(), (class_1935)ArcanusItems.CRESCENT_STAFF.get(), (class_1935)ArcanusItems.ANCIENT_STAFF.get(), (class_1935)ArcanusItems.WAND.get(), (class_1935)ArcanusItems.THAUMATURGES_GAUNTLET.get(), (class_1935)ArcanusItems.MAGIC_TOME.get(), (class_1935)ArcanusItems.MAGE_PISTOL.get()});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex == 0 ? ((class_1768)stack.method_7909()).method_7800(stack) : -1, (Object[])new class_1935[]{(class_1935)ArcanusItems.WIZARD_HAT.get(), (class_1935)ArcanusItems.WIZARD_ROBES.get(), (class_1935)ArcanusItems.WIZARD_PANTS.get(), (class_1935)ArcanusItems.WIZARD_BOOTS.get()});
        class_5272.method_27879((class_1792)((class_1792)ArcanusItems.BATTLE_MAGE_HELMET.get()), (class_2960)Arcanus.id("oxidation"), (stack, world, entity, seed) -> (float)BattleMageArmorItem.getOxidation(stack).ordinal() / 10.0f);
        class_5272.method_27879((class_1792)((class_1792)ArcanusItems.BATTLE_MAGE_CHESTPLATE.get()), (class_2960)Arcanus.id("oxidation"), (stack, world, entity, seed) -> (float)BattleMageArmorItem.getOxidation(stack).ordinal() / 10.0f);
        class_5272.method_27879((class_1792)((class_1792)ArcanusItems.BATTLE_MAGE_LEGGINGS.get()), (class_2960)Arcanus.id("oxidation"), (stack, world, entity, seed) -> (float)BattleMageArmorItem.getOxidation(stack).ordinal() / 10.0f);
        class_5272.method_27879((class_1792)((class_1792)ArcanusItems.BATTLE_MAGE_BOOTS.get()), (class_2960)Arcanus.id("oxidation"), (stack, world, entity, seed) -> (float)BattleMageArmorItem.getOxidation(stack).ordinal() / 10.0f);
        ArcanusItems.ITEMS.stream().forEach(holder -> {
            Object patt12627$temp = holder.get();
            if (patt12627$temp instanceof StaffItem) {
                StaffItem item = (StaffItem)((Object)((Object)patt12627$temp));
                class_2960 id = holder.getId();
                StaffItemRenderer staffItemRenderer = new StaffItemRenderer(id);
                ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)staffItemRenderer);
                BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (BuiltinItemRendererRegistry.DynamicItemRenderer)staffItemRenderer);
                ModelLoadingPlugin.register(ctx -> ctx.addModels(new class_2960[]{new class_1091(id.method_48331("_gui"), "inventory"), new class_1091(id.method_48331("_handheld"), "inventory")}));
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            if (!context.camera().method_19333() && !FIRST_PERSON_MODEL_ENABLED.getAsBoolean()) {
                ArcanusClient.renderFirstPersonBolt(context);
            }
        });
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, outlineContext) -> {
            class_636 interactionManager = this.client.field_1761;
            class_746 player = this.client.field_1724;
            class_638 world = context.world();
            class_4587 matrices = context.matrixStack();
            class_4597 vertices = context.consumers();
            class_243 cameraPos = context.camera().method_19326();
            if (player != null && vertices != null && interactionManager != null) {
                class_3965 hitResult;
                class_239 patt13797$temp = this.client.field_1765;
                if (patt13797$temp instanceof class_3965 && ArcanusComponents.isBlockWarded((class_1937)world, (hitResult = (class_3965)patt13797$temp).method_17777()) && player.field_6252) {
                    if (this.client.field_1690.field_1886.method_1434() && player.field_6251 == 0.0f) {
                        hitTimer = 20;
                    }
                    if (!ArcanusComponents.isOwnerOfBlock((class_1657)player, hitResult.method_17777()) || hitTimer > 0) {
                        class_2338 blockPos2 = hitResult.method_17777();
                        float alpha = class_3532.method_15363((float)((float)hitTimer / 20.0f), (float)0.0f, (float)1.0f);
                        ArcanusClient.renderWardedBlock(matrices, vertices, (class_1937)world, cameraPos, blockPos2, alpha);
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.arcanuscontinuum.block_is_warded").method_27692(class_124.field_1061), true);
                    }
                    if (hitTimer > 0) {
                        --hitTimer;
                    }
                }
                if (player.method_6047().method_31573(ArcanusItemTags.STAVES) || player.method_6079().method_31573(ArcanusItemTags.STAVES)) {
                    AtomicReferenceArray chunks = context.world().method_2935().field_16246.field_16251;
                    float alpha = class_3532.method_15374((float)((float)world.method_8510() * 0.06f)) * 0.4f + 0.6f;
                    for (int i = 0; i < chunks.length(); ++i) {
                        class_2791 chunk = (class_2791)chunks.get(i);
                        if (chunk == null) continue;
                        ArcanusComponents.getWardedBlocks(chunk).forEach((blockPos, uuid) -> {
                            if (blockPos.method_10262((class_2382)context.camera().method_19328()) < 256.0) {
                                ArcanusClient.renderWardedBlock(matrices, vertices, (class_1937)world, cameraPos, blockPos, alpha);
                            }
                        });
                    }
                }
            }
            return true;
        });
        HudRenderCallback.EVENT.register((gui, tickDelta) -> {
            class_4587 matrices = gui.method_51448();
            class_746 player = this.client.field_1724;
            if (player != null && !player.method_7325()) {
                List<Pattern> list;
                int stunTimer = ArcanusComponents.getStunTimer((class_1309)player);
                if (stunTimer > 0) {
                    if (stunTimer > 5) {
                        this.renderOverlay(STUN_OVERLAY, Math.min(1.0f, 0.5f + (float)stunTimer % 5.0f / 10.0f));
                    } else {
                        this.renderOverlay(STUN_OVERLAY, Math.min(1.0f, (float)stunTimer / 5.0f));
                    }
                }
                if (!(this.client.field_1773.method_19418().method_19333() || FIRST_PERSON_MODEL_ENABLED.getAsBoolean() || (list = ArcanusComponents.getPattern((class_1309)player)).isEmpty())) {
                    class_4597.class_4598 vertices = this.client.method_22940().method_23000();
                    class_1921 renderLayer = ArcanusClient.getMagicCircles(MAGIC_CIRCLES);
                    class_4588 vertex = vertices.getBuffer(renderLayer);
                    Color color = ArcanusHelper.getMagicColor(player);
                    float x = (float)this.client.method_22683().method_4486() / 2.0f;
                    float y = (float)this.client.method_22683().method_4502() / 2.0f;
                    float scale = 3.0f;
                    matrices.method_22903();
                    matrices.method_46416(x, y, 0.0f);
                    for (int i = 0; i < list.size(); ++i) {
                        Pattern pattern = list.get(i);
                        matrices.method_22903();
                        if (i == 1) {
                            matrices.method_22907(class_7833.field_40718.rotationDegrees(((float)(player.field_6012 + player.method_5628()) + tickDelta) * (5.0f + 2.5f * (float)i)));
                        } else {
                            matrices.method_22907(class_7833.field_40717.rotationDegrees(((float)(player.field_6012 + player.method_5628()) + tickDelta) * (5.0f + 2.5f * (float)i)));
                        }
                        matrices.method_22905(scale, scale, 0.0f);
                        matrices.method_22904(-8.5, -8.5, 0.0);
                        ArcanusClient.drawTexture(vertex, matrices, color, 0, 0, i * 34, pattern == Pattern.LEFT ? 0.0f : 24.0f, 17, 17, 128, 48);
                        matrices.method_22909();
                    }
                    matrices.method_22909();
                    vertices.method_37104();
                }
                double maxMana = ArcanusComponents.getMaxMana((class_1309)player);
                double mana = ArcanusComponents.getMana((class_1309)player);
                double burnout = ArcanusComponents.getBurnout((class_1309)player);
                double manaLock = ArcanusComponents.getManaLock((class_1309)player);
                hudTimer = player.method_6047().method_7909() instanceof StaffItem ? Math.min(hudTimer + 1, 40) : Math.max(hudTimer - 1, 0);
                if (hudTimer > 0) {
                    int x = 0;
                    int y = this.client.method_22683().method_4502() - 28;
                    int width = 96;
                    float alpha = hudTimer > 20 ? 1.0f : (float)hudTimer / 20.0f;
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    gui.method_25290(HUD_ELEMENTS, x, y, 0.0f, 0.0f, 101, 28, 256, 256);
                    gui.method_25290(HUD_ELEMENTS, x, y + 5, 0.0f, 32.0f, (int)((double)width * (mana / maxMana)), 23, 256, 256);
                    int i = (int)Math.ceil((double)width * ((burnout + manaLock) / maxMana));
                    gui.method_25290(HUD_ELEMENTS, x + (width - i), y + 5, (float)(width - i), 56.0f, i, 23, 256, 256);
                    i = (int)Math.ceil((double)width * (manaLock / maxMana));
                    gui.method_25290(HUD_ELEMENTS, x + (width - i), y + 5, (float)(width - i), 80.0f, i, 23, 256, 256);
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        });
    }

    public static void renderBolts(class_1309 entity, class_243 startPos, class_4587 matrices, class_4597 vertices) {
        if (ArcanusComponents.shouldRenderBolt(entity)) {
            class_4588 vertex = vertices.getBuffer(ArcanusClient.getMagicCircles(WHITE));
            class_5819 random = class_5819.method_43049((long)((entity.field_6012 + entity.method_5628()) / 2));
            class_243 endPos = ArcanusComponents.getBoltPos(entity);
            Color color = ArcanusHelper.getMagicColor(entity);
            int steps = (int)(startPos.method_1022(endPos) * 5.0);
            ArcanusClient.renderBolt(matrices, vertex, random, startPos, endPos, steps, 0, true, color.redF(), color.greenF(), color.blueF(), class_4608.field_21444, 0xF000F0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void renderBolt(class_4587 matrices, class_4588 vertex, class_5819 random, class_243 startPos, class_243 endPos, int steps, int currentStep, boolean recurse, float r, float g, float b, int overlay, int light) {
        class_243 direction = endPos.method_1020(startPos);
        class_243 lastPos = startPos;
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        int i = currentStep;
        while (i < steps) {
            class_243 randomOffset = new class_243(random.method_43059(), (double)random.method_39332(-1 / (steps * 2), 1 / (steps * 2)), random.method_43059());
            class_243 nextPos = startPos.method_1019(direction.method_1021((double)((float)(i + 1) / (float)steps))).method_1019(randomOffset.method_1021(0.0833333358168602));
            for (int j = 0; j < 4; ++j) {
                class_243 vert1 = switch (j) {
                    case 0 -> lastPos.method_1031(0.025, 0.025, 0.0);
                    case 1 -> lastPos.method_1031(-0.025, 0.025, 0.0);
                    case 2 -> lastPos.method_1031(-0.025, -0.025, 0.0);
                    case 3 -> lastPos.method_1031(0.025, -0.025, 0.0);
                    default -> lastPos;
                };
                class_243 vert2 = switch (j) {
                    case 0 -> lastPos.method_1031(-0.025, 0.025, 0.0);
                    case 1 -> lastPos.method_1031(-0.025, -0.025, 0.0);
                    case 2 -> lastPos.method_1031(0.025, -0.025, 0.0);
                    case 3 -> lastPos.method_1031(0.025, 0.025, 0.0);
                    default -> lastPos;
                };
                class_243 vert3 = switch (j) {
                    case 0 -> nextPos.method_1031(0.025, 0.025, 0.0);
                    case 1 -> nextPos.method_1031(-0.025, 0.025, 0.0);
                    case 2 -> nextPos.method_1031(-0.025, -0.025, 0.0);
                    case 3 -> nextPos.method_1031(0.025, -0.025, 0.0);
                    default -> nextPos;
                };
                class_243 vert4 = switch (j) {
                    case 0 -> nextPos.method_1031(-0.025, 0.025, 0.0);
                    case 1 -> nextPos.method_1031(-0.025, -0.025, 0.0);
                    case 2 -> nextPos.method_1031(0.025, -0.025, 0.0);
                    case 3 -> nextPos.method_1031(0.025, 0.025, 0.0);
                    default -> nextPos;
                };
                class_243 normal = vert2.method_1020(vert1).method_1036(vert3.method_1020(vert1));
                vertex.method_22918(modelMatrix, (float)vert2.method_10216(), (float)vert2.method_10214(), (float)vert2.method_10215()).method_22915(r, g, b, 0.6f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normalMatrix, (float)normal.method_10216(), (float)normal.method_10214(), (float)normal.method_10215()).method_1344();
                vertex.method_22918(modelMatrix, (float)vert4.method_10216(), (float)vert4.method_10214(), (float)vert4.method_10215()).method_22915(r, g, b, 0.6f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normalMatrix, (float)normal.method_10216(), (float)normal.method_10214(), (float)normal.method_10215()).method_1344();
                vertex.method_22918(modelMatrix, (float)vert3.method_10216(), (float)vert3.method_10214(), (float)vert3.method_10215()).method_22915(r, g, b, 0.6f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normalMatrix, (float)normal.method_10216(), (float)normal.method_10214(), (float)normal.method_10215()).method_1344();
                vertex.method_22918(modelMatrix, (float)vert1.method_10216(), (float)vert1.method_10214(), (float)vert1.method_10215()).method_22915(r, g, b, 0.6f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normalMatrix, (float)normal.method_10216(), (float)normal.method_10214(), (float)normal.method_10215()).method_1344();
            }
            while (recurse && random.method_43057() < 0.2f) {
                class_243 randomOffset1 = new class_243(random.method_43059(), random.method_43059(), random.method_43059());
                ArcanusClient.renderBolt(matrices, vertex, random, lastPos, endPos.method_1019(randomOffset1.method_1021((double)Math.min(random.method_43057(), 0.6f))), steps, i + 1, false, r, g, b, overlay, light);
            }
            lastPos = nextPos;
            ++i;
        }
        return;
    }

    private static void renderWardedBlock(class_4587 matrices, class_4597 vertices, class_1937 world, class_243 cameraPos, class_2338 blockPos, float alpha) {
        class_4588 consumer = vertices.getBuffer(LAYER);
        class_243 pos = class_243.method_24953((class_2382)blockPos);
        matrices.method_22903();
        matrices.method_22904(pos.method_10216() - cameraPos.method_10216(), pos.method_10214() - cameraPos.method_10214(), pos.method_10215() - cameraPos.method_10215());
        matrices.method_22905(1.001f, 1.001f, 1.001f);
        matrices.method_22904(-0.5, -0.5, -0.5);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        Matrix3f matrix3f = matrices.method_23760().method_23762();
        int light = world.method_22339(blockPos);
        int overlay = class_4608.field_21444;
        Color color = ArcanusHelper.getMagicColor(ArcanusComponents.getWardedBlocks(world.method_22350(blockPos)).get(blockPos));
        float r = class_3532.method_15363((float)(color.redF() * alpha), (float)0.0f, (float)1.0f);
        float g = class_3532.method_15363((float)(color.greenF() * alpha), (float)0.0f, (float)1.0f);
        float b = class_3532.method_15363((float)(color.blueF() * alpha), (float)0.0f, (float)1.0f);
        color = Color.fromFloatsRGB(r, g, b);
        block8: for (class_2350 direction : class_2350.values()) {
            class_2338 posToSide = blockPos.method_10093(direction);
            class_2680 stateToSide = world.method_8320(posToSide);
            if (stateToSide.method_30368((class_1922)world, posToSide, direction.method_10153(), class_5431.field_25822) || ArcanusComponents.isBlockWarded(world, posToSide)) continue;
            switch (direction) {
                case field_11035: {
                    ArcanusClient.renderSide(matrix4f, consumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, color, light, overlay, matrix3f, class_2350.field_11035);
                    continue block8;
                }
                case field_11043: {
                    ArcanusClient.renderSide(matrix4f, consumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, color, light, overlay, matrix3f, class_2350.field_11043);
                    continue block8;
                }
                case field_11034: {
                    ArcanusClient.renderSide(matrix4f, consumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, color, light, overlay, matrix3f, class_2350.field_11034);
                    continue block8;
                }
                case field_11039: {
                    ArcanusClient.renderSide(matrix4f, consumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, color, light, overlay, matrix3f, class_2350.field_11039);
                    continue block8;
                }
                case field_11033: {
                    ArcanusClient.renderSide(matrix4f, consumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, light, overlay, matrix3f, class_2350.field_11033);
                    continue block8;
                }
                case field_11036: {
                    ArcanusClient.renderSide(matrix4f, consumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, color, light, overlay, matrix3f, class_2350.field_11036);
                }
            }
        }
        matrices.method_22909();
    }

    private static void renderFirstPersonBolt(WorldRenderContext context) {
        class_746 player = context.gameRenderer().method_35772().field_1724;
        if (player != null) {
            class_4587 matrices = context.matrixStack();
            class_243 camPos = context.camera().method_19326();
            float tickDelta = context.tickDelta();
            class_243 startPos = player.method_30950(tickDelta).method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
            matrices.method_22903();
            matrices.method_22904(-camPos.method_10216(), -camPos.method_10214(), -camPos.method_10215());
            ArcanusClient.renderBolts((class_1309)player, startPos.method_1031(0.0, -0.1, 0.0), matrices, context.consumers());
            matrices.method_22909();
        }
    }

    public static class_1921 getMagicCircles(class_2960 texture) {
        return class_1921.method_24049((String)Arcanus.id("magic_circle").toString(), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_1921.field_38344).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23611(class_4668.field_21385).method_23615(class_1921.field_21366).method_23616(class_1921.field_21349).method_23603(class_4668.field_21345).method_23617(false));
    }

    public static class_1921 getMagicPortal(class_2960 texture) {
        return class_1921.method_24049((String)Arcanus.id("magic_portal").toString(), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_1921.field_38344).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23611(class_4668.field_21385).method_23615(class_1921.field_21366).method_23616(class_1921.field_21349).method_23603(class_4668.field_21345).method_23604(class_1921.field_21346).method_23617(false));
    }

    public static class_1921 getMagicCirclesTri(class_2960 texture) {
        return class_1921.method_24049((String)Arcanus.id("magic_circle_tri").toString(), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_1921.field_38344).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23611(class_4668.field_21385).method_23615(class_1921.field_21366).method_23616(class_1921.field_21349).method_23603(class_4668.field_21345).method_23617(false));
    }

    public static void drawTexture(class_4588 vertex, class_4587 matrices, Color color, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanusClient.drawTexturedQuad(vertex, matrices.method_23760().method_23761(), color, x, x + width, y, y + height, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight);
    }

    private static void drawTexturedQuad(class_4588 vertex, Matrix4f matrix, Color color, int x0, int x1, int y0, int y1, float u0, float u1, float v0, float v1) {
        vertex.method_22918(matrix, (float)x0, (float)y1, 0.0f).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(u0, v1).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        vertex.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(u1, v1).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        vertex.method_22918(matrix, (float)x1, (float)y0, 0.0f).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(u1, v0).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        vertex.method_22918(matrix, (float)x0, (float)y0, 0.0f).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(u0, v0).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
    }

    public static void renderSide(Matrix4f matrix4f, class_4588 vertices, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4, Color color, int light, int overlay, Matrix3f normal, class_2350 direction) {
        vertices.method_22918(matrix4f, x1, y1, z1).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(0.0f, 1.0f).method_22922(overlay).method_22916(light).method_23763(normal, (float)direction.method_10163().method_10263(), (float)direction.method_10163().method_10264(), (float)direction.method_10163().method_10260()).method_1344();
        vertices.method_22918(matrix4f, x2, y1, z2).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(1.0f, 1.0f).method_22922(overlay).method_22916(light).method_23763(normal, (float)direction.method_10163().method_10263(), (float)direction.method_10163().method_10264(), (float)direction.method_10163().method_10260()).method_1344();
        vertices.method_22918(matrix4f, x2, y2, z3).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(1.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normal, (float)direction.method_10163().method_10263(), (float)direction.method_10163().method_10264(), (float)direction.method_10163().method_10260()).method_1344();
        vertices.method_22918(matrix4f, x1, y2, z4).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(normal, (float)direction.method_10163().method_10263(), (float)direction.method_10163().method_10264(), (float)direction.method_10163().method_10260()).method_1344();
    }

    private void renderOverlay(class_2960 texture, float opacity) {
        class_310 client = class_310.method_1551();
        double scaledHeight = client.method_22683().method_4502();
        double scaledWidth = client.method_22683().method_4486();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(0.0, scaledHeight, -90.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(scaledWidth, scaledHeight, -90.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(scaledWidth, 0.0, -90.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, -90.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

