/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.api.spells.Weight;
import dev.cammiescorner.arcanuscontinuum.common.items.SpellBookItem;
import dev.cammiescorner.arcanuscontinuum.common.screens.SpellBookScreenHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class SpellBookScreen
extends class_465<SpellBookScreenHandler> {
    public static final class_2960 BOOK_TEXTURE = Arcanus.id("textures/gui/spell_book.png");
    public static final class_2960 PANEL_TEXTURE = Arcanus.id("textures/gui/spell_crafting.png");
    public final LinkedList<SpellGroup> SPELL_GROUPS = new LinkedList();

    public SpellBookScreen(SpellBookScreenHandler screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 = (this.field_22789 - 256) / 2;
        this.field_2800 = (this.field_22790 - 180) / 2;
        this.field_25270 = -10000;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46433(this.field_22789 / 2 - 49, this.field_2800 + 170).method_46437(98, 20).method_46431());
        this.SPELL_GROUPS.addAll(SpellBookItem.getSpell(((SpellBookScreenHandler)this.method_17577()).getSpellBook()).getComponentGroups());
    }

    protected void method_2389(class_332 gui, float delta, int mouseX, int mouseY) {
        this.method_25420(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.method_25290(BOOK_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, 256, 180, 256, 256);
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        class_4587 matrices = gui.method_51448();
        class_5250 title = this.field_22785.method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1073});
        gui.method_51439(this.field_22793, (class_2561)title, 128 - this.field_22793.method_27525((class_5348)title) / 2, 11, 0x50505D, false);
        for (int i = 0; i < this.SPELL_GROUPS.size(); ++i) {
            SpellGroup group = this.SPELL_GROUPS.get(i);
            List<Vector2i> positions = group.positions();
            RenderSystem.setShader(class_757::method_34539);
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.3f, (float)1.0f);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            matrices.method_22903();
            matrices.method_46416(12.0f, 12.0f, 0.0f);
            Matrix4f matrix = matrices.method_23760().method_23761();
            for (int j = 0; j < positions.size(); ++j) {
                Vector2i pos = (Vector2i)positions.get(j);
                Vector2i prevPos = (Vector2i)positions.get(Math.max(0, j - 1));
                if (j == 0 && i > 0 && !this.SPELL_GROUPS.get(i - 1).isEmpty()) {
                    List<Vector2i> prevPositions = this.SPELL_GROUPS.get(i - 1).positions();
                    prevPos = prevPositions.get(prevPositions.size() - 1);
                }
                if (pos.equals((Object)prevPos)) continue;
                int x1 = prevPos.x();
                int y1 = prevPos.y();
                int x2 = pos.x();
                int y2 = pos.y();
                float angle = (float)(Math.atan2(y2 - y1, x2 - x1) - 1.5707963267948966);
                float dx = class_3532.method_15362((float)angle);
                float dy = class_3532.method_15374((float)angle);
                bufferBuilder.method_22918(matrix, (float)x2 - dx, (float)y2 - dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x2 + dx, (float)y2 + dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x1 + dx, (float)y1 + dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x1 - dx, (float)y1 - dy, 0.0f).method_39415(0).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
        }
        for (SpellGroup group : this.SPELL_GROUPS) {
            for (Vector2i pos : group.positions()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                gui.method_25290(PANEL_TEXTURE, pos.x - 3, pos.y - 3, 60.0f, 208.0f, 30, 30, 384, 256);
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.3f, (float)1.0f);
                gui.method_25290(PANEL_TEXTURE, pos.x - 3, pos.y - 3, 30.0f, 208.0f, 30, 30, 384, 256);
                gui.method_25290(group.getAllComponents().toList().get(group.positions().indexOf(pos)).getTexture(), pos.x, pos.y, 0.0f, 0.0f, 24, 24, 24, 24);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_5250 weight = class_2561.method_43471((String)("spell_book.arcanuscontinuum.weight." + this.getWeight().toString().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1077);
        class_5250 mana = class_2561.method_43470((String)Arcanus.format(this.getManaCost())).method_27692(class_124.field_1078);
        class_5250 coolDown = class_2561.method_43470((String)Arcanus.format((double)this.getCoolDown() / 20.0)).method_10852((class_2561)class_2561.method_43471((String)"spell_book.arcanuscontinuum.seconds")).method_27692(class_124.field_1061);
        gui.method_51439(this.field_22793, (class_2561)weight, 240 - this.field_22793.method_27525((class_5348)weight), 7, 0xFFFFFF, false);
        gui.method_51439(this.field_22793, (class_2561)mana, 240 - this.field_22793.method_27525((class_5348)mana), 17, 0xFFFFFF, false);
        gui.method_51439(this.field_22793, (class_2561)coolDown, 240 - this.field_22793.method_27525((class_5348)coolDown), 27, 0xFFFFFF, false);
        for (SpellGroup group : this.SPELL_GROUPS) {
            for (int i = 0; i < group.positions().size(); ++i) {
                Vector2i position = group.positions().get(i);
                if (!this.method_2378(position.x() - 2, position.y() - 2, 28, 28, mouseX, mouseY)) continue;
                ArrayList<Object> textList = new ArrayList<Object>();
                SpellComponent component = group.getAllComponents().toList().get(i);
                textList.add(component.getName());
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.weight").method_27693(": ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"spell_book.arcanuscontinuum.weight", (Object[])new Object[]{component.getWeight().toString().toLowerCase(Locale.ROOT)}).method_27692(class_124.field_1080)));
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.mana_cost").method_27693(": ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)component.getManaCostAsString()).method_27692(class_124.field_1080)));
                if (component instanceof SpellShape) {
                    SpellShape shape = (SpellShape)component;
                    if (shape.getManaMultiplier() != 0.0) {
                        textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.mana_multiplier").method_27693(": ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)shape.getManaMultiplierAsString()).method_27692(class_124.field_1080)));
                    }
                    if (shape.getPotencyModifier() != 0.0) {
                        textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.potency_modifier").method_27693(": ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)shape.getPotencyModifierAsString()).method_27692(class_124.field_1080)));
                    }
                }
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.cool_down").method_27693(": ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)component.getCoolDownAsString()).method_10852((class_2561)class_2561.method_43471((String)"spell_book.arcanuscontinuum.seconds")).method_27692(class_124.field_1080)));
                gui.method_51434(this.field_22793, textList, mouseX - this.field_2776, mouseY - this.field_2800);
            }
        }
    }

    protected void method_37067() {
        super.method_37067();
        this.SPELL_GROUPS.clear();
    }

    protected boolean method_2378(int x, int y, int width, int height, double pointX, double pointY) {
        int i = this.field_2776;
        int j = this.field_2800;
        return (pointX -= (double)i) >= (double)(x - 1) && pointX < (double)(x + width + 1) && (pointY -= (double)j) >= (double)(y - 1) && pointY < (double)(y + height + 1);
    }

    public Spell getSpell() {
        return new Spell(this.SPELL_GROUPS, this.field_22785.getString());
    }

    public Weight getWeight() {
        return this.getSpell().getWeight();
    }

    public double getManaCost() {
        return this.getSpell().getManaCost();
    }

    public int getCoolDown() {
        return this.getSpell().getCoolDown();
    }
}

