/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.gui.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.api.spells.Spell;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellComponent;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.api.spells.Weight;
import dev.cammiescorner.arcanuscontinuum.api.util.Rectangle;
import dev.cammiescorner.arcanuscontinuum.client.gui.util.Action;
import dev.cammiescorner.arcanuscontinuum.client.gui.util.UndoRedoStack;
import dev.cammiescorner.arcanuscontinuum.client.gui.widgets.SpellComponentWidget;
import dev.cammiescorner.arcanuscontinuum.client.gui.widgets.UndoRedoButtonWidget;
import dev.cammiescorner.arcanuscontinuum.common.items.SpellBookItem;
import dev.cammiescorner.arcanuscontinuum.common.packets.c2s.SaveBookDataPacket;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusSpellComponents;
import dev.cammiescorner.arcanuscontinuum.common.screens.SpellcraftScreenHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector4i;

public class SpellcraftScreen
extends class_465<SpellcraftScreenHandler> {
    public static final class_2960 BOOK_TEXTURE = Arcanus.id("textures/gui/spell_book.png");
    public static final class_2960 PANEL_TEXTURE = Arcanus.id("textures/gui/spell_crafting.png");
    private static final Vector4i VALID_BOUNDS = new Vector4i(30, 40, 197, 114);
    private static List<SpellComponent> spellShapes;
    private static List<SpellComponent> spellEffects;
    private final LinkedList<SpellGroup> spellGroups = new LinkedList();
    private final List<SpellComponentWidget> spellShapeWidgets = Lists.newArrayList();
    private final List<SpellComponentWidget> spellEffectWidgets = Lists.newArrayList();
    private final UndoRedoStack undoRedoStack = new UndoRedoStack();
    private SpellComponent draggedComponent = (SpellComponent)ArcanusSpellComponents.EMPTY.get();
    private class_342 textBox;
    private int leftScroll;
    private int rightScroll;
    private double leftKnobPos;
    private double rightKnobPos;
    private boolean draggingLeft;
    private boolean draggingRight;

    public SpellcraftScreen(SpellcraftScreenHandler screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, (class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 = (this.field_22789 - 256) / 2;
        this.field_2800 = (this.field_22790 - 180) / 2;
        this.field_25270 = -10000;
        spellShapes = Arcanus.SPELL_COMPONENTS.method_10220().filter(component -> !ArcanusSpellComponents.EMPTY.is(component) && component.isEnabled() && ArcanusComponents.getWizardLevel((class_1309)class_310.method_1551().field_1724) >= component.getMinLevel() && component instanceof SpellShape).toList();
        spellEffects = Arcanus.SPELL_COMPONENTS.method_10220().filter(component -> !ArcanusSpellComponents.EMPTY.is(component) && component.isEnabled() && ArcanusComponents.getWizardLevel((class_1309)class_310.method_1551().field_1724) >= component.getMinLevel() && component instanceof SpellEffect).toList();
        if (this.field_22787 != null) {
            for (SpellComponent component2 : spellShapes) {
                if (ArcanusComponents.getWizardLevel((class_1309)this.field_22787.field_1724) < component2.getMinLevel()) continue;
                this.addSpellShapeChild(new SpellComponentWidget(-35, component2, widget -> {
                    if (this.spellComponentCount() < ArcanusComponents.maxSpellSize((class_1309)this.field_22787.field_1724)) {
                        this.draggedComponent = widget.getSpellComponent();
                    }
                }));
            }
            for (SpellComponent component2 : spellEffects) {
                if (ArcanusComponents.getWizardLevel((class_1309)this.field_22787.field_1724) < component2.getMinLevel()) continue;
                this.addSpellEffectChild(new SpellComponentWidget(267, component2, widget -> {
                    if (this.spellComponentCount() < ArcanusComponents.maxSpellSize((class_1309)this.field_22787.field_1724)) {
                        this.draggedComponent = widget.getSpellComponent();
                    }
                }));
            }
        }
        this.addCloseButtons();
        this.textBox = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, this.field_2776 + 15, this.field_2800 + 8, 88, 14, (class_2561)class_2561.method_43473()));
        this.textBox.method_1852(SpellBookItem.getSpell(((SpellcraftScreenHandler)this.method_17577()).getSpellBook()).getName());
        this.method_37063((class_364)new UndoRedoButtonWidget((this.field_22789 - 48) / 2, this.field_2800 - 8, true, this.undoRedoStack, button -> this.undoRedoStack.undo()));
        this.method_37063((class_364)new UndoRedoButtonWidget(this.field_22789 / 2, this.field_2800 - 8, false, this.undoRedoStack, button -> this.undoRedoStack.redo()));
        for (SpellGroup group : SpellBookItem.getSpell(((SpellcraftScreenHandler)this.method_17577()).getSpellBook()).getComponentGroups()) {
            if (group.isEmpty()) continue;
            this.undoRedoStack.addAction(new Action(group.shape(), group.positions().get(0), () -> this.spellGroups.add(group), () -> this.spellGroups.remove(group))).Do().run();
            for (int i = 0; i < group.effects().size(); ++i) {
                SpellEffect effect = group.effects().get(i);
                Vector2i pos = group.positions().get(i + 1);
                this.undoRedoStack.addAction(new Action(effect, pos, () -> {
                    group.effects().add(effect);
                    group.positions().add(pos);
                }, () -> {
                    group.effects().remove(effect);
                    group.positions().remove(pos);
                }));
            }
        }
    }

    protected void method_2389(class_332 gui, float delta, int mouseX, int mouseY) {
        this.method_25420(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.method_25290(BOOK_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, 256, 180, 256, 256);
        RenderSystem.setShaderTexture((int)0, (class_2960)PANEL_TEXTURE);
        gui.method_25290(PANEL_TEXTURE, this.field_2776 - 62, this.field_2800 + 1, 0.0f, 0.0f, 380, 178, 384, 256);
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        Rectangle leftKnob = this.getLeftScrollKnob();
        Rectangle rightKnob = this.getRightScrollKnob();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)PANEL_TEXTURE);
        gui.method_25290(PANEL_TEXTURE, leftKnob.x(), leftKnob.y(), this.draggingLeft ? 12.0f : 0.0f, 184.0f, leftKnob.width(), leftKnob.height(), 384, 256);
        gui.method_25290(PANEL_TEXTURE, rightKnob.x(), rightKnob.y(), this.draggingRight ? 12.0f : 0.0f, 184.0f, rightKnob.width(), rightKnob.height(), 384, 256);
        this.drawWidgets(gui, mouseX, mouseY, class_310.method_1551().method_1488());
        super.method_2388(gui, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.method_2378(-62, 1, 58, 178, mouseX, mouseY)) {
            if (this.leftScroll > 0 && amount > 0.0) {
                --this.leftScroll;
            }
            if (this.leftScroll < spellShapes.size() * 2 - 12 && amount < 0.0) {
                ++this.leftScroll;
            }
            this.leftKnobPos = (float)this.leftScroll * (148.0f / (float)(spellShapes.size() * 2 - 12));
        }
        if (this.method_2378(260, 1, 58, 178, mouseX, mouseY)) {
            if (this.rightScroll > 0 && amount > 0.0) {
                --this.rightScroll;
            }
            if (this.rightScroll < spellEffects.size() * 2 - 12 && amount < 0.0) {
                ++this.rightScroll;
            }
            this.rightKnobPos = (float)this.rightScroll * (148.0f / (float)(spellEffects.size() * 2 - 12));
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingLeft) {
            this.leftKnobPos = class_3532.method_15350((double)(mouseY - (double)this.field_2800 - 16.0), (double)0.0, (double)148.0);
            this.leftScroll = (int)(this.leftKnobPos / 148.0 * (double)(spellShapes.size() * 2 - 12));
        } else if (this.draggingRight) {
            this.rightKnobPos = class_3532.method_15350((double)(mouseY - (double)this.field_2800 - 16.0), (double)0.0, (double)148.0);
            this.rightScroll = (int)(this.rightKnobPos / 148.0 * (double)(spellEffects.size() * 2 - 12));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (SpellComponentWidget widget : this.spellShapeWidgets) {
                if (!this.method_2378(widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364(), mouseX, mouseY)) continue;
                widget.method_25348(mouseX, mouseY);
            }
            for (SpellComponentWidget widget : this.spellEffectWidgets) {
                if (!this.method_2378(widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364(), mouseX, mouseY)) continue;
                widget.method_25348(mouseX, mouseY);
            }
            if (this.method_2378(-58, 5, 12, 170, mouseX, mouseY)) {
                this.draggingLeft = true;
                this.leftKnobPos = class_3532.method_15350((double)(mouseY - (double)this.field_2800 - 16.0), (double)0.0, (double)148.0);
                this.leftScroll = (int)(this.leftKnobPos / 148.0 * (double)(spellShapes.size() * 2 - 12));
            } else if (this.method_2378(302, 5, 12, 170, mouseX, mouseY)) {
                this.draggingRight = true;
                this.rightKnobPos = class_3532.method_15350((double)(mouseY - (double)this.field_2800 - 16.0), (double)0.0, (double)148.0);
                this.rightScroll = (int)(this.rightKnobPos / 148.0 * (double)(spellEffects.size() * 2 - 12));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!ArcanusSpellComponents.EMPTY.is((Object)this.draggedComponent) && button == 0) {
            if (this.method_2378(VALID_BOUNDS.x(), VALID_BOUNDS.y(), VALID_BOUNDS.z(), VALID_BOUNDS.w(), mouseX, mouseY) && !this.isTooCloseToComponents(mouseX, mouseY)) {
                Object positions;
                Vector2i pos = new Vector2i((int)(mouseX - (double)this.field_2776 - 12.0), (int)(mouseY - (double)this.field_2800 - 12.0));
                SpellComponent spellComponent = this.draggedComponent;
                if (spellComponent instanceof SpellShape) {
                    SpellShape shape = (SpellShape)spellComponent;
                    positions = new ArrayList();
                    positions.add(pos);
                    SpellGroup group = new SpellGroup(shape, new ArrayList<SpellEffect>(), (List<Vector2i>)positions);
                    Action action = this.undoRedoStack.addAction(new Action(this.draggedComponent, pos, () -> this.spellGroups.add(group), () -> this.spellGroups.remove(group)));
                    action.Do().run();
                }
                if ((positions = this.draggedComponent) instanceof SpellEffect) {
                    SpellEffect effect = (SpellEffect)positions;
                    if (!this.spellGroups.isEmpty() && !ArcanusSpellComponents.EMPTY.is((Object)this.spellGroups.getLast().shape())) {
                        Action action = this.undoRedoStack.addAction(new Action(this.draggedComponent, pos, () -> {
                            this.spellGroups.getLast().effects().add(effect);
                            this.spellGroups.getLast().positions().add(pos);
                        }, () -> {
                            this.spellGroups.getLast().effects().remove(effect);
                            this.spellGroups.getLast().positions().remove(pos);
                        }));
                        action.Do().run();
                    }
                }
            }
            this.draggedComponent = (SpellComponent)ArcanusSpellComponents.EMPTY.get();
        }
        if (this.draggingLeft) {
            this.draggingLeft = false;
        }
        if (this.draggingRight) {
            this.draggingRight = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.textBox.method_25370()) {
            if (keyCode == 256) {
                this.textBox.method_25365(false);
                return false;
            }
            if (keyCode == 69) {
                return false;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_37067() {
        super.method_37067();
        this.spellGroups.clear();
        this.spellShapeWidgets.clear();
        this.spellEffectWidgets.clear();
    }

    private void drawWidgets(class_332 gui, int mouseX, int mouseY, float delta) {
        List<Vector2i> positions;
        SpellComponentWidget widget;
        int i;
        class_4587 matrices = gui.method_51448();
        int scale = (int)this.field_22787.method_22683().method_4495();
        RenderSystem.enableScissor((int)((this.field_2776 - 38) * scale), (int)((this.field_2800 + 5) * scale), (int)(30 * scale), (int)(170 * scale));
        for (i = 0; i < this.spellShapeWidgets.size(); ++i) {
            widget = this.spellShapeWidgets.get(i);
            widget.method_46419(8 + i * 28 - this.leftScroll * 14);
            widget.method_25394(gui, mouseX - this.field_2776, mouseY - this.field_2800, delta);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!widget.method_25367()) continue;
            gui.method_25290(PANEL_TEXTURE, widget.method_46426() - 3, widget.method_46427() - 3, 0.0f, 208.0f, 30, 30, 384, 256);
        }
        RenderSystem.disableScissor();
        RenderSystem.enableScissor((int)((this.field_2776 + 264) * scale), (int)((this.field_2800 + 5) * scale), (int)(30 * scale), (int)(170 * scale));
        for (i = 0; i < this.spellEffectWidgets.size(); ++i) {
            widget = this.spellEffectWidgets.get(i);
            widget.method_46419(8 + i * 28 - this.rightScroll * 14);
            widget.method_25394(gui, mouseX - this.field_2776, mouseY - this.field_2800, delta);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!widget.method_25367()) continue;
            gui.method_25290(PANEL_TEXTURE, widget.method_46426() - 3, widget.method_46427() - 3, 0.0f, 208.0f, 30, 30, 384, 256);
        }
        RenderSystem.disableScissor();
        for (i = 0; i < this.spellGroups.size(); ++i) {
            SpellGroup group = this.spellGroups.get(i);
            positions = group.positions();
            RenderSystem.setShader(class_757::method_34539);
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.3f, (float)1.0f);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            matrices.method_22903();
            matrices.method_46416(12.0f, 12.0f, 0.0f);
            Matrix4f matrix = matrices.method_23760().method_23761();
            for (int j = 0; j < positions.size(); ++j) {
                Vector2i pos = positions.get(j);
                Vector2i prevPos = positions.get(Math.max(0, j - 1));
                if (j == 0 && i > 0 && !this.spellGroups.get(i - 1).isEmpty()) {
                    List<Vector2i> prevPositions = this.spellGroups.get(i - 1).positions();
                    prevPos = prevPositions.get(prevPositions.size() - 1);
                }
                if (pos.equals((Object)prevPos)) continue;
                int x1 = prevPos.x();
                int y1 = prevPos.y();
                int x2 = pos.x();
                int y2 = pos.y();
                float angle = (float)(Math.atan2(y2 - y1, x2 - x1) - 1.5707963267948966);
                float dx = class_3532.method_15362((float)angle);
                float dy = class_3532.method_15374((float)angle);
                bufferBuilder.method_22918(matrix, (float)x2 - dx, (float)y2 - dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x2 + dx, (float)y2 + dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x1 + dx, (float)y1 + dy, 0.0f).method_39415(0).method_1344();
                bufferBuilder.method_22918(matrix, (float)x1 - dx, (float)y1 - dy, 0.0f).method_39415(0).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
        }
        for (SpellGroup group : this.spellGroups) {
            positions = group.positions();
            for (int j = 0; j < positions.size(); ++j) {
                Vector2i pos = positions.get(j);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                gui.method_25290(PANEL_TEXTURE, pos.x - 3, pos.y - 3, 60.0f, 208.0f, 30, 30, 384, 256);
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.3f, (float)1.0f);
                gui.method_25290(PANEL_TEXTURE, pos.x - 3, pos.y - 3, 30.0f, 208.0f, 30, 30, 384, 256);
                gui.method_25290(group.getAllComponents().toList().get(j).getTexture(), pos.x, pos.y, 0.0f, 0.0f, 24, 24, 24, 24);
            }
        }
        if (!ArcanusSpellComponents.EMPTY.is((Object)this.draggedComponent)) {
            int colour = 0xFF0000;
            if (!(!this.method_2378(VALID_BOUNDS.x(), VALID_BOUNDS.y(), VALID_BOUNDS.z(), VALID_BOUNDS.w(), mouseX, mouseY) || this.isTooCloseToComponents(mouseX, mouseY) || this.draggedComponent instanceof SpellEffect && (this.spellGroups.isEmpty() || this.spellGroups.getLast().isEmpty()))) {
                colour = 65280;
            }
            float r = (float)(colour >> 16 & 0xFF) / 255.0f;
            float g = (float)(colour >> 8 & 0xFF) / 255.0f;
            float b = (float)(colour & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.method_25290(PANEL_TEXTURE, mouseX - this.field_2776 - 15, mouseY - this.field_2800 - 15, 60.0f, 208.0f, 30, 30, 384, 256);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            gui.method_25290(PANEL_TEXTURE, mouseX - this.field_2776 - 15, mouseY - this.field_2800 - 15, 30.0f, 208.0f, 30, 30, 384, 256);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            gui.method_25290(this.draggedComponent.getTexture(), mouseX - this.field_2776 - 12, mouseY - this.field_2800 - 12, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int componentCount = this.spellComponentCount();
        int maxComponents = ArcanusComponents.maxSpellSize((class_1309)this.field_22787.field_1724);
        int componentCounterColour = 0x5555FF;
        if (componentCount >= maxComponents) {
            componentCounterColour = 0xCC2222;
        }
        String spellComponentCount = String.valueOf(componentCount);
        String maxSpellComponentCount = String.valueOf(maxComponents);
        gui.method_51433(this.field_22793, spellComponentCount, 118 - this.field_22793.method_1727(spellComponentCount) / 2, 11, componentCounterColour, false);
        gui.method_51433(this.field_22793, " / ", 128 - this.field_22793.method_1727(" / ") / 2, 11, 0x555555, false);
        gui.method_51433(this.field_22793, maxSpellComponentCount, 138 - this.field_22793.method_1727(maxSpellComponentCount) / 2, 11, componentCounterColour, false);
        class_5250 weight = class_2561.method_43471((String)("spell_book.arcanuscontinuum.weight." + this.getWeight().toString().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1077);
        class_5250 mana = class_2561.method_43470((String)Arcanus.format(this.getManaCost())).method_27692(class_124.field_1078);
        class_5250 coolDown = class_2561.method_43470((String)Arcanus.format((double)this.getCoolDown() / 20.0)).method_10852((class_2561)class_2561.method_43471((String)"spell_book.arcanuscontinuum.seconds")).method_27692(class_124.field_1061);
        gui.method_51439(this.field_22793, (class_2561)weight, 240 - this.field_22793.method_27525((class_5348)weight), 7, 0xFFFFFF, false);
        gui.method_51439(this.field_22793, (class_2561)mana, 240 - this.field_22793.method_27525((class_5348)mana), 17, 0xFFFFFF, false);
        gui.method_51439(this.field_22793, (class_2561)coolDown, 240 - this.field_22793.method_27525((class_5348)coolDown), 27, 0xFFFFFF, false);
        int n = this.field_22793.method_1727("12 / 12");
        Objects.requireNonNull(this.field_22793);
        if (this.method_2378(109, 8, n, 9 + 4, mouseX, mouseY)) {
            gui.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.arcanuscontinuum.tooltip.component_count"), mouseX - this.field_2776, mouseY - this.field_2800);
        }
        for (SpellComponentWidget widget2 : this.spellShapeWidgets) {
            if (!widget2.method_25367()) continue;
            widget2.renderTooltip(gui, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        for (SpellComponentWidget widget3 : this.spellEffectWidgets) {
            if (!widget3.method_25367()) continue;
            widget3.renderTooltip(gui, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        for (SpellGroup group : this.spellGroups) {
            for (int i2 = 0; i2 < group.positions().size(); ++i2) {
                Vector2i position = group.positions().get(i2);
                if (!this.method_2378(position.x() - 2, position.y() - 2, 28, 28, mouseX, mouseY)) continue;
                ArrayList<Object> textList = new ArrayList<Object>();
                SpellComponent component = group.getAllComponents().toList().get(i2);
                textList.add(component.getName());
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.weight").method_27693(": ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"spell_book.arcanuscontinuum.weight", (Object[])new Object[]{component.getWeight().toString().toLowerCase(Locale.ROOT)}).method_27692(class_124.field_1080)));
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.mana_cost").method_27693(": ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)component.getManaCostAsString()).method_27692(class_124.field_1080)));
                if (component instanceof SpellShape) {
                    SpellShape shape = (SpellShape)component;
                    if (shape.getManaMultiplier() != 0.0) {
                        textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.mana_multiplier").method_27693(": ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)shape.getManaMultiplierAsString()).method_27692(class_124.field_1080)));
                    }
                    if (shape.getPotencyModifier() != 0.0) {
                        textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.potency_modifier").method_27693(": ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)shape.getPotencyModifierAsString()).method_27692(class_124.field_1080)));
                    }
                }
                textList.add(class_2561.method_43471((String)"spell_book.arcanuscontinuum.cool_down").method_27693(": ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)component.getCoolDownAsString()).method_10852((class_2561)class_2561.method_43471((String)"spell_book.arcanuscontinuum.seconds")).method_27692(class_124.field_1080)));
                gui.method_51434(this.field_22793, textList, mouseX - this.field_2776, mouseY - this.field_2800);
            }
        }
    }

    protected void addCloseButtons() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            SaveBookDataPacket.send(((SpellcraftScreenHandler)this.method_17577()).getPos(), this.getSpell());
            this.method_25419();
        }).method_46433(this.field_22789 / 2 - 100, this.field_2800 + 170).method_46437(98, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"lectern.take_book"), button -> {
            SaveBookDataPacket.send(((SpellcraftScreenHandler)this.method_17577()).getPos(), this.getSpell());
            this.field_22787.field_1761.method_2900(((SpellcraftScreenHandler)this.field_2797).field_7763, 0);
            this.method_25419();
        }).method_46433(this.field_22789 / 2 + 2, this.field_2800 + 170).method_46437(98, 20).method_46431());
    }

    public <T extends SpellComponentWidget> T addSpellShapeChild(T drawable) {
        this.spellShapeWidgets.add(drawable);
        return drawable;
    }

    public <T extends SpellComponentWidget> T addSpellEffectChild(T drawable) {
        this.spellEffectWidgets.add(drawable);
        return drawable;
    }

    public Rectangle getLeftScrollKnob() {
        return new Rectangle(-58, (int)(5.0 + this.leftKnobPos), 12, 22);
    }

    public Rectangle getRightScrollKnob() {
        return new Rectangle(302, (int)(5.0 + this.rightKnobPos), 12, 22);
    }

    public boolean isTooCloseToComponents(double mouseX, double mouseY) {
        return this.distanceToNearestComponent(mouseX, mouseY) < 40.0;
    }

    public double distanceToNearestComponent(double mouseX, double mouseY) {
        return this.spellGroups.stream().mapToDouble(spellGroup -> spellGroup.positions().stream().mapToDouble(position -> position.distance((int)(mouseX - (double)this.field_2776 - 12.0), (int)(mouseY - (double)this.field_2800 - 12.0))).min().orElse(Double.MAX_VALUE)).min().orElse(Double.MAX_VALUE);
    }

    public int spellComponentCount() {
        int count = 0;
        for (SpellGroup group : this.spellGroups) {
            if (group.isEmpty()) continue;
            count += group.getAllComponents().toList().size();
        }
        return count;
    }

    public Spell getSpell() {
        if (this.spellGroups.isEmpty()) {
            return new Spell();
        }
        if (this.spellGroups.get(0).isEmpty() && this.spellGroups.size() > 1 && !this.spellGroups.get(1).isEmpty()) {
            this.spellGroups.remove(0);
        }
        return new Spell(this.spellGroups, this.textBox.method_1882().isBlank() ? "Empty" : this.textBox.method_1882());
    }

    public Weight getWeight() {
        return this.getSpell().getWeight();
    }

    public double getManaCost() {
        return this.getSpell().getManaCost();
    }

    public int getCoolDown() {
        return this.getSpell().getCoolDown();
    }
}

