/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.gui.screens;

import com.mojang.authlib.GameProfile;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.client.gui.screens.NotSupporterScreen;
import dev.cammiescorner.arcanuscontinuum.client.gui.screens.SupporterSavingScreen;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.cammiescorner.arcanuscontinuum.common.util.StandardColors;
import dev.cammiescorner.arcanuscontinuum.common.util.supporters.HaloData;
import dev.cammiescorner.arcanuscontinuum.common.util.supporters.WizardData;
import dev.upcraft.datasync.api.util.Entitlements;
import dev.upcraft.datasync.api.util.GameProfileHelper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SupporterScreen
extends class_437 {
    private final class_437 parent;
    private Entitlements userEntitlements;
    @Nullable
    private WizardData wizardData;
    @Nullable
    private HaloData haloData;
    private boolean haloEnabled;
    private class_342 magicColorField;
    private class_342 pocketDimensionColorField;
    private class_342 haloColorField;

    public SupporterScreen(class_437 parent, GameProfile clientProfile, Entitlements userEntitlements) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.userEntitlements = userEntitlements;
        if (userEntitlements.keys().contains(WizardData.ID)) {
            this.wizardData = (WizardData)Arcanus.WIZARD_DATA.getOrDefault(clientProfile.getId(), (Object)WizardData.empty());
        }
        if (userEntitlements.keys().contains(HaloData.ID)) {
            this.haloData = (HaloData)Arcanus.HALO_DATA.getOrDefault(clientProfile.getId(), (Object)HaloData.empty());
            this.haloEnabled = this.haloData.shouldShow();
        }
    }

    public static void open(@Nullable class_437 parent) {
        GameProfile clientProfile = GameProfileHelper.getClientProfile();
        Entitlements entitlements = Entitlements.getOrEmpty((UUID)clientProfile.getId());
        boolean isSupporter = entitlements.keys().contains(WizardData.ID) || entitlements.keys().contains(HaloData.ID);
        class_310.method_1551().method_1507(isSupporter ? new SupporterScreen(parent, clientProfile, entitlements) : new NotSupporterScreen(parent, clientProfile));
    }

    private boolean hasWizardData() {
        return this.wizardData != null;
    }

    private boolean hasHaloData() {
        return this.haloData != null;
    }

    private class_2561 getHaloEnabledText() {
        class_5250 text = this.haloEnabled ? class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.halo_enabled") : class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.halo_disabled");
        class_5250 checkMark = this.haloEnabled ? class_2561.method_43471((String)"screen.arcanuscontinuum.check.enabled").method_27692(class_124.field_1060) : class_2561.method_43471((String)"screen.arcanuscontinuum.check.disabled").method_27692(class_124.field_1061);
        return class_2561.method_43473().method_10852((class_2561)checkMark).method_27693(" ").method_10852((class_2561)text);
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int yOffset = 0;
        if (this.hasHaloData()) {
            if (this.hasWizardData()) {
                yOffset = -35;
            }
            this.haloColorField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, centerX + 11, centerY + yOffset - 10, 64, 20, (class_2561)class_2561.method_43473()));
            this.method_37063((class_364)class_4185.method_46430((class_2561)this.getHaloEnabledText(), buttonWidget -> {
                this.haloEnabled = !this.haloEnabled;
                buttonWidget.method_25355(this.getHaloEnabledText());
            }).method_46434(centerX - 11, centerY + yOffset + 30 - 10, 88, 20).method_46431());
            this.haloColorField.method_47404((class_2561)class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.halo_color"));
            this.haloColorField.method_1852(String.format("#%06X", this.haloData.color().asInt(Color.Ordering.RGB)));
            this.haloColorField.method_1880(7);
            yOffset = 35;
        }
        if (this.hasWizardData()) {
            this.magicColorField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, centerX + 11, centerY + yOffset - 10, 64, 20, (class_2561)class_2561.method_43473()));
            this.magicColorField.method_47404((class_2561)class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.magic_color"));
            this.magicColorField.method_1852(String.format("#%06X", this.wizardData.magicColor().asInt(Color.Ordering.RGB)));
            this.magicColorField.method_1880(7);
            this.pocketDimensionColorField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, centerX + 11, centerY + yOffset - 10 + 30, 64, 20, (class_2561)class_2561.method_43473()));
            this.pocketDimensionColorField.method_47404((class_2561)class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.pocket_dimension_color"));
            this.pocketDimensionColorField.method_1852(String.format("#%06X", this.wizardData.pocketDimensionColor().asInt(Color.Ordering.RGB)));
            this.pocketDimensionColorField.method_1880(7);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.save_and_exit"), buttonWidget -> {
            ArrayList<CompletableFuture> saveFutures = new ArrayList<CompletableFuture>();
            if (this.hasHaloData()) {
                HaloData newHaloData = this.getColorFromField(this.haloColorField).map(this.haloData::withColor).orElse(this.haloData).withEnabled(this.haloEnabled);
                if (!newHaloData.equals(this.haloData)) {
                    saveFutures.add(Arcanus.HALO_DATA.setData((Object)newHaloData));
                }
            }
            if (this.hasWizardData()) {
                WizardData newWizardData = this.getColorFromField(this.magicColorField).map(this.wizardData::withColor).orElse(this.wizardData);
                newWizardData = this.getColorFromField(this.pocketDimensionColorField).map(newWizardData::withPocketDimensionColor).orElse(newWizardData);
                if (!newWizardData.equals(this.wizardData)) {
                    saveFutures.add(Arcanus.WIZARD_DATA.setData((Object)newWizardData));
                }
            }
            this.field_22787.method_1507((class_437)new SupporterSavingScreen(CompletableFuture.allOf((CompletableFuture[])saveFutures.toArray(CompletableFuture[]::new)), () -> this.field_22787.method_1507(this.parent)));
        }).method_46434(centerX - 55, this.field_22790 - 27, 110, 20).method_46431());
    }

    public void method_25420(class_332 graphics) {
        this.method_25434(graphics);
        graphics.method_51422(0.125f, 0.125f, 0.125f, 1.0f);
        graphics.method_25290(class_437.field_44669, 16, 32, 0.0f, 0.0f, this.field_22789 - 32, this.field_22790 - 65, 32, 32);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.method_51740(class_1921.method_51785(), 16, 32, this.field_22789 - 16, 36, -16777216, 0, 0);
        graphics.method_51740(class_1921.method_51785(), 16, this.field_22790 - 37, this.field_22789 - 16, this.field_22790 - 33, 0, -16777216, 0);
    }

    private Optional<Color> getColorFromField(class_342 field) {
        String fieldText = field.method_1882().trim().replace("#", "");
        if (fieldText.length() != 6) {
            return Optional.of(StandardColors.BLACK);
        }
        try {
            int rgb = Integer.parseInt(fieldText, 16);
            return Optional.of(Color.fromInt(rgb, Color.Ordering.RGB));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private void renderColorDisplay(class_332 graphics, int x, int y, Optional<Color> color) {
        graphics.method_25294(x - 9, y - 9, x + 9, y + 9, -986896);
        color.ifPresent(colorValue -> graphics.method_25294(x - 8, y - 8, x + 8, y + 8, colorValue.asIntARGB()));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int yOffset = 0;
        int xOffset = -130;
        if (this.hasHaloData()) {
            if (this.hasWizardData()) {
                yOffset = -35;
            }
            this.renderColorDisplay(graphics, centerX - 2, centerY + yOffset, this.getColorFromField(this.haloColorField));
            class_5250 class_52502 = class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.halo_color");
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, (class_2561)class_52502, centerX + xOffset, centerY + yOffset - 9 / 2, 0xFFFFFF, false);
            yOffset = 35;
        }
        if (this.hasWizardData()) {
            this.renderColorDisplay(graphics, centerX - 2, centerY + yOffset, this.getColorFromField(this.magicColorField));
            class_5250 class_52503 = class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.magic_color");
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, (class_2561)class_52503, centerX + xOffset, centerY + yOffset - 9 / 2, 0xFFFFFF, false);
            this.renderColorDisplay(graphics, centerX - 2, centerY + yOffset + 30, this.getColorFromField(this.pocketDimensionColorField));
            class_5250 class_52504 = class_2561.method_43471((String)"config.arcanuscontinuum.supporter_settings.pocket_dimension_color");
            Objects.requireNonNull(this.field_22793);
            graphics.method_51439(this.field_22793, (class_2561)class_52504, centerX + xOffset, centerY + yOffset + 30 - 9 / 2, 0xFFFFFF, false);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

