/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.client.ArcanusClient;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Beam;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class BeamRenderer
extends class_897<Beam> {
    private static final class_2960 BEAM_TEXTURE = Arcanus.id("textures/entity/magic/beam.png");
    private static final class_1921 LAYER = ArcanusClient.getMagicCircles(BEAM_TEXTURE);
    private static final Vector3d UP = new Vector3d(0.0, 1.0, 0.0);

    public BeamRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(Beam entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertices, int light) {
        class_1309 caster = entity.getCaster();
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        if (caster != null) {
            class_243 startPos = caster.method_30950(tickDelta).method_1031(0.0, (double)(caster.method_18381(caster.method_18376()) * 0.9f), 0.0);
            class_243 endPos = entity.getBeamPos(tickDelta);
            Vector3d axis = new Vector3d(endPos.method_10216() - startPos.method_10216(), endPos.method_10214() - startPos.method_10214(), endPos.method_10215() - startPos.method_10215()).normalize();
            class_4588 vertex = vertices.getBuffer(LAYER);
            Color color = ArcanusHelper.getMagicColor(entity);
            float distance = entity.method_5739((class_1297)caster) / 2.0f;
            matrices.method_22903();
            matrices.method_22904(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            for (int i = 0; i < 2; ++i) {
                Vector3d vec = new Vector3d(cam.method_10216(), cam.method_10214(), cam.method_10215()).sub(startPos.method_10216(), startPos.method_10214(), startPos.method_10215()).cross((Vector3dc)axis).normalize().mul(0.2);
                vec.rotateAxis(Math.toRadians(i == 0 ? 45.0 : -45.0), axis.x, axis.y, axis.z);
                class_243 vert1 = startPos.method_1031(vec.x, vec.y, vec.z);
                class_243 vert2 = startPos.method_1023(vec.x, vec.y, vec.z);
                class_243 vert3 = endPos.method_1031(vec.x, vec.y, vec.z);
                class_243 vert4 = endPos.method_1023(vec.x, vec.y, vec.z);
                float beamProgress = entity.getBeamProgress(tickDelta) * 2.0f;
                if (i > 0) {
                    beamProgress *= -1.0f;
                }
                float minU = 0.0f;
                float minV = -beamProgress;
                float maxU = 1.0f;
                float maxV = distance - beamProgress;
                if (i > 0) {
                    minV = 1.0f - minV;
                    maxV = 1.0f - maxV;
                }
                BeamRenderer.vertex(vertex, matrices, vert4, color, maxU, minV);
                BeamRenderer.vertex(vertex, matrices, vert3, color, minU, minV);
                BeamRenderer.vertex(vertex, matrices, vert1, color, minU, maxV);
                BeamRenderer.vertex(vertex, matrices, vert2, color, maxU, maxV);
            }
            matrices.method_22909();
        }
    }

    public boolean shouldRender(Beam entity, class_4604 frustum, double x, double y, double z) {
        return true;
    }

    private static void vertex(class_4588 vertex, class_4587 matrices, class_243 vert, Color color, float u, float v) {
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        vertex.method_22918(modelMatrix, (float)vert.method_10216(), (float)vert.method_10214(), (float)vert.method_10215()).method_1336(color.red(), color.green(), color.blue(), color.alpha()).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public class_2960 getTextureLocation(Beam entity) {
        return BEAM_TEXTURE;
    }
}

