/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.client.ArcanusClient;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.PocketDimensionPortalModel;
import dev.cammiescorner.arcanuscontinuum.client.models.entity.magic.SpatialRiftSigilModel;
import dev.cammiescorner.arcanuscontinuum.client.utils.StencilBuffer;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.PocketDimensionPortal;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.lwjgl.opengl.GL31;

public class PocketDimensionPortalRenderer
extends class_897<PocketDimensionPortal> {
    private static final class_2960 PORTAL_TEXTURE = Arcanus.id("textures/entity/magic/pocket_dimension_portal.png");
    private static final class_2960 SIGIL_TEXTURE = Arcanus.id("textures/entity/magic/spatial_rift_sigil.png");
    private final class_310 client = class_310.method_1551();
    private final class_289 tesselator = class_289.method_1348();
    private final PocketDimensionPortalModel portalModel;
    private final SpatialRiftSigilModel sigilModel;

    public PocketDimensionPortalRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.portalModel = new PocketDimensionPortalModel(ctx.method_32170().method_32072(PocketDimensionPortalModel.MODEL_LAYER));
        this.sigilModel = new SpatialRiftSigilModel(ctx.method_32170().method_32072(SpatialRiftSigilModel.MODEL_LAYER));
    }

    public void render(PocketDimensionPortal entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertices, int light) {
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertices, light);
        StencilBuffer stencilBuffer = (StencilBuffer)this.client.method_1522();
        class_1921 portalLayer = ArcanusClient.getMagicPortal(PORTAL_TEXTURE);
        class_1921 sigilLayer = ArcanusClient.getMagicCircles(SIGIL_TEXTURE);
        Color pocketDimColor = ArcanusHelper.getPocketDimensionColor(entity);
        Color magicColor = ArcanusHelper.getMagicColor(entity);
        float ageDelta = (float)entity.getTrueAge() + tickDelta;
        float maxScale = 0.75f;
        float scale = entity.getTrueAge() <= 100 ? Math.min(maxScale, ageDelta / 100.0f * maxScale) : (entity.getTrueAge() > 700 ? Math.max(0.0f, (1.0f - (ageDelta - 700.0f) / 20.0f) * maxScale) : maxScale);
        matrices.method_22903();
        matrices.method_22904(0.0, 1.625, 0.0);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrices.method_22905(scale, 1.0f, scale);
        this.portalModel.skybox.method_22699(matrices, vertices.getBuffer(class_1921.method_23572((class_2960)PORTAL_TEXTURE)), light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.05, 0.0);
        matrices.method_22905(scale, 1.0f, scale);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        if (!stencilBuffer.arcanus$isStencilBufferEnabled()) {
            stencilBuffer.arcanus$enableStencilBufferAndReload(true);
        }
        GL31.glEnable((int)2960);
        GL31.glDepthMask((boolean)false);
        GL31.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        GL31.glStencilOp((int)7680, (int)7680, (int)7682);
        GL31.glStencilFunc((int)514, (int)0, (int)255);
        GL31.glStencilMask((int)255);
        class_1921.method_23589().method_23516();
        class_757.method_34539().method_34586();
        GL31.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        GL31.glDepthFunc((int)515);
        PocketDimensionPortalRenderer.drawStencil(matrices, this.tesselator);
        class_757.method_34539().method_34585();
        class_1921.method_23589().method_23518();
        GL31.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL31.glStencilFunc((int)517, (int)0, (int)255);
        GL31.glStencilMask((int)0);
        matrices.method_22903();
        matrices.method_22904(-0.375, 0.0, 0.0);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        matrices.method_22905(maxScale, maxScale, maxScale);
        this.portalModel.method_2828(matrices, vertices.getBuffer(portalLayer), light, class_4608.field_21444, pocketDimColor.redF(), pocketDimColor.greenF(), pocketDimColor.blueF(), 1.0f);
        matrices.method_22909();
        if (vertices instanceof class_4597.class_4598) {
            class_4597.class_4598 immediate = (class_4597.class_4598)vertices;
            immediate.method_22993();
            GL31.glDepthMask((boolean)true);
        }
        GL31.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        GL31.glStencilOp((int)7680, (int)7680, (int)7683);
        GL31.glStencilFunc((int)514, (int)1, (int)255);
        GL31.glStencilMask((int)255);
        class_1921.method_23589().method_23516();
        class_757.method_34539().method_34586();
        GL31.glDepthFunc((int)519);
        PocketDimensionPortalRenderer.drawStencil(matrices, this.tesselator);
        class_757.method_34539().method_34585();
        class_1921.method_23589().method_23518();
        GL31.glStencilFunc((int)514, (int)0, (int)255);
        GL31.glStencilMask((int)0);
        GL31.glDisable((int)2960);
        GL31.glEnable((int)2929);
        GL31.glDepthFunc((int)515);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904(0.0, 1.51, 0.0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22905(scale / maxScale, 1.0f, scale / maxScale);
        this.sigilModel.sigil.field_3675 = ((float)entity.field_6012 + tickDelta) * 0.015f;
        this.sigilModel.method_2828(matrices, vertices.getBuffer(sigilLayer), light, class_4608.field_21444, magicColor.redF(), magicColor.greenF(), magicColor.blueF(), 1.0f);
        matrices.method_22909();
    }

    public class_2960 getTextureLocation(PocketDimensionPortal entity) {
        return PORTAL_TEXTURE;
    }

    public static void drawStencil(class_4587 matrices, class_289 tessellator) {
        class_287 builder = tessellator.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        builder.method_22918(matrices.method_23760().method_23761(), 0.0f, -1.0f, -1.0f).method_1344();
        builder.method_22918(matrices.method_23760().method_23761(), 0.0f, 1.0f, -1.0f).method_1344();
        builder.method_22918(matrices.method_23760().method_23761(), 0.0f, 1.0f, 1.0f).method_1344();
        builder.method_22918(matrices.method_23760().method_23761(), 0.0f, -1.0f, 1.0f).method_1344();
        tessellator.method_1350();
    }
}

