/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.client.renderer.entity.magic;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.client.ArcanusClient;
import dev.cammiescorner.arcanuscontinuum.common.entities.magic.Smite;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SmiteRenderer
extends class_897<Smite> {
    private static final class_2960 TEXTURE = Arcanus.id("textures/block/magic_block.png");

    public SmiteRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(Smite entity, float yaw, float tickDelta, class_4587 matrices, class_4597 provider, int light) {
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, provider, light);
        this.renderBeam(entity, matrices, provider, 0.0f, (float)((double)(entity.method_37908().method_31605() + 2048) - entity.method_23318()), 0.0f, tickDelta, class_4608.field_21444, light);
    }

    public void renderBeam(Smite entity, class_4587 matrices, class_4597 provider, float x, float y, float z, float tickDelta, int overlay, int light) {
        int maxQuads = 16;
        float radius = 2.25f;
        Color color = ArcanusHelper.getMagicColor(entity);
        float squaredLength = x * x + y * y + z * z;
        float length = class_3532.method_15355((float)squaredLength);
        float ageDelta = (float)(entity.field_6012 - 1) + tickDelta;
        float scale = class_3532.method_15363((float)(ageDelta < 3.0f ? ageDelta / 3.0f : (ageDelta > 9.0f ? 1.0f - (ageDelta - 9.0f) / 15.0f : 1.0f)), (float)0.0f, (float)1.0f);
        float alpha = ageDelta < 3.0f ? 1.0f : class_3532.method_15363((float)(1.0f - (ageDelta - 3.0f) / 23.0f), (float)0.0f, (float)1.0f);
        float r = color.redF() * alpha;
        float g = color.greenF() * alpha;
        float b = color.blueF() * alpha;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        matrices.method_22905(scale, scale, 1.0f);
        class_4588 vertexConsumer = provider.getBuffer(ArcanusClient.getMagicCircles(TEXTURE));
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = matrices.method_23760().method_23762();
        float vertX1 = 0.0f;
        float vertY1 = radius;
        for (int i = 1; i <= maxQuads; ++i) {
            float vertX2 = class_3532.method_15374((float)((float)i * ((float)Math.PI * 2) / (float)maxQuads)) * radius;
            float vertY2 = class_3532.method_15362((float)((float)i * ((float)Math.PI * 2) / (float)maxQuads)) * radius;
            Vector3f u = new Vector3f(vertX2 - vertX1, vertY2 - vertY1, length);
            Vector3f v = new Vector3f(vertX1 - vertX2, vertY1 - vertY2, -length);
            Vector3f normal = u.cross((Vector3fc)v);
            vertexConsumer.method_22918(matrix4f, vertX1, vertY1, 0.0f).method_22915(r, g, b, 1.0f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(matrix3f, normal.x, normal.y, normal.z).method_1344();
            vertexConsumer.method_22918(matrix4f, vertX1, vertY1, length).method_22915(r, g, b, 1.0f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(matrix3f, normal.x, normal.y, normal.z).method_1344();
            vertexConsumer.method_22918(matrix4f, vertX2, vertY2, length).method_22915(r, g, b, 1.0f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(matrix3f, normal.x, normal.y, normal.z).method_1344();
            vertexConsumer.method_22918(matrix4f, vertX2, vertY2, 0.0f).method_22915(r, g, g, 1.0f).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_23763(matrix3f, normal.x, normal.y, normal.z).method_1344();
            vertX1 = vertX2;
            vertY1 = vertY2;
        }
        matrices.method_22909();
    }

    public boolean shouldRender(Smite entity, class_4604 frustum, double x, double y, double z) {
        return true;
    }

    public class_2960 getTextureLocation(Smite entity) {
        return TEXTURE;
    }
}

