/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.command.pocketdimension;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.common.command.PocketDimensionCommand;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionComponent;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionPlot;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusDimensions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2300;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.server.MinecraftServer;

public class ExportPocketDimensionCommand {
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public static void register(RequiredArgumentBuilder<class_2168, class_2300> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(source -> source.method_9259(2))).executes(context -> ExportPocketDimensionCommand.export((CommandContext<class_2168>)context, PocketDimensionCommand.getPlayerProfile((CommandContext<class_2168>)context))));
    }

    private static int export(CommandContext<class_2168> context, GameProfile targetProfile) {
        String date = LocalDateTime.now().format(FORMAT);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3218 pocketDim = server.method_3847(ArcanusDimensions.POCKET_DIMENSION);
        if (pocketDim == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.arcanuscontinuum.pocket_dimension.export.error.dimension_not_found", (Object[])new Object[]{ArcanusDimensions.POCKET_DIMENSION}));
            return 0;
        }
        PocketDimensionPlot plot = PocketDimensionComponent.get(server).getAssignedPlotSpace(targetProfile.getId());
        if (plot == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.arcanuscontinuum.pocket_dimension.export.error.pocket_not_found", (Object[])new Object[]{targetProfile.getName()}));
            return 0;
        }
        class_2960 structureId = Arcanus.id("pocket_dimensions/%s/pocket_dimensions_%s".formatted(targetProfile.getId(), date));
        Arcanus.LOGGER.info("Saving pocket dimension for player {} ({}) as '{}'", new Object[]{targetProfile.getName(), targetProfile.getId(), structureId});
        class_3485 templateManager = pocketDim.method_14183();
        class_3499 structure = templateManager.method_15091(structureId);
        structure.method_15161("%s_pocket_dimension_%s_%s".formatted("arcanuscontinuum", targetProfile.getId(), date));
        structure.method_15174((class_1937)pocketDim, plot.min(), (class_2382)plot.max().method_10069(1, 1, 1).method_10059((class_2382)plot.min()), true, null);
        templateManager.method_15093(structureId);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.arcanuscontinuum.pocket_dimension.export.success", (Object[])new Object[]{targetProfile.getName()}), true);
        return 1;
    }
}

