/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.command.pocketdimension;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.cammiescorner.arcanuscontinuum.common.command.PocketDimensionCommand;
import dev.cammiescorner.arcanuscontinuum.common.components.level.PocketDimensionComponent;
import dev.cammiescorner.arcanuscontinuum.common.data.ArcanusDimensions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class RegeneratePocketDimensionCommand {
    public static void register(RequiredArgumentBuilder<class_2168, class_2300> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"regenerate").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> RegeneratePocketDimensionCommand.regeneratePocket((CommandContext<class_2168>)context, PocketDimensionCommand.getPlayerProfile((CommandContext<class_2168>)context), PocketDimensionComponent.RegenerateType.FULL)));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"repair_walls").requires(serverCommandSource -> serverCommandSource.method_9259(3))).executes(context -> RegeneratePocketDimensionCommand.regeneratePocket((CommandContext<class_2168>)context, PocketDimensionCommand.getPlayerProfile((CommandContext<class_2168>)context), PocketDimensionComponent.RegenerateType.WALLS_ONLY)));
    }

    public static int regeneratePocket(CommandContext<class_2168> context, GameProfile target, PocketDimensionComponent.RegenerateType regenerateType) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3218 pocketDimension = server.method_3847(ArcanusDimensions.POCKET_DIMENSION);
        PocketDimensionComponent component = PocketDimensionComponent.get(server);
        if (!component.replacePlotSpace(target.getId(), pocketDimension, regenerateType)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Pocket dimension location not found for player %s (%s)".formatted(target.getName(), target.getId())));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> switch (regenerateType) {
            case PocketDimensionComponent.RegenerateType.WALLS_ONLY -> class_2561.method_43469((String)"command.arcanuscontinuum.pocket_dimension.regenerate.success.walls_only", (Object[])new Object[]{target.getName()});
            case PocketDimensionComponent.RegenerateType.FULL -> class_2561.method_43469((String)"command.arcanuscontinuum.pocket_dimension.regenerate.success.full", (Object[])new Object[]{target.getName()});
            default -> throw new UnsupportedOperationException();
        }, true);
        return 1;
    }
}

