/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.chunk;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.upcraft.sparkweave.api.SparkweaveApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2791;

public class WardedBlocksComponent
implements AutoSyncedComponent {
    private final Map<class_2338, UUID> wardedBlocks = new HashMap<class_2338, UUID>();
    private final class_2791 chunk;

    public WardedBlocksComponent(class_2791 chunk) {
        this.chunk = chunk;
    }

    public void readFromNbt(class_2487 tag) {
        class_2499 nbtList = tag.method_10554("WardedBlocksMap", 10);
        this.wardedBlocks.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 compound = nbtList.method_10602(i);
            class_2499 blockPosList = compound.method_10554("BlockPosList", 10);
            UUID ownerUuid = compound.method_25926("OwnerUuid");
            if (SparkweaveApi.CLIENTSIDE_ENVIRONMENT) {
                Arcanus.WIZARD_DATA.get(ownerUuid);
            }
            for (int j = 0; j < blockPosList.size(); ++j) {
                this.wardedBlocks.put(class_2512.method_10691((class_2487)blockPosList.method_10602(j)), ownerUuid);
            }
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 nbtList = new class_2499();
        HashMap<UUID, class_2499> map = new HashMap<UUID, class_2499>();
        this.wardedBlocks.forEach((blockPos, uuid) -> map.computeIfAbsent((UUID)uuid, uuid1 -> new class_2499()).add((Object)class_2512.method_10692((class_2338)blockPos)));
        map.forEach((uuid, nbt) -> {
            class_2487 compound = new class_2487();
            compound.method_25927("OwnerUuid", uuid);
            compound.method_10566("BlockPosList", (class_2520)nbt);
            nbtList.add((Object)compound);
        });
        tag.method_10566("WardedBlocksMap", (class_2520)nbtList);
    }

    public void addWardedBlock(class_1657 player, class_2338 pos) {
        if (!this.isBlockWarded(pos)) {
            this.wardedBlocks.put(pos, player.method_5667());
            this.chunk.syncComponent(ArcanusComponents.WARDED_BLOCKS_COMPONENT);
            this.chunk.method_12008(true);
        }
    }

    public void removeWardedBlock(class_1657 player, class_2338 pos) {
        boolean canOtherPlayersRemoveBlock = ArcanusConfig.UtilityEffects.WardingEffectProperties.canBeRemovedByOthers;
        if (canOtherPlayersRemoveBlock || this.isOwnerOfBlock(player, pos)) {
            this.wardedBlocks.remove(pos);
            this.chunk.syncComponent(ArcanusComponents.WARDED_BLOCKS_COMPONENT);
            this.chunk.method_12008(true);
        }
    }

    public boolean isOwnerOfBlock(class_1657 player, class_2338 pos) {
        return this.wardedBlocks.getOrDefault(pos, class_156.field_25140).equals(player.method_5667());
    }

    public boolean isBlockWarded(class_2338 pos) {
        return this.wardedBlocks.containsKey(pos);
    }

    public Map<class_2338, UUID> getWardedBlocks() {
        return Collections.unmodifiableMap(this.wardedBlocks);
    }
}

