/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.color;

import com.google.common.base.MoreObjects;
import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.common.components.MagicColorComponent;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.ArcanusHelper;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class GenericMagicColorComponent
implements MagicColorComponent,
AutoSyncedComponent {
    private final Object provider;
    private UUID sourceId = class_156.field_25140;

    public GenericMagicColorComponent(Object provider) {
        this.provider = provider;
    }

    public void readFromNbt(class_2487 tag) {
        this.sourceId = tag.method_25926("SourceId");
        this.updateStoredColor();
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_25927("SourceId", this.sourceId);
    }

    @Override
    public Color getColor() {
        return ArcanusHelper.getMagicColor(this.sourceId);
    }

    @Override
    public Color getPocketDimensionColor() {
        return ArcanusHelper.getPocketDimensionColor(this.sourceId);
    }

    @Override
    public UUID getSourceId() {
        return this.sourceId;
    }

    @Override
    public void setSourceId(@Nullable UUID ownerId) {
        this.sourceId = (UUID)MoreObjects.firstNonNull((Object)ownerId, (Object)class_156.field_25140);
        ArcanusComponents.MAGIC_COLOR.sync(this.provider);
        this.updateStoredColor();
    }

    private void updateStoredColor() {
        if (!class_156.field_25140.equals(this.sourceId)) {
            Arcanus.WIZARD_DATA.get(this.sourceId);
        }
    }
}

