/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.entity;

import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

public class BurnoutComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    public static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("c2223d02-f2f0-4fa9-b9d8-5b2c265a8195");
    public static final UUID MOVE_SPEED_MODIFIER = UUID.fromString("38e12f7a-64d8-4054-b609-039e240eb2a9");
    private final class_1309 entity;
    private double burnout;

    public BurnoutComponent(class_1309 entity) {
        this.entity = entity;
    }

    public void serverTick() {
        class_1324 burnoutRegenAttr = this.entity.method_5996((class_1320)ArcanusEntityAttributes.BURNOUT_REGEN.get());
        class_1324 attackSpeedAttr = this.entity.method_5996(class_5134.field_23723);
        class_1324 moveSpeedAttr = this.entity.method_5996(class_5134.field_23719);
        if (burnoutRegenAttr != null && this.drainBurnout(burnoutRegenAttr.method_6194(), true)) {
            class_1657 player;
            class_1309 class_13092;
            this.drainBurnout(burnoutRegenAttr.method_6194() / (double)((class_13092 = this.entity) instanceof class_1657 && (player = (class_1657)class_13092).method_7337() ? 1 : 30), false);
            class_13092 = this.entity;
            if (class_13092 instanceof class_1657) {
                player = (class_1657)class_13092;
                player.method_7322(0.01f);
            }
        }
        if (attackSpeedAttr != null) {
            if (this.burnout > 0.0 && attackSpeedAttr.method_6199(ATTACK_SPEED_MODIFIER) == null) {
                attackSpeedAttr.method_26837(new class_1322(ATTACK_SPEED_MODIFIER, "Burnout modifier", -0.5, class_1322.class_1323.field_6330));
            }
            if (this.burnout <= 0.0 && attackSpeedAttr.method_6199(ATTACK_SPEED_MODIFIER) != null) {
                attackSpeedAttr.method_6200(ATTACK_SPEED_MODIFIER);
            }
        }
        if (moveSpeedAttr != null) {
            if (this.burnout > 0.0 && moveSpeedAttr.method_6199(MOVE_SPEED_MODIFIER) == null) {
                moveSpeedAttr.method_26837(new class_1322(MOVE_SPEED_MODIFIER, "Burnout modifier", -0.1, class_1322.class_1323.field_6330));
            }
            if (this.burnout <= 0.0 && moveSpeedAttr.method_6199(MOVE_SPEED_MODIFIER) != null) {
                moveSpeedAttr.method_6200(MOVE_SPEED_MODIFIER);
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.burnout = tag.method_10574("Burnout");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10549("Burnout", this.burnout);
    }

    public double getBurnout() {
        return this.burnout;
    }

    public void setBurnout(double burnout) {
        this.burnout = burnout;
        if (this.entity instanceof class_1657) {
            ArcanusComponents.BURNOUT_COMPONENT.sync((Object)this.entity);
        }
    }

    public boolean addBurnout(double amount, boolean simulate) {
        double maxMana = ArcanusComponents.getMaxMana(this.entity) - ArcanusComponents.getManaLock(this.entity);
        if (this.getBurnout() < maxMana) {
            if (!simulate) {
                this.setBurnout(Math.min(maxMana, this.getBurnout() + amount));
            }
            return true;
        }
        return false;
    }

    public boolean drainBurnout(double amount, boolean simulate) {
        double maxMana = ArcanusComponents.getMaxMana(this.entity) - ArcanusComponents.getManaLock(this.entity);
        if (this.getBurnout() > 0.0) {
            if (!simulate) {
                if (this.burnout > maxMana) {
                    this.setBurnout(Math.max(0.0, maxMana - amount));
                } else {
                    this.setBurnout(Math.max(0.0, this.getBurnout() - amount));
                }
            }
            return true;
        }
        return false;
    }
}

