/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.entity;

import dev.cammiescorner.arcanuscontinuum.Arcanus;
import dev.cammiescorner.arcanuscontinuum.ArcanusConfig;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellEffect;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellGroup;
import dev.cammiescorner.arcanuscontinuum.api.spells.SpellShape;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.cammiescorner.arcanuscontinuum.common.util.Color;
import dev.cammiescorner.arcanuscontinuum.common.util.NBTHelper;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class CounterComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    private final class_1309 entity;
    private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
    private final List<SpellGroup> groups = new ArrayList<SpellGroup>();
    private UUID casterId = class_156.field_25140;
    private class_1799 stack = class_1799.field_8037;
    private Color color = Arcanus.DEFAULT_MAGIC_COLOUR;
    private int groupIndex = 0;
    private double potency = 1.0;
    private long endTime = 0L;

    public CounterComponent(class_1309 entity) {
        this.entity = entity;
    }

    public void serverTick() {
        if (!this.hasCounterActive(this.entity.method_37908()) && this.endTime != 0L) {
            this.removeCounter();
        }
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeInt(this.color.asInt(Color.Ordering.ARGB));
        buf.writeLong(this.endTime);
    }

    public void applySyncPacket(class_2540 buf) {
        this.color = Color.fromInt(buf.readInt(), Color.Ordering.ARGB);
        this.endTime = buf.readLong();
    }

    public void readFromNbt(class_2487 tag) {
        int i;
        this.effects.clear();
        this.groups.clear();
        this.casterId = tag.method_25926("CasterId");
        this.stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
        this.color = NBTHelper.readColor(tag, "Color");
        this.groupIndex = tag.method_10550("GroupIndex");
        this.potency = tag.method_10574("Potency");
        this.endTime = tag.method_10537("EndTime");
        class_2499 effectList = tag.method_10554("Effects", 8);
        class_2499 groupsList = tag.method_10554("SpellGroups", 10);
        for (i = 0; i < effectList.size(); ++i) {
            this.effects.add((SpellEffect)Arcanus.SPELL_COMPONENTS.method_10223(new class_2960(effectList.method_10608(i))));
        }
        for (i = 0; i < groupsList.size(); ++i) {
            this.groups.add(SpellGroup.fromNbt(groupsList.method_10602(i)));
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 effectList = new class_2499();
        class_2499 groupsList = new class_2499();
        tag.method_25927("CasterId", this.casterId);
        tag.method_10566("ItemStack", (class_2520)this.stack.method_7953(new class_2487()));
        NBTHelper.writeColor(tag, this.color, "Color");
        tag.method_10569("GroupIndex", this.groupIndex);
        tag.method_10549("Potency", this.potency);
        tag.method_10544("EndTime", this.endTime);
        for (SpellEffect effect : this.effects) {
            effectList.add((Object)class_2519.method_23256((String)Arcanus.SPELL_COMPONENTS.method_10221((Object)effect).toString()));
        }
        for (SpellGroup group : this.groups) {
            groupsList.add((Object)group.toNbt());
        }
        tag.method_10566("Effects", (class_2520)effectList);
        tag.method_10566("SpellGroups", (class_2520)groupsList);
    }

    public void removeCounter() {
        this.effects.clear();
        this.groups.clear();
        this.casterId = class_156.field_25140;
        this.stack = class_1799.field_8037;
        this.color = Arcanus.DEFAULT_MAGIC_COLOUR;
        this.groupIndex = 0;
        this.potency = 1.0;
        this.endTime = 0L;
        this.entity.syncComponent(ArcanusComponents.COUNTER_COMPONENT);
    }

    public void setProperties(@Nullable class_1309 caster, class_1799 stack, List<SpellEffect> effects, List<SpellGroup> groups, int groupIndex, Color color, double potency, long worldTime) {
        this.effects.clear();
        this.groups.clear();
        this.effects.addAll(effects);
        this.groups.addAll(groups);
        if (caster != null) {
            this.casterId = caster.method_5667();
        }
        this.stack = stack;
        this.color = color;
        this.groupIndex = groupIndex;
        this.potency = potency;
        this.endTime = worldTime + (long)ArcanusConfig.SpellShapes.CounterShapeProperties.baseEffectDuration;
        this.entity.syncComponent(ArcanusComponents.COUNTER_COMPONENT);
    }

    public void castCounter(class_1309 attackingEntity) {
        class_1937 class_19372 = this.entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1309 livingEntity;
            class_3218 world = (class_3218)class_19372;
            class_3966 target = new class_3966((class_1297)attackingEntity);
            class_1297 class_12972 = world.method_14190(this.casterId);
            class_1309 caster = class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972) : null;
            for (SpellEffect effect : new HashSet<SpellEffect>(this.effects)) {
                effect.effect(caster, (class_1297)this.entity, this.entity.method_37908(), (class_239)target, this.effects, this.stack, this.potency);
            }
            SpellShape.castNext(caster, target.method_17784(), (class_1297)this.entity, world, this.stack, this.groups, this.groupIndex, this.potency);
        }
        this.removeCounter();
    }

    public boolean hasCounterActive(class_1937 world) {
        return world.method_8510() <= this.endTime;
    }

    public Color getColor() {
        return this.color;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

