/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanuscontinuum.common.components.entity;

import dev.cammiescorner.arcanuscontinuum.api.entities.ArcanusEntityAttributes;
import dev.cammiescorner.arcanuscontinuum.common.registry.ArcanusComponents;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class ManaComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    private final class_1309 entity;
    private double mana;

    public ManaComponent(class_1309 entity) {
        this.entity = entity;
    }

    public void serverTick() {
        class_1324 manaRegenAttr = this.entity.method_5996((class_1320)ArcanusEntityAttributes.MANA_REGEN.get());
        if (manaRegenAttr != null) {
            class_1657 player;
            class_1309 class_13092;
            this.addMana(manaRegenAttr.method_6194() / (double)((class_13092 = this.entity) instanceof class_1657 && (player = (class_1657)class_13092).method_7337() ? 1 : 20), false);
        }
        if (this.getMana() > this.getTrueMaxMana()) {
            this.setMana(this.getTrueMaxMana());
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.mana = tag.method_10574("Mana");
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10549("Mana", this.mana);
    }

    public double getMana() {
        return this.mana;
    }

    public void setMana(double mana) {
        this.mana = class_3532.method_15350((double)mana, (double)0.0, (double)this.getTrueMaxMana());
        ArcanusComponents.MANA_COMPONENT.sync((Object)this.entity);
    }

    public double getTrueMaxMana() {
        return this.getMaxMana() - this.getManaLock() - ArcanusComponents.getBurnout(this.entity);
    }

    public double getMaxMana() {
        class_1324 maxManaAttr = this.entity.method_5996((class_1320)ArcanusEntityAttributes.MAX_MANA.get());
        if (maxManaAttr != null) {
            return maxManaAttr.method_6194();
        }
        return 0.0;
    }

    public double getManaLock() {
        class_1324 manaLockAttr = this.entity.method_5996((class_1320)ArcanusEntityAttributes.MANA_LOCK.get());
        if (manaLockAttr != null) {
            return manaLockAttr.method_6194();
        }
        return 0.0;
    }

    public boolean addMana(double amount, boolean simulate) {
        if (this.getMana() < this.getTrueMaxMana()) {
            if (!simulate) {
                this.setMana(this.getMana() + amount);
            }
            return true;
        }
        return false;
    }

    public boolean drainMana(double amount, boolean simulate) {
        class_1324 instance = this.entity.method_5996((class_1320)ArcanusEntityAttributes.MANA_COST.get());
        if (instance != null) {
            amount *= instance.method_6194();
        }
        if (this.getMana() >= 0.0 && this.getMana() + this.getTrueMaxMana() >= amount) {
            if (!simulate) {
                if (amount > this.getMana()) {
                    ArcanusComponents.addBurnout(this.entity, amount - this.getMana(), false);
                    if (ArcanusComponents.getBurnout(this.entity) >= ArcanusComponents.getMaxMana(this.entity) * 0.5) {
                        this.entity.method_5643(this.entity.method_48923().method_48829(), (float)Math.min((double)(this.entity.method_6032() - 1.0f), amount - this.getMana()));
                    }
                }
                this.setMana(Math.max(0.0, this.getMana() - amount));
            }
            return true;
        }
        return false;
    }
}

